/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.services.elements.ContactServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.ContactVO;

public class ContactServiceSecurity
extends BaseServiceSecurity
implements ContactService {
    private ContactServiceLocal contactService;

    @Override
    public ContactVO getContactVO(Long contactId, boolean useFields, boolean useImages) {
        Contact contact = this.contactService.load(contactId, Contact.Relationships.OWNER);
        this.checkView(contact.getOwner());
        return this.contactService.getContactVO(contactId, useFields, useImages);
    }

    @Override
    public List<ContactVO> getContactVOs(List<Contact> contacts, boolean useFields, boolean useImages) {
        for (Contact contact : contacts) {
            contact = this.contactService.load(contact.getId(), Contact.Relationships.OWNER);
            this.checkView(contact.getOwner());
        }
        return this.contactService.getContactVOs(contacts, useFields, useImages);
    }

    @Override
    public List<Contact> list(Member owner) {
        this.checkView(owner);
        return this.contactService.list(owner);
    }

    @Override
    public Contact load(Long id, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, Contact.Relationships.OWNER);
        Contact contact = this.contactService.load(id, newFetch);
        this.checkView(contact.getOwner());
        return contact;
    }

    @Override
    public Contact load(Member owner, Member member, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, Contact.Relationships.OWNER);
        Contact contact = this.contactService.load(owner, member, newFetch);
        this.checkView(contact.getOwner());
        return contact;
    }

    @Override
    public Contact loadIfExists(Member owner, Member member, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, Contact.Relationships.OWNER);
        Contact contact = this.contactService.loadIfExists(owner, member, newFetch);
        if (contact != null) {
            this.checkView(contact.getOwner());
        }
        return contact;
    }

    @Override
    public int remove(Long ... id) {
        for (Long tempId : id) {
            Contact contact = this.contactService.load(tempId, Contact.Relationships.OWNER);
            this.checkManage(contact.getOwner());
        }
        return this.contactService.remove(id);
    }

    @Override
    public Contact save(Contact contact) {
        Member owner = this.fetchService.fetch(contact.getOwner(), new Relationship[0]);
        this.checkManage(owner);
        this.permissionService.checkRelatesTo(contact.getContact());
        return this.contactService.save(contact);
    }

    public void setContactServiceLocal(ContactServiceLocal contactService) {
        this.contactService = contactService;
    }

    @Override
    public void validate(Contact contact) throws ValidationException {
        this.contactService.validate(contact);
    }

    private void checkManage(Member member) {
        this.permissionService.permission(member).member(new MemberPermission[0]).operator(OperatorPermission.CONTACTS_MANAGE).check();
    }

    private void checkView(Member member) {
        this.permissionService.permission(member).member(new MemberPermission[0]).operator(OperatorPermission.CONTACTS_VIEW).check();
    }
}

