/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.ElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasBalanceException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasOpenInvoicesException;
import nl.strohalm.cyclos.services.elements.exceptions.RegistrationAgreementNotAcceptedException;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public interface ElementService
extends Service {
    public void acceptAgreement(String var1);

    public BulkMemberActionResultVO bulkChangeMemberChannels(FullTextMemberQuery var1, Collection<Channel> var2, Collection<Channel> var3) throws ValidationException;

    public BulkMemberActionResultVO bulkChangeMemberGroup(FullTextMemberQuery var1, MemberGroup var2, String var3) throws ValidationException;

    public <E extends Element> E changeGroup(E var1, Group var2, String var3) throws MemberHasBalanceException, MemberHasOpenInvoicesException, ValidationException;

    public <E extends Element> E changeProfile(E var1);

    public PendingEmailChange confirmEmailChange(String var1) throws EntityNotFoundException;

    public List<? extends Element> fullTextSearch(FullTextElementQuery var1);

    public ElementVO getElementVO(long var1);

    public Calendar getFirstMemberActivationDate();

    public PendingEmailChange getPendingEmailChange(Member var1);

    public List<? extends Group> getPossibleNewGroups(Element var1);

    public void invitePerson(String var1);

    public <T extends Element> T load(Long var1, Relationship ... var2) throws EntityNotFoundException;

    public Member loadByPrincipal(PrincipalType var1, String var2, Relationship ... var3) throws EntityNotFoundException;

    public PendingMember loadPendingMember(Long var1, Relationship ... var2);

    public PendingMember loadPendingMemberByKey(String var1, Relationship ... var2);

    public <T extends User> T loadUser(Long var1, Relationship ... var2) throws EntityNotFoundException;

    public <T extends User> T loadUser(String var1, Relationship ... var2) throws EntityNotFoundException;

    public Member publicValidateRegistration(String var1) throws EntityNotFoundException, RegistrationAgreementNotAcceptedException;

    public Object register(Element var1, boolean var2, String var3);

    public <T extends User> T reloadUser(Long var1, Relationship ... var2) throws EntityNotFoundException;

    public void remove(Long var1) throws UnexpectedEntityException;

    public int removePendingMembers(Long ... var1);

    public PendingMember resendEmail(PendingMember var1) throws MailSendingException;

    public PendingEmailChange resendEmailChange(Long var1) throws MailSendingException;

    public List<? extends Element> search(ElementQuery var1);

    public List<PendingMember> search(PendingMemberQuery var1);

    public List<? extends Element> searchAtDate(MemberQuery var1, Calendar var2);

    public void setRegistrationAgreementAgreed(PendingMember var1);

    public boolean shallAcceptAgreement(Member var1);

    public PendingMember update(PendingMember var1);

    public void validate(Element var1, WhenSaving var2, boolean var3) throws ValidationException;

    public void validate(PendingMember var1) throws ValidationException;

    public void validateBulkChangeChannels(FullTextMemberQuery var1, Collection<Channel> var2, Collection<Channel> var3);
}

