/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.dao.access.UserDAO;
import nl.strohalm.cyclos.dao.access.UsernameChangeLogDAO;
import nl.strohalm.cyclos.dao.groups.GroupHistoryLogDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.dao.members.NotificationPreferenceDAO;
import nl.strohalm.cyclos.dao.members.PendingEmailChangeDAO;
import nl.strohalm.cyclos.dao.members.PendingMemberDAO;
import nl.strohalm.cyclos.dao.members.RegistrationAgreementLogDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.access.UsernameChangeLog;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupHistoryLog;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.ElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextAdminQuery;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.FullTextOperatorQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.entities.members.RegistrationAgreementLog;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterestQuery;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemark;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.MemberAccountHandler;
import nl.strohalm.cyclos.services.accounts.cards.CardServiceLocal;
import nl.strohalm.cyclos.services.accounts.pos.PosServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.AdInterestServiceLocal;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.elements.ContactServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.RemarkServiceLocal;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasBalanceException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasOpenInvoicesException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasPendingLoansException;
import nl.strohalm.cyclos.services.elements.exceptions.RegistrationAgreementNotAcceptedException;
import nl.strohalm.cyclos.services.elements.exceptions.UsernameAlreadyInUseException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.MailHandler;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.lock.UniqueObjectHandler;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.EmailValidation;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.UniqueError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class ElementServiceImpl
implements ElementServiceLocal {
    private MessageResolver messageResolver = new MessageResolver.NoOpMessageResolver();
    private ElementDAO elementDao;
    private GroupHistoryLogDAO groupHistoryLogDao;
    private NotificationPreferenceDAO notificationPreferenceDao;
    private UserDAO userDao;
    private AccessServiceLocal accessService;
    private AccountServiceLocal accountService;
    private AdInterestServiceLocal adInterestService;
    private AdServiceLocal adService;
    private BrokeringServiceLocal brokeringService;
    private CommissionServiceLocal commissionService;
    private ContactServiceLocal contactService;
    private AdminCustomFieldServiceLocal adminCustomFieldService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private OperatorCustomFieldServiceLocal operatorCustomFieldService;
    private FetchServiceLocal fetchService;
    private GroupServiceLocal groupService;
    private InvoiceServiceLocal invoiceService;
    private PaymentServiceLocal paymentService;
    private LoanServiceLocal loanService;
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    private PreferenceServiceLocal preferenceService;
    private RemarkServiceLocal remarkService;
    private SettingsServiceLocal settingsService;
    private ChannelServiceLocal channelService;
    private HashHandler hashHandler;
    private MailHandler mailHandler;
    private MemberAccountHandler memberAccountHandler;
    private PendingMemberDAO pendingMemberDao;
    private PendingEmailChangeDAO pendingEmailChangeDao;
    private RegistrationAgreementLogDAO registrationAgreementLogDao;
    private CardServiceLocal cardService;
    private PosServiceLocal posService;
    private PermissionServiceLocal permissionService;
    private UsernameChangeLogDAO usernameChangeLogDao;
    private AdminNotificationHandler adminNotificationHandler;
    private MemberNotificationHandler memberNotificationHandler;
    private CustomFieldHelper customFieldHelper;
    private UniqueObjectHandler uniqueObjectHandler;

    @Override
    public void acceptAgreement(String remoteAddress) {
        Member member = LoggedUser.member();
        MemberGroup group = member.getMemberGroup();
        RegistrationAgreement registrationAgreement = group.getRegistrationAgreement();
        if (registrationAgreement == null) {
            throw new ValidationException();
        }
        this.createAgreementLog(remoteAddress, member, registrationAgreement);
    }

    @Override
    public boolean applyQueryRestrictions(FullTextElementQuery query) {
        boolean isMemberSearchingForOperators;
        if (query instanceof FullTextAdminQuery) {
            this.permissionService.permission().admin(AdminAdminPermission.ADMINS_VIEW).check();
        } else if (query instanceof FullTextOperatorQuery) {
            Member member = ((FullTextOperatorQuery)query).getMember();
            if (member == null) {
                throw new ValidationException();
            }
            this.permissionService.permission(member).member(new MemberPermission[0]).operator().check();
        } else if (query instanceof FullTextMemberQuery) {
            Collection<MemberGroup> visibleGroups = this.permissionService.getVisibleMemberGroups(false);
            if (visibleGroups.isEmpty()) {
                return false;
            }
            Collection<? extends Group> queryGroups = query.getGroups();
            query.setGroups(PermissionHelper.checkSelection(visibleGroups, queryGroups));
        }
        boolean bl = isMemberSearchingForOperators = query instanceof FullTextOperatorQuery && ((Entity)LoggedUser.element()).equals(((FullTextOperatorQuery)query).getMember());
        if (!LoggedUser.isAdministrator() && !isMemberSearchingForOperators) {
            query.setEnabled(true);
        }
        return true;
    }

    @Override
    public BulkMemberActionResultVO bulkChangeMemberChannels(FullTextMemberQuery query, Collection<Channel> enableChannels, Collection<Channel> disableChannels) throws ValidationException {
        this.validateBulkChangeChannels(query, enableChannels, disableChannels);
        enableChannels = this.channelService.load(EntityHelper.toIds(enableChannels));
        disableChannels = this.channelService.load(EntityHelper.toIds(disableChannels));
        int changed = 0;
        int unchanged = 0;
        query.setIterateAll();
        List<? extends Element> members = this.fullTextSearch(query);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        for (Member member : members) {
            Member member2 = this.fetchService.fetch(member, Member.Relationships.CHANNELS, Element.Relationships.GROUP);
            boolean mustChange = false;
            for (Channel channel : enableChannels) {
                if (!this.accessService.isChannelAllowedToBeEnabledForMember(channel, member2) || member2.getChannels().contains(channel)) continue;
                mustChange = true;
                member2.getChannels().add(channel);
            }
            Collection<Channel> memberChannels = this.accessService.getChannelsEnabledForMember(member2);
            Collection memberDisabledChannels = CollectionUtils.subtract(this.channelService.list(), memberChannels);
            Collection toDisableChannels = CollectionUtils.subtract(disableChannels, (Collection)memberDisabledChannels);
            if (CollectionUtils.isNotEmpty((Collection)toDisableChannels)) {
                mustChange = true;
                for (Channel channel : toDisableChannels) {
                    member2.getChannels().remove(channel);
                }
            }
            if (mustChange) {
                ++changed;
                this.elementDao.update(member2);
            } else {
                ++unchanged;
            }
            cacheCleaner.clearCache();
        }
        return new BulkMemberActionResultVO(changed, unchanged);
    }

    @Override
    public BulkMemberActionResultVO bulkChangeMemberGroup(FullTextMemberQuery query, MemberGroup newGroup, String comments) throws ValidationException {
        if (newGroup == null || newGroup.isTransient()) {
            throw new ValidationException();
        }
        if (StringUtils.isEmpty((String)comments)) {
            throw new ValidationException();
        }
        newGroup = this.fetchService.fetch(newGroup, new Relationship[0]);
        int changed = 0;
        int unchanged = 0;
        query.setIterateAll();
        List<? extends Element> members = this.fullTextSearch(query);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        for (Member member : members) {
            if (newGroup.equals(member.getGroup())) {
                ++unchanged;
            } else {
                this.changeGroup(member, newGroup, comments);
                ++changed;
            }
            cacheCleaner.clearCache();
        }
        return new BulkMemberActionResultVO(changed, unchanged);
    }

    @Override
    public <E extends Element> E changeGroup(E element, Group newGroup, String comments) throws MemberHasBalanceException, MemberHasOpenInvoicesException, ValidationException {
        Member member;
        newGroup = this.fetchService.fetch(newGroup, new Relationship[0]);
        Object loggedElement = LoggedUser.element();
        if (element == null || newGroup == null || StringUtils.isEmpty((String)comments) || ((Entity)loggedElement).equals(element)) {
            throw new ValidationException();
        }
        Group oldGroup = ((Element)(element = this.load(((Entity)element).getId(), Element.Relationships.USER, Element.Relationships.GROUP))).getGroup();
        if (oldGroup.equals(newGroup) || oldGroup.getStatus() == Group.Status.REMOVED) {
            throw new ValidationException();
        }
        if (element instanceof Member) {
            this.checkNewGroup((Member)element, (MemberGroup)newGroup);
        }
        if (newGroup.getStatus() == Group.Status.REMOVED) {
            try {
                this.accessService.disconnect(((Element)element).getUser());
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            if (element instanceof Member) {
                Member member2 = (Member)element;
                AdQuery adQuery = new AdQuery();
                adQuery.setOwner(member2);
                this.adService.remove(EntityHelper.toIds(this.adService.search(adQuery)));
                AdInterestQuery adInterestQuery = new AdInterestQuery();
                adInterestQuery.setOwner(member2);
                this.adInterestService.remove(EntityHelper.toIds(this.adInterestService.search(adInterestQuery)));
                this.notificationPreferenceDao.delete(EntityHelper.toIds(this.notificationPreferenceDao.load(member2)));
                this.contactService.remove(EntityHelper.toIds(this.contactService.list(member2)));
                this.cardService.cancelAllMemberCards(member2);
                this.posService.unassignAllMemberPos(member2);
            }
        }
        boolean noLongerBroker = false;
        if (element instanceof Member) {
            member = (Member)element;
            MemberGroup oldMemberGroup = (MemberGroup)oldGroup;
            MemberGroup newMemberGroup = (MemberGroup)newGroup;
            boolean bl = noLongerBroker = oldMemberGroup.isBroker() && (newGroup.getStatus() == Group.Status.REMOVED || !newMemberGroup.isBroker());
            if (noLongerBroker) {
                BrokeringQuery brokeringQuery = new BrokeringQuery();
                brokeringQuery.setBroker(member);
                brokeringQuery.setResultType(QueryParameters.ResultType.ITERATOR);
                MessageSettings messageSettings = this.settingsService.getMessageSettings();
                String brokeringComments = messageSettings.getBrokerRemovedRemarkComments();
                brokeringComments = MessageProcessingHelper.processVariables(brokeringComments, member, this.settingsService.getLocalSettings());
                for (Brokering brokering : this.brokeringService.search(brokeringQuery)) {
                    this.brokeringService.remove(brokering, brokeringComments);
                }
            }
            if (oldMemberGroup.isBroker() || newMemberGroup.isBroker()) {
                this.commissionService.updateBrokerCommissions(member, oldMemberGroup, newMemberGroup);
            }
        }
        ((Element)element).setGroup(newGroup);
        this.elementDao.update(element);
        if (element instanceof Member) {
            member = (Member)element;
            boolean wasInactive = !member.isActive();
            this.handleAccounts(member);
            if (wasInactive && member.isActive()) {
                this.sendActivationMailIfNeeded(ActivationMail.ONLINE, member);
            }
        }
        this.createGroupRemark((Element)element, oldGroup, newGroup, comments);
        this.elementDao.addToIndex(element);
        if (element instanceof Member && noLongerBroker) {
            member = (Member)element;
            this.memberNotificationHandler.removedFromBrokerGroupNotification(member);
        }
        return (E)element;
    }

    @Override
    public Member changeMemberProfileByWebService(ServiceClient client, Member member) {
        if (member.isTransient()) {
            throw new UnexpectedEntityException();
        }
        Object current = this.load(member.getId(), new Relationship[0]);
        Set<MemberGroup> manageGroups = this.fetchService.fetch(client, ServiceClient.Relationships.MANAGE_GROUPS).getManageGroups();
        if (!manageGroups.contains(((Element)current).getGroup())) {
            throw new PermissionDeniedException();
        }
        return this.save(member, ActivationMail.THREADED, WhenSaving.PROFILE, false);
    }

    @Override
    public <E extends Element> E changeProfile(E element) {
        return this.save(element, null, WhenSaving.PROFILE, false);
    }

    @Override
    public PendingEmailChange confirmEmailChange(String key) throws EntityNotFoundException {
        Member member = LoggedUser.member();
        PendingEmailChange pendingEmailChange = this.pendingEmailChangeDao.getByMember(member, new Relationship[0]);
        if (pendingEmailChange == null) {
            throw new EntityNotFoundException(PendingEmailChange.class);
        }
        member.setEmail(pendingEmailChange.getNewEmail());
        this.elementDao.update(member);
        this.pendingEmailChangeDao.removeAll(member);
        return pendingEmailChange;
    }

    @Override
    public void createAgreementForAllMembers(RegistrationAgreement registrationAgreement, MemberGroup group) {
        this.elementDao.createAgreementForAllMembers(registrationAgreement, group);
    }

    @Override
    public List<? extends Element> fullTextSearch(FullTextElementQuery query) {
        if (query instanceof FullTextMemberQuery) {
            FullTextMemberQuery memberQuery = (FullTextMemberQuery)query;
            Collection<GroupFilter> groupFilters = this.fetchService.fetch(memberQuery.getGroupFilters(), new Relationship[]{GroupFilter.Relationships.GROUPS});
            if (CollectionUtils.isNotEmpty(groupFilters)) {
                boolean hasGroupFilters = CollectionUtils.isNotEmpty(memberQuery.getGroupFilters());
                boolean hasGroups = CollectionUtils.isNotEmpty(memberQuery.getGroups());
                HashSet<MemberGroup> groupsFromFilters = new HashSet<MemberGroup>();
                if (hasGroupFilters) {
                    for (GroupFilter groupFilter : groupFilters) {
                        groupsFromFilters.addAll(groupFilter.getGroups());
                    }
                    if (hasGroups) {
                        memberQuery.setGroups(CollectionUtils.intersection(groupsFromFilters, memberQuery.getGroups()));
                    } else {
                        memberQuery.setGroups(groupsFromFilters);
                    }
                }
                memberQuery.setGroupFilters(null);
            }
        }
        if (query.getNameDisplay() == null) {
            query.setNameDisplay(this.settingsService.getLocalSettings().getMemberResultDisplay());
        }
        query.setAnalyzer(this.settingsService.getLocalSettings().getLanguage().getAnalyzer());
        return this.elementDao.fullTextSearch(query);
    }

    @Override
    public ElementVO getElementVO(long id) {
        return id > 0L ? ((Element)this.elementDao.load(id, new Relationship[0])).readOnlyView() : null;
    }

    @Override
    public Calendar getFirstMemberActivationDate() {
        return this.elementDao.getFirstMemberActivationDate();
    }

    @Override
    public PendingEmailChange getPendingEmailChange(Member member) {
        return this.pendingEmailChangeDao.getByMember(member, new Relationship[0]);
    }

    @Override
    public List<? extends Group> getPossibleNewGroups(Element element) {
        Group group = this.fetchService.fetch(element, Element.Relationships.GROUP).getGroup();
        if (group.getStatus() == Group.Status.REMOVED) {
            return Collections.singletonList(group);
        }
        GroupQuery query = new GroupQuery();
        if (group instanceof OperatorGroup) {
            query.setNatures(Group.Nature.OPERATOR);
            query.setMember(((OperatorGroup)group).getMember());
        } else if (group.getNature() == Group.Nature.ADMIN) {
            query.setNatures(Group.Nature.ADMIN);
        } else {
            query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        }
        List<? extends Group> groups = this.groupService.search(query);
        groups.remove(group);
        return groups;
    }

    @Override
    public Member insertMember(Member member, boolean ignoreActivationMail, boolean validatePassword) {
        ActivationMail activationMail = ignoreActivationMail ? ActivationMail.IGNORE : ActivationMail.THREADED;
        return this.save(member, activationMail, WhenSaving.IMPORT, false);
    }

    @Override
    public void invitePerson(String email) {
        this.mailHandler.sendInvitation((Element)LoggedUser.element(), email);
    }

    @Override
    public <T extends Element> T load(Long id, Relationship ... fetch) {
        Element element = (Element)this.elementDao.load(id, fetch);
        this.checkAccessToMember(element);
        return (T)element;
    }

    @Override
    public Member loadByPrincipal(PrincipalType principalType, String principal, Relationship ... fetch) {
        try {
            if (principal == null) {
                throw new NullPointerException();
            }
            Channel.Principal principalEnum = principalType == null ? Channel.Principal.USER : principalType.getPrincipal();
            switch (principalEnum) {
                case USER: {
                    Object user = this.loadUser(principal, new Relationship[0]);
                    return (Member)this.fetchService.fetch(((User)user).getElement(), fetch);
                }
                case EMAIL: {
                    return (Member)this.elementDao.loadByEmail(principal, fetch);
                }
                case CUSTOM_FIELD: {
                    MemberCustomField customField = principalType.getCustomField();
                    if (StringUtils.isNotEmpty((String)customField.getPattern())) {
                        principal = StringHelper.removeMask(customField.getPattern(), principal, false);
                    }
                    return this.elementDao.loadByCustomField(customField, principal, fetch);
                }
                case CARD: {
                    boolean cardExpired;
                    String cardNumber = StringHelper.onlyNumbers(principal);
                    Card card = this.cardService.loadByNumber(new BigInteger(cardNumber), Card.Relationships.OWNER);
                    Calendar expirationDate = DateHelper.truncateNextDay(card.getExpirationDate());
                    boolean bl = cardExpired = !Calendar.getInstance().getTime().before(expirationDate.getTime());
                    if (card.getStatus() != Card.Status.ACTIVE || cardExpired) {
                        throw new EntityNotFoundException("The card " + cardNumber + " is not active or has expired.");
                    }
                    return this.fetchService.fetch(card.getOwner(), fetch);
                }
            }
            throw new EntityNotFoundException(Member.class);
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            EntityNotFoundException enfe = new EntityNotFoundException(Member.class);
            enfe.initCause(e);
            throw enfe;
        }
    }

    @Override
    public OperatorUser loadOperatorUser(Member member, String operatorUsername, Relationship ... fetch) throws EntityNotFoundException {
        return this.userDao.loadOperator(member, operatorUsername, fetch);
    }

    @Override
    public PendingMember loadPendingMember(Long id, Relationship ... fetch) {
        PendingMember pendingMember = (PendingMember)this.pendingMemberDao.load(id, fetch);
        this.checkManagement(pendingMember);
        return pendingMember;
    }

    @Override
    public PendingMember loadPendingMemberByKey(String key, Relationship ... fetch) {
        return this.pendingMemberDao.loadByKey(key, fetch);
    }

    @Override
    public <T extends User> T loadUser(Long id, Relationship ... fetch) {
        User user = (User)this.userDao.load(id, fetch);
        this.checkAccessToMember(user.getElement());
        return (T)user;
    }

    @Override
    public <T extends User> T loadUser(String username, Relationship ... fetch) {
        Object user = this.userDao.load(username, fetch);
        this.checkAccessToMember(((User)user).getElement());
        return user;
    }

    @Override
    public int processMembersExpirationForGroups(Calendar time) {
        GroupQuery query = new GroupQuery();
        query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        int count = 0;
        List<? extends Group> groups = this.groupService.search(query);
        String message = this.messageResolver.message("changeGroup.member.expired", new Object[0]);
        for (Group group : groups) {
            MemberGroup memberGroup = (MemberGroup)this.fetchService.fetch(group, new Relationship[0]);
            MemberGroupSettings memberSettings = memberGroup.getMemberSettings();
            TimePeriod expireMembersAfter = memberSettings.getExpireMembersAfter();
            if (expireMembersAfter == null || expireMembersAfter.getNumber() <= 0) continue;
            Calendar limit = expireMembersAfter.remove(DateHelper.truncate(time));
            List<Member> members = this.elementDao.listMembersRegisteredBeforeOnGroup(limit, memberGroup);
            MemberGroup groupAfterExpiration = memberSettings.getGroupAfterExpiration();
            for (Member member : members) {
                this.changeGroup(member, groupAfterExpiration, message);
                ++count;
            }
        }
        return count;
    }

    @Override
    public Member publicValidateRegistration(String key) throws EntityNotFoundException, RegistrationAgreementNotAcceptedException {
        PendingMember pendingMember = this.pendingMemberDao.loadByKey(key, PendingMember.Relationships.values());
        RegistrationAgreement registrationAgreement = pendingMember.getRegistrationAgreement();
        Calendar agreementDate = pendingMember.getRegistrationAgreementDate();
        String remoteAddress = pendingMember.getRemoteAddress();
        MemberGroup group = pendingMember.getMemberGroup();
        if (group.getRegistrationAgreement() != null && !group.getRegistrationAgreement().equals(registrationAgreement)) {
            throw new RegistrationAgreementNotAcceptedException();
        }
        this.pendingMemberDao.delete(pendingMember.getId());
        Member member = new Member();
        PropertyHelper.copyProperties(pendingMember, member, "id", "memberGroup", "username", "password", "customValues");
        member.setGroup(pendingMember.getMemberGroup());
        MemberUser user = new MemberUser();
        member.setUser(user);
        user.setSalt(pendingMember.getSalt());
        user.setUsername(pendingMember.getUsername());
        String password = pendingMember.getPassword();
        if (StringUtils.isNotEmpty((String)password)) {
            user.setPassword(password);
            if (!pendingMember.isForceChangePassword()) {
                user.setPasswordDate(Calendar.getInstance());
            }
        }
        this.customFieldHelper.cloneFieldValues(pendingMember, member);
        member = this.save(member, ActivationMail.ONLINE, WhenSaving.EMAIL_VALIDATION, pendingMember.isForceChangePassword());
        if (registrationAgreement != null) {
            RegistrationAgreementLog log = new RegistrationAgreementLog();
            log.setMember(member);
            log.setRegistrationAgreement(registrationAgreement);
            log.setDate(agreementDate);
            log.setRemoteAddress(remoteAddress);
            this.registrationAgreementLogDao.insert(log);
        }
        this.adminNotificationHandler.notifyNewPublicRegistration(member);
        return member;
    }

    @Override
    public void purgeOldEmailValidations(Calendar time) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TimePeriod timePeriod = localSettings.getDeletePendingRegistrationsAfter();
        if (timePeriod == null || timePeriod.getNumber() <= 0) {
            return;
        }
        Calendar limit = timePeriod.remove(time);
        this.pendingMemberDao.deleteBefore(limit);
        this.pendingEmailChangeDao.deleteBefore(limit);
    }

    @Override
    public Object register(Element element, boolean forceChangePassword, String remoteAddress) {
        if (element instanceof Administrator) {
            if (!forceChangePassword) {
                element.getUser().setPasswordDate(Calendar.getInstance());
            }
            return this.save(element, ActivationMail.ONLINE, WhenSaving.ADMIN_BY_ADMIN, forceChangePassword);
        }
        if (element instanceof Member) {
            WhenSaving whenSaving = LoggedUser.getAccessType() == null ? WhenSaving.PUBLIC : (LoggedUser.isBroker() ? WhenSaving.BY_BROKER : WhenSaving.MEMBER_BY_ADMIN);
            return this.register((Member)element, whenSaving, forceChangePassword, remoteAddress);
        }
        if (element instanceof Operator) {
            Operator operator = (Operator)element;
            Member loggedMember = (Member)LoggedUser.element();
            operator.setMember(loggedMember);
            operator.getUser().setPasswordDate(Calendar.getInstance());
            return this.save(operator, null, WhenSaving.OPERATOR, false);
        }
        throw new UnexpectedEntityException();
    }

    @Override
    public RegisteredMember registerMemberByWebService(ServiceClient client, Member member, String remoteAddress) {
        MemberGroup group;
        Set<MemberGroup> manageGroups = (client = this.fetchService.fetch(client, ServiceClient.Relationships.MANAGE_GROUPS)).getManageGroups();
        if (manageGroups.isEmpty()) {
            throw new PermissionDeniedException();
        }
        try {
            group = (MemberGroup)this.fetchService.fetch(member.getGroup(), new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException();
        }
        if (group == null) {
            group = manageGroups.iterator().next();
        }
        return this.register(member, WhenSaving.WEB_SERVICE, false, remoteAddress);
    }

    @Override
    public <T extends User> T reloadUser(Long id, Relationship ... fetch) {
        User user = (User)this.userDao.reload(id, fetch);
        this.checkAccessToMember(user.getElement());
        return (T)user;
    }

    @Override
    public void remove(Long id) throws UnexpectedEntityException {
        Member member;
        Object element = this.load(id, new Relationship[0]);
        if (element instanceof Member && (member = (Member)element).getActivationDate() != null) {
            throw new UnexpectedEntityException();
        }
        this.elementDao.delete(id);
        this.elementDao.removeFromIndex(element);
    }

    @Override
    public int removePendingMembers(Long ... ids) {
        if (ids == null) {
            return 0;
        }
        for (Long id : ids) {
            this.checkManagement(EntityHelper.reference(PendingMember.class, id));
        }
        return this.pendingMemberDao.delete(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingMember resendEmail(PendingMember pendingMember) throws MailSendingException {
        try {
            this.mailHandler.sendEmailValidation(pendingMember);
            pendingMember.setLastEmailDate(Calendar.getInstance());
            PendingMember pendingMember2 = this.pendingMemberDao.update(pendingMember);
            return pendingMember2;
        }
        finally {
            if (CurrentTransactionData.hasMailError()) {
                throw new MailSendingException("Email validation for " + pendingMember.getName());
            }
        }
    }

    @Override
    public PendingEmailChange resendEmailChange(Long memberId) throws MailSendingException {
        Object element = this.load(memberId, new Relationship[0]);
        if (!(element instanceof Member)) {
            throw new EntityNotFoundException(Member.class);
        }
        Member member = (Member)element;
        PendingEmailChange change = this.pendingEmailChangeDao.getByMember(member, new Relationship[0]);
        return this.resendEmail(change);
    }

    @Override
    public List<? extends Element> search(ElementQuery query) {
        query.fetch(Element.Relationships.USER);
        if (query.getOrder() == null) {
            query.setOrder(this.settingsService.getLocalSettings().getMemberResultDisplay());
        }
        return this.elementDao.search(query);
    }

    @Override
    public List<PendingMember> search(PendingMemberQuery params) {
        Collection<MemberGroup> allowedGroups = null;
        if (LoggedUser.hasUser()) {
            if (LoggedUser.isBroker()) {
                Member loggedBroker = (Member)LoggedUser.element();
                params.setBroker(loggedBroker);
                BrokerGroup group = (BrokerGroup)LoggedUser.group();
                allowedGroups = this.fetchService.fetch(group, BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS).getPossibleInitialGroups();
            } else {
                AdminGroup group = (AdminGroup)LoggedUser.group();
                allowedGroups = this.fetchService.fetch(group, AdminGroup.Relationships.MANAGES_GROUPS).getManagesGroups();
            }
        }
        if (allowedGroups != null) {
            if (allowedGroups.isEmpty()) {
                return Collections.emptyList();
            }
            Collection<MemberGroup> groups = params.getGroups();
            if (CollectionUtils.isEmpty(groups)) {
                params.setGroups(allowedGroups);
            } else {
                Iterator<MemberGroup> iterator = groups.iterator();
                while (iterator.hasNext()) {
                    MemberGroup memberGroup = iterator.next();
                    if (allowedGroups.contains(memberGroup)) continue;
                    iterator.remove();
                }
            }
        }
        return this.pendingMemberDao.search(params);
    }

    @Override
    public List<? extends Element> searchAtDate(MemberQuery query, Calendar date) {
        if (query.getOrder() == null) {
            query.setOrder(this.settingsService.getLocalSettings().getMemberResultDisplay());
        }
        return this.elementDao.searchAtDate(query, date);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAdInterestServiceLocal(AdInterestServiceLocal adInterestService) {
        this.adInterestService = adInterestService;
    }

    public void setAdminCustomFieldServiceLocal(AdminCustomFieldServiceLocal adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    public void setCardServiceLocal(CardServiceLocal cardService) {
        this.cardService = cardService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    public void setContactServiceLocal(ContactServiceLocal contactService) {
        this.contactService = contactService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementDao(ElementDAO elementDAO) {
        this.elementDao = elementDAO;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupHistoryLogDao(GroupHistoryLogDAO groupHistoryLogDao) {
        this.groupHistoryLogDao = groupHistoryLogDao;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setHashHandler(HashHandler hashHandler) {
        this.hashHandler = hashHandler;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setMailHandler(MailHandler mailHandler) {
        this.mailHandler = mailHandler;
    }

    public void setMemberAccountHandler(MemberAccountHandler memberAccountHandler) {
        this.memberAccountHandler = memberAccountHandler;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setNotificationPreferenceDao(NotificationPreferenceDAO notificationPreferenceDao) {
        this.notificationPreferenceDao = notificationPreferenceDao;
    }

    public void setOperatorCustomFieldServiceLocal(OperatorCustomFieldServiceLocal operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPendingEmailChangeDao(PendingEmailChangeDAO pendingEmailChangeDao) {
        this.pendingEmailChangeDao = pendingEmailChangeDao;
    }

    public void setPendingMemberDao(PendingMemberDAO pendingMemberDao) {
        this.pendingMemberDao = pendingMemberDao;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPosServiceLocal(PosServiceLocal posService) {
        this.posService = posService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    @Override
    public void setRegistrationAgreementAgreed(PendingMember pendingMember) {
        RegistrationAgreement registrationAgreement = (pendingMember = this.fetchService.reload(pendingMember, new Relationship[0])).getMemberGroup().getRegistrationAgreement();
        if (registrationAgreement == null) {
            throw new ValidationException();
        }
        pendingMember.setRegistrationAgreement(registrationAgreement);
        pendingMember.setRegistrationAgreementDate(Calendar.getInstance());
        this.pendingMemberDao.update(pendingMember);
    }

    public void setRegistrationAgreementLogDao(RegistrationAgreementLogDAO registrationAgreementLogDao) {
        this.registrationAgreementLogDao = registrationAgreementLogDao;
    }

    public void setRemarkServiceLocal(RemarkServiceLocal remarkService) {
        this.remarkService = remarkService;
    }

    public void setScheduledPaymentServiceLocal(ScheduledPaymentServiceLocal scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setUniqueObjectHandler(UniqueObjectHandler uniqueObjectHandler) {
        this.uniqueObjectHandler = uniqueObjectHandler;
    }

    public void setUserDao(UserDAO userDAO) {
        this.userDao = userDAO;
    }

    public void setUsernameChangeLogDao(UsernameChangeLogDAO usernameChangeLogDao) {
        this.usernameChangeLogDao = usernameChangeLogDao;
    }

    @Override
    public boolean shallAcceptAgreement(Member member) {
        RegistrationAgreement registrationAgreement = (member = this.fetchService.fetch(member, Element.Relationships.GROUP)).getMemberGroup().getRegistrationAgreement();
        if (registrationAgreement == null) {
            return false;
        }
        List<RegistrationAgreementLog> logs = this.registrationAgreementLogDao.listByMember(member);
        for (RegistrationAgreementLog log : logs) {
            if (!log.getRegistrationAgreement().equals(registrationAgreement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PendingMember update(PendingMember pendingMember) {
        if (pendingMember == null || pendingMember.isTransient()) {
            throw new UnexpectedEntityException();
        }
        this.checkManagement(pendingMember);
        this.validate(pendingMember);
        Collection<MemberCustomFieldValue> customValues = pendingMember.getCustomValues();
        pendingMember = this.pendingMemberDao.update(pendingMember);
        pendingMember.setCustomValues(customValues);
        this.memberCustomFieldService.saveValues(pendingMember);
        return pendingMember;
    }

    @Override
    public void validate(Element element, WhenSaving when, boolean manualPassword) throws ValidationException {
        Group group = element.getGroup();
        if (group == null || group.isTransient()) {
            if (element.isTransient()) {
                throw new ValidationException("group", "member.group", new RequiredError(new Object[0]));
            }
            Object loaded = this.load(element.getId(), Element.Relationships.GROUP);
            group = ((Element)loaded).getGroup();
            element.setGroup(group);
        } else {
            group = this.fetchService.fetch(group, new Relationship[0]);
        }
        if (element instanceof Member && element.isPersistent()) {
            Member member = (Member)element;
            Collection<MemberCustomFieldValue> customValues = member.getCustomValues();
            List<MemberCustomField> fields = this.memberCustomFieldService.list();
            fields = this.customFieldHelper.onlyForGroup(fields, (MemberGroup)group);
            Member current = (Member)this.load(element.getId(), Member.Relationships.CUSTOM_VALUES);
            Collection<MemberCustomFieldValue> currentValues = current.getCustomValues();
            Object loggedElement = LoggedUser.hasUser() ? LoggedUser.element() : null;
            boolean byOwner = loggedElement != null && ((Entity)loggedElement).equals(current);
            boolean byBroker = false;
            if (loggedElement != null && LoggedUser.isBroker()) {
                byBroker = ((Entity)loggedElement).equals(current.getBroker());
            }
            Object loggedGroup = LoggedUser.hasUser() ? LoggedUser.group() : null;
            for (MemberCustomField field : fields) {
                if (loggedGroup == null || field.getUpdateAccess().granted((Group)loggedGroup, byOwner, byBroker, false, when == WhenSaving.WEB_SERVICE)) continue;
                MemberCustomFieldValue currentValue = this.customFieldHelper.findByField(field, currentValues);
                MemberCustomFieldValue value = this.customFieldHelper.findByField(field, customValues);
                if (value != null) {
                    customValues.remove(value);
                }
                if (currentValue == null) continue;
                customValues.add(currentValue);
            }
        }
        this.createValidator(group, element, when, manualPassword).validate(element);
    }

    @Override
    public void validate(PendingMember pendingMember) throws ValidationException {
        this.getValidator(pendingMember).validate(pendingMember);
    }

    @Override
    public void validateBulkChangeChannels(FullTextMemberQuery query, Collection<Channel> enableChannels, Collection<Channel> disableChannels) {
        Collection intersection = CollectionUtils.intersection(enableChannels, disableChannels);
        if (CollectionUtils.isNotEmpty((Collection)intersection)) {
            throw new ValidationException("changeChannels.invalidChannelsSelection", this.toString(intersection));
        }
    }

    private void cancelScheduledPaymentsAndNotify(Member member, MemberGroup newGroup) {
        Collection<MemberAccountType> accountTypes = newGroup.getAccountTypes();
        if (accountTypes == null) {
            accountTypes = Collections.emptyList();
        }
        this.scheduledPaymentService.cancelScheduledPaymentsAndNotify(member, accountTypes);
    }

    private void checkAccessToMember(Element element) {
        if (element instanceof Member && LoggedUser.hasUser()) {
            AdminGroup group;
            Collection<MemberGroup> managesGroups;
            MemberGroup group2;
            Collection<MemberGroup> canViewMembersOfGroups;
            Member loggedMember;
            Member member = this.fetchService.fetch((Member)element, Member.Relationships.BROKER);
            if (LoggedUser.isMember() || LoggedUser.isOperator() ? !(loggedMember = (Member)LoggedUser.accountOwner()).equals(member) && !(canViewMembersOfGroups = (group2 = this.fetchService.fetch(loggedMember.getMemberGroup(), MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS)).getCanViewProfileOfGroups()).contains(element.getGroup()) && !loggedMember.equals(member.getBroker()) : LoggedUser.isAdministrator() && !(managesGroups = this.fetchService.fetch(group = (AdminGroup)LoggedUser.group(), AdminGroup.Relationships.MANAGES_GROUPS).getManagesGroups()).contains(member.getGroup())) {
                throw new PermissionDeniedException();
            }
        }
    }

    private void checkManagement(PendingMember pendingMember) {
        boolean valid = false;
        if (LoggedUser.hasUser()) {
            pendingMember = this.fetchService.fetch(pendingMember, new Relationship[0]);
            if (LoggedUser.isBroker()) {
                Member loggedBroker = (Member)LoggedUser.element();
                valid = loggedBroker.equals(pendingMember.getBroker());
            } else {
                AdminGroup group = (AdminGroup)LoggedUser.group();
                Collection<MemberGroup> managesGroups = this.fetchService.reload(group, AdminGroup.Relationships.MANAGES_GROUPS).getManagesGroups();
                valid = managesGroups.contains(pendingMember.getMemberGroup());
            }
        }
        if (!valid) {
            throw new PermissionDeniedException();
        }
    }

    private void checkNewGroup(Member member, MemberGroup newGroup) {
        AccountType accType;
        Collection<MemberAccountType> accountTypes = newGroup.getAccountTypes();
        if (accountTypes == null) {
            accountTypes = Collections.emptyList();
        }
        LoanQuery lQuery = new LoanQuery();
        lQuery.fetch(RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TYPE));
        lQuery.setStatus(Loan.Status.OPEN);
        lQuery.setMember(member);
        for (Loan loan : this.loanService.search(lQuery)) {
            LoanParameters params = loan.getTransferType().getLoan();
            if (!accountTypes.contains(this.getFrom(params.getRepaymentType()))) {
                throw new MemberHasPendingLoansException(newGroup);
            }
            if (params.getType() != Loan.Type.WITH_INTEREST) continue;
            accType = this.getFrom(params.getMonthlyInterestRepaymentType());
            if (accType != null && !accountTypes.contains(accType)) {
                throw new MemberHasPendingLoansException(newGroup);
            }
            accType = this.getFrom(params.getGrantFeeRepaymentType());
            if (accType != null && !accountTypes.contains(accType)) {
                throw new MemberHasPendingLoansException(newGroup);
            }
            accType = this.getFrom(params.getExpirationFeeRepaymentType());
            if (accType != null && !accountTypes.contains(accType)) {
                throw new MemberHasPendingLoansException(newGroup);
            }
            accType = this.getFrom(params.getExpirationDailyInterestRepaymentType());
            if (accType == null || accountTypes.contains(accType)) continue;
            throw new MemberHasPendingLoansException(newGroup);
        }
        InvoiceQuery invoiceQuery = new InvoiceQuery();
        invoiceQuery.setDirection(InvoiceQuery.Direction.INCOMING);
        invoiceQuery.setOwner(member);
        invoiceQuery.setStatus(Invoice.Status.OPEN);
        for (Invoice invoice : this.invoiceService.search(invoiceQuery)) {
            boolean bl = false;
            Iterator<MemberAccountType> accIt = accountTypes.iterator();
            while (!bl && accIt.hasNext()) {
                accType = accIt.next();
                Iterator<TransferType> ttIt = accType.getFromTransferTypes().iterator();
                while (!bl && ttIt.hasNext()) {
                    TransferType tt = ttIt.next();
                    if (!tt.getTo().equals(invoice.getDestinationAccountType())) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            throw new MemberHasOpenInvoicesException(newGroup);
        }
        invoiceQuery.setDirection(InvoiceQuery.Direction.OUTGOING);
        for (Invoice invoice : this.invoiceService.search(invoiceQuery)) {
            if (accountTypes.contains(invoice.getDestinationAccountType())) continue;
            throw new MemberHasOpenInvoicesException(newGroup);
        }
        this.cancelScheduledPaymentsAndNotify(member, newGroup);
        BigDecimal minimumPayment = this.paymentService.getMinimumPayment();
        for (Account account : this.accountService.getAccounts(member, new Relationship[0])) {
            BigDecimal balance = this.accountService.getBalance(new AccountDateDTO(account));
            if (accountTypes.contains(account.getType()) || balance.abs().compareTo(minimumPayment) <= 0) continue;
            throw new MemberHasBalanceException(newGroup, (MemberAccountType)account.getType());
        }
    }

    private RegistrationAgreementLog createAgreementLog(String remoteAddress, Member member, RegistrationAgreement registrationAgreement) {
        RegistrationAgreementLog log = new RegistrationAgreementLog();
        log.setMember(member);
        log.setRegistrationAgreement(registrationAgreement);
        log.setDate(Calendar.getInstance());
        log.setRemoteAddress(remoteAddress);
        return this.registrationAgreementLogDao.insert(log);
    }

    private void createGroupHistoryLog(Element element, Group group, Calendar start) {
        GroupHistoryLog newGhl = new GroupHistoryLog();
        newGhl.setElement(element);
        newGhl.setGroup(group);
        newGhl.setPeriod(Period.begginingAt(start));
        this.groupHistoryLogDao.insert(newGhl);
    }

    private void createGroupRemark(Element member, Group oldGroup, Group newGroup, String comments) {
        Calendar now = Calendar.getInstance();
        GroupRemark remark = new GroupRemark();
        if (LoggedUser.hasUser()) {
            remark.setWriter((Element)LoggedUser.element());
        }
        remark.setSubject(member);
        remark.setDate(now);
        remark.setOldGroup(oldGroup);
        remark.setNewGroup(newGroup);
        remark.setComments(comments);
        this.remarkService.save(remark);
        this.updateGroupHistoryLogs(member, newGroup, now);
    }

    private Validator createValidator(final Group group, final Element element, final WhenSaving when, final boolean manualPassword) {
        final Element.Nature nature = group.getNature().getElementNature();
        final String baseName = nature.name().toLowerCase();
        return new DelegatingValidator(new DelegatingValidator.DelegateSource(){

            @Override
            public Validator getValidator() {
                boolean ignoreValidation;
                AccessSettings accessSettings = ElementServiceImpl.this.settingsService.getAccessSettings();
                LocalSettings localSettings = ElementServiceImpl.this.settingsService.getLocalSettings();
                Validator validator = new Validator(baseName);
                validator.property("group").required();
                validator.property("name").required().maxLength(100);
                boolean isMember = nature == Element.Nature.MEMBER;
                ServiceClient client = LoggedUser.serviceClient();
                if (element.isTransient() && (!isMember || accessSettings.getUsernameGeneration() == AccessSettings.UsernameGeneration.NONE) || element.isPersistent()) {
                    Validator.Property username = validator.property("username");
                    username.required();
                    validator.general(new ExistingUsernameValidation());
                    RangeConstraint usernameLength = accessSettings.getUsernameLength();
                    if (usernameLength != null) {
                        username.add(new LengthValidation(usernameLength)).regex(accessSettings.getUsernameRegex());
                    }
                }
                if (element.isTransient()) {
                    Channel channel;
                    boolean loginPasswordRequired;
                    boolean bl = loginPasswordRequired = manualPassword || when == WhenSaving.PUBLIC;
                    if (client != null && ((channel = client.getChannel()).getCredentials() == Channel.Credentials.DEFAULT || channel.getCredentials() == Channel.Credentials.LOGIN_PASSWORD)) {
                        loginPasswordRequired = true;
                    }
                    Validator.Property password = validator.property("user.password").key("createMember.password");
                    if (loginPasswordRequired) {
                        password.required();
                    }
                    if (!when.isPreHashed()) {
                        ElementServiceImpl.this.accessService.addLoginPasswordValidation(element, password);
                    }
                    if (isMember) {
                        Channel channel2;
                        boolean pinRequired = false;
                        if (client != null && (channel2 = client.getChannel()).getCredentials() == Channel.Credentials.PIN) {
                            pinRequired = true;
                        }
                        Validator.Property pin = validator.property("user.pin").key("channel.credentials.PIN");
                        if (pinRequired) {
                            pin.required();
                        }
                        if (!when.isPreHashed()) {
                            ElementServiceImpl.this.accessService.addPinValidation((Member)element, pin);
                        }
                    }
                }
                Validator.Property email = validator.property("email");
                boolean bl = ignoreValidation = nature == Element.Nature.OPERATOR || client != null && client.isIgnoreRegistrationValidations();
                if (!ignoreValidation && localSettings.isEmailRequired()) {
                    email.required();
                }
                email.add(EmailValidation.instance()).maxLength(100);
                if (localSettings.isEmailUnique()) {
                    email.add(new UniqueEmailValidation(element.getId(), when == WhenSaving.PUBLIC));
                }
                validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                    @Override
                    public Validator getValidator() {
                        switch (nature) {
                            case ADMIN: {
                                return ElementServiceImpl.this.adminCustomFieldService.getValueValidator((AdminGroup)group);
                            }
                            case MEMBER: {
                                Member member = (Member)element;
                                MemberCustomField.Access access = null;
                                if (!LoggedUser.hasUser()) {
                                    access = MemberCustomField.Access.REGISTRATION;
                                } else {
                                    member = ElementServiceImpl.this.fetchService.fetch(member, Member.Relationships.BROKER);
                                    Object loggedElement = LoggedUser.element();
                                    if (((Entity)loggedElement).equals(element)) {
                                        access = MemberCustomField.Access.MEMBER;
                                    } else if (member == null && LoggedUser.isBroker() || member != null && ((Entity)loggedElement).equals(member.getBroker())) {
                                        access = MemberCustomField.Access.BROKER;
                                    } else if (loggedElement instanceof Administrator) {
                                        access = MemberCustomField.Access.ADMIN;
                                    }
                                }
                                return ElementServiceImpl.this.memberCustomFieldService.getValueValidator((MemberGroup)group, access);
                            }
                            case OPERATOR: {
                                return ElementServiceImpl.this.operatorCustomFieldService.getValueValidator(((OperatorGroup)group).getMember());
                            }
                        }
                        return null;
                    }
                }));
                return validator;
            }
        });
    }

    private String generateUsername(int length) {
        String generated;
        boolean exists;
        do {
            if ((generated = RandomStringUtils.randomNumeric((int)length)).charAt(0) == '0') {
                generated = new Random().nextInt(8) + 1 + generated.substring(1);
            }
            try {
                this.userDao.load(generated, new Relationship[0]);
                exists = true;
            }
            catch (EntityNotFoundException e) {
                exists = false;
            }
        } while (exists);
        return generated;
    }

    private MemberGroupSettings.EmailValidation getEmailValidation(WhenSaving whenSaving, Element element) {
        if (whenSaving == null || element.getNature() != Element.Nature.MEMBER) {
            return null;
        }
        switch (whenSaving) {
            case BY_BROKER: {
                return MemberGroupSettings.EmailValidation.BROKER;
            }
            case MEMBER_BY_ADMIN: {
                return MemberGroupSettings.EmailValidation.ADMIN;
            }
            case PROFILE: {
                if (LoggedUser.serviceClient() != null) {
                    return MemberGroupSettings.EmailValidation.WEB_SERVICE;
                }
                if (((Entity)LoggedUser.element()).equals(element)) {
                    return MemberGroupSettings.EmailValidation.USER;
                }
                if (LoggedUser.isBroker()) {
                    return MemberGroupSettings.EmailValidation.BROKER;
                }
                if (LoggedUser.isAdministrator()) {
                    return MemberGroupSettings.EmailValidation.ADMIN;
                }
            }
            case PUBLIC: {
                return MemberGroupSettings.EmailValidation.USER;
            }
            case WEB_SERVICE: {
                return MemberGroupSettings.EmailValidation.WEB_SERVICE;
            }
        }
        return null;
    }

    private AccountType getFrom(TransferType tt) {
        return tt == null ? null : tt.getFrom();
    }

    private Validator getValidator(final PendingMember pendingMember) {
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        final MemberGroup group = pendingMember.getMemberGroup();
        Validator validator = new Validator("member");
        validator.property("name").required().maxLength(100);
        if (accessSettings.getUsernameGeneration() == AccessSettings.UsernameGeneration.NONE) {
            validator.property("username").required().maxLength(64);
        }
        validator.property("email").required().maxLength(100).add(new PendingMemberEmailValidation(pendingMember));
        if (group != null) {
            validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                @Override
                public Validator getValidator() {
                    MemberCustomField.Access access = null;
                    access = !LoggedUser.hasUser() ? MemberCustomField.Access.REGISTRATION : (((Entity)LoggedUser.element()).equals(pendingMember.getBroker()) ? MemberCustomField.Access.BROKER : MemberCustomField.Access.ADMIN);
                    return ElementServiceImpl.this.memberCustomFieldService.getValueValidator(group, access);
                }
            }));
        }
        validator.general(new ExistingUsernameValidation());
        return validator;
    }

    private void handleAccounts(Member member) {
        member = this.fetchService.fetch(member, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
        MemberGroup group = member.getMemberGroup();
        Collection<MemberGroupAccountSettings> accountSettings = group.getAccountSettings();
        List<? extends Account> accounts = this.accountService.getAccounts(member, Account.Relationships.TYPE);
        for (MemberAccount memberAccount : accounts) {
            if (this.hasAccount(memberAccount, accountSettings)) continue;
            this.memberAccountHandler.deactivate(memberAccount, group.getStatus() == Group.Status.REMOVED);
        }
        if (!CollectionUtils.isEmpty(accountSettings)) {
            for (MemberGroupAccountSettings memberGroupAccountSettings : accountSettings) {
                this.memberAccountHandler.activate(member, memberGroupAccountSettings.getAccountType());
            }
        }
        if (member.getActivationDate() == null && group.isActive()) {
            member.setActivationDate(Calendar.getInstance());
        }
    }

    private boolean hasAccount(MemberAccount account, Collection<MemberGroupAccountSettings> accountSettings) {
        for (MemberGroupAccountSettings settings : accountSettings) {
            if (!account.getType().equals(settings.getAccountType())) continue;
            return true;
        }
        return false;
    }

    private RegisteredMember register(Member member, WhenSaving when, boolean forceChangePassword, String remoteAddress) {
        RegisteredMember result;
        boolean validateEmail;
        MemberGroup group = (MemberGroup)this.fetchService.fetch(member.getGroup(), new Relationship[0]);
        member.setGroup(group);
        MemberGroupSettings settings = group.getMemberSettings();
        MemberGroupSettings.EmailValidation emailValidation = this.getEmailValidation(when, member);
        boolean bl = validateEmail = settings.getEmailValidation() != null && settings.getEmailValidation().contains(emailValidation);
        if (validateEmail) {
            RegistrationAgreement registrationAgreement;
            PendingMember pendingMember = new PendingMember();
            PropertyHelper.copyProperties(member, pendingMember, new String[0]);
            pendingMember.setCreationDate(Calendar.getInstance());
            pendingMember.setSalt(this.hashHandler.newSalt());
            pendingMember.setForceChangePassword(forceChangePassword);
            User user = member.getUser();
            if (user != null) {
                pendingMember.setPassword(this.hashHandler.hash(pendingMember.getSalt(), user.getPassword()));
            }
            if (user instanceof MemberUser) {
                MemberUser memberUser = (MemberUser)user;
                pendingMember.setPin(this.hashHandler.hash(pendingMember.getSalt(), memberUser.getPin()));
            }
            pendingMember.setValidationKey(RandomStringUtils.randomAlphanumeric((int)64));
            if (when == WhenSaving.PUBLIC && (registrationAgreement = group.getRegistrationAgreement()) != null) {
                pendingMember.setRegistrationAgreement(registrationAgreement);
                pendingMember.setRegistrationAgreementDate(Calendar.getInstance());
            }
            this.validate(pendingMember);
            result = this.pendingMemberDao.insert(pendingMember);
            this.memberCustomFieldService.saveValues(result);
            this.resendEmail((PendingMember)result);
        } else {
            RegistrationAgreement registrationAgreement;
            ActivationMail activationMail = when == WhenSaving.WEB_SERVICE ? ActivationMail.THREADED : ActivationMail.ONLINE;
            result = member = this.save(member, activationMail, when, forceChangePassword);
            if (when == WhenSaving.PUBLIC && (registrationAgreement = (member = this.fetchService.fetch(member, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.REGISTRATION_AGREEMENT))).getMemberGroup().getRegistrationAgreement()) != null) {
                this.createAgreementLog(remoteAddress, member, registrationAgreement);
            }
            this.adminNotificationHandler.notifyNewPublicRegistration(member);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingEmailChange resendEmail(PendingEmailChange pendingEmailChange) throws MailSendingException {
        try {
            this.mailHandler.sendEmailChange(pendingEmailChange);
            pendingEmailChange.setLastEmailDate(Calendar.getInstance());
            PendingEmailChange pendingEmailChange2 = this.pendingEmailChangeDao.update(pendingEmailChange);
            return pendingEmailChange2;
        }
        finally {
            if (CurrentTransactionData.hasMailError()) {
                throw new MailSendingException("Email change validation for " + pendingEmailChange.getMember().getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <E extends Element> E save(E element, ActivationMail activationMail, WhenSaving when, boolean forceChangePassword) {
        this.validate((Element)element, when, false);
        Collection values = (Collection)PropertyHelper.get(element, "customValues");
        PropertyHelper.set(element, "customValues", null);
        boolean isInsert = ((Entity)element).isTransient();
        if (isInsert) {
            Calendar creationDate;
            MemberUser memberUser;
            AccessSettings accessSettings = this.settingsService.getAccessSettings();
            AccessSettings.UsernameGeneration usernameGeneration = accessSettings.getUsernameGeneration();
            if (element instanceof Member && usernameGeneration != AccessSettings.UsernameGeneration.NONE) {
                User user = ((Element)element).getUser();
                if (user == null) {
                    user = new MemberUser();
                    ((Element)element).setUser(user);
                }
                String generated = this.generateUsername(accessSettings.getGeneratedUsernameLength());
                while (!this.uniqueObjectHandler.tryAcquire(Pair.of(generated, generated))) {
                    generated = this.generateUsername(accessSettings.getGeneratedUsernameLength());
                }
                user.setUsername(generated);
            } else {
                String username = ((Element)element).getUsername();
                if (!this.uniqueObjectHandler.tryAcquire(Pair.of(username, username))) {
                    throw new UsernameAlreadyInUseException(username);
                }
                try {
                    if (element instanceof Operator) {
                        this.loadOperatorUser((Member)LoggedUser.element(), username, new Relationship[0]);
                    } else {
                        this.loadUser(username, new Relationship[0]);
                    }
                    throw new UsernameAlreadyInUseException(username);
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
            String email = StringUtils.trimToNull((String)((Element)element).getEmail());
            if (this.settingsService.getLocalSettings().isEmailUnique() && StringUtils.isNotEmpty((String)email) && !this.uniqueObjectHandler.tryAcquire(Pair.of(email, email))) {
                throw new ValidationException(new UniqueError(email));
            }
            User user = ((Element)element).getUser();
            if (user.getSalt() == null) {
                user.setSalt(this.hashHandler.newSalt());
            }
            if (StringUtils.isNotEmpty((String)user.getPassword())) {
                if (!when.isPreHashed()) {
                    user.setPassword(this.hashHandler.hash(user.getSalt(), user.getPassword()));
                }
                if (!forceChangePassword) {
                    user.setPasswordDate(Calendar.getInstance());
                }
            }
            if (user instanceof MemberUser && StringUtils.isNotEmpty((String)(memberUser = (MemberUser)user).getPin()) && !when.isPreHashed()) {
                memberUser.setPin(this.hashHandler.hash(user.getSalt(), memberUser.getPin()));
            }
            if ((creationDate = ((Element)element).getCreationDate()) == null) {
                creationDate = Calendar.getInstance();
                ((Element)element).setCreationDate(creationDate);
            }
            if ((element = (Element)this.elementDao.insert(element)) instanceof Member) {
                void var21_42;
                Member member = (Member)element;
                this.handleAccounts(member);
                if (member.isActive()) {
                    this.sendActivationMailIfNeeded(activationMail, member);
                }
                MemberGroup group = this.fetchService.fetch(member.getMemberGroup(), MemberGroup.Relationships.CHANNELS, MemberGroup.Relationships.DEFAULT_MAIL_MESSAGES, MemberGroup.Relationships.SMS_MESSAGES, MemberGroup.Relationships.DEFAULT_SMS_MESSAGES);
                ArrayList<Channel> memberChannels = new ArrayList<Channel>(group.getDefaultChannels());
                member.setChannels(memberChannels);
                element = this.elementDao.update(member, false);
                ArrayList<NotificationPreference> preferences = new ArrayList<NotificationPreference>();
                Collection<Message.Type> defaultMailMessages = group.getDefaultMailMessages();
                Collection<Message.Type> smsMessages = group.getSmsMessages();
                Collection<Message.Type> defaultSmsMessages = group.getDefaultSmsMessages();
                Message.Type[] arr$ = Message.Type.values();
                int len$ = arr$.length;
                boolean bl = false;
                while (var21_42 < len$) {
                    Message.Type type = arr$[var21_42];
                    NotificationPreference preference = new NotificationPreference();
                    preference.setEmail(defaultMailMessages.contains(type));
                    preference.setMessage(true);
                    if (smsMessages.contains(type) && defaultSmsMessages.contains(type)) {
                        preference.setSms(true);
                    }
                    preference.setMember(member);
                    preference.setType(type);
                    preferences.add(preference);
                    ++var21_42;
                }
                this.preferenceService.save(member, preferences);
                Member broker = member.getBroker();
                if (broker != null) {
                    this.brokeringService.create(broker, member);
                }
            }
            this.createGroupHistoryLog((Element)element, ((Element)element).getGroup(), creationDate);
        } else {
            Element saved = (Element)this.elementDao.load(((Entity)element).getId(), new Relationship[0]);
            ((Element)element).setCreationDate(saved.getCreationDate());
            ((Element)element).setGroup(saved.getGroup());
            User user = saved.getUser();
            if (element instanceof Member) {
                String givenEmail;
                String savedEmail;
                String givenName;
                boolean isWebServiceInvocation = !LoggedUser.hasUser();
                Member member = (Member)element;
                String savedName = saved.getName();
                if (!savedName.equals(givenName = ((Element)element).getName())) {
                    boolean canChangeName;
                    boolean bl = canChangeName = isWebServiceInvocation || this.permissionService.permission(member).admin(AdminMemberPermission.MEMBERS_CHANGE_NAME).broker(BrokerPermission.MEMBERS_CHANGE_NAME).member(MemberPermission.PROFILE_CHANGE_NAME).hasPermission();
                    if (!canChangeName) {
                        member.setName(savedName);
                    }
                }
                if (!ObjectUtils.equals((Object)(savedEmail = StringUtils.trimToNull((String)saved.getEmail())), (Object)(givenEmail = StringUtils.trimToNull((String)((Element)element).getEmail())))) {
                    boolean canChangeEmail;
                    boolean bl = canChangeEmail = isWebServiceInvocation || this.permissionService.permission(member).admin(AdminMemberPermission.MEMBERS_CHANGE_EMAIL).broker(BrokerPermission.MEMBERS_CHANGE_EMAIL).member(MemberPermission.PROFILE_CHANGE_EMAIL).hasPermission();
                    if (!canChangeEmail) {
                        member.setEmail(savedEmail);
                    } else {
                        this.pendingEmailChangeDao.removeAll(member);
                        if (givenEmail != null) {
                            MemberGroupSettings.EmailValidation emailValidation = this.getEmailValidation(when, (Element)element);
                            if (member.getMemberGroup().getMemberSettings().getEmailValidation().contains(emailValidation)) {
                                member.setEmail(savedEmail);
                                PendingEmailChange pec = new PendingEmailChange();
                                pec.setBy((Element)LoggedUser.element());
                                pec.setCreationDate(Calendar.getInstance());
                                pec.setMember(member);
                                pec.setNewEmail(givenEmail);
                                pec.setRemoteAddress(LoggedUser.remoteAddress());
                                pec.setValidationKey(RandomStringUtils.randomAlphanumeric((int)64));
                                pec = this.pendingEmailChangeDao.insert(pec);
                                this.resendEmail(pec);
                            }
                        }
                    }
                }
                String savedUsername = saved.getUsername();
                String givenUsername = ((Element)element).getUsername();
                boolean canChangeUsername = this.settingsService.getAccessSettings().getUsernameGeneration() == AccessSettings.UsernameGeneration.NONE ? isWebServiceInvocation || this.permissionService.permission(member).admin(AdminMemberPermission.MEMBERS_CHANGE_USERNAME).broker(BrokerPermission.MEMBERS_CHANGE_USERNAME).member(MemberPermission.PROFILE_CHANGE_USERNAME).hasPermission() : false;
                if (!savedUsername.equals(givenUsername) && canChangeUsername) {
                    UsernameChangeLog log = new UsernameChangeLog();
                    log.setDate(Calendar.getInstance());
                    log.setBy((Element)LoggedUser.element());
                    log.setUser(user);
                    log.setPreviousUsername(savedUsername);
                    log.setNewUsername(givenUsername);
                    this.usernameChangeLogDao.insert(log);
                    user.setUsername(givenUsername);
                    List<? extends Account> accounts = this.accountService.getAccounts(member, new Relationship[0]);
                    for (Account account : accounts) {
                        account.setOwnerName(givenUsername);
                    }
                }
            } else if (element instanceof Operator && LoggedUser.isMember()) {
                user.setUsername(((Element)element).getUsername());
            }
            ((Element)element).setUser(user);
            if (element instanceof Member) {
                Member member = (Member)element;
                Member savedMember = (Member)saved;
                member.setActivationDate(savedMember.getActivationDate());
                member.setBroker(savedMember.getBroker());
                member.setChannels(this.accessService.getChannelsEnabledForMember(savedMember));
            } else if (element instanceof Operator) {
                Operator operator = (Operator)element;
                Operator savedOperator = (Operator)saved;
                operator.setMember(savedOperator.getMember());
                if (!LoggedUser.isMember()) {
                    operator.setName(savedOperator.getName());
                }
            }
            element = (Element)this.elementDao.update(element);
        }
        PropertyHelper.set(element, "customValues", values);
        if (element instanceof Member) {
            this.memberCustomFieldService.saveValues((Member)element);
        } else if (element instanceof Administrator) {
            this.adminCustomFieldService.saveValues((Administrator)element);
        } else if (element instanceof Operator) {
            this.operatorCustomFieldService.saveValues((Operator)element);
        }
        this.elementDao.addToIndex(element);
        return (E)element;
    }

    private void sendActivationMailIfNeeded(ActivationMail activationMail, Member member) {
        if (activationMail == ActivationMail.IGNORE || StringUtils.isEmpty((String)member.getEmail())) {
            return;
        }
        MemberGroup group = member.getMemberGroup();
        User user = member.getUser();
        boolean sendPasswordByEmail = group.getMemberSettings().isSendPasswordByEmail();
        String password = null;
        if (sendPasswordByEmail && StringUtils.isEmpty((String)user.getPassword())) {
            password = this.accessService.generatePassword(group);
            user.setPassword(this.hashHandler.hash(user.getSalt(), password));
            member.setUser(this.userDao.update(user));
            member.getMemberUser().setPasswordGenerated(true);
        }
        this.mailHandler.sendActivation(activationMail == ActivationMail.THREADED, member, password);
    }

    private String toString(Collection<Channel> channels) {
        StringBuilder str = new StringBuilder();
        for (Channel channel : channels) {
            channel = this.channelService.load(channel.getId());
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(channel.getDisplayName());
        }
        return str.toString();
    }

    private void updateGroupHistoryLogs(Element element, Group newGroup, Calendar date) {
        GroupHistoryLog lastGhl = this.groupHistoryLogDao.getLastGroupHistoryLog(element);
        if (lastGhl != null) {
            lastGhl.getPeriod().setEnd(date);
            this.groupHistoryLogDao.update(lastGhl);
        }
        this.createGroupHistoryLog(element, newGroup, date);
    }

    private class UniqueEmailValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -1170302387628372503L;
        private final Long userId;
        private final boolean pendingToo;

        private UniqueEmailValidation(Long userId, boolean pendingToo) {
            this.userId = userId;
            this.pendingToo = pendingToo;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String email = (String)value;
            if (StringUtils.isEmpty((String)email)) {
                return null;
            }
            try {
                Element loaded = ElementServiceImpl.this.elementDao.loadByEmail(email, new Relationship[0]);
                if (this.userId == null) {
                    return new UniqueError(email);
                }
                if (!loaded.getId().equals(this.userId)) {
                    return new UniqueError(email);
                }
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
            if (this.pendingToo && ElementServiceImpl.this.pendingMemberDao.emailExists(null, email)) {
                return new UniqueError(email);
            }
            return null;
        }
    }

    private class PendingMemberEmailValidation
    implements PropertyValidation {
        private final PendingMember pendingMember;
        private static final long serialVersionUID = 377970183876523686L;

        private PendingMemberEmailValidation(PendingMember pendingMember) {
            this.pendingMember = pendingMember;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String email = (String)value;
            LocalSettings localSettings = ElementServiceImpl.this.settingsService.getLocalSettings();
            if (localSettings.isEmailUnique()) {
                if (StringUtils.isNotEmpty((String)email) && ElementServiceImpl.this.pendingMemberDao.emailExists(this.pendingMember, email)) {
                    return new UniqueError(email);
                }
                try {
                    Element loaded = ElementServiceImpl.this.elementDao.loadByEmail(email, new Relationship[0]);
                    if (loaded != null) {
                        return new UniqueError(email);
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private class ExistingUsernameValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -3358417537796698704L;

        private ExistingUsernameValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            String username = null;
            if (object instanceof Element) {
                username = ((Element)object).getUsername();
            } else if (object instanceof PendingMember) {
                username = ((PendingMember)object).getUsername();
            }
            Long id = ((Entity)object).getId();
            if (StringUtils.isEmpty((String)username)) {
                return null;
            }
            boolean existing = false;
            if (object instanceof Operator) {
                Member member = LoggedUser.isOperator() ? (Member)LoggedUser.accountOwner() : (Member)LoggedUser.element();
                try {
                    OperatorUser existingOperator = ElementServiceImpl.this.userDao.loadOperator(member, username, new Relationship[0]);
                    existing = !existingOperator.getId().equals(id);
                }
                catch (EntityNotFoundException e) {}
            } else {
                try {
                    Object existingUser = ElementServiceImpl.this.userDao.load(username, new Relationship[0]);
                    existing = !((Entity)existingUser).getId().equals(id);
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
                if (!existing) {
                    try {
                        PendingMember pendingMember = ElementServiceImpl.this.pendingMemberDao.loadByUsername(username, new Relationship[0]);
                        existing = !(object instanceof PendingMember) || !pendingMember.getId().equals(((PendingMember)object).getId());
                    }
                    catch (EntityNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            if (existing) {
                return new ValidationError("createMember.error.usernameAlreadyInUse", username);
            }
            return null;
        }
    }

    private static enum ActivationMail {
        IGNORE,
        THREADED,
        ONLINE;

    }
}

