/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.AdminQuery;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.ElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.OperatorQuery;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasBalanceException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberHasOpenInvoicesException;
import nl.strohalm.cyclos.services.elements.exceptions.RegistrationAgreementNotAcceptedException;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ElementServiceSecurity
extends BaseServiceSecurity
implements ElementService {
    private ElementServiceLocal elementService;
    private GroupServiceLocal groupService;
    private ChannelServiceLocal channelService;

    @Override
    public void acceptAgreement(String remoteAddress) {
        if (!LoggedUser.isMember()) {
            throw new PermissionDeniedException();
        }
        this.elementService.acceptAgreement(remoteAddress);
    }

    @Override
    public BulkMemberActionResultVO bulkChangeMemberChannels(FullTextMemberQuery query, Collection<Channel> enableChannels, Collection<Channel> disableChannels) throws ValidationException {
        if (!this.elementService.applyQueryRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission().admin(AdminMemberPermission.BULK_ACTIONS_CHANGE_CHANNELS).check();
        Channel webChannel = this.channelService.loadByInternalName("web");
        if (enableChannels.contains(webChannel) || disableChannels.contains(webChannel)) {
            throw new PermissionDeniedException();
        }
        return this.elementService.bulkChangeMemberChannels(query, enableChannels, disableChannels);
    }

    @Override
    public BulkMemberActionResultVO bulkChangeMemberGroup(FullTextMemberQuery query, MemberGroup newGroup, String comments) throws ValidationException {
        if (!this.elementService.applyQueryRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission().admin(AdminMemberPermission.BULK_ACTIONS_CHANGE_GROUP).check();
        this.permissionService.checkManages(newGroup);
        return this.elementService.bulkChangeMemberGroup(query, newGroup, comments);
    }

    @Override
    public <E extends Element> E changeGroup(E element, Group newGroup, String comments) throws MemberHasBalanceException, MemberHasOpenInvoicesException, ValidationException {
        this.checkChangeGroup(element);
        if (((Entity)LoggedUser.element()).equals(element) || !this.permissionService.getAllVisibleGroups().contains(newGroup)) {
            throw new PermissionDeniedException();
        }
        return this.elementService.changeGroup(element, newGroup, comments);
    }

    @Override
    public <E extends Element> E changeProfile(E element) {
        if (!((Entity)LoggedUser.element()).equals(element)) {
            this.permissionService.permission(element).admin(AdminAdminPermission.ADMINS_CHANGE_PROFILE, AdminMemberPermission.MEMBERS_CHANGE_PROFILE).broker(BrokerPermission.MEMBERS_CHANGE_PROFILE).member(MemberPermission.OPERATORS_MANAGE).check();
        }
        return this.elementService.changeProfile(element);
    }

    @Override
    public PendingEmailChange confirmEmailChange(String key) throws EntityNotFoundException {
        if (!LoggedUser.isMember()) {
            throw new PermissionDeniedException();
        }
        return this.elementService.confirmEmailChange(key);
    }

    @Override
    public List<? extends Element> fullTextSearch(FullTextElementQuery query) {
        if (!this.elementService.applyQueryRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        return this.elementService.fullTextSearch(query);
    }

    @Override
    public ElementVO getElementVO(long id) {
        return this.elementService.getElementVO(id);
    }

    @Override
    public Calendar getFirstMemberActivationDate() {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_STATISTICS).check();
        return this.elementService.getFirstMemberActivationDate();
    }

    @Override
    public PendingEmailChange getPendingEmailChange(Member member) {
        this.permissionService.checkManages(member);
        return this.elementService.getPendingEmailChange(member);
    }

    @Override
    public List<? extends Group> getPossibleNewGroups(Element element) {
        this.checkChangeGroup(element);
        return this.elementService.getPossibleNewGroups(element);
    }

    @Override
    public void invitePerson(String email) {
        this.permissionService.permission().basic(BasicPermission.BASIC_INVITE_MEMBER).check();
        this.elementService.invitePerson(email);
    }

    @Override
    public <T extends Element> T load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        Object element = this.elementService.load(id, fetch);
        this.permissionService.checkRelatesTo((Element)element);
        return element;
    }

    @Override
    public Member loadByPrincipal(PrincipalType principalType, String principal, Relationship ... fetch) throws EntityNotFoundException {
        return this.elementService.loadByPrincipal(principalType, principal, fetch);
    }

    @Override
    public PendingMember loadPendingMember(Long id, Relationship ... fetch) {
        PendingMember pendingMember = this.elementService.loadPendingMember(id, fetch);
        this.checkManagePending(pendingMember);
        return pendingMember;
    }

    @Override
    public PendingMember loadPendingMemberByKey(String key, Relationship ... fetch) {
        return this.elementService.loadPendingMemberByKey(key, fetch);
    }

    @Override
    public <T extends User> T loadUser(Long id, Relationship ... fetch) throws EntityNotFoundException {
        Object user = this.elementService.loadUser(id, fetch);
        this.permissionService.checkRelatesTo(((User)user).getElement());
        return user;
    }

    @Override
    public <T extends User> T loadUser(String username, Relationship ... fetch) throws EntityNotFoundException {
        Object user = this.elementService.loadUser(username, fetch);
        this.permissionService.checkRelatesTo(((User)user).getElement());
        return user;
    }

    @Override
    public Member publicValidateRegistration(String key) throws EntityNotFoundException, RegistrationAgreementNotAcceptedException {
        return this.elementService.publicValidateRegistration(key);
    }

    @Override
    public Object register(Element element, boolean forceChangePassword, String remoteAddress) {
        if (element.getGroup() == null) {
            throw new ValidationException();
        }
        if (LoggedUser.hasUser()) {
            this.permissionService.checkManages(element.getGroup());
            Group.Nature groupNature = element.getGroup().getNature();
            this.permissionService.permission().admin((AdminPermission)((Object)(groupNature == Group.Nature.MEMBER || groupNature == Group.Nature.BROKER ? AdminMemberPermission.MEMBERS_REGISTER : AdminAdminPermission.ADMINS_REGISTER))).broker(BrokerPermission.MEMBERS_REGISTER).member(MemberPermission.OPERATORS_MANAGE).check();
        }
        PermissionHelper.checkContains(this.getPossibleInitialGroups(element), element.getGroup());
        return this.elementService.register(element, forceChangePassword, remoteAddress);
    }

    @Override
    public <T extends User> T reloadUser(Long id, Relationship ... fetch) throws EntityNotFoundException {
        Object user = this.elementService.reloadUser(id, fetch);
        this.permissionService.checkRelatesTo(((User)user).getElement());
        return user;
    }

    @Override
    public void remove(Long id) throws UnexpectedEntityException {
        Object element = this.elementService.load(id, new Relationship[0]);
        this.permissionService.permission((Element)element).admin(AdminMemberPermission.MEMBERS_REMOVE, AdminAdminPermission.ADMINS_REMOVE).member(MemberPermission.OPERATORS_MANAGE).check();
        this.elementService.remove(id);
    }

    @Override
    public int removePendingMembers(Long ... ids) {
        for (Long id : ids) {
            PendingMember pendingMember = this.elementService.loadPendingMember(id, new Relationship[0]);
            this.checkManagePending(pendingMember);
        }
        return this.elementService.removePendingMembers(ids);
    }

    @Override
    public PendingMember resendEmail(PendingMember pendingMember) throws MailSendingException {
        pendingMember = this.fetchService.fetch(pendingMember, new Relationship[0]);
        this.checkManagePending(pendingMember);
        return this.elementService.resendEmail(pendingMember);
    }

    @Override
    public PendingEmailChange resendEmailChange(Long memberId) throws MailSendingException {
        Member member = this.fetchService.fetch(EntityHelper.reference(Member.class, memberId), new Relationship[0]);
        this.permissionService.permission(member).admin(AdminMemberPermission.MEMBERS_CHANGE_EMAIL).broker(BrokerPermission.MEMBERS_CHANGE_EMAIL).member(MemberPermission.PROFILE_CHANGE_EMAIL).check();
        return this.elementService.resendEmailChange(memberId);
    }

    @Override
    public List<? extends Element> search(ElementQuery query) {
        if (!this.applyRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        return this.elementService.search(query);
    }

    @Override
    public List<PendingMember> search(PendingMemberQuery params) {
        this.permissionService.permission().admin(AdminMemberPermission.MEMBERS_MANAGE_PENDING).broker(BrokerPermission.MEMBERS_MANAGE_PENDING).check();
        if (LoggedUser.isBroker()) {
            params.setBroker((Member)LoggedUser.element());
        } else {
            params.setGroups(PermissionHelper.checkSelection(this.permissionService.getManagedMemberGroups(), params.getGroups()));
        }
        return this.elementService.search(params);
    }

    @Override
    public List<? extends Element> searchAtDate(MemberQuery query, Calendar date) {
        if (!this.applyRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        return this.elementService.searchAtDate(query, date);
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    @Override
    public void setRegistrationAgreementAgreed(PendingMember pendingMember) {
        this.elementService.setRegistrationAgreementAgreed(pendingMember);
    }

    @Override
    public boolean shallAcceptAgreement(Member member) {
        this.permissionService.checkManages(member);
        return this.elementService.shallAcceptAgreement(member);
    }

    @Override
    public PendingMember update(PendingMember pendingMember) {
        this.checkManagePending(pendingMember);
        return this.elementService.update(pendingMember);
    }

    @Override
    public void validate(Element element, WhenSaving when, boolean manualPassword) throws ValidationException {
        this.elementService.validate(element, when, manualPassword);
    }

    @Override
    public void validate(PendingMember pendingMember) throws ValidationException {
        this.elementService.validate(pendingMember);
    }

    @Override
    public void validateBulkChangeChannels(FullTextMemberQuery query, Collection<Channel> enableChannels, Collection<Channel> disableChannels) {
        this.elementService.validateBulkChangeChannels(query, enableChannels, disableChannels);
    }

    private boolean applyRestrictions(ElementQuery query) {
        if (query instanceof AdminQuery) {
            this.permissionService.permission().admin(AdminAdminPermission.ADMINS_VIEW).check();
        } else if (query instanceof OperatorQuery) {
            Member member = ((OperatorQuery)query).getMember();
            if (member == null) {
                throw new ValidationException();
            }
            this.permissionService.permission(member).member(new MemberPermission[0]).operator().check();
        } else {
            Collection<MemberGroup> visibleGroups = this.permissionService.getVisibleMemberGroups(false);
            if (visibleGroups.isEmpty()) {
                return false;
            }
            Collection<? extends Group> queryGroups = query.getGroups();
            query.setGroups(PermissionHelper.checkSelection(visibleGroups, queryGroups));
        }
        if (!LoggedUser.isAdministrator()) {
            query.setEnabled(true);
        }
        return true;
    }

    private void checkChangeGroup(Element element) {
        this.permissionService.permission(element).admin(AdminAdminPermission.ADMINS_CHANGE_GROUP, AdminMemberPermission.MEMBERS_CHANGE_GROUP).member(MemberPermission.OPERATORS_MANAGE).check();
    }

    private void checkManagePending(PendingMember pendingMember) {
        this.permissionService.permission().admin(AdminMemberPermission.MEMBERS_MANAGE_PENDING).broker(BrokerPermission.MEMBERS_MANAGE_PENDING).check();
        if (LoggedUser.isAdministrator() && !this.permissionService.manages(pendingMember.getMemberGroup())) {
            throw new PermissionDeniedException();
        }
        if (LoggedUser.isBroker() && !((Entity)LoggedUser.element()).equals(pendingMember.getBroker())) {
            throw new PermissionDeniedException();
        }
    }

    private Collection<? extends Group> getPossibleInitialGroups(Element element) {
        Collection<Object> groups;
        if (LoggedUser.getAccessType() == null) {
            groups = element instanceof Member ? this.groupService.getPossibleInitialGroups(null) : Collections.emptyList();
        } else if (element instanceof Administrator) {
            GroupQuery query = new GroupQuery();
            query.setStatus(Group.Status.NORMAL);
            query.setNature(Group.Nature.ADMIN);
            groups = this.groupService.search(query);
        } else if (element instanceof Member) {
            if (LoggedUser.isAdministrator()) {
                groups = this.permissionService.getManagedMemberGroups();
            } else if (LoggedUser.isBroker()) {
                BrokerGroup brokerGroup = (BrokerGroup)this.fetchService.fetch(LoggedUser.group(), new Relationship[]{BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS});
                groups = brokerGroup.getPossibleInitialGroups();
            } else {
                groups = Collections.emptyList();
            }
        } else {
            GroupQuery query = new GroupQuery();
            query.setMember(LoggedUser.member());
            query.setNature(Group.Nature.OPERATOR);
            query.setStatus(Group.Status.NORMAL);
            groups = this.groupService.search(query);
        }
        return groups;
    }
}

