/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.members.imports.ImportedMemberDAO;
import nl.strohalm.cyclos.dao.members.imports.ImportedMemberRecordDAO;
import nl.strohalm.cyclos.dao.members.imports.MemberImportDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberQuery;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberRecord;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.entities.members.imports.MemberImportResult;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.CreditLimitDTO;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberImportServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.csv.CSVReader;
import nl.strohalm.cyclos.utils.csv.UnknownColumnException;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.EmailValidation;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.MaxLengthError;
import nl.strohalm.cyclos.utils.validation.MinLengthError;
import nl.strohalm.cyclos.utils.validation.RegexValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.UniqueError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class MemberImportServiceImpl
implements MemberImportServiceLocal {
    private FetchServiceLocal fetchService;
    private ElementServiceLocal elementService;
    private MemberRecordServiceLocal memberRecordService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService;
    private AccountServiceLocal accountService;
    private PaymentServiceLocal paymentService;
    private SettingsServiceLocal settingsService;
    private GroupServiceLocal groupService;
    private MemberRecordTypeServiceLocal memberRecordTypeService;
    private HashHandler hashHandler;
    private MemberImportDAO memberImportDao;
    private ImportedMemberDAO importedMemberDao;
    private ImportedMemberRecordDAO importedMemberRecordDao;
    private CustomFieldHelper customFieldHelper;

    @Override
    public MemberImportResult getSummary(MemberImport memberImport) {
        MemberImportResult result = new MemberImportResult();
        ImportedMemberQuery query = new ImportedMemberQuery();
        query.setPageForCount();
        query.setMemberImport(memberImport);
        query.setStatus(ImportedMemberQuery.Status.ALL);
        result.setTotal(PageHelper.getTotalCount(this.importedMemberDao.search(query)));
        query.setStatus(ImportedMemberQuery.Status.ERROR);
        result.setErrors(PageHelper.getTotalCount(this.importedMemberDao.search(query)));
        result.setCredits(this.importedMemberDao.getTransactions(memberImport, true));
        result.setDebits(this.importedMemberDao.getTransactions(memberImport, false));
        return result;
    }

    @Override
    public MemberImport importMembers(MemberImport memberImport, InputStream data) {
        List<String> headers;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        this.getValidator().validate(memberImport);
        MemberGroup group = this.fetchService.fetch(memberImport.getGroup(), new Relationship[0]);
        memberImport.setGroup(group);
        memberImport.setBy((Administrator)LoggedUser.element());
        memberImport.setDate(Calendar.getInstance());
        memberImport = this.memberImportDao.insert(memberImport);
        MemberGroupAccountSettings accountSettings = null;
        MemberAccountType accountType = memberImport.getAccountType();
        if (accountType != null) {
            accountSettings = this.groupService.loadAccountSettings(group.getId(), accountType.getId(), new Relationship[0]);
        }
        List<MemberCustomField> customFields = this.memberCustomFieldService.list();
        customFields = this.customFieldHelper.onlyForGroup(customFields, group);
        HashMap<String, CustomField> customFieldMap = new HashMap<String, CustomField>(customFields.size());
        for (MemberCustomField customField : customFields) {
            customFieldMap.put(customField.getInternalName().toLowerCase(), this.fetchService.fetch(customField, CustomField.Relationships.POSSIBLE_VALUES));
        }
        MemberRecordTypeQuery mrtQuery = new MemberRecordTypeQuery();
        mrtQuery.fetch(MemberRecordType.Relationships.FIELDS);
        ArrayList<Group> mrtGroups = new ArrayList<Group>();
        mrtGroups.add(group);
        mrtQuery.setGroups(mrtGroups);
        List<MemberRecordType> recordTypes = this.memberRecordTypeService.search(mrtQuery);
        HashMap<String, MemberRecordType> recordTypeMap = new HashMap<String, MemberRecordType>(recordTypes.size());
        HashMap<MemberRecordType, Map<String, CustomField>> recordTypeFieldsMap = new HashMap<MemberRecordType, Map<String, CustomField>>(recordTypes.size());
        for (MemberRecordType recordType : recordTypes) {
            String lowercaseName = recordType.getName().toLowerCase();
            recordTypeMap.put(lowercaseName, recordType);
            HashMap<String, MemberRecordCustomField> fields = new HashMap<String, MemberRecordCustomField>();
            for (MemberRecordCustomField customField : recordType.getFields()) {
                fields.put(customField.getInternalName().toLowerCase(), this.fetchService.fetch(customField, CustomField.Relationships.POSSIBLE_VALUES));
            }
            recordTypeFieldsMap.put(recordType, fields);
        }
        char stringQuote = CoercionHelper.coerce(Character.TYPE, localSettings.getCsvStringQuote().getValue()).charValue();
        char valueSeparator = CoercionHelper.coerce(Character.TYPE, localSettings.getCsvValueSeparator().getValue()).charValue();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(data, localSettings.getCharset()));
            headers = CSVReader.readLine(in, stringQuote, valueSeparator);
        }
        catch (Exception e) {
            throw new ValidationException("memberImport.invalidFormat", new Object[0]);
        }
        HashSet<String> usedUsernames = new HashSet<String>();
        try {
            List<String> values;
            CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
            int lineNumber = 2;
            while ((values = CSVReader.readLine(in, stringQuote, valueSeparator)) != null) {
                if (values.isEmpty()) continue;
                this.importMember(memberImport, accountSettings, lineNumber, customFieldMap, recordTypeMap, recordTypeFieldsMap, localSettings, accessSettings, headers, values, usedUsernames);
                ++lineNumber;
                cacheCleaner.clearCache();
            }
        }
        catch (IOException e) {
            throw new ValidationException("memberImport.errorReading", new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return memberImport;
    }

    @Override
    public MemberImport load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        return (MemberImport)this.memberImportDao.load(id, fetch);
    }

    @Override
    public void processImport(MemberImport memberImport, boolean sendActivationMail) {
        memberImport = this.fetchService.fetch(memberImport, MemberImport.Relationships.GROUP, MemberImport.Relationships.ACCOUNT_TYPE, MemberImport.Relationships.INITIAL_CREDIT_TRANSFER_TYPE, MemberImport.Relationships.INITIAL_DEBIT_TRANSFER_TYPE);
        ImportedMemberQuery memberQuery = new ImportedMemberQuery();
        memberQuery.setResultType(QueryParameters.ResultType.ITERATOR);
        memberQuery.setMemberImport(memberImport);
        memberQuery.setStatus(ImportedMemberQuery.Status.SUCCESS);
        int count = 0;
        for (ImportedMember importedMember : this.importedMemberDao.search(memberQuery)) {
            this.processMember(memberImport, importedMember, sendActivationMail);
            if (count % 20 == 0) {
                this.fetchService.clearCache();
            }
            ++count;
        }
        this.memberImportDao.delete(memberImport.getId());
    }

    @Override
    public void purgeOld(Calendar time) {
        time = new TimePeriod(1, TimePeriod.Field.DAYS).remove(time);
        for (MemberImport memberImport : this.memberImportDao.listBefore(time)) {
            this.memberImportDao.delete(memberImport.getId());
        }
    }

    @Override
    public List<ImportedMember> searchImportedMembers(ImportedMemberQuery params) {
        return this.importedMemberDao.search(params);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setHashHandler(HashHandler hashHandler) {
        this.hashHandler = hashHandler;
    }

    public void setImportedMemberDao(ImportedMemberDAO importedMemberDao) {
        this.importedMemberDao = importedMemberDao;
    }

    public void setImportedMemberRecordDao(ImportedMemberRecordDAO importedMemberRecordDao) {
        this.importedMemberRecordDao = importedMemberRecordDao;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberImportDao(MemberImportDAO memberImportDao) {
        this.memberImportDao = memberImportDao;
    }

    public void setMemberRecordCustomFieldServiceLocal(MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    public void setMemberRecordServiceLocal(MemberRecordServiceLocal memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    public void setMemberRecordTypeServiceLocal(MemberRecordTypeServiceLocal memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(MemberImport memberImport) throws ValidationException {
        this.getValidator().validate(memberImport);
    }

    private Validator getValidator() {
        Validator validator = new Validator("memberImport");
        validator.property("group").required();
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importMember(MemberImport memberImport, MemberGroupAccountSettings accountSettings, int lineNumber, Map<String, CustomField> customFieldMap, Map<String, MemberRecordType> recordTypeMap, Map<MemberRecordType, Map<String, CustomField>> recordTypeFieldsMap, LocalSettings localSettings, AccessSettings accessSettings, List<String> headers, List<String> values, Set<String> importedUsernames) {
        Object fieldValue;
        ImportedMember member;
        HashMap<MemberRecordType, HashMap<String, String>> recordFieldValues;
        HashMap<String, String> customFieldValues;
        HashMap<MemberRecordType, ImportedMemberRecord> records;
        block81: {
            records = new HashMap<MemberRecordType, ImportedMemberRecord>();
            customFieldValues = new HashMap<String, String>();
            recordFieldValues = new HashMap<MemberRecordType, HashMap<String, String>>();
            member = new ImportedMember();
            member.setSalt(this.hashHandler.newSalt());
            member.setLineNumber(lineNumber);
            member.setImport(memberImport);
            member.setStatus(ImportedMember.Status.SUCCESS);
            member = this.importedMemberDao.insert(member);
            Calendar today = DateHelper.truncate(Calendar.getInstance());
            try {
                member.setCustomValues((Collection<MemberCustomFieldValue>)new ArrayList<MemberCustomFieldValue>());
                CalendarConverter dateConverter = localSettings.getRawDateConverter();
                for (int i = 0; i < headers.size() && i < values.size(); ++i) {
                    String field = StringUtils.trimToEmpty((String)headers.get(i)).toLowerCase();
                    String value = StringUtils.trimToNull((String)values.get(i));
                    if ("name".equals(field)) {
                        member.setName(value);
                        continue;
                    }
                    if ("username".equals(field)) {
                        member.setUsername(value);
                        continue;
                    }
                    if ("password".equals(field)) {
                        member.setPassword(this.hashHandler.hash(member.getSalt(), value));
                        continue;
                    }
                    if ("email".equals(field)) {
                        member.setEmail(value);
                        continue;
                    }
                    if ("creationdate".equals(field)) {
                        try {
                            Calendar creationDate = dateConverter.valueOf(value);
                            if (creationDate == null) continue;
                            if (creationDate.after(today)) throw new Exception();
                            if (creationDate.get(1) < 1950) {
                                throw new Exception();
                            }
                            member.setCreationDate(creationDate);
                            continue;
                        }
                        catch (Exception e) {
                            member.setStatus(ImportedMember.Status.INVALID_CREATION_DATE);
                            member.setErrorArgument1(value);
                            break;
                        }
                    }
                    if ("balance".equals(field)) {
                        try {
                            member.setInitialBalance((BigDecimal)localSettings.getNumberConverter().valueOf(value));
                            continue;
                        }
                        catch (Exception e) {
                            member.setStatus(ImportedMember.Status.INVALID_BALANCE);
                            member.setErrorArgument1(value);
                            break;
                        }
                    }
                    if ("creditlimit".equals(field)) {
                        try {
                            BigDecimal limit = (BigDecimal)localSettings.getNumberConverter().valueOf(value);
                            if (limit != null) {
                                limit = limit.abs();
                            }
                            member.setCreditLimit(limit);
                            continue;
                        }
                        catch (Exception e) {
                            member.setStatus(ImportedMember.Status.INVALID_CREDIT_LIMIT);
                            member.setErrorArgument1(value);
                            break;
                        }
                    }
                    if ("uppercreditlimit".equals(field)) {
                        try {
                            member.setUpperCreditLimit((BigDecimal)localSettings.getNumberConverter().valueOf(value));
                            continue;
                        }
                        catch (Exception e) {
                            member.setStatus(ImportedMember.Status.INVALID_UPPER_CREDIT_LIMIT);
                            member.setErrorArgument1(value);
                            break;
                        }
                    }
                    if (customFieldMap.containsKey(field)) {
                        CustomField customField = customFieldMap.get(field);
                        MemberCustomFieldValue fieldValue2 = new MemberCustomFieldValue();
                        fieldValue2.setField(customField);
                        fieldValue2.setValue(this.preprocessCustomFieldValue(customField, value));
                        member.getCustomValues().add(fieldValue2);
                        customFieldValues.put(field, value);
                        continue;
                    }
                    if (!field.contains(".")) throw new UnknownColumnException(field);
                    String[] parts = field.split("\\.");
                    String recordTypeName = parts[0];
                    MemberRecordType recordType = recordTypeMap.get(recordTypeName);
                    if (recordType == null) {
                        member.setStatus(ImportedMember.Status.INVALID_RECORD_TYPE);
                        member.setErrorArgument1(recordTypeName);
                        break;
                    }
                    String recordTypeField = parts[1];
                    Map<String, CustomField> fieldsMap = recordTypeFieldsMap.get(recordType);
                    CustomField customField = fieldsMap.get(recordTypeField);
                    if (customField == null) {
                        member.setStatus(ImportedMember.Status.INVALID_RECORD_TYPE_FIELD);
                        member.setErrorArgument1(recordTypeName);
                        member.setErrorArgument2(recordTypeField);
                        break;
                    }
                    ImportedMemberRecord record = (ImportedMemberRecord)records.get(recordType);
                    if (record == null) {
                        record = new ImportedMemberRecord();
                        record.setMember(member);
                        record.setType(recordType);
                        record = this.importedMemberRecordDao.insert(record);
                        record.setCustomValues((Collection<ImportedMemberRecordCustomFieldValue>)new ArrayList<ImportedMemberRecordCustomFieldValue>());
                        records.put(recordType, record);
                    }
                    fieldValue = new ImportedMemberRecordCustomFieldValue();
                    ((CustomFieldValue)fieldValue).setField(customField);
                    ((CustomFieldValue)fieldValue).setValue(this.preprocessCustomFieldValue(customField, value));
                    record.getCustomValues().add((ImportedMemberRecordCustomFieldValue)fieldValue);
                    HashMap<String, String> fieldValues = (HashMap<String, String>)recordFieldValues.get(recordType);
                    if (fieldValues == null) {
                        fieldValues = new HashMap<String, String>();
                        recordFieldValues.put(recordType, fieldValues);
                    }
                    fieldValues.put(recordTypeField, value);
                }
                if (member.getStatus() != ImportedMember.Status.SUCCESS) {
                    return;
                }
                if (member.getName() == null) {
                    member.setStatus(ImportedMember.Status.MISSING_NAME);
                    return;
                }
                String username = member.getUsername();
                if (accessSettings.getUsernameGeneration() == AccessSettings.UsernameGeneration.NONE && username == null) {
                    member.setStatus(ImportedMember.Status.MISSING_USERNAME);
                    return;
                }
                if (username != null) {
                    ValidationError error = new RegexValidation(accessSettings.getUsernameRegex()).validate(null, null, username);
                    if (error == null) {
                        error = new LengthValidation(accessSettings.getUsernameLength()).validate(null, null, username);
                    }
                    if (error != null) {
                        member.setStatus(ImportedMember.Status.INVALID_USERNAME);
                        member.setErrorArgument1(username);
                        return;
                    }
                    if (!importedUsernames.add(username)) {
                        member.setStatus(ImportedMember.Status.USERNAME_ALREADY_IN_USE);
                        member.setErrorArgument1(username);
                        return;
                    }
                    this.elementService.loadUser(username, new Relationship[0]);
                    member.setStatus(ImportedMember.Status.USERNAME_ALREADY_IN_USE);
                    member.setErrorArgument1(username);
                    return;
                }
            }
            catch (UnknownColumnException e) {
                throw e;
            }
            catch (Exception e) {
                member.setStatus(ImportedMember.Status.UNKNOWN_ERROR);
                member.setErrorArgument1(e.toString());
                return;
            }
            {
                if (member.getEmail() != null || !localSettings.isEmailRequired()) break block81;
                member.setStatus(ImportedMember.Status.MISSING_EMAIL);
                return;
            }
        }
        if (EmailValidation.instance().validate(null, null, member.getEmail()) != null) {
            member.setStatus(ImportedMember.Status.INVALID_EMAIL);
            member.setErrorArgument1(member.getEmail());
            return;
        }
        if (memberImport.getAccountType() == null) {
            member.setInitialBalance(null);
            member.setCreditLimit(null);
            member.setUpperCreditLimit(null);
        } else {
            BigDecimal balance;
            if (member.getCreditLimit() == null) {
                member.setCreditLimit(accountSettings.getDefaultCreditLimit());
            }
            if (member.getUpperCreditLimit() == null) {
                member.setUpperCreditLimit(accountSettings.getDefaultUpperCreditLimit());
            }
            if ((balance = member.getInitialBalance()) != null) {
                double balanceValue = balance.doubleValue();
                if (balanceValue > 0.0 && memberImport.getInitialCreditTransferType() == null) {
                    member.setInitialBalance(null);
                    balanceValue = 0.0;
                } else if (balanceValue < 0.0 && memberImport.getInitialDebitTransferType() == null) {
                    member.setInitialBalance(null);
                    balanceValue = 0.0;
                }
                BigDecimal creditLimit = member.getCreditLimit();
                if (creditLimit != null && balanceValue < 0.0 && balance.compareTo(creditLimit.negate()) < 0) {
                    member.setStatus(ImportedMember.Status.BALANCE_LOWER_THAN_CREDIT_LIMIT);
                    return;
                }
                BigDecimal upperCreditLimit = member.getUpperCreditLimit();
                if (upperCreditLimit != null && balanceValue > 0.0 && balance.compareTo(upperCreditLimit) > 0) {
                    member.setStatus(ImportedMember.Status.BALANCE_UPPER_THAN_CREDIT_LIMIT);
                    return;
                }
            }
        }
        try {
            this.memberCustomFieldService.saveValues(member);
        }
        catch (Exception e) {
            ValidationException vex;
            Map<String, Collection<ValidationError>> errorsByProperty;
            member.setStatus(ImportedMember.Status.INVALID_CUSTOM_FIELD);
            if (e instanceof ValidationException && MapUtils.isNotEmpty(errorsByProperty = (vex = (ValidationException)e).getErrorsByProperty())) {
                String fieldName = errorsByProperty.keySet().iterator().next();
                String displayName = vex.getDisplayNameByProperty().get(fieldName);
                member.setErrorArgument1(StringUtils.isEmpty((String)displayName) ? fieldName : displayName);
                String fieldValue3 = StringUtils.trimToNull((String)((String)customFieldValues.get(fieldName.toLowerCase())));
                if (CollectionUtils.isNotEmpty(errorsByProperty.get(fieldName))) {
                    ValidationError ve = errorsByProperty.get(fieldName).iterator().next();
                    if (ve instanceof UniqueError) {
                        member.setStatus(ImportedMember.Status.INVALID_CUSTOM_FIELD_VALUE_UNIQUE);
                        member.setErrorArgument2(ve.getArguments().iterator().next().toString());
                    } else if (ve instanceof RequiredError) {
                        member.setStatus(ImportedMember.Status.MISSING_CUSTOM_FIELD);
                    } else if (ve instanceof MaxLengthError) {
                        member.setStatus(ImportedMember.Status.INVALID_CUSTOM_FIELD_VALUE_MAX_LENGTH);
                        member.setErrorArgument2(ve.getArguments().iterator().next().toString());
                    } else if (ve instanceof MinLengthError) {
                        member.setStatus(ImportedMember.Status.INVALID_CUSTOM_FIELD_VALUE_MIN_LENGTH);
                        member.setErrorArgument2(ve.getArguments().iterator().next().toString());
                    }
                }
                if (StringUtils.isEmpty((String)member.getErrorArgument2()) && fieldValue3 != null) {
                    member.setErrorArgument2(fieldValue3);
                }
            }
            this.importedMemberDao.update(member);
            return;
        }
        Iterator i$ = records.values().iterator();
        while (i$.hasNext()) {
            ImportedMemberRecord record = (ImportedMemberRecord)i$.next();
            MemberRecordType recordType = record.getType();
            Map fieldValues = (Map)recordFieldValues.get(recordType);
            boolean empty = true;
            for (String value : fieldValues.values()) {
                if (!StringUtils.isNotEmpty((String)value)) continue;
                empty = false;
                break;
            }
            if (empty) {
                this.importedMemberRecordDao.delete(record.getId());
                continue;
            }
            try {
                this.memberRecordCustomFieldService.saveValues(record);
            }
            catch (Exception e) {
                ValidationException vex;
                Map<String, Collection<ValidationError>> errorsByProperty;
                member.setStatus(ImportedMember.Status.INVALID_RECORD_FIELD);
                if (e instanceof ValidationException && MapUtils.isNotEmpty(errorsByProperty = (vex = (ValidationException)e).getErrorsByProperty())) {
                    String fieldName = errorsByProperty.keySet().iterator().next();
                    member.setErrorArgument1(recordType.getName() + "." + fieldName);
                    fieldValue = StringUtils.trimToNull((String)((String)fieldValues.get(fieldName)));
                    if (fieldValue == null) {
                        member.setStatus(ImportedMember.Status.MISSING_RECORD_FIELD);
                    } else {
                        member.setErrorArgument2((String)fieldValue);
                    }
                }
                this.importedMemberDao.update(member);
                return;
            }
        }
        return;
        finally {
            this.importedMemberDao.update(member);
        }
    }

    private String preprocessCustomFieldValue(CustomField field, String value) {
        if (field.getType() == CustomField.Type.MEMBER) {
            try {
                Object user = this.elementService.loadUser(value, new Relationship[0]);
                if (user instanceof MemberUser) {
                    value = ((Entity)user).getId().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private void processMember(MemberImport memberImport, ImportedMember importedMember, boolean sendActivationMail) {
        MemberAccountType accountType;
        Collection<ImportedMemberRecord> records;
        importedMember = this.fetchService.fetch(importedMember, ImportedMember.Relationships.CUSTOM_VALUES, ImportedMember.Relationships.RECORDS);
        Member member = new Member();
        MemberUser user = new MemberUser();
        member.setUser(user);
        member.setCreationDate(importedMember.getCreationDate());
        member.setGroup(memberImport.getGroup());
        member.setName(importedMember.getName());
        user.setSalt(importedMember.getSalt());
        user.setUsername(importedMember.getUsername());
        user.setPassword(importedMember.getPassword());
        member.setEmail(importedMember.getEmail());
        this.fetchService.fetch(importedMember.getCustomValues(), new Relationship[]{CustomFieldValue.Relationships.FIELD, CustomFieldValue.Relationships.POSSIBLE_VALUE});
        this.customFieldHelper.cloneFieldValues(importedMember, member);
        member = this.elementService.insertMember(member, !sendActivationMail, false);
        if (member.getActivationDate() != null && importedMember.getCreationDate() != null) {
            member.setActivationDate(importedMember.getCreationDate());
        }
        if ((records = importedMember.getRecords()) != null) {
            for (ImportedMemberRecord importedRecord : records) {
                importedRecord = this.fetchService.fetch(importedRecord, ImportedMemberRecord.Relationships.CUSTOM_VALUES);
                MemberRecord record = new MemberRecord();
                record.setElement(member);
                record.setType(importedRecord.getType());
                record.setCustomValues((Collection<MemberRecordCustomFieldValue>)new ArrayList<MemberRecordCustomFieldValue>());
                for (ImportedMemberRecordCustomFieldValue importedValue : importedRecord.getCustomValues()) {
                    CustomField field = importedValue.getField();
                    MemberRecordCustomFieldValue recordValue = new MemberRecordCustomFieldValue();
                    recordValue.setField(field);
                    if (field.getType() == CustomField.Type.ENUMERATED) {
                        recordValue.setPossibleValue(importedValue.getPossibleValue());
                    } else if (field.getType() == CustomField.Type.MEMBER) {
                        recordValue.setMemberValue(importedValue.getMemberValue());
                    }
                    record.getCustomValues().add(recordValue);
                }
                this.memberRecordService.insert(record);
            }
        }
        if ((accountType = memberImport.getAccountType()) != null) {
            CreditLimitDTO limit = new CreditLimitDTO();
            limit.setLimitPerType(Collections.singletonMap(accountType, importedMember.getCreditLimit()));
            limit.setUpperLimitPerType(Collections.singletonMap(accountType, importedMember.getUpperCreditLimit()));
            this.accountService.setCreditLimit(member, limit);
            BigDecimal initialBalance = importedMember.getInitialBalance();
            if (initialBalance != null) {
                double balance = initialBalance.doubleValue();
                TransferDTO transfer = null;
                if (balance < 0.0 && memberImport.getInitialDebitTransferType() != null) {
                    transfer = new TransferDTO();
                    transfer.setFromOwner(member);
                    transfer.setToOwner(SystemAccountOwner.instance());
                    transfer.setTransferType(memberImport.getInitialDebitTransferType());
                } else if (balance > 0.0 && memberImport.getInitialCreditTransferType() != null) {
                    transfer = new TransferDTO();
                    transfer.setFromOwner(SystemAccountOwner.instance());
                    transfer.setToOwner(member);
                    transfer.setTransferType(memberImport.getInitialCreditTransferType());
                }
                if (transfer != null) {
                    transfer.setAutomatic(true);
                    transfer.setContext(TransactionContext.AUTOMATIC);
                    transfer.setAmount(initialBalance.abs());
                    transfer.setDescription(transfer.getTransferType().getDescription());
                    this.paymentService.insertWithoutNotification(transfer);
                }
            }
        }
    }
}

