/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberQuery;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.entities.members.imports.MemberImportResult;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.MemberImportService;
import nl.strohalm.cyclos.services.elements.MemberImportServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MemberImportServiceSecurity
extends BaseServiceSecurity
implements MemberImportService {
    private MemberImportServiceLocal memberImportService;

    @Override
    public MemberImportResult getSummary(MemberImport memberImport) {
        this.checkMemberImportPermissions(memberImport.getGroup());
        return this.memberImportService.getSummary(memberImport);
    }

    @Override
    public MemberImport importMembers(MemberImport memberImport, InputStream data) {
        this.checkMemberImportPermissions(memberImport.getGroup());
        return this.memberImportService.importMembers(memberImport, data);
    }

    @Override
    public MemberImport load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        MemberImport memberImport = this.memberImportService.load(id, fetch);
        this.checkMemberImportPermissions(memberImport.getGroup());
        return memberImport;
    }

    @Override
    public void processImport(MemberImport memberImport, boolean sendActivationMail) {
        this.checkMemberImportPermissions(memberImport.getGroup());
        this.memberImportService.processImport(memberImport, sendActivationMail);
    }

    @Override
    public List<ImportedMember> searchImportedMembers(ImportedMemberQuery params) {
        MemberImport memberImport = this.memberImportService.load(params.getMemberImport().getId(), new Relationship[0]);
        if (!this.hasMemberImportPermissions(memberImport.getGroup())) {
            return Collections.emptyList();
        }
        return this.memberImportService.searchImportedMembers(params);
    }

    public void setMemberImportServiceLocal(MemberImportServiceLocal memberImportService) {
        this.memberImportService = memberImportService;
    }

    @Override
    public void validate(MemberImport memberImport) throws ValidationException {
        this.memberImportService.validate(memberImport);
    }

    private void checkMemberImportPermissions(MemberGroup group) {
        if (!this.hasMemberImportPermissions(group)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasMemberImportPermissions(MemberGroup group) {
        if (group == null) {
            return false;
        }
        return this.permissionService.permission().admin(AdminMemberPermission.MEMBERS_IMPORT).hasPermission() && this.permissionService.manages(group);
    }
}

