/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.members.MemberRecordDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.records.FullTextMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.StringUtils;

public class MemberRecordServiceImpl
implements MemberRecordServiceLocal {
    private MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService;
    private MemberRecordTypeServiceLocal memberRecordTypeService;
    private MemberRecordDAO memberRecordDao;
    private SettingsServiceLocal settingsService;

    @Override
    public Map<MemberRecordType, Integer> countByType(Element element) {
        MemberRecordTypeQuery typeQuery = new MemberRecordTypeQuery();
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(element.getGroup());
        typeQuery.setGroups(groups);
        if (LoggedUser.hasUser()) {
            Object loggedGroup = LoggedUser.group();
            if (loggedGroup instanceof AdminGroup) {
                typeQuery.setViewableByAdminGroup((AdminGroup)loggedGroup);
            } else if (loggedGroup instanceof BrokerGroup) {
                typeQuery.setViewableByBrokerGroup((BrokerGroup)loggedGroup);
            } else {
                throw new PermissionDeniedException();
            }
        }
        List<MemberRecordType> types = this.memberRecordTypeService.search(typeQuery);
        LinkedHashMap<MemberRecordType, Integer> map = new LinkedHashMap<MemberRecordType, Integer>();
        for (MemberRecordType type : types) {
            MemberRecordQuery query = new MemberRecordQuery();
            query.setElement(element);
            query.setType(type);
            query.setPageForCount();
            int count = PageHelper.getTotalCount(this.search(query));
            map.put(type, count);
        }
        return map;
    }

    @Override
    public List<MemberRecord> fullTextSearch(FullTextMemberRecordQuery query) {
        if (query.getElement() != null && StringUtils.isEmpty((String)query.getKeywords())) {
            return this.search(query.toMemberRecordQuery());
        }
        query.setAnalyzer(this.settingsService.getLocalSettings().getLanguage().getAnalyzer());
        return this.memberRecordDao.fullTextSearch(query);
    }

    @Override
    public MemberRecord insert(MemberRecord memberRecord) throws PermissionDeniedException {
        return this.doSave(memberRecord);
    }

    @Override
    public MemberRecord load(Long id, Relationship ... fetch) {
        return (MemberRecord)this.memberRecordDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) throws PermissionDeniedException {
        int count = this.memberRecordDao.delete(ids);
        this.memberRecordDao.removeFromIndex(MemberRecord.class, ids);
        return count;
    }

    @Override
    public List<MemberRecord> search(MemberRecordQuery query) {
        return this.memberRecordDao.search(query);
    }

    public void setMemberRecordCustomFieldServiceLocal(MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    public void setMemberRecordDao(MemberRecordDAO memberRecordDao) {
        this.memberRecordDao = memberRecordDao;
    }

    public void setMemberRecordTypeServiceLocal(MemberRecordTypeServiceLocal memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public MemberRecord update(MemberRecord memberRecord) throws PermissionDeniedException {
        return this.doSave(memberRecord);
    }

    @Override
    public void validate(MemberRecord memberRecord) throws ValidationException {
        this.getValidator().validate(memberRecord);
    }

    private MemberRecord doSave(MemberRecord memberRecord) {
        Object by = LoggedUser.element();
        Calendar now = Calendar.getInstance();
        Collection<MemberRecordCustomFieldValue> customValues = memberRecord.getCustomValues();
        memberRecord.setCustomValues((Collection<MemberRecordCustomFieldValue>)null);
        if (memberRecord.isTransient()) {
            memberRecord.setDate(now);
            memberRecord.setBy((Element)by);
            memberRecord = this.memberRecordDao.insert(memberRecord);
        } else {
            MemberRecord current = this.load(memberRecord.getId(), new Relationship[0]);
            memberRecord.setBy(current.getBy());
            memberRecord.setDate(current.getDate());
            memberRecord.setModifiedBy((Element)by);
            memberRecord.setLastModified(now);
            memberRecord = this.memberRecordDao.update(memberRecord);
        }
        memberRecord.setCustomValues(customValues);
        this.memberRecordCustomFieldService.saveValues(memberRecord);
        this.memberRecordDao.addToIndex(memberRecord);
        return memberRecord;
    }

    private Validator getValidator() {
        Validator validator = new Validator("memberRecord");
        validator.property("type").required();
        validator.property("element").key("memberRecord.user").required();
        validator.property("title").required();
        return validator;
    }
}

