/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.AbstractMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.FullTextMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.MemberRecordServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MemberRecordServiceSecurity
extends BaseServiceSecurity
implements MemberRecordService {
    private MemberRecordServiceLocal memberRecordService;
    private MemberRecordTypeServiceLocal memberRecordTypeService;

    @Override
    public Map<MemberRecordType, Integer> countByType(Element element) {
        this.permissionService.checkManages(element);
        Map<MemberRecordType, Integer> map = this.memberRecordService.countByType(element);
        Iterator<MemberRecordType> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            MemberRecordType mrt = iter.next();
            if (this.memberRecordTypeService.canView(mrt, element.getNature())) continue;
            iter.remove();
        }
        return map;
    }

    @Override
    public List<MemberRecord> fullTextSearch(FullTextMemberRecordQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.memberRecordService.fullTextSearch(query);
    }

    @Override
    public MemberRecord insert(MemberRecord memberRecord) throws PermissionDeniedException {
        this.checkCreate(memberRecord);
        return this.memberRecordService.insert(memberRecord);
    }

    @Override
    public MemberRecord load(Long id, Relationship ... fetch) {
        this.checkView(id);
        return this.memberRecordService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) throws PermissionDeniedException {
        this.checkRemove(ids);
        return this.memberRecordService.remove(ids);
    }

    @Override
    public List<MemberRecord> search(MemberRecordQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.memberRecordService.search(query);
    }

    public void setMemberRecordServiceLocal(MemberRecordServiceLocal memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    public void setMemberRecordTypeServiceLocal(MemberRecordTypeServiceLocal memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Override
    public MemberRecord update(MemberRecord memberRecord) throws PermissionDeniedException {
        this.checkUpdate(memberRecord);
        return this.memberRecordService.update(memberRecord);
    }

    @Override
    public void validate(MemberRecord memberRecord) throws ValidationException {
        this.memberRecordService.validate(memberRecord);
    }

    private boolean applyQueryRestrictions(AbstractMemberRecordQuery query) {
        MemberRecordType type = query.getType();
        if (type == null) {
            return false;
        }
        Element element = this.fetchService.fetch(query.getElement(), Element.Relationships.GROUP);
        if (element != null && !this.permissionService.manages(element)) {
            return false;
        }
        if (element != null && !this.memberRecordTypeService.canView(type, element.getNature())) {
            return false;
        }
        if (LoggedUser.isAdministrator()) {
            Collection<Group> groups = PermissionHelper.checkSelection(this.permissionService.getAllVisibleGroups(), query.getGroups());
            if (groups == null) {
                return false;
            }
            query.setGroups(groups);
        } else if (LoggedUser.isBroker()) {
            query.setBroker(LoggedUser.member());
        }
        return true;
    }

    private void checkCreate(MemberRecord memberRecord) {
        boolean canCreate = false;
        Element element = this.fetchService.fetch(memberRecord.getElement(), new Relationship[0]);
        if (element == null) {
            return;
        }
        this.permissionService.checkManages(element);
        MemberRecordType type = this.fetchService.fetch(memberRecord.getType(), new Relationship[0]);
        if (LoggedUser.isAdministrator()) {
            if (element instanceof Administrator) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.CREATE_ADMIN_RECORD_TYPES);
                canCreate = adminGroup.getCreateAdminRecordTypes().contains(type);
            } else if (element instanceof Member) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.CREATE_MEMBER_RECORD_TYPES);
                canCreate = adminGroup.getCreateMemberRecordTypes().contains(type);
            }
        } else if (LoggedUser.isBroker()) {
            BrokerGroup brokerGroup = this.fetchService.fetch((BrokerGroup)LoggedUser.group(), BrokerGroup.Relationships.BROKER_CREATE_MEMBER_RECORD_TYPES);
            if (element instanceof Member) {
                canCreate = brokerGroup.getBrokerCreateMemberRecordTypes().contains(type);
            }
        }
        if (!canCreate) {
            throw new PermissionDeniedException();
        }
    }

    private void checkRemove(Long ... ids) {
        boolean canRemove = true;
        for (Long id : ids) {
            MemberRecord memberRecord = this.memberRecordService.load(id, MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.TYPE);
            this.permissionService.checkManages(memberRecord.getElement());
            MemberRecordType type = this.fetchService.fetch(memberRecord.getType(), new Relationship[0]);
            if (LoggedUser.isAdministrator()) {
                AdminGroup adminGroup;
                if (memberRecord.getElement() instanceof Administrator) {
                    adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.DELETE_ADMIN_RECORD_TYPES);
                    canRemove = adminGroup.getDeleteAdminRecordTypes().contains(type);
                } else if (memberRecord.getElement() instanceof Member) {
                    adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.DELETE_MEMBER_RECORD_TYPES);
                    canRemove = adminGroup.getDeleteMemberRecordTypes().contains(type);
                }
            } else if (LoggedUser.isBroker()) {
                BrokerGroup brokerGroup = this.fetchService.fetch((BrokerGroup)LoggedUser.group(), BrokerGroup.Relationships.BROKER_DELETE_MEMBER_RECORD_TYPES);
                if (memberRecord.getElement() instanceof Member) {
                    canRemove = brokerGroup.getBrokerDeleteMemberRecordTypes().contains(type);
                }
            }
            if (canRemove) continue;
            throw new PermissionDeniedException();
        }
    }

    private void checkUpdate(MemberRecord memberRecord) {
        boolean canUpdate = false;
        MemberRecord saved = this.memberRecordService.load(memberRecord.getId(), MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.TYPE);
        memberRecord.setElement(saved.getElement());
        memberRecord.setType(saved.getType());
        this.permissionService.checkManages(memberRecord.getElement());
        if (LoggedUser.isAdministrator()) {
            if (memberRecord.getElement() instanceof Administrator) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.MODIFY_ADMIN_RECORD_TYPES);
                canUpdate = adminGroup.getModifyAdminRecordTypes().contains(memberRecord.getType());
            } else if (memberRecord.getElement() instanceof Member) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.MODIFY_MEMBER_RECORD_TYPES);
                canUpdate = adminGroup.getModifyMemberRecordTypes().contains(memberRecord.getType());
            }
        } else if (LoggedUser.isBroker()) {
            BrokerGroup brokerGroup = this.fetchService.fetch((BrokerGroup)LoggedUser.group(), BrokerGroup.Relationships.BROKER_MODIFY_MEMBER_RECORD_TYPES);
            if (memberRecord.getElement() instanceof Member) {
                canUpdate = brokerGroup.getBrokerModifyMemberRecordTypes().contains(memberRecord.getType());
            }
        }
        if (!canUpdate) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(Long id) {
        boolean canView = false;
        MemberRecord memberRecord = this.memberRecordService.load(id, MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.TYPE);
        this.permissionService.checkManages(memberRecord.getElement());
        MemberRecordType type = memberRecord.getType();
        if (LoggedUser.isAdministrator()) {
            if (memberRecord.getElement() instanceof Administrator) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES);
                canView = adminGroup.getViewAdminRecordTypes().contains(type);
            } else if (memberRecord.getElement() instanceof Member) {
                AdminGroup adminGroup = this.fetchService.fetch((AdminGroup)LoggedUser.group(), AdminGroup.Relationships.VIEW_MEMBER_RECORD_TYPES);
                canView = adminGroup.getViewMemberRecordTypes().contains(type);
            }
        } else if (LoggedUser.isBroker()) {
            BrokerGroup brokerGroup = this.fetchService.fetch((BrokerGroup)LoggedUser.group(), BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES);
            if (memberRecord.getElement() instanceof Member) {
                canView = brokerGroup.getBrokerMemberRecordTypes().contains(type);
            }
        }
        if (!canView) {
            throw new PermissionDeniedException();
        }
    }
}

