/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.groups.GroupDAO;
import nl.strohalm.cyclos.dao.members.MemberRecordTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MemberRecordTypeServiceImpl
implements MemberRecordTypeServiceLocal {
    private FetchDAO fetchDao;
    private GroupDAO groupDao;
    private MemberRecordTypeDAO memberRecordTypeDao;
    private FetchServiceLocal fetchService;
    private PermissionServiceLocal permissionService;

    @Override
    public boolean canView(MemberRecordType memberRecordType, Element.Nature nature) {
        if (this.permissionService.hasPermission(AdminSystemPermission.MEMBER_RECORD_TYPES_VIEW)) {
            return true;
        }
        if (LoggedUser.isAdministrator()) {
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES, AdminGroup.Relationships.VIEW_MEMBER_RECORD_TYPES);
            boolean isVisible = false;
            if (nature == null) {
                isVisible = adminGroup.getViewAdminRecordTypes().contains(memberRecordType) || adminGroup.getViewMemberRecordTypes().contains(memberRecordType);
            } else if (nature.equals(Element.Nature.ADMIN)) {
                isVisible = adminGroup.getViewAdminRecordTypes().contains(memberRecordType);
            } else if (nature.equals(Element.Nature.MEMBER)) {
                isVisible = adminGroup.getViewMemberRecordTypes().contains(memberRecordType);
            } else {
                return false;
            }
            return isVisible;
        }
        if (LoggedUser.isBroker()) {
            BrokerGroup brokerGroup = (BrokerGroup)LoggedUser.group();
            brokerGroup = this.fetchService.fetch(brokerGroup, BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES);
            return brokerGroup.getBrokerMemberRecordTypes().contains(memberRecordType);
        }
        return false;
    }

    private Validator getValidator() {
        Validator validator = new Validator("memberRecordType");
        validator.property("name").required();
        validator.property("label").required();
        validator.property("layout").required();
        validator.property("editable").required();
        validator.property("showMenuItem").required();
        return validator;
    }

    @Override
    public MemberRecordType load(Long id, Relationship ... fetch) {
        return (MemberRecordType)this.memberRecordTypeDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) throws PermissionDeniedException {
        for (Long id : ids) {
            MemberRecordType memberRecordType = this.load(id, MemberRecordType.Relationships.VIEWABLE_BY_ADMIN_GROUPS, MemberRecordType.Relationships.VIEWABLE_BY_BROKER_GROUPS);
            this.removeFromViewerCollections(memberRecordType);
        }
        return this.memberRecordTypeDao.delete(ids);
    }

    private void removeFromViewerCollections(MemberRecordType memberRecordType) {
        Collection<AdminGroup> viewableByAdminGroups = memberRecordType.getViewableByAdminGroups();
        for (AdminGroup adminGroup : viewableByAdminGroups) {
            adminGroup = this.fetchDao.fetch(adminGroup, AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES, AdminGroup.Relationships.VIEW_MEMBER_RECORD_TYPES);
            adminGroup.getViewAdminRecordTypes().remove(memberRecordType);
            adminGroup.getViewMemberRecordTypes().remove(memberRecordType);
        }
        Collection<BrokerGroup> viewableByBrokerGroups = memberRecordType.getViewableByBrokerGroups();
        for (BrokerGroup brokerGroup : viewableByBrokerGroups) {
            brokerGroup = this.fetchDao.fetch(brokerGroup, BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES);
            brokerGroup.getBrokerMemberRecordTypes().remove(memberRecordType);
        }
    }

    @Override
    public MemberRecordType save(MemberRecordType memberRecordType) throws PermissionDeniedException {
        this.validate(memberRecordType);
        if (memberRecordType.isTransient()) {
            memberRecordType = this.memberRecordTypeDao.insert(memberRecordType);
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchDao.fetch(adminGroup, AdminGroup.Relationships.VIEW_MEMBER_RECORD_TYPES, AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES);
            adminGroup.getViewMemberRecordTypes().add(memberRecordType);
            adminGroup.getCreateMemberRecordTypes().add(memberRecordType);
            if (memberRecordType.isEditable()) {
                adminGroup.getModifyMemberRecordTypes().add(memberRecordType);
                adminGroup.getDeleteMemberRecordTypes().add(memberRecordType);
            }
            this.groupDao.update(adminGroup);
            return memberRecordType;
        }
        return this.memberRecordTypeDao.update(memberRecordType);
    }

    @Override
    public List<MemberRecordType> search(MemberRecordTypeQuery query) {
        return this.memberRecordTypeDao.search(query);
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }

    public void setMemberRecordTypeDao(MemberRecordTypeDAO memberRecordTypeDao) {
        this.memberRecordTypeDao = memberRecordTypeDao;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void validate(MemberRecordType memberRecordType) throws ValidationException {
        this.getValidator().validate(memberRecordType);
    }
}

