/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MemberRecordTypeServiceSecurity
extends BaseServiceSecurity
implements MemberRecordTypeService {
    private MemberRecordTypeServiceLocal memberRecordTypeService;

    @Override
    public MemberRecordType load(Long id, Relationship ... fetch) {
        MemberRecordType memberRecordType = this.memberRecordTypeService.load(id, fetch);
        if (!this.memberRecordTypeService.canView(memberRecordType, null)) {
            throw new PermissionDeniedException();
        }
        return memberRecordType;
    }

    @Override
    public int remove(Long ... id) throws PermissionDeniedException {
        this.permissionService.permission().admin(AdminSystemPermission.MEMBER_RECORD_TYPES_MANAGE).check();
        return this.memberRecordTypeService.remove(id);
    }

    @Override
    public MemberRecordType save(MemberRecordType memberRecordType) throws PermissionDeniedException {
        this.permissionService.permission().admin(AdminSystemPermission.MEMBER_RECORD_TYPES_MANAGE).check();
        return this.memberRecordTypeService.save(memberRecordType);
    }

    @Override
    public List<MemberRecordType> search(MemberRecordTypeQuery query) {
        if (!this.applyRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.memberRecordTypeService.search(query);
    }

    public void setMemberRecordTypeServiceLocal(MemberRecordTypeServiceLocal memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Override
    public void validate(MemberRecordType memberRecordType) throws ValidationException {
        this.memberRecordTypeService.validate(memberRecordType);
    }

    private boolean applyRestrictions(MemberRecordTypeQuery query) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.MEMBER_RECORD_TYPES_VIEW)) {
            if (LoggedUser.isAdministrator()) {
                query.setViewableByAdminGroup((AdminGroup)LoggedUser.group());
            } else if (LoggedUser.isBroker()) {
                query.setViewableByBrokerGroup((BrokerGroup)LoggedUser.group());
            }
            Collection<Group> groups = PermissionHelper.checkSelection(this.permissionService.getAllVisibleGroups(), query.getGroups());
            if (groups == null) {
                return false;
            }
            query.setGroups(groups);
        }
        return true;
    }
}

