/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.dao.sms.MemberSmsStatusDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceSummaryDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.PaymentsAwaitingFeedbackQuery;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceQuery;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.members.messages.MessageBox;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.accounts.rates.ConversionSimulationDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.AccountActivitiesVO;
import nl.strohalm.cyclos.services.elements.ActivitiesVO;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberStatusVO;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.QuickAccessVO;
import nl.strohalm.cyclos.services.elements.ReferenceServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.services.sms.MemberGroupSmsContextImpl;
import nl.strohalm.cyclos.services.sms.exceptions.SmsContextInitializationException;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.CustomObjectHandler;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import nl.strohalm.cyclos.utils.lock.LockHandlerFactory;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.members.FullTextMemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberResultPage;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.MyProfileVO;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.TransactionStatus;

public class MemberServiceImpl
implements MemberServiceLocal {
    private FetchServiceLocal fetchService;
    private PreferenceServiceLocal preferenceService;
    private AccountServiceLocal accountService;
    private InvoiceServiceLocal invoiceService;
    private PermissionServiceLocal permissionService;
    private BrokeringServiceLocal brokeringService;
    private LoanServiceLocal loanService;
    private AdServiceLocal adService;
    private ReferenceServiceLocal referenceService;
    private PaymentServiceLocal paymentService;
    private TransferAuthorizationServiceLocal transferAuthorizationService;
    private MessageServiceLocal messageService;
    private ElementDAO elementDao;
    private RateServiceLocal rateService;
    private TransferTypeServiceLocal transferTypeService;
    private AccessServiceLocal accessService;
    private ChannelServiceLocal channelService;
    private MemberSmsStatusDAO memberSmsStatusDao;
    private GroupServiceLocal groupService;
    private LockHandlerFactory lockHandlerFactory;
    private TransactionHelper transactionHelper;
    private CommissionServiceLocal commissionService;
    private CustomObjectHandler customObjectHandler;
    private ElementServiceLocal elementService;
    private MemberHelper memberHelper;
    private MemberCustomFieldService memberCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Override
    public void ensureAllowChargingSms(MemberSmsStatus memberSmsStatus, boolean hasNotificationsBySms) {
        Member member = memberSmsStatus.getMember();
        ISmsContext smsContext = this.getSmsContext(member);
        int smsFree = smsContext.getFreeSms(member);
        int smsAdditionalCharged = smsContext.getAdditionalChargedSms(member);
        if (smsAdditionalCharged == 1 && smsFree == 0) {
            Member fetchedMember = this.fetchService.fetch(member, Member.Relationships.CHANNELS);
            boolean smsChannelEnabled = this.accessService.getChannelsEnabledForMember(fetchedMember).contains(this.channelService.getSmsChannel());
            boolean allowChargingSms = smsChannelEnabled || memberSmsStatus.isAcceptPaidMailing() || hasNotificationsBySms;
            memberSmsStatus.setAllowChargingSms(allowChargingSms);
        }
    }

    @Override
    public ActivitiesVO getActivities(Member member) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        return this.doGetActivities(member);
    }

    @Override
    public Map<MemberGroup, Integer> getGroupMemberCount(Collection<MemberGroup> groups, Calendar timePoint) {
        Map<Long, Integer> countPerGroupId = timePoint == null ? this.elementDao.getCountPerGroup(groups) : this.elementDao.getCountPerGroup(groups, timePoint);
        TreeMap<MemberGroup, Integer> groupMemberCount = new TreeMap<MemberGroup, Integer>();
        for (MemberGroup memberGroup : groups) {
            MemberGroup memberGroup2 = (MemberGroup)this.groupService.load(memberGroup.getId(), new Relationship[0]);
            groupMemberCount.put(memberGroup2, 0);
        }
        for (Map.Entry entry : countPerGroupId.entrySet()) {
            MemberGroup group = (MemberGroup)this.groupService.load((Long)entry.getKey(), new Relationship[0]);
            Integer count = (Integer)entry.getValue();
            groupMemberCount.put(group, count);
        }
        return groupMemberCount;
    }

    @Override
    public MemberResultPage getMemberResultPage(FullTextMemberSearchParameters params) {
        FullTextMemberQuery query = this.memberHelper.toFullTextQuery(params);
        if (!this.elementService.applyQueryRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        List<? extends Element> members = this.elementService.fullTextSearch(query);
        return this.memberHelper.toResultPage(members, params.getShowCustomFields(), params.getShowImages());
    }

    @Override
    public MemberVO getMemberVO(Member member, boolean useMemberFields, boolean useImages) {
        List<MemberCustomField> fields = null;
        if (useMemberFields) {
            fields = this.memberCustomFieldService.list();
            if (!LoggedUser.isUnrestrictedClient()) {
                MemberGroup group = LoggedUser.member().getMemberGroup();
                fields = this.customFieldHelper.onlyVisibleFields(fields, group);
            }
        }
        return this.memberHelper.toVO(member, fields, useImages);
    }

    @Override
    public MyProfileVO getMyProfileVO(Member member) {
        return this.memberHelper.toMyProfileVO(member);
    }

    @Override
    public QuickAccessVO getQuickAccess() {
        Member member = (Member)LoggedUser.accountOwner();
        QuickAccessVO quickAccess = new QuickAccessVO();
        quickAccess.setUpdateProfile(true);
        quickAccess.setSearchMembers(CollectionUtils.isNotEmpty(this.permissionService.getVisibleMemberGroups()));
        quickAccess.setAccountInformation(this.permissionService.permission(member).member(new MemberPermission[0]).operator(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION).hasPermission() && CollectionUtils.isNotEmpty(this.accountService.getAccounts(member, new Relationship[0])));
        if (LoggedUser.isOperator()) {
            quickAccess.setMemberPayment(this.permissionService.permission().operator(OperatorPermission.PAYMENTS_PAYMENT_TO_MEMBER).hasPermission() && this.permissionService.permission().operator(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION).hasPermission());
        } else if (LoggedUser.isMember()) {
            quickAccess.setMemberPayment(this.permissionService.permission().member(MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER).hasPermission());
        }
        quickAccess.setPublishAd(this.permissionService.permission().member(MemberPermission.ADS_PUBLISH).operator(OperatorPermission.ADS_PUBLISH).hasPermission());
        quickAccess.setSearchAds(this.permissionService.permission().member(MemberPermission.ADS_VIEW).operator(MemberPermission.ADS_VIEW).hasPermission());
        quickAccess.setViewMessages(this.permissionService.permission().member(MemberPermission.MESSAGES_VIEW).operator(OperatorPermission.MESSAGES_VIEW).hasPermission());
        quickAccess.setViewContacts(this.permissionService.permission().member(new MemberPermission[0]).operator(OperatorPermission.CONTACTS_VIEW).hasPermission());
        return quickAccess;
    }

    @Override
    public ISmsContext getSmsContext(Member member) throws SmsContextInitializationException {
        MemberGroup memberGroup = member.getMemberGroup();
        String className = memberGroup.getMemberSettings().getSmsContextClassName();
        if (StringUtils.isEmpty((String)className)) {
            return MemberGroupSmsContextImpl.getInstance();
        }
        try {
            return (ISmsContext)this.customObjectHandler.get(className);
        }
        catch (Exception e) {
            throw new SmsContextInitializationException(memberGroup, className, e.getMessage());
        }
    }

    @Override
    public MemberSmsStatus getSmsStatus(final Member member, final boolean update) {
        boolean isNewTransaction;
        boolean bl = isNewTransaction = !update;
        if (isNewTransaction) {
            MemberSmsStatus status = this.transactionHelper.runInNewTransaction(new Transactional<MemberSmsStatus>(){

                @Override
                public MemberSmsStatus afterCommit(MemberSmsStatus result) {
                    return MemberServiceImpl.this.fetchService.fetch(result, RelationshipHelper.nested(MemberSmsStatus.Relationships.MEMBER, Element.Relationships.GROUP));
                }

                public MemberSmsStatus doInTransaction(TransactionStatus status) {
                    if (!update) {
                        status.setRollbackOnly();
                    }
                    return MemberServiceImpl.this.performGetSmsStatus(member);
                }
            });
            status.setMember(member);
            return status;
        }
        return this.performGetSmsStatus(member);
    }

    @Override
    public MemberStatusVO getStatus() {
        Collection<MemberAccountType> accountTypes;
        MemberStatusVO status = new MemberStatusVO();
        Member member = (Member)LoggedUser.accountOwner();
        MemberGroup group = member.getMemberGroup();
        Object user = LoggedUser.user();
        Calendar lastLogin = ((User)user).getLastLogin();
        boolean isOperator = LoggedUser.isOperator();
        if (this.permissionService.hasPermission((Permission)((Object)(isOperator ? OperatorPermission.MESSAGES_VIEW : MemberPermission.MESSAGES_VIEW)))) {
            MessageQuery messages = new MessageQuery();
            messages.setGetter(member);
            messages.setMessageBox(MessageBox.INBOX);
            messages.setRead(false);
            messages.setPageForCount();
            status.setUnreadMessages(PageHelper.getTotalCount(this.messageService.search(messages)));
        }
        if (CollectionUtils.isNotEmpty(accountTypes = (group = this.fetchService.fetch(group, MemberGroup.Relationships.ACCOUNT_SETTINGS)).getAccountTypes()) && (!isOperator || this.permissionService.hasPermission(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION))) {
            TransferQuery transfers = new TransferQuery();
            transfers.setRootOnly(true);
            transfers.setToAccountOwner(member);
            transfers.setLoanTransfer(false);
            if (lastLogin != null) {
                transfers.setPeriod(Period.begginingAt(lastLogin).useTime());
            }
            transfers.setPageForCount();
            status.setNewPayments(PageHelper.getTotalCount(this.paymentService.search(transfers)));
        }
        if (this.permissionService.hasPermission((Permission)((Object)(isOperator ? OperatorPermission.REFERENCES_VIEW : MemberPermission.REFERENCES_VIEW)))) {
            ReferenceQuery references = new ReferenceQuery();
            references.setNature(Reference.Nature.GENERAL);
            references.setTo(member);
            if (lastLogin != null) {
                references.setPeriod(Period.begginingAt(lastLogin).useTime());
            }
            references.setPageForCount();
            status.setNewReferences(PageHelper.getTotalCount(this.referenceService.search(references)));
        }
        if (this.permissionService.hasPermission((Permission)((Object)(isOperator ? OperatorPermission.INVOICES_VIEW : MemberPermission.INVOICES_VIEW)))) {
            InvoiceQuery invoices = new InvoiceQuery();
            invoices.setOwner(member);
            invoices.setDirection(InvoiceQuery.Direction.INCOMING);
            invoices.setStatus(Invoice.Status.OPEN);
            invoices.setPageForCount();
            status.setOpenInvoices(PageHelper.getTotalCount(this.invoiceService.search(invoices)));
        }
        if (this.permissionService.hasPermission((Permission)((Object)(isOperator ? OperatorPermission.LOANS_VIEW : MemberPermission.LOANS_VIEW)))) {
            LoanQuery loans = new LoanQuery();
            loans.setMember(member);
            loans.setStatus(Loan.Status.OPEN);
            loans.setPageForCount();
            status.setOpenLoans(PageHelper.getTotalCount(this.loanService.search(loans)));
        }
        if (!isOperator || this.permissionService.hasPermission(OperatorPermission.REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS)) {
            PaymentsAwaitingFeedbackQuery awaitingFeedback = new PaymentsAwaitingFeedbackQuery();
            awaitingFeedback.setPageForCount();
            awaitingFeedback.setExpired(false);
            awaitingFeedback.setMember(member);
            status.setPaymentsAwaitingFeedback(PageHelper.getTotalCount(this.referenceService.searchPaymentsAwaitingFeedback(awaitingFeedback)));
        }
        if (this.permissionService.hasPermission((Permission)((Object)(isOperator ? OperatorPermission.PAYMENTS_AUTHORIZE : MemberPermission.PAYMENTS_AUTHORIZE)))) {
            TransfersAwaitingAuthorizationQuery awaitingAuthorization = new TransfersAwaitingAuthorizationQuery();
            awaitingAuthorization.setPageForCount();
            status.setPaymentsToAuthorize(PageHelper.getTotalCount(this.transferAuthorizationService.searchTransfersAwaitingAuthorization(awaitingAuthorization)));
        }
        if (member.getBroker() != null && !isOperator) {
            BrokerCommissionContractQuery contractsQuery = new BrokerCommissionContractQuery();
            contractsQuery.setPageForCount();
            contractsQuery.setMember(member);
            contractsQuery.setStatus(BrokerCommissionContract.Status.PENDING);
            status.setHasPendingCommissionContracts(PageHelper.hasResults(this.commissionService.searchBrokerCommissionContracts(contractsQuery)));
        }
        return status;
    }

    @Override
    public boolean hasValueForField(Member member, MemberCustomField field) {
        return this.elementDao.hasValueForField(member, field);
    }

    @Override
    public IteratorList<Member> iterateByGroup(boolean ordered, MemberGroup ... groups) {
        return new IteratorListImpl<Member>(this.elementDao.iterateMembers(ordered, groups));
    }

    @Override
    public IteratorList<Member> iterateByGroup(MemberGroup ... groups) {
        return this.iterateByGroup(false, groups);
    }

    @Override
    public Member loadByIdOrPrincipal(Long id, String principalType, String principal) {
        Member member;
        if (id != null) {
            try {
                member = (Member)this.elementService.load(id, new Relationship[0]);
            }
            catch (ClassCastException e) {
                throw new EntityNotFoundException(Member.class);
            }
        } else if (StringUtils.isNotEmpty((String)principal)) {
            member = this.memberHelper.loadByPrincipal(principalType, principal, new Relationship[0]);
        } else {
            return null;
        }
        Member restrictedMember = WebServiceContext.getMember();
        if (restrictedMember != null && !this.permissionService.relatesTo(member)) {
            throw new EntityNotFoundException(Member.class);
        }
        return member;
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setCustomObjectHandler(CustomObjectHandler customObjectHandler) {
        this.customObjectHandler = customObjectHandler;
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setLockHandlerFactory(LockHandlerFactory lockHandlerFactory) {
        this.lockHandlerFactory = lockHandlerFactory;
    }

    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setMemberSmsStatusDao(MemberSmsStatusDAO memberSmsStatusDao) {
        this.memberSmsStatusDao = memberSmsStatusDao;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setReferenceServiceLocal(ReferenceServiceLocal referenceService) {
        this.referenceService = referenceService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public MemberSmsStatus updateSmsStatus(MemberSmsStatus memberSmsStatus) {
        return this.memberSmsStatusDao.update(memberSmsStatus);
    }

    private boolean canViewAccountInformation(Element element, MemberAccount memberAccount) {
        memberAccount = this.fetchService.fetch(memberAccount, Account.Relationships.TYPE, RelationshipHelper.nested(MemberAccount.Relationships.MEMBER, Member.Relationships.BROKER));
        if (element instanceof Administrator) {
            return true;
        }
        if (element instanceof Operator) {
            MemberGroup operatorsMemberGroup;
            Operator operator = this.fetchService.fetch((Operator)element, RelationshipHelper.nested(Operator.Relationships.MEMBER, Element.Relationships.GROUP), RelationshipHelper.nested(Element.Relationships.GROUP, OperatorGroup.Relationships.CAN_VIEW_INFORMATION_OF));
            if (memberAccount.getMember().equals(operator.getMember()) ? operator.getOperatorGroup().getCanViewInformationOf().contains(memberAccount.getType()) : (operatorsMemberGroup = this.fetchService.fetch(operator.getMember().getMemberGroup(), MemberGroup.Relationships.CAN_VIEW_INFORMATION_OF)).getCanViewInformationOf().contains(memberAccount.getType())) {
                return true;
            }
        } else if (element instanceof Member) {
            Member member = this.fetchService.fetch((Member)element, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CAN_VIEW_INFORMATION_OF), RelationshipHelper.nested(Element.Relationships.GROUP, BrokerGroup.Relationships.BROKER_CAN_VIEW_INFORMATION_OF));
            if (member.getGroup() instanceof BrokerGroup && member.equals(memberAccount.getMember().getBroker())) {
                BrokerGroup brokerGroup = (BrokerGroup)member.getMemberGroup();
                return brokerGroup.getBrokerCanViewInformationOf().contains(memberAccount.getType());
            }
            MemberGroup memberGroup = member.getMemberGroup();
            if (memberGroup.getCanViewInformationOf().contains(memberAccount.getType())) {
                return true;
            }
        }
        return false;
    }

    private ActivitiesVO doGetActivities(Member member) {
        boolean isBroker;
        boolean showAccountInformation;
        ActivitiesVO vo = new ActivitiesVO();
        boolean showAdsInformation = this.adService.visibleGroupsForAds().contains(member.getGroup());
        boolean showNonActiveAdsInformation = false;
        Object loggedElement = LoggedUser.element();
        if (this.permissionService.manages(member)) {
            showAccountInformation = this.permissionService.permission(member).admin(AdminMemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION).broker(BrokerPermission.ACCOUNTS_INFORMATION).member(new MemberPermission[0]).operator(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION).hasPermission();
            showNonActiveAdsInformation = showAdsInformation;
        } else {
            showAccountInformation = this.permissionService.permission().member(MemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION).operator(MemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION).hasPermission();
        }
        boolean showReferencesInformation = this.permissionService.permission().admin(AdminMemberPermission.REFERENCES_VIEW).member(MemberPermission.REFERENCES_VIEW).operator(OperatorPermission.REFERENCES_VIEW).hasPermission();
        boolean showInvoicesInformation = showAccountInformation && this.permissionService.permission().admin(AdminMemberPermission.INVOICES_VIEW).member(MemberPermission.INVOICES_VIEW).operator(OperatorPermission.INVOICES_VIEW).hasPermission();
        vo.setShowAccountInformation(showAccountInformation);
        vo.setShowInvoicesInformation(showInvoicesInformation);
        vo.setShowReferencesInformation(showReferencesInformation);
        vo.setShowAdsInformation(showAdsInformation);
        vo.setShowNonActiveAdsInformation(showNonActiveAdsInformation);
        vo.setSinceActive(member.getActivationDate());
        boolean bl = isBroker = member.getGroup().getNature() == Group.Nature.BROKER;
        if (isBroker) {
            BrokeringQuery query = new BrokeringQuery();
            query.setBroker(member);
            query.setStatus(BrokeringQuery.Status.ACTIVE);
            query.setPageForCount();
            vo.setNumberBrokeredMembers(PageHelper.getTotalCount(this.brokeringService.search(query)));
        }
        if (showReferencesInformation) {
            vo.setReceivedReferencesByLevel(this.referenceService.countReferencesByLevel(Reference.Nature.GENERAL, member, true));
            vo.setGivenReferencesByLevel(this.referenceService.countReferencesByLevel(Reference.Nature.GENERAL, member, false));
        }
        if (vo.isShowAdsInformation()) {
            vo.setAdsByStatus(this.adService.getNumberOfAds(null, member));
        }
        List<? extends Account> accounts = this.accountService.getAccounts(member, new Relationship[0]);
        if (showInvoicesInformation) {
            InvoiceSummaryDTO incomingInvoicesDTO = new InvoiceSummaryDTO();
            incomingInvoicesDTO.setOwner(member);
            incomingInvoicesDTO.setDirection(InvoiceQuery.Direction.INCOMING);
            incomingInvoicesDTO.setStatus(Invoice.Status.OPEN);
            vo.setIncomingInvoices(this.invoiceService.getSummary(incomingInvoicesDTO));
            InvoiceSummaryDTO summaryDTO = new InvoiceSummaryDTO();
            summaryDTO.setOwner(member);
            summaryDTO.setDirection(InvoiceQuery.Direction.OUTGOING);
            summaryDTO.setStatus(Invoice.Status.OPEN);
            vo.setOutgoingInvoices(this.invoiceService.getSummary(summaryDTO));
        }
        Calendar days30 = DateHelper.truncate(Calendar.getInstance());
        days30.add(5, -30);
        for (MemberAccount memberAccount : accounts) {
            boolean hasRateInfo = false;
            GetTransactionsDTO allTime = new GetTransactionsDTO(memberAccount);
            AccountActivitiesVO activities = new AccountActivitiesVO();
            AccountStatus accountStatus = this.accountService.getRatedStatus(memberAccount, null);
            activities.setAccountStatus(accountStatus);
            hasRateInfo = this.rateService.isAnyRateEnabled(memberAccount, null);
            activities.setHasRateInfo(hasRateInfo);
            if (hasRateInfo) {
                List<TransferType> currencyConversionTTs = this.transferTypeService.getConversionTTs(memberAccount.getType().getCurrency());
                List<TransferType> accountConversionTTs = this.transferTypeService.getConversionTTs(memberAccount.getType());
                TransferType conversionTT = null;
                if (accountConversionTTs.size() == 1) {
                    Object[] ttArray = accountConversionTTs.toArray();
                    conversionTT = (TransferType)ttArray[0];
                } else if (accountConversionTTs.size() == 0 && currencyConversionTTs.size() == 1) {
                    Object[] ttArray = currencyConversionTTs.toArray();
                    conversionTT = (TransferType)ttArray[0];
                }
                BigDecimal balance = accountStatus.getBalance();
                if (balance.compareTo(BigDecimal.ZERO) > 0 && conversionTT != null) {
                    ConversionSimulationDTO dto = new ConversionSimulationDTO();
                    dto.setTransferType(conversionTT);
                    dto.setAccount(memberAccount);
                    dto.setAmount(balance);
                    dto.setUseActualRates(true);
                    dto.setDate(Calendar.getInstance());
                    TransactionFeePreviewForRatesDTO result = this.paymentService.simulateConversion(dto);
                    activities.setTotalFeePercentage(result.getRatesAsFeePercentage());
                }
            }
            if (showAccountInformation && (memberAccount.getMember().equals(loggedElement) || this.canViewAccountInformation((Element)loggedElement, memberAccount))) {
                activities.setShowAccountInfo(true);
                GetTransactionsDTO txAllTime = new GetTransactionsDTO(memberAccount);
                txAllTime.setRootOnly(true);
                GetTransactionsDTO tx30Days = new GetTransactionsDTO((Account)memberAccount, Period.begginingAt(days30));
                tx30Days.setRootOnly(true);
                activities.setCreditsAllTime(this.accountService.getCredits(txAllTime));
                activities.setDebitsAllTime(this.accountService.getDebits(txAllTime));
                activities.setCreditsLast30Days(this.accountService.getCredits(tx30Days));
                activities.setDebitsLast30Days(this.accountService.getDebits(tx30Days));
                if (isBroker) {
                    activities.setBrokerCommission(this.accountService.getBrokerCommissions(allTime));
                }
                LoanQuery loanQuery = new LoanQuery();
                loanQuery.setMember(member);
                loanQuery.setStatus(Loan.Status.OPEN);
                loanQuery.setAccountType(memberAccount.getType());
                int remainingLoans = 0;
                BigDecimal remainingLoanAmount = BigDecimal.ZERO;
                List<Loan> loans = this.loanService.search(loanQuery);
                for (Loan loan : loans) {
                    ++remainingLoans;
                    remainingLoanAmount = remainingLoanAmount.add(loan.getRemainingAmount());
                }
                activities.setRemainingLoans(new TransactionSummaryVO(remainingLoans, remainingLoanAmount));
            }
            if (!activities.isShowAccountInfo() && !activities.isHasRateInfo()) continue;
            vo.addAccountActivities(memberAccount.getType().getName(), activities);
        }
        return vo;
    }

    private boolean hasNotificationsBySms(Member member) {
        Collection<NotificationPreference> preferences = this.preferenceService.load(member);
        if (CollectionUtils.isEmpty(preferences)) {
            return false;
        }
        for (NotificationPreference preference : preferences) {
            if (!preference.isSms()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemberSmsStatus performGetSmsStatus(Member member) {
        MemberSmsStatus status;
        LockHandler lockHandler = this.lockHandlerFactory.getLockHandler();
        lockHandler.lockSmsStatus(member);
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        Calendar today = Calendar.getInstance();
        Period currentMonth = TimePeriod.ONE_MONTH.currentPeriod(today);
        try {
            Calendar paidSmsExpiration;
            status = this.memberSmsStatusDao.load(member, new Relationship[0]);
            boolean changed = false;
            if (today.after(status.getFreeSmsExpiration())) {
                status.setFreeSmsSent(0);
                status.setFreeSmsExpiration(currentMonth.getEnd());
                changed = true;
            }
            if ((paidSmsExpiration = status.getPaidSmsExpiration()) != null && today.after(paidSmsExpiration)) {
                status.setPaidSmsLeft(0);
                status.setPaidSmsExpiration(null);
                changed = true;
            }
            if (changed) {
                status = this.memberSmsStatusDao.update(status);
            }
        }
        catch (EntityNotFoundException e) {
            MemberGroup group = member.getMemberGroup();
            status = new MemberSmsStatus();
            status.setMember(member);
            status.setFreeSmsExpiration(currentMonth.getEnd());
            status.setAllowChargingSms(group.isDefaultAllowChargingSms());
            status.setAcceptFreeMailing(group.isDefaultAcceptFreeMailing());
            status.setAcceptPaidMailing(group.isDefaultAcceptPaidMailing());
            this.ensureAllowChargingSms(status, this.hasNotificationsBySms(member));
            status = this.memberSmsStatusDao.insert(status);
        }
        finally {
            lockHandler.release();
        }
        return status;
    }
}

