/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.ActivitiesVO;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberStatusVO;
import nl.strohalm.cyclos.services.elements.QuickAccessVO;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.services.sms.exceptions.SmsContextInitializationException;
import nl.strohalm.cyclos.webservices.members.FullTextMemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberResultPage;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.MyProfileVO;

public class MemberServiceSecurity
extends BaseServiceSecurity
implements MemberService {
    private MemberServiceLocal memberService;

    @Override
    public ActivitiesVO getActivities(Member member) {
        if (this.permissionService.manages(member)) {
            this.permissionService.permission(member).admin(AdminMemberPermission.REPORTS_VIEW).broker(BrokerPermission.REPORTS_VIEW).member(new MemberPermission[0]).operator(OperatorPermission.REPORTS_VIEW_MEMBER).check();
        } else {
            this.permissionService.checkRelatesTo(member);
            this.permissionService.permission().member(MemberPermission.REPORTS_VIEW).operator(MemberPermission.REPORTS_VIEW).check();
        }
        return this.memberService.getActivities(member);
    }

    @Override
    public MemberResultPage getMemberResultPage(FullTextMemberSearchParameters params) {
        return this.memberService.getMemberResultPage(params);
    }

    @Override
    public MemberVO getMemberVO(Member member, boolean useMemberFields, boolean useImages) {
        this.permissionService.checkRelatesTo(member);
        return this.memberService.getMemberVO(member, useMemberFields, useImages);
    }

    @Override
    public MyProfileVO getMyProfileVO(Member member) {
        this.permissionService.checkRelatesTo(member);
        return this.memberService.getMyProfileVO(member);
    }

    @Override
    public QuickAccessVO getQuickAccess() {
        return this.memberService.getQuickAccess();
    }

    @Override
    public ISmsContext getSmsContext(Member member) throws SmsContextInitializationException {
        this.permissionService.permission(member).admin(AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).broker(BrokerPermission.PREFERENCES_MANAGE_NOTIFICATIONS).member(MemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).check();
        return this.memberService.getSmsContext(member);
    }

    @Override
    public MemberStatusVO getStatus() {
        return this.memberService.getStatus();
    }

    @Override
    public Member loadByIdOrPrincipal(Long id, String principalType, String principal) {
        Member member = this.memberService.loadByIdOrPrincipal(id, principalType, principal);
        if (member != null) {
            this.permissionService.checkRelatesTo(member);
        }
        return member;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }
}

