/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.dao.members.MessageCategoryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.messages.MessageCategoryQuery;
import nl.strohalm.cyclos.services.elements.MessageCategoryServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MessageCategoryServiceImpl
implements MessageCategoryServiceLocal {
    private MessageCategoryDAO messageCategoryDao;
    private FetchServiceLocal fetchService;

    @Override
    public boolean canView(MessageCategory cat) {
        SystemGroup group = LoggedUser.isOperator() ? (SystemGroup)LoggedUser.member().getGroup() : (SystemGroup)LoggedUser.group();
        group = this.fetchService.fetch(group, SystemGroup.Relationships.MESSAGE_CATEGORIES);
        return group.getMessageCategories().contains(cat);
    }

    public MessageCategoryDAO getMessageCategoryDao() {
        return this.messageCategoryDao;
    }

    @Override
    public synchronized List<MessageCategory> listAll() {
        return this.messageCategoryDao.findAll();
    }

    @Override
    public MessageCategory load(Long id) {
        return (MessageCategory)this.messageCategoryDao.load(id, new Relationship[0]);
    }

    @Override
    public int remove(Long ... ids) {
        return this.messageCategoryDao.delete(ids);
    }

    @Override
    public MessageCategory save(MessageCategory messageCategory) {
        this.validate(messageCategory);
        MessageCategory messageCategoryAux = null;
        messageCategoryAux = messageCategory.isTransient() ? this.messageCategoryDao.insert(messageCategory) : this.messageCategoryDao.update(messageCategory);
        return messageCategoryAux;
    }

    @Override
    public List<MessageCategory> search(MessageCategoryQuery query) {
        return this.messageCategoryDao.search(query);
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMessageCategoryDao(MessageCategoryDAO messageCategoryDao) {
        this.messageCategoryDao = messageCategoryDao;
    }

    @Override
    public void validate(MessageCategory messageCategory) throws ValidationException {
        this.getValidator().validate(messageCategory);
    }

    private Validator getValidator() {
        Validator validator = new Validator();
        validator.property("name").required().maxLength(200);
        return validator;
    }
}

