/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.messages.MessageCategoryQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.MessageCategoryService;
import nl.strohalm.cyclos.services.elements.MessageCategoryServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MessageCategoryServiceSecurity
extends BaseServiceSecurity
implements MessageCategoryService {
    private MessageCategoryServiceLocal messageCategoryService;

    @Override
    public MessageCategory load(Long id) {
        MessageCategory messageCategory = this.messageCategoryService.load(id);
        if (!this.permissionService.hasPermission(AdminSystemPermission.MESSAGE_CATEGORIES_VIEW) && !this.messageCategoryService.canView(messageCategory)) {
            throw new PermissionDeniedException();
        }
        return messageCategory;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManages();
        return this.messageCategoryService.remove(ids);
    }

    @Override
    public MessageCategory save(MessageCategory messageCategory) {
        this.checkManages();
        return this.messageCategoryService.save(messageCategory);
    }

    @Override
    public List<MessageCategory> search(MessageCategoryQuery query) {
        List<MessageCategory> result = this.filterVisible(this.messageCategoryService.search(query));
        return result;
    }

    public void setMessageCategoryServiceLocal(MessageCategoryServiceLocal messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    @Override
    public void validate(MessageCategory messageCategory) throws ValidationException {
        this.messageCategoryService.validate(messageCategory);
    }

    private void checkManages() {
        this.permissionService.permission().admin(AdminSystemPermission.MESSAGE_CATEGORIES_MANAGE).check();
    }

    private List<MessageCategory> filterVisible(List<MessageCategory> listAll) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.MESSAGE_CATEGORIES_VIEW)) {
            Iterator<MessageCategory> iterator = listAll.iterator();
            while (iterator.hasNext()) {
                MessageCategory cat = iterator.next();
                if (this.messageCategoryService.canView(cat)) continue;
                iterator.remove();
            }
        }
        return listAll;
    }
}

