/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.members.MessageDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.elements.MessageAction;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendDirectMessageToMemberDTO;
import nl.strohalm.cyclos.services.elements.SendMessageDTO;
import nl.strohalm.cyclos.services.elements.SendMessageFromBrokerToMembersDTO;
import nl.strohalm.cyclos.services.elements.SendMessageFromSystemDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToAdminDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToGroupDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToMemberDTO;
import nl.strohalm.cyclos.services.elements.SendSmsDTO;
import nl.strohalm.cyclos.services.elements.exceptions.MemberWontReceiveNotificationException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.preferences.MessageChannel;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.services.sms.SmsLogServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.LinkGenerator;
import nl.strohalm.cyclos.utils.MailHandler;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.WorkerThreads;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.sms.SmsSender;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class MessageServiceImpl
implements MessageServiceLocal,
DisposableBean,
InitializingService {
    private static final Log LOG = LogFactory.getLog(MessageServiceImpl.class);
    private PermissionServiceLocal permissionService;
    private MessageDAO messageDao;
    private FetchServiceLocal fetchService;
    private MemberServiceLocal memberService;
    private PaymentServiceLocal paymentService;
    private PreferenceServiceLocal preferenceService;
    private SettingsServiceLocal settingsService;
    private SmsLogServiceLocal smsLogService;
    private LinkGenerator linkGenerator;
    private MailHandler mailHandler;
    private SmsSender smsSender;
    private TransactionHelper transactionHelper;
    private int maxSmsThreads;
    private SmsSenderThreads smsSenderThreads;
    private AdminNotificationHandler adminNotificationHandler;

    @Override
    public boolean canManage(Message message) {
        if ((message = this.checkMessageOwner(message)) == null) {
            return false;
        }
        return this.permissionService.permission().admin(AdminMemberPermission.MESSAGES_MANAGE).member(MemberPermission.MESSAGES_MANAGE).operator(OperatorPermission.MESSAGES_MANAGE).hasPermission();
    }

    @Override
    public boolean canSendToAdmin() {
        return this.permissionService.permission().member(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION).operator(OperatorPermission.MESSAGES_SEND_TO_ADMINISTRATION).hasPermission();
    }

    @Override
    public boolean canSendToMember(Member member) {
        return this.permissionService.permission().admin(AdminMemberPermission.MESSAGES_SEND_TO_MEMBER).member(MemberPermission.MESSAGES_SEND_TO_MEMBER).operator(OperatorPermission.MESSAGES_SEND_TO_MEMBER).hasPermission() && this.permissionService.relatesTo(member);
    }

    @Override
    public Message checkMessageOwner(Message message) {
        if (message == null) {
            return null;
        }
        message = this.fetchService.fetch(message, Message.Relationships.FROM_MEMBER, Message.Relationships.TO_MEMBER);
        Member loggedMember = (Member)(LoggedUser.hasUser() && !LoggedUser.isAdministrator() ? LoggedUser.accountOwner() : null);
        Member owner = message.getOwner();
        if (loggedMember == null && owner != null || loggedMember != null && !loggedMember.equals(owner)) {
            return null;
        }
        return message;
    }

    public void destroy() throws Exception {
        if (this.smsSenderThreads != null) {
            this.smsSenderThreads.interrupt();
            this.smsSenderThreads = null;
        }
    }

    @Override
    public void initializeService() {
        this.purgeExpiredMessagesOnTrash(Calendar.getInstance());
    }

    @Override
    public Message load(Long id, Relationship ... fetch) {
        return (Message)this.messageDao.load(id, fetch);
    }

    @Override
    public Message nextToSend() {
        return this.messageDao.nextToSend();
    }

    @Override
    public void performAction(MessageAction action, Long ... ids) {
        for (Long id : ids) {
            Message message = (Message)this.messageDao.load(id, new Relationship[0]);
            if (action == MessageAction.DELETE) {
                this.messageDao.delete(message.getId());
                continue;
            }
            switch (action) {
                case MOVE_TO_TRASH: {
                    message.setRemovedAt(Calendar.getInstance());
                    break;
                }
                case RESTORE: {
                    message.setRemovedAt(null);
                    break;
                }
                case MARK_AS_READ: {
                    message.setRead(true);
                    break;
                }
                case MARK_AS_UNREAD: {
                    message.setRead(false);
                }
            }
            this.messageDao.update(message);
        }
    }

    @Override
    public void purgeExpiredMessagesOnTrash(Calendar time) {
        TimePeriod timePeriod = this.settingsService.getLocalSettings().getDeleteMessagesOnTrashAfter();
        if (timePeriod == null || timePeriod.getNumber() <= 0) {
            return;
        }
        Calendar limit = timePeriod.remove(DateHelper.truncate(time));
        this.messageDao.removeMessagesOnTrashBefore(limit);
    }

    @Override
    public Message read(Long id, Relationship ... fetch) {
        Message message = this.load(id, fetch);
        message.setRead(true);
        return message;
    }

    @Override
    public List<Message> search(MessageQuery query) {
        return this.messageDao.search(query);
    }

    @Override
    public Message send(SendMessageDTO message) {
        if (message instanceof SendMessageToGroupDTO || message instanceof SendMessageFromBrokerToMembersDTO) {
            return this.doSendBulk(message);
        }
        if (message instanceof SendMessageToAdminDTO) {
            Message sentMessage = this.doSendSingle(message);
            this.adminNotificationHandler.notifyMessage(sentMessage);
            return sentMessage;
        }
        if (message instanceof SendDirectMessageToMemberDTO) {
            return this.doSendSingle(message);
        }
        return this.doSendSingle(message);
    }

    @Override
    public void sendEmailIfNeeded(Message message) {
        Member member = message.getToMember();
        Set<MessageChannel> receivedChannels = this.preferenceService.receivedChannels(member, message.getType());
        if (receivedChannels.contains((Object)MessageChannel.EMAIL)) {
            InternetAddress replyTo = this.mailHandler.getInternetAddress(message.getFromMember());
            InternetAddress to = this.mailHandler.getInternetAddress(member);
            this.mailHandler.send(message.getSubject(), replyTo, to, message.getBody(), message.isHtml());
        }
    }

    @Override
    public void sendFromSystem(SendMessageFromSystemDTO message) {
        Entity entity = message.getEntity();
        String link = "";
        if (entity != null && this.linkGenerator != null) {
            link = this.linkGenerator.generateLinkFor(message.getToMember(), entity);
        }
        String body = StringUtils.replace((String)message.getBody(), (String)"#link#", (String)link);
        message.setBody(body);
        message.setHtml(true);
        this.doSendSingle(message);
    }

    @Override
    public SmsLog sendSms(final SendSmsDTO params) {
        final MutableObject result = new MutableObject();
        this.transactionHelper.runInNewTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SmsLog log;
                try {
                    log = MessageServiceImpl.this.doSendSms(params);
                }
                catch (LockingException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)"Unknown error sending sms", (Throwable)e);
                    log = MessageServiceImpl.this.newSmsLog(params, SmsLog.ErrorType.SEND_ERROR, false);
                }
                if (log.getErrorType() != null) {
                    status.setRollbackOnly();
                }
                final SmsLog toSave = log;
                CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                    @Override
                    protected void onTransactionEnd(boolean commit) {
                        MessageServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                            protected void doInTransactionWithoutResult(TransactionStatus status) {
                                result.setValue((Object)MessageServiceImpl.this.smsLogService.save(toSave));
                            }
                        });
                    }
                });
            }
        });
        return (SmsLog)result.getValue();
    }

    @Override
    public synchronized void sendSmsAfterTransactionCommit(final SendSmsDTO params) {
        if (this.smsSenderThreads == null) {
            this.smsSenderThreads = new SmsSenderThreads("SMS sender for " + this.settingsService.getLocalSettings().getApplicationName(), this.maxSmsThreads);
        }
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                MessageServiceImpl.this.smsSenderThreads.enqueue(params);
            }
        });
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    public void setMailHandler(MailHandler mailHandler) {
        this.mailHandler = mailHandler;
    }

    public void setMaxSmsThreads(int maxSmsThreads) {
        this.maxSmsThreads = maxSmsThreads;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }

    public void setMessageDao(MessageDAO messageDao) {
        this.messageDao = messageDao;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public final void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setSmsLogServiceLocal(SmsLogServiceLocal smsLogService) {
        this.smsLogService = smsLogService;
    }

    public void setSmsSender(SmsSender smsSender) {
        this.smsSender = smsSender;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    public void validate(SendMessageDTO message) throws ValidationException {
        this.getValidator(message.getClass()).validate(message);
    }

    private Validator basicToMemberValidator() {
        Validator validator = this.basicValidator();
        validator.property("toMember").required();
        return validator;
    }

    private Validator basicValidator() {
        Validator validator = new Validator("message");
        validator.property("subject").required();
        validator.property("body").required();
        return validator;
    }

    private Message buildFromDTO(SendMessageDTO dto, Message.Direction direction) {
        return this.buildFromDTO(dto, dto, direction);
    }

    private Message buildFromDTO(SendMessageDTO original, SendMessageDTO dto, Message.Direction direction) {
        Message message = new Message();
        message.setDate(Calendar.getInstance());
        message.setHtml(dto.isHtml());
        message.setSubject(dto.getSubject());
        message.setBody(dto.getBody());
        if (!(dto instanceof SendMessageFromSystemDTO)) {
            message.setFromMember((Member)(LoggedUser.hasUser() && !LoggedUser.isAdministrator() ? LoggedUser.accountOwner() : null));
        }
        message.setType(dto.getType());
        message.setDirection(direction);
        if (direction == Message.Direction.OUTGOING) {
            message.setRead(true);
            message.setEmailSent(true);
        }
        if (dto instanceof SendMessageToMemberDTO) {
            message.setToMember(((SendMessageToMemberDTO)dto).getToMember());
        } else if (dto instanceof SendMessageToGroupDTO) {
            message.setToGroups(new ArrayList<MemberGroup>(((SendMessageToGroupDTO)dto).getToGroups()));
        }
        if (message.isFromAMember() && message.isToAMember()) {
            message.setCategory(null);
        } else {
            message.setCategory(dto.getCategory());
        }
        return message;
    }

    private TransferDTO buildSmsChargeDto(Member member, ISmsContext smsContext) {
        MemberGroupSettings memberSettings = member.getMemberGroup().getMemberSettings();
        TransferType smsChargeTransferType = memberSettings.getSmsChargeTransferType();
        BigDecimal smsChargeAmount = smsContext.getAdditionalChargeAmount(member);
        if (smsChargeTransferType == null || smsChargeAmount == null) {
            return null;
        }
        TransferDTO transferDto = new TransferDTO();
        if (smsChargeTransferType.isFromMember()) {
            transferDto.setFromOwner(member);
        } else {
            transferDto.setFromOwner(SystemAccountOwner.instance());
        }
        transferDto.setToOwner(SystemAccountOwner.instance());
        transferDto.setTransferType(smsChargeTransferType);
        transferDto.setDescription(smsChargeTransferType.getDescription());
        transferDto.setAmount(smsChargeAmount);
        transferDto.setAutomatic(true);
        return transferDto;
    }

    private Message doSendBulk(SendMessageDTO message) {
        this.validate(message);
        return this.insertSenderCopy(message);
    }

    private Message doSendSingle(SendMessageDTO message) {
        this.validate(message);
        Set<MessageChannel> messageChannels = null;
        if (message instanceof SendMessageToMemberDTO) {
            SendMessageToMemberDTO toMemberMessage = (SendMessageToMemberDTO)message;
            messageChannels = this.preferenceService.receivedChannels(toMemberMessage.getToMember(), message.getType());
            if (toMemberMessage.requiresMemberToReceive() && CollectionUtils.isEmpty(messageChannels)) {
                throw new MemberWontReceiveNotificationException();
            }
        }
        Message senderCopy = this.insertSenderCopy(message);
        Message toSend = this.buildFromDTO(message, Message.Direction.INCOMING);
        String sms = null;
        String smsTraceData = null;
        if (message instanceof SendMessageFromSystemDTO) {
            SendMessageFromSystemDTO messageFromSystem = (SendMessageFromSystemDTO)message;
            sms = messageFromSystem.getSms();
            smsTraceData = messageFromSystem.getSmsTraceData();
        }
        this.send(toSend, sms, smsTraceData, messageChannels);
        return senderCopy;
    }

    private SmsLog doSendSms(SendSmsDTO params) {
        Member target = params.getTargetMember();
        MemberCustomField customField = this.settingsService.getSmsCustomField();
        if (customField == null || !this.memberService.hasValueForField(target, customField)) {
            return this.newSmsLog(params, SmsLog.ErrorType.NO_PHONE, false);
        }
        Member charged = params.getChargedMember();
        boolean freeMailing = params.getSmsMailing() != null && params.getSmsMailing().isFree();
        SmsLog.ErrorType errorType = null;
        boolean boughtNewMessages = false;
        MemberSmsStatus memberSmsStatus = null;
        int additionalChargedSms = 0;
        boolean statusChanged = false;
        boolean freeBaseUsed = false;
        ISmsContext smsContext = null;
        if (!freeMailing) {
            if (charged == null) {
                charged = target;
                params.setChargedMember(charged);
            }
            charged = this.fetchService.reload(charged, Element.Relationships.GROUP);
            smsContext = this.memberService.getSmsContext(charged);
            memberSmsStatus = this.memberService.getSmsStatus(charged, true);
            additionalChargedSms = smsContext.getAdditionalChargedSms(charged);
            int freeSms = smsContext.getFreeSms(charged);
            if (memberSmsStatus.getFreeSmsSent() < freeSms) {
                memberSmsStatus.setFreeSmsSent(memberSmsStatus.getFreeSmsSent() + 1);
                freeBaseUsed = true;
                statusChanged = true;
            } else if (memberSmsStatus.getPaidSmsLeft() > 0) {
                memberSmsStatus.setPaidSmsLeft(memberSmsStatus.getPaidSmsLeft() - 1);
                statusChanged = true;
            } else if (additionalChargedSms > 0) {
                if (memberSmsStatus.isAllowChargingSms()) {
                    TransferDTO chargeDTO = this.buildSmsChargeDto(charged, smsContext);
                    try {
                        if (chargeDTO == null) {
                            throw new UnexpectedEntityException();
                        }
                        this.paymentService.insertWithoutNotification(chargeDTO);
                        boughtNewMessages = true;
                    }
                    catch (NotEnoughCreditsException e) {
                        errorType = SmsLog.ErrorType.NOT_ENOUGH_FUNDS;
                    }
                    catch (MaxAmountPerDayExceededException e) {
                        errorType = SmsLog.ErrorType.NOT_ENOUGH_FUNDS;
                    }
                    catch (UpperCreditLimitReachedException e) {
                        errorType = SmsLog.ErrorType.NOT_ENOUGH_FUNDS;
                    }
                    catch (UnexpectedEntityException e) {
                        ValidationException exc = new ValidationException("The SMS charging is not well configured. Please, check the charging transfer type.", new Object[0]);
                        exc.setShowDetailMessage(true);
                        throw exc;
                    }
                } else {
                    errorType = SmsLog.ErrorType.ALLOW_CHARGING_DISABLED;
                }
            } else {
                if (freeSms == 0) {
                    ValidationException exc = new ValidationException("SMS cannot be sent becasue both free messages and aditional messages are zero for member: " + charged.getUsername(), new Object[0]);
                    exc.setShowDetailMessage(true);
                    throw exc;
                }
                errorType = SmsLog.ErrorType.NO_SMS_LEFT;
            }
        }
        if (errorType == null) {
            try {
                if (!this.smsSender.send(target, params.getText(), params.getTraceData())) {
                    throw new Exception("Sms sender returns false when sending a sms (trace=" + params.getTraceData() + ")");
                }
                if (boughtNewMessages) {
                    int left = additionalChargedSms - 1;
                    Calendar expiration = null;
                    if (left > 0) {
                        TimePeriod additionalChargedPeriod = smsContext.getAdditionalChargedPeriod(charged);
                        if (additionalChargedPeriod == null) {
                            additionalChargedPeriod = TimePeriod.ONE_MONTH;
                        }
                        expiration = additionalChargedPeriod.add(Calendar.getInstance());
                    }
                    memberSmsStatus.setPaidSmsLeft(left);
                    memberSmsStatus.setPaidSmsExpiration(expiration);
                    statusChanged = true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Unknown error sending sms", (Throwable)e);
                errorType = SmsLog.ErrorType.SEND_ERROR;
                statusChanged = false;
            }
        }
        if (statusChanged) {
            this.memberService.updateSmsStatus(memberSmsStatus);
        }
        return this.newSmsLog(params, errorType, freeBaseUsed);
    }

    private Validator getValidator(Class<? extends SendMessageDTO> type) {
        if (type == SendDirectMessageToMemberDTO.class) {
            Validator toMember = this.basicToMemberValidator();
            toMember.property("toMember").add(new SameFromAndToValidation());
            toMember.property("category").add(new RequiredWhenFromAdminValidation());
            return toMember;
        }
        if (type == SendMessageToAdminDTO.class) {
            Validator toAdmin = this.basicValidator();
            toAdmin.property("category").required();
            return toAdmin;
        }
        if (type == SendMessageFromBrokerToMembersDTO.class) {
            Validator toRegisteredMembers = this.basicValidator();
            return toRegisteredMembers;
        }
        if (type == SendMessageToGroupDTO.class) {
            Validator toGroup = this.basicValidator();
            toGroup.property("toGroups").required();
            toGroup.property("category").add(new RequiredWhenFromAdminValidation());
            return toGroup;
        }
        if (type == SendMessageFromSystemDTO.class) {
            Validator fromSystem = this.basicToMemberValidator();
            fromSystem.property("type").required();
            return fromSystem;
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    private Message insertSenderCopy(SendMessageDTO dto) throws MemberWontReceiveNotificationException {
        Message inReplyTo = this.checkMessageOwner(dto.getInReplyTo());
        if (inReplyTo != null) {
            this.markAsReplied(inReplyTo);
        }
        if (dto instanceof SendMessageFromSystemDTO) {
            return null;
        }
        Message message = this.buildFromDTO(dto, Message.Direction.OUTGOING);
        message = this.messageDao.insert(message);
        if (dto instanceof SendMessageToGroupDTO) {
            SendMessageToGroupDTO toGroup = (SendMessageToGroupDTO)dto;
            this.messageDao.assignPendingToSendByGroups(message, toGroup.getToGroups());
        } else if (dto instanceof SendMessageFromBrokerToMembersDTO) {
            Member broker = (Member)LoggedUser.element();
            this.messageDao.assignPendingToSendByBroker(message, broker);
        }
        return message;
    }

    private void markAsReplied(Message message) {
        if (message != null) {
            message.setReplied(true);
            this.messageDao.update(message);
        }
    }

    private SmsLog newSmsLog(SendSmsDTO params, SmsLog.ErrorType errorType, boolean freeBaseUsed) {
        SmsLog newLog = new SmsLog();
        newLog.setDate(Calendar.getInstance());
        newLog.setTargetMember(params.getTargetMember());
        newLog.setChargedMember(params.getChargedMember());
        newLog.setErrorType(errorType);
        newLog.setFreeBaseUsed(freeBaseUsed);
        newLog.setMessageType(params.getMessageType());
        newLog.setSmsMailing(params.getSmsMailing());
        newLog.setSmsType(params.getSmsType());
        newLog.setSmsTypeArgs(params.getSmsTypeArgs());
        return newLog;
    }

    private Set<MessageChannel> send(Message message, String smsMessage, String smsTraceData, Set<MessageChannel> messageChannels) {
        Member toMember = this.fetchService.fetch(message.getToMember(), Element.Relationships.GROUP);
        message.setCategory(this.fetchService.fetch(message.getCategory(), new Relationship[0]));
        EnumSet<MessageChannel> result = EnumSet.noneOf(MessageChannel.class);
        if (toMember != null) {
            MemberGroup group = toMember.getMemberGroup();
            Message.Type type = message.getType();
            if (messageChannels == null) {
                messageChannels = this.preferenceService.receivedChannels(toMember, type);
            }
            if (CollectionUtils.isEmpty(messageChannels)) {
                return result;
            }
            String email = toMember.getEmail();
            if (messageChannels.contains((Object)MessageChannel.EMAIL) && StringUtils.isNotEmpty((String)email)) {
                InternetAddress replyTo = this.mailHandler.getInternetAddress(message.getFromMember());
                InternetAddress to = this.mailHandler.getInternetAddress(toMember);
                this.mailHandler.sendAfterTransactionCommit(message.getSubject(), replyTo, to, message.getBody(), message.isHtml());
                message.setEmailSent(true);
                result.add(MessageChannel.EMAIL);
            }
            if (StringUtils.isNotEmpty((String)smsMessage) && messageChannels.contains((Object)MessageChannel.SMS) && group.getSmsMessages().contains(type)) {
                SendSmsDTO sendDTO = new SendSmsDTO();
                sendDTO.setTargetMember(toMember);
                sendDTO.setMessageType(type);
                sendDTO.setText(smsMessage);
                sendDTO.setTraceData(smsTraceData);
                this.sendSmsAfterTransactionCommit(sendDTO);
                result.add(MessageChannel.SMS);
            }
            if (!messageChannels.contains((Object)MessageChannel.MESSAGE)) {
                return result;
            }
            result.add(MessageChannel.MESSAGE);
        }
        this.messageDao.insert(message);
        return result;
    }

    private class SmsSenderThreads
    extends WorkerThreads<SendSmsDTO> {
        public SmsSenderThreads(String name, int threadCount) {
            super(name, threadCount);
        }

        @Override
        protected void process(SendSmsDTO params) {
            MessageServiceImpl.this.sendSms(params);
        }
    }

    public static class SameFromAndToValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -3649308826565152361L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            SendMessageToMemberDTO dto = (SendMessageToMemberDTO)object;
            Member loggedMember = LoggedUser.hasUser() && LoggedUser.isMember() ? LoggedUser.element() : null;
            Member toMember = dto.getToMember();
            if (loggedMember != null && loggedMember.equals(toMember)) {
                return new InvalidError();
            }
            return null;
        }
    }

    public static class RequiredWhenFromAdminValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -3593591846871843393L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            if (LoggedUser.hasUser() && LoggedUser.isAdministrator()) {
                return RequiredValidation.instance().validate(object, property, value);
            }
            return null;
        }
    }
}

