/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.MessageAction;
import nl.strohalm.cyclos.services.elements.MessageCategoryServiceLocal;
import nl.strohalm.cyclos.services.elements.MessageService;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendDirectMessageToMemberDTO;
import nl.strohalm.cyclos.services.elements.SendMessageDTO;
import nl.strohalm.cyclos.services.elements.SendMessageFromBrokerToMembersDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToAdminDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToGroupDTO;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MessageServiceSecurity
extends BaseServiceSecurity
implements MessageService {
    private MessageServiceLocal messageService;
    private MessageCategoryServiceLocal messageCategoryService;

    @Override
    public boolean canManage(Message message) {
        return this.messageService.canManage(message);
    }

    @Override
    public boolean canSendToAdmin() {
        return this.messageService.canSendToAdmin();
    }

    @Override
    public boolean canSendToMember(Member member) {
        return this.messageService.canSendToMember(member);
    }

    @Override
    public Message load(Long id, Relationship ... fetch) {
        Message message = this.messageService.load(id, fetch);
        this.checkView(message);
        return message;
    }

    @Override
    public void performAction(MessageAction action, Long ... ids) {
        for (Long id : ids) {
            Message message = this.messageService.load(id, new Relationship[0]);
            this.checkManage(message);
        }
        this.messageService.performAction(action, ids);
    }

    @Override
    public Message read(Long id, Relationship ... fetch) {
        Message message = this.messageService.read(id, fetch);
        this.checkView(message);
        return message;
    }

    @Override
    public List<Message> search(MessageQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.messageService.search(query);
    }

    @Override
    public Message send(SendMessageDTO message) {
        this.checkSend(message);
        return this.messageService.send(message);
    }

    public void setMessageCategoryServiceLocal(MessageCategoryServiceLocal messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    @Override
    public void validate(SendMessageDTO message) throws ValidationException {
        this.messageService.validate(message);
    }

    private boolean applyQueryRestrictions(MessageQuery query) {
        if (!this.permissionService.permission().admin(AdminMemberPermission.MESSAGES_VIEW).member(MemberPermission.MESSAGES_VIEW).operator(OperatorPermission.MESSAGES_VIEW).hasPermission()) {
            return false;
        }
        query.setGetter((Element)LoggedUser.element());
        return true;
    }

    private void checkManage(Message message) {
        if (!this.canManage(message)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkSend(SendMessageDTO message) {
        if (message instanceof SendMessageToGroupDTO) {
            this.permissionService.permission().admin(AdminMemberPermission.MESSAGES_SEND_TO_GROUP).check();
            if (!this.permissionService.getVisibleMemberGroups().containsAll(((SendMessageToGroupDTO)message).getToGroups())) {
                throw new PermissionDeniedException();
            }
        } else if (message instanceof SendMessageFromBrokerToMembersDTO) {
            this.permissionService.permission().broker(BrokerPermission.MESSAGES_SEND_TO_MEMBERS).check();
        } else if (message instanceof SendMessageToAdminDTO) {
            if (!this.canSendToAdmin()) {
                throw new PermissionDeniedException();
            }
        } else if (message instanceof SendDirectMessageToMemberDTO) {
            if (!this.canSendToMember(((SendDirectMessageToMemberDTO)message).getToMember())) {
                throw new PermissionDeniedException();
            }
        } else {
            throw new IllegalArgumentException("Unexpected message class received " + message.getClass().getName());
        }
        if (message.getCategory() != null && !this.messageCategoryService.canView(message.getCategory())) {
            throw new PermissionDeniedException();
        }
        if (message.getInReplyTo() != null) {
            this.checkView(message.getInReplyTo());
        }
    }

    private void checkView(Message message) {
        this.permissionService.permission().admin(AdminMemberPermission.MESSAGES_VIEW).member(MemberPermission.MESSAGES_VIEW).operator(OperatorPermission.MESSAGES_VIEW).check();
        if (this.messageService.checkMessageOwner(message) == null) {
            throw new PermissionDeniedException();
        }
    }
}

