/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.members.ReferenceDAO;
import nl.strohalm.cyclos.dao.members.ReferenceHistoryDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentAwaitingFeedbackDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.GeneralReference;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PaymentsAwaitingFeedbackQuery;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceHistoryLog;
import nl.strohalm.cyclos.entities.members.ReferenceHistoryLogQuery;
import nl.strohalm.cyclos.entities.members.ReferenceQuery;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.elements.ReferenceServiceLocal;
import nl.strohalm.cyclos.services.elements.TransactionFeedbackAction;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.StringUtils;

public class ReferenceServiceImpl
implements ReferenceServiceLocal {
    private SettingsServiceLocal settingsService;
    private AlertServiceLocal alertService;
    private FetchServiceLocal fetchService;
    private PermissionServiceLocal permissionService;
    private ReferenceDAO referenceDao;
    private ReferenceHistoryDAO referenceHistoryDao;
    private MemberNotificationHandler memberNotificationHandler;

    @Override
    public boolean canGiveGeneralReference(Member member) {
        return !LoggedUser.isAdministrator() && !((Element)LoggedUser.element()).getAccountOwner().equals(member) && this.permissionService.permission().member(MemberPermission.REFERENCES_GIVE).operator(OperatorPermission.REFERENCES_MANAGE_MEMBER_REFERENCES).hasPermission() && this.permissionService.relatesTo(member);
    }

    @Override
    public boolean canManage(Reference ref) {
        switch (ref.getNature()) {
            case GENERAL: {
                return this.canManageGeneralReference(ref.getFrom());
            }
            case TRANSACTION: {
                if (ref.isTransient() && (LoggedUser.isMember() || LoggedUser.isOperator()) && !this.permissionService.manages(ref.getFrom())) {
                    return false;
                }
                if (!ref.isTransient() && (LoggedUser.isMember() || LoggedUser.isOperator()) && !this.permissionService.manages(ref.getTo())) {
                    return false;
                }
                if (!this.permissionService.manages(ref.getFrom()) && !this.permissionService.manages(ref.getTo())) {
                    return false;
                }
                if (LoggedUser.isBroker() && !((Entity)LoggedUser.element()).equals(ref.getFrom()) && !((Entity)LoggedUser.element()).equals(ref.getTo())) {
                    return false;
                }
                return this.permissionService.permission().admin(AdminMemberPermission.TRANSACTION_FEEDBACKS_MANAGE).member(new MemberPermission[0]).operator(OperatorPermission.REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS).hasPermission();
            }
        }
        return false;
    }

    @Override
    public boolean canManageGeneralReference(Member member) {
        return this.permissionService.permission(member).admin(AdminMemberPermission.REFERENCES_MANAGE).broker(BrokerPermission.REFERENCES_MANAGE).member(MemberPermission.REFERENCES_GIVE).operator(OperatorPermission.REFERENCES_MANAGE_MEMBER_REFERENCES).hasPermission();
    }

    @Override
    public boolean canReplyFeedbackNow(TransactionFeedback transactionFeedback) {
        Payment payment = transactionFeedback.getPayment();
        Calendar date = transactionFeedback.getDate();
        Calendar replyLimit = payment.getType().getFeedbackReplyExpirationTime().add(date);
        return replyLimit.after(Calendar.getInstance());
    }

    @Override
    public Map<Reference.Level, Integer> countGivenReferencesByLevel(Reference.Nature nature) {
        Collection<MemberGroup> memberGroups = null;
        if (LoggedUser.hasUser()) {
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS);
            memberGroups = adminGroup.getManagesGroups();
        }
        return this.referenceDao.countGivenReferencesByLevel(nature, memberGroups);
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesByLevel(Reference.Nature nature, Member member, boolean received) {
        return this.normalizeCountByLevel(this.referenceDao.countReferencesByLevel(nature, null, member, received));
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesHistoryByLevel(Reference.Nature nature, Member member, Period period, boolean received) {
        Map<Reference.Level, Integer> countByLevel = nature == Reference.Nature.TRANSACTION ? this.referenceDao.countReferencesByLevel(nature, period, member, received) : this.referenceHistoryDao.countReferencesHistoryByLevel(member, period, received);
        return this.normalizeCountByLevel(countByLevel);
    }

    @Override
    public Collection<Reference.Nature> getNaturesByGroup(MemberGroup group) {
        EnumSet<Reference.Nature> natures = EnumSet.noneOf(Reference.Nature.class);
        group = this.fetchService.fetch(group, Group.Relationships.TRANSFER_TYPES);
        for (TransferType transferType : group.getTransferTypes()) {
            if (!transferType.isRequiresFeedback()) continue;
            natures.add(Reference.Nature.TRANSACTION);
            break;
        }
        if (this.permissionService.hasPermission((Group)group, MemberPermission.REFERENCES_GIVE)) {
            natures.add(Reference.Nature.GENERAL);
        }
        return natures;
    }

    @Override
    public TransactionFeedbackAction getPossibleAction(TransactionFeedback transactionFeedback) {
        if (transactionFeedback.isTransient()) {
            if (this.canFeedbackNow(transactionFeedback)) {
                return TransactionFeedbackAction.COMMENTS;
            }
            return TransactionFeedbackAction.VIEW;
        }
        TransactionFeedback current = (TransactionFeedback)this.load(transactionFeedback.getId(), new Relationship[0]);
        if (LoggedUser.isAdministrator()) {
            return TransactionFeedbackAction.ADMIN_EDIT;
        }
        if (((Element)LoggedUser.element()).getAccountOwner().equals(current.getTo()) && StringUtils.isEmpty((String)current.getReplyComments()) && this.canReplyFeedbackNow(current)) {
            return TransactionFeedbackAction.REPLY_COMMENTS;
        }
        return TransactionFeedbackAction.VIEW;
    }

    @Override
    public Reference load(Long id, Relationship ... fetch) {
        return (Reference)this.referenceDao.load(id, fetch);
    }

    @Override
    public GeneralReference loadGeneral(Member from, Member to, Relationship ... fetch) throws EntityNotFoundException {
        ReferenceQuery query = new ReferenceQuery();
        query.fetch(fetch);
        query.setNature(Reference.Nature.GENERAL);
        query.setFrom(from);
        query.setTo(to);
        List<? extends Reference> list = this.search(query);
        if (list.isEmpty()) {
            throw new EntityNotFoundException(GeneralReference.class);
        }
        return (GeneralReference)list.iterator().next();
    }

    @Override
    public TransactionFeedback loadTransactionFeedback(Payment payment, Relationship ... fetch) throws EntityNotFoundException {
        ReferenceQuery query = new ReferenceQuery();
        query.setNature(Reference.Nature.TRANSACTION);
        if (payment instanceof ScheduledPayment) {
            query.setScheduledPayment((ScheduledPayment)payment);
        } else {
            query.setTransfer((Transfer)payment);
        }
        query.setUniqueResult();
        List<? extends Reference> refs = this.search(query);
        if (refs.isEmpty()) {
            throw new EntityNotFoundException(TransactionFeedback.class);
        }
        return (TransactionFeedback)refs.iterator().next();
    }

    @Override
    public int processExpiredFeedbacks(Calendar time) {
        time = DateHelper.truncate(time);
        PaymentsAwaitingFeedbackQuery query = new PaymentsAwaitingFeedbackQuery();
        query.setExpired(true);
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        List<PaymentAwaitingFeedbackDTO> paymentsAwaitingFeedback = this.searchPaymentsAwaitingFeedback(query);
        int processed = 0;
        CacheCleaner cleaner = new CacheCleaner(this.fetchService);
        for (PaymentAwaitingFeedbackDTO dto : paymentsAwaitingFeedback) {
            TransferType transferType = EntityHelper.reference(TransferType.class, dto.getTransferTypeId());
            transferType = this.fetchService.fetch(transferType, new Relationship[0]);
            Class paymentClass = dto.isScheduled() ? ScheduledPayment.class : Transfer.class;
            Payment payment = this.fetchService.fetch(EntityHelper.reference(paymentClass, dto.getId()), Payment.Relationships.FROM, Payment.Relationships.TO);
            TransactionFeedback feedback = new TransactionFeedback();
            feedback.setDate(time);
            feedback.setComments(transferType.getDefaultFeedbackComments());
            feedback.setLevel(transferType.getDefaultFeedbackLevel());
            feedback.setFrom((Member)payment.getFromOwner());
            feedback.setTo((Member)payment.getToOwner());
            feedback.setPayment(payment);
            this.referenceDao.insert(feedback, false);
            cleaner.clearCache();
            ++processed;
        }
        return processed;
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            Reference reference = this.load(id, null);
            this.updatePreviousReferenceHistoryLog(reference);
        }
        return this.referenceDao.delete(ids);
    }

    @Override
    public GeneralReference save(GeneralReference reference) {
        reference.setDate(Calendar.getInstance());
        return (GeneralReference)this.doSave(reference);
    }

    @Override
    public TransactionFeedback save(TransactionFeedback transactionFeedback) {
        switch (this.getPossibleAction(transactionFeedback)) {
            case ADMIN_EDIT: {
                return this.saveTransactionFeedbackByAdmin(transactionFeedback);
            }
            case COMMENTS: {
                return this.saveTransactionFeedbackComments(transactionFeedback);
            }
            case REPLY_COMMENTS: {
                return this.saveTransactionFeedbackReplyComments(transactionFeedback);
            }
        }
        throw new PermissionDeniedException();
    }

    @Override
    public List<? extends Reference> search(ReferenceQuery query) {
        return this.referenceDao.search(query);
    }

    @Override
    public List<PaymentAwaitingFeedbackDTO> searchPaymentsAwaitingFeedback(PaymentsAwaitingFeedbackQuery query) {
        return this.referenceDao.searchPaymentsAwaitingFeedback(query);
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setReferenceDao(ReferenceDAO referenceDAO) {
        this.referenceDao = referenceDAO;
    }

    public void setReferenceHistoryDao(ReferenceHistoryDAO referenceHistoryDao) {
        this.referenceHistoryDao = referenceHistoryDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(Reference reference) throws ValidationException {
        Validator validator = reference instanceof GeneralReference ? this.getGeneralValidator() : this.getTransactionFeedbackValidator((TransactionFeedback)reference);
        validator.validate(reference);
    }

    private boolean canFeedbackNow(TransactionFeedback transactionFeedback) {
        Payment payment = transactionFeedback.getPayment();
        Calendar paymentDate = (payment = this.fetchService.fetch(payment, Payment.Relationships.TYPE)) instanceof ScheduledPayment ? payment.getDate() : payment.getProcessDate();
        Calendar commentLimit = payment.getType().getFeedbackExpirationTime().add(paymentDate);
        return commentLimit.after(Calendar.getInstance());
    }

    private Validator createBasicValidator() {
        Validator validator = new Validator("reference");
        validator.property("level").required();
        validator.property("from").required();
        validator.property("to").required().add(new PropertyValidation(){
            private static final long serialVersionUID = 5881069152089528552L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                Reference reference = (Reference)object;
                Member from = reference.getFrom();
                if (from != null && from.equals(value)) {
                    return new InvalidError();
                }
                return null;
            }
        });
        validator.property("comments").required().maxLength(1000);
        return validator;
    }

    private void createNewReferenceHistoryLog(Reference reference) {
        ReferenceHistoryLog log = new ReferenceHistoryLog();
        log.setFrom(reference.getFrom());
        log.setTo(reference.getTo());
        log.setLevel(reference.getLevel());
        log.setPeriod(Period.begginingAt(reference.getDate()));
        this.referenceHistoryDao.insert(log);
    }

    private Reference doSave(Reference reference) {
        this.validate(reference);
        boolean isInsert = reference.isTransient();
        if (isInsert) {
            reference = this.referenceDao.insert(reference);
        } else if ((reference = this.referenceDao.update(reference)) instanceof GeneralReference) {
            this.updatePreviousReferenceHistoryLog(reference);
        }
        if (reference instanceof GeneralReference) {
            int receivedVeryBad;
            int givenVeryBad;
            this.createNewReferenceHistoryLog(reference);
            AlertSettings alertSettings = this.settingsService.getAlertSettings();
            Member from = reference.getFrom();
            if (alertSettings.getGivenVeryBadRefs() > 0 && (givenVeryBad = this.referenceDao.countReferencesByLevel(reference.getNature(), null, from, false).get(Reference.Level.VERY_BAD).intValue()) >= alertSettings.getGivenVeryBadRefs()) {
                boolean hasAlert;
                AlertQuery query = new AlertQuery();
                query.setType(Alert.Type.MEMBER);
                query.setMember(from);
                query.setKey(MemberAlert.Alerts.GIVEN_VERY_BAD_REFS.getValue());
                query.setPageForCount();
                boolean bl = hasAlert = PageHelper.getTotalCount(this.alertService.search(query)) > 0;
                if (!hasAlert) {
                    this.alertService.create(from, MemberAlert.Alerts.GIVEN_VERY_BAD_REFS, givenVeryBad);
                }
            }
            Member to = reference.getTo();
            if (alertSettings.getReceivedVeryBadRefs() > 0 && (receivedVeryBad = this.referenceDao.countReferencesByLevel(reference.getNature(), null, to, true).get(Reference.Level.VERY_BAD).intValue()) >= alertSettings.getReceivedVeryBadRefs()) {
                boolean hasAlert;
                AlertQuery query = new AlertQuery();
                query.setType(Alert.Type.MEMBER);
                query.setMember(from);
                query.setKey(MemberAlert.Alerts.RECEIVED_VERY_BAD_REFS.getValue());
                query.setPageForCount();
                boolean bl = hasAlert = PageHelper.getTotalCount(this.alertService.search(query)) > 0;
                if (!hasAlert) {
                    this.alertService.create(to, MemberAlert.Alerts.RECEIVED_VERY_BAD_REFS, receivedVeryBad);
                }
            }
        }
        if (isInsert && reference instanceof GeneralReference) {
            this.memberNotificationHandler.receivedReferenceNotification(reference);
        }
        return reference;
    }

    private Validator getGeneralValidator() {
        return this.createBasicValidator();
    }

    private Validator getTransactionFeedbackValidator(TransactionFeedback transactionFeedback) {
        Validator transactionFeedbackValidator = this.createBasicValidator();
        transactionFeedbackValidator.property("payment").required();
        transactionFeedbackValidator.general(new GeneralValidation(){
            private static final long serialVersionUID = 1L;

            @Override
            public ValidationError validate(Object object) {
                TransactionFeedback transactionFeedback = (TransactionFeedback)object;
                if (transactionFeedback.isTransient()) {
                    boolean readyForFeedback;
                    boolean bl = readyForFeedback = !LoggedUser.isAdministrator() && ((Element)LoggedUser.element()).getAccountOwner().equals(transactionFeedback.getFrom());
                    if (readyForFeedback && !ReferenceServiceImpl.this.canFeedbackNow(transactionFeedback)) {
                        return new ValidationError("reference.transactionFeedback.feedbackPeriodExpired", new Object[0]);
                    }
                }
                if (!transactionFeedback.isTransient()) {
                    boolean readyForReply;
                    TransactionFeedback current = (TransactionFeedback)ReferenceServiceImpl.this.load(transactionFeedback.getId(), new Relationship[0]);
                    boolean bl = readyForReply = !LoggedUser.isAdministrator() && ((Element)LoggedUser.element()).getAccountOwner().equals(current.getTo()) && StringUtils.isEmpty((String)current.getReplyComments());
                    if (readyForReply && !ReferenceServiceImpl.this.canReplyFeedbackNow(current)) {
                        return new ValidationError("reference.transactionFeedback.feedbackPeriodExpired", new Object[0]);
                    }
                }
                return null;
            }
        });
        return transactionFeedbackValidator;
    }

    private Map<Reference.Level, Integer> normalizeCountByLevel(Map<Reference.Level, Integer> countMap) {
        LinkedHashMap<Reference.Level, Integer> countByLevel = new LinkedHashMap<Reference.Level, Integer>();
        Iterator<Reference.Level> i$ = this.settingsService.getLocalSettings().getReferenceLevelList().iterator();
        while (i$.hasNext()) {
            Reference.Level level;
            Integer count = countMap.get(level = i$.next());
            countByLevel.put(level, count == null ? 0 : count);
        }
        return countByLevel;
    }

    private TransactionFeedback saveTransactionFeedbackByAdmin(TransactionFeedback transactionFeedback) {
        Calendar now = Calendar.getInstance();
        Reference.Level level = transactionFeedback.getLevel();
        String comments = transactionFeedback.getComments();
        String replyComments = transactionFeedback.getReplyComments();
        String adminComments = transactionFeedback.getAdminComments();
        transactionFeedback = (TransactionFeedback)this.referenceDao.load(transactionFeedback.getId(), new Relationship[0]);
        transactionFeedback.setLevel(level);
        transactionFeedback.setComments(comments);
        if (StringUtils.isNotEmpty((String)replyComments)) {
            transactionFeedback.setReplyComments(replyComments);
            if (transactionFeedback.getReplyCommentsDate() == null) {
                transactionFeedback.setReplyCommentsDate(now);
            }
        } else {
            transactionFeedback.setReplyComments(null);
        }
        if (StringUtils.isNotEmpty((String)adminComments)) {
            transactionFeedback.setAdminComments(adminComments);
            transactionFeedback.setAdminCommentsDate(now);
        } else {
            transactionFeedback.setAdminComments(null);
            transactionFeedback.setAdminCommentsDate(null);
        }
        this.validate(transactionFeedback);
        transactionFeedback = this.referenceDao.update(transactionFeedback);
        this.memberNotificationHandler.transactionFeedBackAdminCommentsNotification(transactionFeedback);
        return transactionFeedback;
    }

    private TransactionFeedback saveTransactionFeedbackComments(TransactionFeedback transactionFeedback) {
        Payment payment = this.fetchService.fetch(transactionFeedback.getPayment(), Payment.Relationships.TYPE, Payment.Relationships.FROM, Payment.Relationships.TO);
        Reference.Level level = transactionFeedback.getLevel();
        String comments = transactionFeedback.getComments();
        if (!payment.getType().isRequiresFeedback()) {
            throw new UnexpectedEntityException();
        }
        try {
            transactionFeedback = this.loadTransactionFeedback(payment, new Relationship[0]);
        }
        catch (EntityNotFoundException e) {
            transactionFeedback = new TransactionFeedback();
            transactionFeedback.setDate(Calendar.getInstance());
            transactionFeedback.setPayment(payment);
            transactionFeedback.setFrom((Member)payment.getFromOwner());
            transactionFeedback.setTo((Member)payment.getToOwner());
            transactionFeedback.setLevel(level);
            transactionFeedback.setComments(comments);
            transactionFeedback = (TransactionFeedback)this.doSave(transactionFeedback);
        }
        this.memberNotificationHandler.transactionFeedBackReceivedNotification(transactionFeedback);
        return transactionFeedback;
    }

    private TransactionFeedback saveTransactionFeedbackReplyComments(TransactionFeedback transactionFeedback) {
        String replyComments = transactionFeedback.getReplyComments();
        if ((transactionFeedback = (TransactionFeedback)this.referenceDao.load(transactionFeedback.getId(), new Relationship[0])).getReplyCommentsDate() != null) {
            return transactionFeedback;
        }
        if (StringUtils.isEmpty((String)replyComments)) {
            throw new ValidationException("replyComments", "reference.replyComments", new RequiredError(new Object[0]));
        }
        transactionFeedback.setReplyCommentsDate(Calendar.getInstance());
        transactionFeedback.setReplyComments(replyComments);
        this.validate(transactionFeedback);
        transactionFeedback = this.referenceDao.update(transactionFeedback);
        this.memberNotificationHandler.transactionFeedBackReplyNotification(transactionFeedback);
        return transactionFeedback;
    }

    private void updatePreviousReferenceHistoryLog(Reference reference) {
        ReferenceHistoryLogQuery query = new ReferenceHistoryLogQuery();
        query.setFrom(reference.getFrom());
        query.setTo(reference.getTo());
        ReferenceHistoryLog previousLog = this.referenceHistoryDao.getOpenReferenceHistoryLog(query);
        if (previousLog != null) {
            Period period = previousLog.getPeriod();
            period.setEnd(reference.getDate());
            previousLog.setPeriod(period);
            this.referenceHistoryDao.update(previousLog);
        }
    }
}

