/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentAwaitingFeedbackDTO;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.GeneralReference;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PaymentsAwaitingFeedbackQuery;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceQuery;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.services.elements.ReferenceServiceLocal;
import nl.strohalm.cyclos.services.elements.TransactionFeedbackAction;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class ReferenceServiceSecurity
extends BaseServiceSecurity
implements ReferenceService {
    private ReferenceServiceLocal referenceService;

    @Override
    public boolean canGiveGeneralReference(Member member) {
        return this.referenceService.canGiveGeneralReference(member);
    }

    @Override
    public boolean canManage(Reference ref) {
        return this.referenceService.canManage(ref);
    }

    @Override
    public boolean canManageGeneralReference(Member member) {
        return this.referenceService.canManageGeneralReference(member);
    }

    @Override
    public boolean canReplyFeedbackNow(TransactionFeedback transactionFeedback) {
        return this.referenceService.canReplyFeedbackNow(transactionFeedback);
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesByLevel(Reference.Nature nature, Member member, boolean received) {
        this.permissionService.checkRelatesTo(member);
        return this.referenceService.countReferencesByLevel(nature, member, received);
    }

    @Override
    public Map<Reference.Level, Integer> countReferencesHistoryByLevel(Reference.Nature nature, Member member, Period date, boolean received) {
        this.permissionService.checkRelatesTo(member);
        return this.referenceService.countReferencesHistoryByLevel(nature, member, date, received);
    }

    @Override
    public Collection<Reference.Nature> getNaturesByGroup(MemberGroup group) {
        if (!this.permissionService.getAllVisibleGroups().contains(group)) {
            throw new PermissionDeniedException();
        }
        return this.referenceService.getNaturesByGroup(group);
    }

    @Override
    public TransactionFeedbackAction getPossibleAction(TransactionFeedback transactionFeedback) {
        return this.referenceService.getPossibleAction(transactionFeedback);
    }

    @Override
    public Reference load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        Reference ref = this.referenceService.load(id, fetch);
        this.checkView(ref);
        return ref;
    }

    @Override
    public GeneralReference loadGeneral(Member from, Member to, Relationship ... fetch) throws EntityNotFoundException {
        GeneralReference ref = this.referenceService.loadGeneral(from, to, fetch);
        this.checkView(ref);
        return ref;
    }

    @Override
    public TransactionFeedback loadTransactionFeedback(Payment payment, Relationship ... fetch) throws EntityNotFoundException {
        TransactionFeedback tf = this.referenceService.loadTransactionFeedback(payment, fetch);
        this.checkView(tf);
        return tf;
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            Reference ref = this.referenceService.load(id, new Relationship[0]);
            if (ref instanceof TransactionFeedback) {
                throw new PermissionDeniedException();
            }
            this.checkManage(ref);
        }
        return this.referenceService.remove(ids);
    }

    @Override
    public GeneralReference save(GeneralReference reference) {
        this.checkManage(reference);
        return this.referenceService.save(reference);
    }

    @Override
    public TransactionFeedback save(TransactionFeedback transactionFeedback) {
        this.checkManage(transactionFeedback);
        return this.referenceService.save(transactionFeedback);
    }

    @Override
    public List<? extends Reference> search(ReferenceQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.referenceService.search(query);
    }

    @Override
    public List<PaymentAwaitingFeedbackDTO> searchPaymentsAwaitingFeedback(PaymentsAwaitingFeedbackQuery query) {
        if (query.getMember() != null) {
            this.permissionService.checkManages(query.getMember());
        }
        return this.referenceService.searchPaymentsAwaitingFeedback(query);
    }

    public void setReferenceServiceLocal(ReferenceServiceLocal referenceService) {
        this.referenceService = referenceService;
    }

    @Override
    public void validate(Reference reference) throws ValidationException {
        this.referenceService.validate(reference);
    }

    private boolean applyQueryRestrictions(ReferenceQuery query) {
        if (!CollectionUtils.isEmpty(query.getGroups())) {
            query.setGroups(PermissionHelper.checkSelection(this.permissionService.getAllVisibleGroups(), query.getGroups()));
            if (query.getGroups().isEmpty()) {
                return false;
            }
        } else {
            ArrayList<Group> groups = new ArrayList<Group>();
            groups.addAll(this.permissionService.getAllVisibleGroups());
            query.setGroups(groups);
        }
        return this.hasViewPermission(query.getNature());
    }

    private void checkManage(Reference ref) {
        if (!this.canManage(ref)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(Reference ref) {
        if (!this.permissionService.relatesTo(ref.getFrom()) && !this.permissionService.relatesTo(ref.getTo()) || !this.hasViewPermission(ref.getNature())) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasViewPermission(Reference.Nature nature) {
        switch (nature) {
            case GENERAL: {
                return this.permissionService.permission().admin(AdminMemberPermission.REFERENCES_VIEW).member(MemberPermission.REFERENCES_VIEW).operator(OperatorPermission.REFERENCES_VIEW).hasPermission();
            }
            case TRANSACTION: {
                return this.permissionService.permission().admin(AdminMemberPermission.TRANSACTION_FEEDBACKS_VIEW).member(new MemberPermission[0]).operator(OperatorPermission.REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS).hasPermission();
            }
        }
        return false;
    }
}

