/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.RegistrationAgreementService;
import nl.strohalm.cyclos.services.elements.RegistrationAgreementServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class RegistrationAgreementServiceSecurity
extends BaseServiceSecurity
implements RegistrationAgreementService {
    private RegistrationAgreementServiceLocal registrationAgreementService;

    @Override
    public List<RegistrationAgreement> listAll() {
        this.checkView(true);
        return this.registrationAgreementService.listAll();
    }

    @Override
    public RegistrationAgreement load(Long id, Relationship ... fetch) {
        this.checkView(false);
        return this.registrationAgreementService.load(id, fetch);
    }

    @Override
    public boolean remove(Long id) {
        this.checkManage();
        return this.registrationAgreementService.remove(id);
    }

    @Override
    public RegistrationAgreement save(RegistrationAgreement registrationAgreement) {
        this.checkManage();
        return this.registrationAgreementService.save(registrationAgreement);
    }

    public void setRegistrationAgreementServiceLocal(RegistrationAgreementServiceLocal registrationAgreementService) {
        this.registrationAgreementService = registrationAgreementService;
    }

    @Override
    public void validate(RegistrationAgreement registrationAgreement) throws ValidationException {
        this.registrationAgreementService.validate(registrationAgreement);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.REGISTRATION_AGREEMENTS_MANAGE).check();
    }

    private void checkView(boolean isForList) {
        PermissionCheck check = this.permissionService.permission();
        check.admin(AdminSystemPermission.REGISTRATION_AGREEMENTS_VIEW);
        if (isForList) {
            check.admin(AdminSystemPermission.GROUPS_MANAGE_MEMBER, AdminSystemPermission.GROUPS_MANAGE_BROKER);
        }
        check.check();
    }
}

