/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.members.RemarkDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.remarks.BrokerRemark;
import nl.strohalm.cyclos.entities.members.remarks.BrokerRemarkQuery;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemark;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemarkQuery;
import nl.strohalm.cyclos.entities.members.remarks.Remark;
import nl.strohalm.cyclos.entities.members.remarks.RemarkQuery;
import nl.strohalm.cyclos.services.elements.RemarkServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class RemarkServiceImpl
implements RemarkServiceLocal {
    private RemarkDAO remarkDao;

    @Override
    public List<BrokerRemark> listBrokerRemarksFor(Element subject) {
        return this.list(subject, Remark.Nature.BROKER, Remark.Relationships.WRITER, BrokerRemark.Relationships.OLD_BROKER, BrokerRemark.Relationships.NEW_BROKER);
    }

    @Override
    public List<GroupRemark> listGroupChangeHistory(Element subject) {
        return this.list(subject, Remark.Nature.GROUP, GroupRemark.Relationships.OLD_GROUP, GroupRemark.Relationships.NEW_GROUP);
    }

    public Remark load(Long id, Relationship ... fetch) {
        return (Remark)this.remarkDao.load(id, fetch);
    }

    public BrokerRemark save(BrokerRemark remark) {
        return this.doSave(remark);
    }

    @Override
    public GroupRemark save(GroupRemark remark) {
        return this.doSave(remark);
    }

    public void setRemarkDao(RemarkDAO remarkDAO) {
        this.remarkDao = remarkDAO;
    }

    private <R extends Remark> R doSave(R remark) {
        this.validate(remark);
        return this.remarkDao.insert(remark);
    }

    private Validator getValidator(Remark.Nature nature) {
        Validator validator = new Validator("remark");
        validator.property("subject").required();
        validator.property("comments").required().maxLength(4000);
        validator.property("date").required();
        switch (nature) {
            case GROUP: {
                validator.property("oldGroup").required();
                validator.property("newGroup").required();
                break;
            }
            case BROKER: {
                validator.property("oldBroker").required();
                validator.property("newBroker").required();
            }
        }
        return validator;
    }

    private List<? extends Remark> list(Element subject, Remark.Nature type, Relationship ... fetch) {
        RemarkQuery query = null;
        switch (type) {
            case BROKER: {
                query = new BrokerRemarkQuery();
                break;
            }
            case GROUP: {
                query = new GroupRemarkQuery();
            }
        }
        query.setSubject(subject);
        query.fetch(fetch);
        return this.remarkDao.search(query);
    }

    private void validate(Remark remark) throws ValidationException {
        if (LoggedUser.hasUser()) {
            remark.setWriter((Element)LoggedUser.element());
        }
        if (remark.getDate() == null) {
            remark.setDate(Calendar.getInstance());
        }
        this.getValidator(remark.getNature()).validate(remark);
    }
}

