/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.remarks.BrokerRemark;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemark;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.RemarkService;
import nl.strohalm.cyclos.services.elements.RemarkServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class RemarkServiceSecurity
extends BaseServiceSecurity
implements RemarkService {
    private RemarkServiceLocal remarkService;

    @Override
    public List<BrokerRemark> listBrokerRemarksFor(Element subject) {
        this.permissionService.permission(subject).admin(AdminMemberPermission.BROKERINGS_CHANGE_BROKER).check();
        return this.remarkService.listBrokerRemarksFor(subject);
    }

    @Override
    public List<GroupRemark> listGroupChangeHistory(Element subject) {
        this.permissionService.permission(subject).admin(AdminAdminPermission.ADMINS_CHANGE_GROUP, AdminMemberPermission.MEMBERS_CHANGE_GROUP).member(MemberPermission.OPERATORS_MANAGE).check();
        if (LoggedUser.isMember() && !(subject instanceof Operator)) {
            throw new PermissionDeniedException();
        }
        return this.remarkService.listGroupChangeHistory(subject);
    }

    public void setRemarkServiceLocal(RemarkServiceLocal remarkService) {
        this.remarkService = remarkService;
    }
}

