/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;

public class FetchServiceImpl
implements FetchServiceLocal {
    private FetchDAO fetchDao;

    @Override
    public void clearCache() {
        this.fetchDao.clearCache();
    }

    @Override
    public <E extends Entity> List<E> fetch(Collection<E> entities, Relationship ... fetch) {
        if (entities == null) {
            return null;
        }
        ArrayList<Entity> result = new ArrayList<Entity>(entities.size());
        for (Entity entity : entities) {
            entity = this.fetch(entity, fetch);
            result.add(entity);
        }
        return result;
    }

    @Override
    public <E extends Entity> E fetch(E entity, Relationship ... fetch) {
        if (entity == null || entity.getId() == null) {
            return null;
        }
        return this.fetchDao.fetch(entity, fetch);
    }

    public FetchDAO getFetchDao() {
        return this.fetchDao;
    }

    @Override
    public boolean isInitialized(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Entity || value instanceof Collection || value instanceof Map)) {
            return true;
        }
        if (value instanceof EntityReference) {
            return false;
        }
        return this.fetchDao.isInitialized(value);
    }

    @Override
    public <E extends Entity> E reload(E entity, Relationship ... fetch) {
        if (entity == null || entity.getId() == null) {
            return null;
        }
        return this.fetchDao.reload(entity, fetch);
    }

    @Override
    public void removeFromCache(Entity entity) {
        this.fetchDao.removeFromCache(entity);
    }

    public void setFetchDao(FetchDAO fetchDAO) {
        this.fetchDao = fetchDAO;
    }
}

