/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.groups.SystemGroupPermissionsDTO;

public class AdminGroupPermissionsDTO
extends SystemGroupPermissionsDTO<AdminGroup> {
    private static final long serialVersionUID = -7880633748381076158L;
    private Collection<TransferType> grantLoanTTs;
    private Collection<TransferType> systemChargebackTTs;
    private Collection<TransferType> memberChargebackTTs;
    private Collection<TransferType> asMemberToMemberTTs;
    private Collection<TransferType> asMemberToSelfTTs;
    private Collection<TransferType> asMemberToSystemTTs;
    private Collection<TransferType> systemToMemberTTs;
    private Collection<TransferType> systemToSystemTTs;
    private Collection<MemberGroup> managesGroups;
    private Collection<SystemAccountType> viewInformationOf;
    private Collection<AdminGroup> viewConnectedAdminsOf;
    private Collection<MessageCategory> messageCategories;
    private Collection<MemberRecordType> viewAdminRecordTypes;
    private Collection<MemberRecordType> createAdminRecordTypes;
    private Collection<MemberRecordType> modifyAdminRecordTypes;
    private Collection<MemberRecordType> deleteAdminRecordTypes;
    private Collection<MemberRecordType> viewMemberRecordTypes;
    private Collection<MemberRecordType> createMemberRecordTypes;
    private Collection<MemberRecordType> modifyMemberRecordTypes;
    private Collection<MemberRecordType> deleteMemberRecordTypes;

    public Collection<TransferType> getAsMemberToMemberTTs() {
        return this.asMemberToMemberTTs;
    }

    public Collection<TransferType> getAsMemberToSelfTTs() {
        return this.asMemberToSelfTTs;
    }

    public Collection<TransferType> getAsMemberToSystemTTs() {
        return this.asMemberToSystemTTs;
    }

    public Collection<MemberRecordType> getCreateAdminRecordTypes() {
        return this.createAdminRecordTypes;
    }

    public Collection<MemberRecordType> getCreateMemberRecordTypes() {
        return this.createMemberRecordTypes;
    }

    public Collection<MemberRecordType> getDeleteAdminRecordTypes() {
        return this.deleteAdminRecordTypes;
    }

    public Collection<MemberRecordType> getDeleteMemberRecordTypes() {
        return this.deleteMemberRecordTypes;
    }

    public Collection<TransferType> getGrantLoanTTs() {
        return this.grantLoanTTs;
    }

    public Collection<MemberGroup> getManagesGroups() {
        return this.managesGroups;
    }

    public Collection<TransferType> getMemberChargebackTTs() {
        return this.memberChargebackTTs;
    }

    @Override
    public Collection<MessageCategory> getMessageCategories() {
        return this.messageCategories;
    }

    public Collection<MemberRecordType> getModifyAdminRecordTypes() {
        return this.modifyAdminRecordTypes;
    }

    public Collection<MemberRecordType> getModifyMemberRecordTypes() {
        return this.modifyMemberRecordTypes;
    }

    public Collection<TransferType> getSystemChargebackTTs() {
        return this.systemChargebackTTs;
    }

    public Collection<TransferType> getSystemToMemberTTs() {
        return this.systemToMemberTTs;
    }

    public Collection<TransferType> getSystemToSystemTTs() {
        return this.systemToSystemTTs;
    }

    public Collection<MemberRecordType> getViewAdminRecordTypes() {
        return this.viewAdminRecordTypes;
    }

    public Collection<AdminGroup> getViewConnectedAdminsOf() {
        return this.viewConnectedAdminsOf;
    }

    public Collection<SystemAccountType> getViewInformationOf() {
        return this.viewInformationOf;
    }

    public Collection<MemberRecordType> getViewMemberRecordTypes() {
        return this.viewMemberRecordTypes;
    }

    public void setAsMemberToMemberTTs(Collection<TransferType> asMemberToMemberTTs) {
        this.asMemberToMemberTTs = asMemberToMemberTTs;
    }

    public void setAsMemberToSelfTTs(Collection<TransferType> asMemberToSelfTTs) {
        this.asMemberToSelfTTs = asMemberToSelfTTs;
    }

    public void setAsMemberToSystemTTs(Collection<TransferType> asMemberToSystemTTs) {
        this.asMemberToSystemTTs = asMemberToSystemTTs;
    }

    public void setCreateAdminRecordTypes(Collection<MemberRecordType> createAdminRecordTypes) {
        this.createAdminRecordTypes = createAdminRecordTypes;
    }

    public void setCreateMemberRecordTypes(Collection<MemberRecordType> createMemberRecordTypes) {
        this.createMemberRecordTypes = createMemberRecordTypes;
    }

    public void setDeleteAdminRecordTypes(Collection<MemberRecordType> deleteAdminRecordTypes) {
        this.deleteAdminRecordTypes = deleteAdminRecordTypes;
    }

    public void setDeleteMemberRecordTypes(Collection<MemberRecordType> deleteMemberRecordTypes) {
        this.deleteMemberRecordTypes = deleteMemberRecordTypes;
    }

    public void setGrantLoanTTs(Collection<TransferType> grantLoanTTs) {
        this.grantLoanTTs = grantLoanTTs;
    }

    public void setManagesGroups(Collection<MemberGroup> managesGroups) {
        this.managesGroups = managesGroups;
    }

    public void setMemberChargebackTTs(Collection<TransferType> memberChargebackTTs) {
        this.memberChargebackTTs = memberChargebackTTs;
    }

    @Override
    public void setMessageCategories(Collection<MessageCategory> messageCategories) {
        this.messageCategories = messageCategories;
    }

    public void setModifyAdminRecordTypes(Collection<MemberRecordType> modifyAdminRecordTypes) {
        this.modifyAdminRecordTypes = modifyAdminRecordTypes;
    }

    public void setModifyMemberRecordTypes(Collection<MemberRecordType> modifyMemberRecordTypes) {
        this.modifyMemberRecordTypes = modifyMemberRecordTypes;
    }

    public void setSystemChargebackTTs(Collection<TransferType> systemChargebackTTs) {
        this.systemChargebackTTs = systemChargebackTTs;
    }

    public void setSystemToMemberTTs(Collection<TransferType> systemToMemberTTs) {
        this.systemToMemberTTs = systemToMemberTTs;
    }

    public void setSystemToSystemTTs(Collection<TransferType> systemToSystemTTs) {
        this.systemToSystemTTs = systemToSystemTTs;
    }

    public void setViewAdminRecordTypes(Collection<MemberRecordType> viewAdminRecordTypes) {
        this.viewAdminRecordTypes = viewAdminRecordTypes;
    }

    public void setViewConnectedAdminsOf(Collection<AdminGroup> viewConnectedAdminsOf) {
        this.viewConnectedAdminsOf = viewConnectedAdminsOf;
    }

    public void setViewInformationOf(Collection<SystemAccountType> viewInformationOf) {
        this.viewInformationOf = viewInformationOf;
    }

    public void setViewMemberRecordTypes(Collection<MemberRecordType> viewMemberRecordTypes) {
        this.viewMemberRecordTypes = viewMemberRecordTypes;
    }

    @Override
    public void updateOperations() {
        this.update(AdminMemberPermission.MEMBERS_VIEW, this.getManagesGroups());
        this.update(AdminMemberPermission.GUARANTEES_REGISTER_GUARANTEES, this.getGuaranteeTypes());
        this.update(AdminMemberPermission.DOCUMENTS_DETAILS, this.getDocuments());
        this.update(AdminMemberPermission.MESSAGES_VIEW, this.getMessageCategories());
        this.update(AdminSystemPermission.ACCOUNTS_INFORMATION, this.getViewInformationOf());
        this.update(AdminSystemPermission.STATUS_VIEW_CONNECTED_ADMINS, this.getViewConnectedAdminsOf());
        this.update(AdminSystemPermission.PAYMENTS_PAYMENT, this.getSystemToSystemTTs());
        this.update(AdminMemberPermission.PAYMENTS_PAYMENT, this.getSystemToMemberTTs());
        this.update(AdminMemberPermission.LOANS_GRANT, this.getGrantLoanTTs());
        this.update(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, this.getAsMemberToMemberTTs());
        this.update(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, this.getAsMemberToSelfTTs());
        this.update(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, this.getAsMemberToSystemTTs());
        this.update(AdminSystemPermission.PAYMENTS_CHARGEBACK, this.getSystemChargebackTTs());
        this.update(AdminMemberPermission.PAYMENTS_CHARGEBACK, this.getMemberChargebackTTs());
        this.update(AdminMemberPermission.RECORDS_VIEW, this.getViewMemberRecordTypes());
        this.update(AdminMemberPermission.RECORDS_CREATE, this.getCreateMemberRecordTypes());
        this.update(AdminMemberPermission.RECORDS_MODIFY, this.getModifyMemberRecordTypes());
        this.update(AdminMemberPermission.RECORDS_DELETE, this.getDeleteMemberRecordTypes());
        this.update(AdminAdminPermission.RECORDS_VIEW, this.getViewAdminRecordTypes());
        this.update(AdminAdminPermission.RECORDS_CREATE, this.getCreateAdminRecordTypes());
        this.update(AdminAdminPermission.RECORDS_MODIFY, this.getModifyAdminRecordTypes());
        this.update(AdminAdminPermission.RECORDS_DELETE, this.getDeleteAdminRecordTypes());
    }

    @Override
    protected void updateCollections(AdminGroup adminGroup) {
        super.updateCollections(adminGroup);
        Collection<TransferType> grantLoanTTs = this.getGrantLoanTTs();
        Collection<TransferType> systemToMemberTTs = this.getSystemToMemberTTs();
        Collection<TransferType> systemToSystemTTs = this.getSystemToSystemTTs();
        ArrayList<TransferType> transferTypes = new ArrayList<TransferType>();
        if (grantLoanTTs != null) {
            transferTypes.addAll(grantLoanTTs);
        }
        if (systemToMemberTTs != null) {
            transferTypes.addAll(systemToMemberTTs);
        }
        if (systemToSystemTTs != null) {
            transferTypes.addAll(systemToSystemTTs);
        }
        adminGroup.setTransferTypes(transferTypes);
        Collection<TransferType> asMemberToMemberTTs = this.getAsMemberToMemberTTs();
        Collection<TransferType> asMemberToSelfTTs = this.getAsMemberToSelfTTs();
        Collection<TransferType> asMemberToSystemTTs = this.getAsMemberToSystemTTs();
        ArrayList<TransferType> transferTypesAsMember = new ArrayList<TransferType>();
        if (asMemberToMemberTTs != null) {
            transferTypesAsMember.addAll(asMemberToMemberTTs);
        }
        if (asMemberToSelfTTs != null) {
            transferTypesAsMember.addAll(asMemberToSelfTTs);
        }
        if (asMemberToSystemTTs != null) {
            transferTypesAsMember.addAll(asMemberToSystemTTs);
        }
        adminGroup.setTransferTypesAsMember(transferTypesAsMember);
        ArrayList<TransferType> chargebacks = new ArrayList<TransferType>();
        if (this.getSystemChargebackTTs() != null) {
            chargebacks.addAll(this.getSystemChargebackTTs());
        }
        if (this.getMemberChargebackTTs() != null) {
            chargebacks.addAll(this.getMemberChargebackTTs());
        }
        adminGroup.setChargebackTransferTypes(chargebacks);
        adminGroup.setViewInformationOf(this.getViewInformationOf());
        adminGroup.setManagesGroups(this.getManagesGroups());
        adminGroup.setViewConnectedAdminsOf(this.getViewConnectedAdminsOf());
        adminGroup.setViewAdminRecordTypes(this.getViewAdminRecordTypes());
        adminGroup.setCreateAdminRecordTypes(this.getCreateAdminRecordTypes());
        adminGroup.setModifyAdminRecordTypes(this.getModifyAdminRecordTypes());
        adminGroup.setDeleteAdminRecordTypes(this.getDeleteAdminRecordTypes());
        adminGroup.setViewMemberRecordTypes(this.getViewMemberRecordTypes());
        adminGroup.setCreateMemberRecordTypes(this.getCreateMemberRecordTypes());
        adminGroup.setModifyMemberRecordTypes(this.getModifyMemberRecordTypes());
        adminGroup.setDeleteMemberRecordTypes(this.getDeleteMemberRecordTypes());
    }
}

