/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.groups.MemberGroupPermissionsDTO;

public class BrokerGroupPermissionsDTO
extends MemberGroupPermissionsDTO<BrokerGroup> {
    private static final long serialVersionUID = 8264674596578541889L;
    private Collection<Document> brokerDocuments;
    private Collection<TransferType> asMemberToMemberTTs;
    private Collection<TransferType> asMemberToSelfTTs;
    private Collection<TransferType> asMemberToSystemTTs;
    private Collection<TransferType> brokerConversionSimulationTTs;
    private Collection<AccountType> brokerCanViewInformationOf;
    private Collection<MemberRecordType> brokerMemberRecordTypes;
    private Collection<MemberRecordType> brokerCreateMemberRecordTypes;
    private Collection<MemberRecordType> brokerModifyMemberRecordTypes;
    private Collection<MemberRecordType> brokerDeleteMemberRecordTypes;

    public Collection<TransferType> getAsMemberToMemberTTs() {
        return this.asMemberToMemberTTs;
    }

    public Collection<TransferType> getAsMemberToSelfTTs() {
        return this.asMemberToSelfTTs;
    }

    public Collection<TransferType> getAsMemberToSystemTTs() {
        return this.asMemberToSystemTTs;
    }

    public Collection<AccountType> getBrokerCanViewInformationOf() {
        return this.brokerCanViewInformationOf;
    }

    public Collection<TransferType> getBrokerConversionSimulationTTs() {
        return this.brokerConversionSimulationTTs;
    }

    public Collection<MemberRecordType> getBrokerCreateMemberRecordTypes() {
        return this.brokerCreateMemberRecordTypes;
    }

    public Collection<MemberRecordType> getBrokerDeleteMemberRecordTypes() {
        return this.brokerDeleteMemberRecordTypes;
    }

    public Collection<Document> getBrokerDocuments() {
        return this.brokerDocuments;
    }

    public Collection<MemberRecordType> getBrokerMemberRecordTypes() {
        return this.brokerMemberRecordTypes;
    }

    public Collection<MemberRecordType> getBrokerModifyMemberRecordTypes() {
        return this.brokerModifyMemberRecordTypes;
    }

    public void setAsMemberToMemberTTs(Collection<TransferType> asMemberToMemberTTs) {
        this.asMemberToMemberTTs = asMemberToMemberTTs;
    }

    public void setAsMemberToSelfTTs(Collection<TransferType> asMemberToSelfTTs) {
        this.asMemberToSelfTTs = asMemberToSelfTTs;
    }

    public void setAsMemberToSystemTTs(Collection<TransferType> asMemberToSystemTTs) {
        this.asMemberToSystemTTs = asMemberToSystemTTs;
    }

    public void setBrokerCanViewInformationOf(Collection<AccountType> brokerCanViewInformationOf) {
        this.brokerCanViewInformationOf = brokerCanViewInformationOf;
    }

    public void setBrokerConversionSimulationTTs(Collection<TransferType> brokerConversionSimulationTTs) {
        this.brokerConversionSimulationTTs = brokerConversionSimulationTTs;
    }

    public void setBrokerCreateMemberRecordTypes(Collection<MemberRecordType> brokerCreateMemberRecordTypes) {
        this.brokerCreateMemberRecordTypes = brokerCreateMemberRecordTypes;
    }

    public void setBrokerDeleteMemberRecordTypes(Collection<MemberRecordType> brokerDeleteMemberRecordTypes) {
        this.brokerDeleteMemberRecordTypes = brokerDeleteMemberRecordTypes;
    }

    public void setBrokerDocuments(Collection<Document> brokerDocuments) {
        this.brokerDocuments = brokerDocuments;
    }

    public void setBrokerMemberRecordTypes(Collection<MemberRecordType> brokerMemberRecordTypes) {
        this.brokerMemberRecordTypes = brokerMemberRecordTypes;
    }

    public void setBrokerModifyMemberRecordTypes(Collection<MemberRecordType> brokerModifyMemberRecordTypes) {
        this.brokerModifyMemberRecordTypes = brokerModifyMemberRecordTypes;
    }

    @Override
    public void updateOperations() {
        super.updateOperations();
        this.update(BrokerPermission.DOCUMENTS_VIEW, this.getBrokerDocuments());
        this.update(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, this.getAsMemberToMemberTTs());
        this.update(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, this.getAsMemberToSelfTTs());
        this.update(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, this.getAsMemberToSystemTTs());
        this.update(BrokerPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, this.getBrokerCanViewInformationOf());
        this.update(BrokerPermission.MEMBER_RECORDS_VIEW, this.getBrokerMemberRecordTypes());
        this.update(BrokerPermission.MEMBER_RECORDS_CREATE, this.getBrokerCreateMemberRecordTypes());
        this.update(BrokerPermission.MEMBER_RECORDS_MODIFY, this.getBrokerModifyMemberRecordTypes());
        this.update(BrokerPermission.MEMBER_RECORDS_DELETE, this.getBrokerDeleteMemberRecordTypes());
    }

    @Override
    protected void updateCollections(BrokerGroup brokerGroup) {
        super.updateCollections(brokerGroup);
        brokerGroup.setBrokerDocuments(this.getBrokerDocuments());
        Collection<TransferType> asMemberToMemberTTs = this.getAsMemberToMemberTTs();
        Collection<TransferType> asMemberToSelfTTs = this.getAsMemberToSelfTTs();
        Collection<TransferType> asMemberToSystemTTs = this.getAsMemberToSystemTTs();
        ArrayList<TransferType> transferTypesAsMember = new ArrayList<TransferType>();
        if (asMemberToMemberTTs != null) {
            transferTypesAsMember.addAll(asMemberToMemberTTs);
        }
        if (asMemberToSelfTTs != null) {
            transferTypesAsMember.addAll(asMemberToSelfTTs);
        }
        if (asMemberToSystemTTs != null) {
            transferTypesAsMember.addAll(asMemberToSystemTTs);
        }
        brokerGroup.setTransferTypesAsMember(transferTypesAsMember);
        Collection<TransferType> brokerConversionSimulationTTs = this.getBrokerConversionSimulationTTs();
        brokerGroup.setBrokerConversionSimulationTTs(brokerConversionSimulationTTs);
        brokerGroup.setBrokerCanViewInformationOf(this.getBrokerCanViewInformationOf());
        brokerGroup.setBrokerMemberRecordTypes(this.getBrokerMemberRecordTypes());
        brokerGroup.setBrokerCreateMemberRecordTypes(this.getBrokerCreateMemberRecordTypes());
        brokerGroup.setBrokerModifyMemberRecordTypes(this.getBrokerModifyMemberRecordTypes());
        brokerGroup.setBrokerDeleteMemberRecordTypes(this.getBrokerDeleteMemberRecordTypes());
    }
}

