/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.groups.GroupFilterDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.services.groups.GroupFilterServiceLocal;
import nl.strohalm.cyclos.utils.validation.Validator;

public class GroupFilterServiceImpl
implements GroupFilterServiceLocal {
    private GroupFilterDAO groupFilterDao;

    @Override
    public GroupFilter findByLoginPageName(String loginPageName) {
        return this.groupFilterDao.findByLoginPageName(loginPageName);
    }

    @Override
    public Collection<GroupFilter> load(Collection<Long> ids, Relationship ... fetch) {
        return this.groupFilterDao.load(ids, fetch);
    }

    @Override
    public GroupFilter load(Long id, Relationship ... fetch) {
        return (GroupFilter)this.groupFilterDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.groupFilterDao.delete(ids);
    }

    @Override
    public GroupFilter save(GroupFilter groupFilter) {
        this.validate(groupFilter);
        if (groupFilter.isTransient()) {
            return this.groupFilterDao.insert(groupFilter);
        }
        return this.groupFilterDao.update(groupFilter);
    }

    @Override
    public List<GroupFilter> search(GroupFilterQuery query) {
        return this.groupFilterDao.search(query);
    }

    public void setGroupFilterDao(GroupFilterDAO groupFilterDao) {
        this.groupFilterDao = groupFilterDao;
    }

    @Override
    public void validate(GroupFilter groupFilter) {
        this.getValidator().validate(groupFilter);
    }

    private Validator getValidator() {
        Validator validator = new Validator("groupFilter");
        validator.property("name").required().maxLength(100);
        validator.property("loginPageName").maxLength(20);
        validator.property("containerUrl").maxLength(100).url();
        validator.property("description").maxLength(1000);
        return validator;
    }
}

