/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.services.groups.GroupFilterServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class GroupFilterServiceSecurity
extends BaseServiceSecurity
implements GroupFilterService {
    private GroupFilterServiceLocal groupFilterService;

    @Override
    public GroupFilter findByLoginPageName(String loginPageName) {
        return this.groupFilterService.findByLoginPageName(loginPageName);
    }

    @Override
    public Collection<GroupFilter> load(Collection<Long> ids, Relationship ... fetch) {
        Collection<GroupFilter> groupFilters = this.groupFilterService.load(ids, fetch);
        for (GroupFilter groupFilter : groupFilters) {
            this.checkVisible(groupFilter);
        }
        return groupFilters;
    }

    @Override
    public GroupFilter load(Long id, Relationship ... fetch) {
        GroupFilter groupFilter = this.groupFilterService.load(id, fetch);
        this.checkVisible(groupFilter);
        return groupFilter;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.groupFilterService.remove(ids);
    }

    @Override
    public GroupFilter save(GroupFilter groupFilter) {
        if (CollectionUtils.isNotEmpty(groupFilter.getGroups()) && !this.permissionService.getManagedMemberGroups().containsAll(groupFilter.getGroups())) {
            throw new PermissionDeniedException();
        }
        if (CollectionUtils.isNotEmpty(groupFilter.getViewableBy()) && !this.permissionService.getManagedMemberGroups().containsAll(groupFilter.getViewableBy())) {
            throw new PermissionDeniedException();
        }
        this.checkManage();
        return this.groupFilterService.save(groupFilter);
    }

    @Override
    public List<GroupFilter> search(GroupFilterQuery query) {
        if (LoggedUser.isAdministrator()) {
            AdminGroup group = (AdminGroup)LoggedUser.group();
            query.setAdminGroup(group);
        } else {
            Member member = LoggedUser.member();
            if (member != null) {
                query.setViewableBy(member.getMemberGroup());
            }
        }
        return this.groupFilterService.search(query);
    }

    public void setGroupFilterServiceLocal(GroupFilterServiceLocal groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    public void validate(GroupFilter groupFilter) {
        this.groupFilterService.validate(groupFilter);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.GROUP_FILTERS_MANAGE).check();
    }

    private void checkVisible(GroupFilter groupFilter) {
        if (!this.isVisible(groupFilter)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isVisible(GroupFilter groupFilter) {
        if (this.permissionService.hasPermission(AdminSystemPermission.GROUP_FILTERS_VIEW)) {
            return true;
        }
        if (LoggedUser.isAdministrator()) {
            Collection<MemberGroup> groups = this.permissionService.getManagedMemberGroups();
            for (MemberGroup group : groups) {
                if (!group.getGroupFilters().contains(groupFilter)) continue;
                return true;
            }
        } else if (!LoggedUser.hasUser()) {
            if (StringUtils.isNotEmpty((String)groupFilter.getLoginPageName())) {
                return true;
            }
        } else {
            Member member = LoggedUser.member();
            if (member != null) {
                return groupFilter.getViewableBy().contains(member.getMemberGroup());
            }
        }
        throw new PermissionDeniedException();
    }
}

