/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.collections.CollectionUtils;

public abstract class GroupPermissionsDTO<G extends Group>
extends DataObject {
    private static final long serialVersionUID = 6176708478971547330L;
    private G group;
    private Collection<Permission> operations;
    private Collection<GuaranteeType> guaranteeTypes;
    private Collection<TransferType> conversionSimulationTTs;

    public Collection<TransferType> getConversionSimulationTTs() {
        return this.conversionSimulationTTs;
    }

    public G getGroup() {
        return this.group;
    }

    public Collection<GuaranteeType> getGuaranteeTypes() {
        return this.guaranteeTypes;
    }

    public Collection<Permission> getOperations() {
        return this.operations;
    }

    public void setConversionSimulationTTs(Collection<TransferType> conversionSimulationTTs) {
        this.conversionSimulationTTs = conversionSimulationTTs;
    }

    public void setGroup(G group) {
        this.group = group;
    }

    public void setGuaranteeTypes(Collection<GuaranteeType> guaranteeTypes) {
        this.guaranteeTypes = guaranteeTypes;
    }

    public void setOperations(Collection<Permission> operations) {
        this.operations = operations;
    }

    public void update(G group) {
        this.updateOperations();
        this.checkOperations(group);
        this.updateCollections(group);
    }

    protected void checkOperations(G group) {
        Collection<Permission> permissions = this.getOperations();
        List<ModuleType> moduleTypes = ModuleType.getModuleTypes(((Group)group).getNature());
        for (Permission permission : permissions) {
            if (moduleTypes.contains(permission.getModule().getType())) continue;
            throw new PermissionDeniedException();
        }
    }

    protected void update(Permission permission, Collection<? extends Entity> permissionCollection) {
        if (CollectionUtils.isEmpty(permissionCollection)) {
            this.operations.remove(permission);
        } else {
            this.operations.add(permission);
        }
    }

    protected void updateCollections(G group) {
        ((Group)group).setPermissions(new HashSet<Permission>(this.getOperations()));
        ((Group)group).setGuaranteeTypes(this.getGuaranteeTypes());
        ((Group)group).setConversionSimulationTTs(this.getConversionSimulationTTs());
    }

    protected abstract void updateOperations();
}

