/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.AccountLimitLogDAO;
import nl.strohalm.cyclos.dao.accounts.MemberGroupAccountSettingsDAO;
import nl.strohalm.cyclos.dao.accounts.fee.account.AccountFeeDAO;
import nl.strohalm.cyclos.dao.accounts.fee.transaction.TransactionFeeDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.PaymentFilterDAO;
import nl.strohalm.cyclos.dao.customizations.CustomFieldDAO;
import nl.strohalm.cyclos.dao.customizations.CustomizedFileDAO;
import nl.strohalm.cyclos.dao.groups.GroupDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.dao.members.MemberRecordTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.scheduling.polling.AccountActivationPollingTask;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.BulkUpdateAccountDTO;
import nl.strohalm.cyclos.services.accounts.MemberAccountHandler;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupPermissionsDTO;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class GroupServiceImpl
implements GroupServiceLocal {
    private static final Relationship[] FETCH_TO_KEEP_DATA = new Relationship[]{Group.Relationships.PERMISSIONS, Group.Relationships.TRANSFER_TYPES, Group.Relationships.CONVERSION_SIMULATION_TTS, BrokerGroup.Relationships.BROKER_CONVERSION_SIMULATION_TTS, SystemGroup.Relationships.DOCUMENTS, SystemGroup.Relationships.MESSAGE_CATEGORIES, BrokerGroup.Relationships.BROKER_DOCUMENTS, BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES, AdminGroup.Relationships.MANAGES_GROUPS, SystemGroup.Relationships.CHARGEBACK_TRANSFER_TYPES, AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER, AdminGroup.Relationships.VIEW_INFORMATION_OF, AdminGroup.Relationships.VIEW_CONNECTED_ADMINS_OF, AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS, MemberGroup.Relationships.MANAGED_BY_GROUPS, Group.Relationships.GUARANTEE_TYPES};
    private static final Relationship[] FETCH_TO_REMOVE = new Relationship[]{Group.Relationships.PAYMENT_FILTERS, AdminGroup.Relationships.CONNECTED_ADMINS_VIEWED_BY, AdminGroup.Relationships.ADMIN_CUSTOM_FIELDS, MemberGroup.Relationships.ACCOUNT_FEES, MemberGroup.Relationships.MANAGED_BY_GROUPS, MemberGroup.Relationships.CUSTOM_FIELDS, MemberGroup.Relationships.FROM_TRANSACTION_FEES, MemberGroup.Relationships.TO_TRANSACTION_FEES, MemberGroup.Relationships.MEMBER_RECORD_TYPES};
    private AccountFeeDAO accountFeeDao;
    private AccountTypeServiceLocal accountTypeService;
    private AccountServiceLocal accountService;
    private CustomFieldDAO customFieldDao;
    private CustomizedFileDAO customizedFileDao;
    private GroupDAO groupDao;
    private ElementDAO elementDao;
    private ElementServiceLocal elementService;
    private MemberGroupAccountSettingsDAO memberGroupAccountSettingsDao;
    private MemberRecordTypeDAO memberRecordTypeDao;
    private PaymentFilterDAO paymentFilterDao;
    private TransactionFeeDAO transactionFeeDao;
    private MemberAccountHandler memberAccountHandler;
    private PermissionServiceLocal permissionService;
    private FetchServiceLocal fetchService;
    private AdminCustomFieldServiceLocal adminCustomFieldService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private OperatorCustomFieldServiceLocal operatorCustomFieldService;
    private SettingsServiceLocal settingsService;
    private ChannelServiceLocal channelService;
    private ApplicationServiceLocal applicationService;
    private AccountDAO accountDao;
    private AccountLimitLogDAO accountLimitLogDao;

    @Override
    public int countPendingAccounts(MemberGroup group, MemberAccountType accountType) {
        return this.accountService.countPendingActivation(group, accountType);
    }

    @Override
    public SystemGroup findByLoginPageName(String loginPageName) {
        return this.groupDao.findByLoginPageName(loginPageName);
    }

    public CustomFieldDAO getCustomFieldDao() {
        return this.customFieldDao;
    }

    public CustomizedFileDAO getCustomizedFileDao() {
        return this.customizedFileDao;
    }

    public GroupDAO getGroupDao() {
        return this.groupDao;
    }

    public MemberAccountHandler getMemberAccountHandler() {
        return this.memberAccountHandler;
    }

    public MemberGroupAccountSettingsDAO getMemberGroupAccountSettingsDao() {
        return this.memberGroupAccountSettingsDao;
    }

    public MemberRecordTypeDAO getMemberRecordTypeDao() {
        return this.memberRecordTypeDao;
    }

    public PaymentFilterDAO getPaymentFilterDao() {
        return this.paymentFilterDao;
    }

    public List<MemberGroup> getPossibleInitialGroups(GroupFilter groupFilter) {
        if (LoggedUser.hasUser() && LoggedUser.isBroker()) {
            BrokerGroup brokerGroup = (BrokerGroup)LoggedUser.group();
            brokerGroup = this.fetchService.fetch(brokerGroup, BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS);
            return (List)brokerGroup.getPossibleInitialGroups();
        }
        groupFilter = this.fetchService.fetch(groupFilter, GroupFilter.Relationships.GROUPS);
        GroupQuery query = new GroupQuery();
        query.setNatures(Group.Nature.BROKER, Group.Nature.MEMBER);
        ArrayList<MemberGroup> initialGroups = new ArrayList<MemberGroup>();
        for (Group group : this.search(query)) {
            MemberGroup memberGroup = (MemberGroup)this.fetchService.fetch(group, new Relationship[0]);
            if (!memberGroup.isInitialGroup()) continue;
            initialGroups.add(memberGroup);
        }
        if (groupFilter != null) {
            initialGroups.retainAll(groupFilter.getGroups());
        }
        return initialGroups;
    }

    @Override
    public boolean hasGroupsWhichRequiresSpecialOnPassword() {
        GroupQuery query = new GroupQuery();
        query.setStatus(Group.Status.NORMAL);
        for (Group group : this.search(query)) {
            if (group.getBasicSettings().getPasswordPolicy() != BasicGroupSettings.PasswordPolicy.AVOID_OBVIOUS_LETTERS_NUMBERS_SPECIAL) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMemberGroupsWhichEnforcesCharactersOnPassword() {
        GroupQuery query = new GroupQuery();
        query.setStatus(Group.Status.NORMAL);
        query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        for (Group group : this.search(query)) {
            if (!group.getBasicSettings().getPasswordPolicy().isForceCharacters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <G extends Group> G insert(G group, G baseGroup) {
        MemberGroup memberGroup;
        if (baseGroup != null) {
            group = this.copyBaseGroupSettings(group, baseGroup);
        } else {
            group.setBasicSettings(new BasicGroupSettings());
            if (group instanceof MemberGroup) {
                memberGroup = (MemberGroup)group;
                memberGroup.setMemberSettings(new MemberGroupSettings());
            }
        }
        this.validate(group);
        group = this.save(group);
        if (baseGroup != null) {
            this.copyInverseCollections(group, baseGroup);
        }
        if (group instanceof MemberGroup) {
            memberGroup = (MemberGroup)group;
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS);
            Collection<MemberGroup> managesGroups = adminGroup.getManagesGroups();
            managesGroups.add(memberGroup);
            this.groupDao.update(adminGroup);
        }
        this.clearRelatedCaches(group);
        return group;
    }

    @Override
    public MemberGroupAccountSettings insertAccountSettings(MemberGroupAccountSettings settings) {
        MemberGroup memberGroup = this.fetchService.fetch(settings.getGroup(), new Relationship[0]);
        AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
        Collection<MemberGroup> managesGroups = (adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups();
        if (!managesGroups.contains(memberGroup)) {
            throw new PermissionDeniedException();
        }
        this.validate(settings);
        try {
            this.memberGroupAccountSettingsDao.load((long)settings.getGroup().getId(), settings.getAccountType().getId(), new Relationship[0]);
            throw new UnexpectedEntityException();
        }
        catch (EntityNotFoundException e) {
            MemberAccountType currentDefault = this.accountTypeService.getDefault(memberGroup, new Relationship[0]);
            if (currentDefault == null) {
                settings.setDefault(true);
            } else if (settings.isDefault()) {
                MemberGroupAccountSettings defaultSettings = this.memberGroupAccountSettingsDao.load((long)memberGroup.getId(), currentDefault.getId(), new Relationship[0]);
                defaultSettings.setDefault(false);
                this.memberGroupAccountSettingsDao.update(defaultSettings);
            }
            MemberGroupAccountSettings saved = this.memberGroupAccountSettingsDao.insert(settings);
            if (!memberGroup.isActive()) {
                memberGroup.setActive(true);
                this.groupDao.update(memberGroup);
                this.elementDao.activateMembersOfGroup(memberGroup);
            }
            BulkUpdateAccountDTO dto = new BulkUpdateAccountDTO();
            dto.setGroup(saved.getGroup());
            dto.setType(saved.getAccountType());
            dto.setCreditLimit(saved.getDefaultCreditLimit());
            dto.setUpperCreditLimit(saved.getDefaultUpperCreditLimit());
            this.accountDao.markForActivation(dto);
            this.applicationService.awakePollingTaskOnTransactionCommit(AccountActivationPollingTask.class);
            return saved;
        }
    }

    @Override
    public List<OperatorGroup> iterateOperatorGroups(MemberGroup memberGroup) {
        return this.groupDao.iterateOperatorGroups(memberGroup);
    }

    @Override
    public <T extends Group> Collection<T> load(Collection<Long> ids, Relationship ... fetch) {
        return this.groupDao.load(ids, fetch);
    }

    @Override
    public <T extends Group> T load(Long id, Relationship ... fetch) {
        return (T)((Group)this.groupDao.load(id, fetch));
    }

    @Override
    public MemberGroupAccountSettings loadAccountSettings(long groupId, long accountTypeId, Relationship ... fetch) {
        return this.memberGroupAccountSettingsDao.load(groupId, accountTypeId, fetch);
    }

    @Override
    public <T extends Group> T reload(Long id, Relationship ... fetch) {
        return (T)((Group)this.groupDao.reload(id, fetch));
    }

    @Override
    public void remove(Long id) throws EntityNotFoundException {
        Object group = this.load(id, FETCH_TO_REMOVE);
        if (!(group instanceof OperatorGroup)) {
            this.removeFromInverseCollections((Group)group);
        }
        this.permissionService.evictCache((Group)group);
        this.groupDao.delete(id);
    }

    @Override
    public void removeAccountTypeRelationship(MemberGroup group, MemberAccountType type) {
        this.memberGroupAccountSettingsDao.delete((long)group.getId(), (long)type.getId());
        this.accountDao.markForDeactivation(type, group);
        this.applicationService.awakePollingTaskOnTransactionCommit(AccountActivationPollingTask.class);
    }

    @Override
    public List<? extends Group> search(GroupQuery query) {
        if (!query.isIgnoreManagedBy() && LoggedUser.hasUser() && LoggedUser.isAdministrator()) {
            AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
            query.setManagedBy(adminGroup);
        }
        return this.groupDao.search(query);
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAccountFeeDao(AccountFeeDAO accountFeeDao) {
        this.accountFeeDao = accountFeeDao;
    }

    public void setAccountLimitLogDao(AccountLimitLogDAO accountLimitLogDao) {
        this.accountLimitLogDao = accountLimitLogDao;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setAdminCustomFieldServiceLocal(AdminCustomFieldServiceLocal adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCustomFieldDao(CustomFieldDAO customFieldDao) {
        this.customFieldDao = customFieldDao;
    }

    public void setCustomizedFileDao(CustomizedFileDAO customizedFileDao) {
        this.customizedFileDao = customizedFileDao;
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }

    public void setMemberAccountHandler(MemberAccountHandler memberAccountHandler) {
        this.memberAccountHandler = memberAccountHandler;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberGroupAccountSettingsDao(MemberGroupAccountSettingsDAO memberGroupAccountSettingsDao) {
        this.memberGroupAccountSettingsDao = memberGroupAccountSettingsDao;
    }

    public void setMemberRecordTypeDao(MemberRecordTypeDAO memberRecordTypeDao) {
        this.memberRecordTypeDao = memberRecordTypeDao;
    }

    public void setOperatorCustomFieldServiceLocal(OperatorCustomFieldServiceLocal operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    public void setPaymentFilterDao(PaymentFilterDAO paymentFilterDao) {
        this.paymentFilterDao = paymentFilterDao;
    }

    @Override
    public <G extends Group> G setPermissions(GroupPermissionsDTO<G> dto) {
        Group group = (Group)this.fetchService.fetch(dto.getGroup(), new Relationship[0]);
        dto.update(group);
        group = this.groupDao.update(group);
        this.permissionService.evictCache(group);
        return (G)group;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionFeeDao(TransactionFeeDAO transactionFeeDao) {
        this.transactionFeeDao = transactionFeeDao;
    }

    @Override
    public <G extends Group> G update(G group, boolean forceMembersToAcceptAgreement) {
        MemberGroup memberGroup;
        this.validate(group);
        Object currentGroup = this.load(group.getId(), new Relationship[0]);
        if (group.isRemoved()) {
            ((Group)currentGroup).setName(group.getName());
            ((Group)currentGroup).setDescription(group.getDescription());
            return this.groupDao.update(group);
        }
        boolean wasTPUsed = false;
        boolean wasActive = false;
        boolean isTPUsed = false;
        RegistrationAgreement oldAgreement = null;
        if (group instanceof MemberGroup) {
            memberGroup = (MemberGroup)group;
            MemberGroup currentMemberGroup = (MemberGroup)this.load(memberGroup.getId(), new Relationship[0]);
            oldAgreement = this.fetchService.fetch(currentMemberGroup.getRegistrationAgreement(), new Relationship[0]);
            try {
                wasTPUsed = currentMemberGroup.getBasicSettings().getTransactionPassword().isUsed();
            }
            catch (Exception e) {
                wasTPUsed = false;
            }
            try {
                isTPUsed = memberGroup.getBasicSettings().getTransactionPassword().isUsed();
            }
            catch (Exception e) {
                isTPUsed = false;
            }
            wasActive = currentMemberGroup.isActive();
        }
        if ((group = this.save(group)) instanceof MemberGroup) {
            RegistrationAgreement registrationAgreement;
            memberGroup = (MemberGroup)group;
            if (wasTPUsed && !isTPUsed || !wasTPUsed && isTPUsed) {
                memberGroup = this.fetchService.reload(memberGroup, MemberGroup.Relationships.ACCOUNT_SETTINGS);
                for (MemberGroupAccountSettings mgas : memberGroup.getAccountSettings()) {
                    mgas.setTransactionPasswordRequired(isTPUsed);
                    this.memberGroupAccountSettingsDao.update(mgas);
                }
            }
            if (!wasActive && memberGroup.isActive()) {
                this.elementDao.activateMembersOfGroup(memberGroup);
            }
            if ((registrationAgreement = this.fetchService.fetch(memberGroup.getRegistrationAgreement(), new Relationship[0])) != null && !registrationAgreement.equals(oldAgreement) && !forceMembersToAcceptAgreement) {
                this.elementService.createAgreementForAllMembers(registrationAgreement, memberGroup);
            }
        }
        return group;
    }

    @Override
    public MemberGroupAccountSettings updateAccountSettings(MemberGroupAccountSettings settings, boolean updateAccountLimits) {
        MemberGroup memberGroup = settings.getGroup();
        AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
        Collection<MemberGroup> managesGroups = (adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups();
        if (!managesGroups.contains(memberGroup)) {
            throw new PermissionDeniedException();
        }
        this.validate(settings);
        MemberAccountType currentDefault = this.accountTypeService.getDefault(memberGroup, new Relationship[0]);
        if (currentDefault == null || currentDefault.equals(settings.getAccountType())) {
            settings.setDefault(true);
        } else if (settings.isDefault()) {
            MemberGroupAccountSettings defaultSettings = this.memberGroupAccountSettingsDao.load((long)memberGroup.getId(), currentDefault.getId(), new Relationship[0]);
            defaultSettings.setDefault(false);
            this.memberGroupAccountSettingsDao.update(defaultSettings);
        }
        MemberGroupAccountSettings saved = this.memberGroupAccountSettingsDao.update(settings);
        if (updateAccountLimits) {
            BulkUpdateAccountDTO dto = new BulkUpdateAccountDTO();
            dto.setType(saved.getAccountType());
            dto.setGroup(settings.getGroup());
            dto.setCreditLimit(saved.getDefaultCreditLimit());
            dto.setUpperCreditLimit(saved.getDefaultUpperCreditLimit());
            this.accountDao.bulkUpdateCreditLimites(dto);
            this.accountLimitLogDao.insertAfterCreditLimitBulkUpdate(saved.getAccountType(), settings.getGroup());
        }
        return saved;
    }

    @Override
    public boolean usesPin(MemberGroup group) {
        group = this.fetchService.fetch(group, MemberGroup.Relationships.CHANNELS);
        Collection<Channel> channels = group.getChannels();
        for (Channel channel : channels) {
            if (channel.getCredentials() != Channel.Credentials.PIN) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(Group group) {
        if (group.isTransient()) {
            this.getInsertValidator().validate(group);
        } else if (Group.Status.REMOVED.equals(group.getStatus())) {
            this.getRemovedValidator().validate(group);
        } else if (group instanceof AdminGroup) {
            this.getAdminValidator().validate(group);
        } else if (group instanceof BrokerGroup) {
            this.getBrokerValidator().validate(group);
        } else if (group instanceof MemberGroup) {
            this.getMemberValidator().validate(group);
        } else if (group instanceof OperatorGroup) {
            this.getOperatorValidator().validate(group);
        }
    }

    @Override
    public void validate(MemberGroupAccountSettings settings) {
        this.getAccountSettingsValidator().validate(settings);
    }

    private void clearRelatedCaches(Group group) {
        if (group instanceof AdminGroup) {
            this.adminCustomFieldService.clearCache();
        } else if (group instanceof MemberGroup) {
            this.memberCustomFieldService.clearCache();
        } else if (group instanceof OperatorGroup) {
            this.operatorCustomFieldService.clearCache();
        }
        this.accountTypeService.clearCache();
    }

    private <G extends Group> G copyBaseGroupSettings(G group, G baseGroup) {
        ArrayList<TransferType> transferTypesAsMember;
        baseGroup = this.fetchService.fetch(baseGroup, Group.Relationships.PAYMENT_FILTERS, Group.Relationships.PERMISSIONS, Group.Relationships.TRANSFER_TYPES, SystemGroup.Relationships.DOCUMENTS, Group.Relationships.CUSTOMIZED_FILES, SystemGroup.Relationships.MESSAGE_CATEGORIES, AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER, AdminGroup.Relationships.MANAGES_GROUPS, AdminGroup.Relationships.VIEW_INFORMATION_OF, AdminGroup.Relationships.VIEW_CONNECTED_ADMINS_OF, AdminGroup.Relationships.CONNECTED_ADMINS_VIEWED_BY, AdminGroup.Relationships.ADMIN_CUSTOM_FIELDS, MemberGroup.Relationships.ACCOUNT_SETTINGS, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS, MemberGroup.Relationships.CAN_VIEW_INFORMATION_OF, MemberGroup.Relationships.ACCOUNT_FEES, MemberGroup.Relationships.MANAGED_BY_GROUPS, MemberGroup.Relationships.CUSTOM_FIELDS, MemberGroup.Relationships.FROM_TRANSACTION_FEES, MemberGroup.Relationships.TO_TRANSACTION_FEES, BrokerGroup.Relationships.TRANSFER_TYPES_AS_MEMBER, BrokerGroup.Relationships.BROKER_DOCUMENTS, BrokerGroup.Relationships.BROKER_CAN_VIEW_INFORMATION_OF, OperatorGroup.Relationships.MEMBER, OperatorGroup.Relationships.MAX_AMOUNT_PER_DAY_BY_TRANSFER_TYPE, OperatorGroup.Relationships.CAN_VIEW_INFORMATION_OF, Group.Relationships.GUARANTEE_TYPES, MemberGroup.Relationships.CAN_ISSUE_CERTIFICATION_TO_GROUPS, MemberGroup.Relationships.CAN_BUY_WITH_PAYMENT_OBLIGATIONS_FROM_GROUPS, MemberGroup.Relationships.CARD_TYPE);
        HashSet<Permission> permissions = new HashSet<Permission>(baseGroup.getPermissions());
        group.setPermissions(permissions);
        group.setStatus(baseGroup.getStatus());
        ArrayList<TransferType> transferTypes = new ArrayList<TransferType>(baseGroup.getTransferTypes());
        group.setTransferTypes(transferTypes);
        ArrayList<TransferType> conversionSimulationTTs = new ArrayList<TransferType>(baseGroup.getConversionSimulationTTs());
        group.setConversionSimulationTTs(conversionSimulationTTs);
        if (!(group instanceof OperatorGroup)) {
            group.setBasicSettings((BasicGroupSettings)baseGroup.getBasicSettings().clone());
        }
        ArrayList<GuaranteeType> guaranteeTypes = new ArrayList<GuaranteeType>(baseGroup.getGuaranteeTypes());
        group.setGuaranteeTypes(guaranteeTypes);
        if (group instanceof SystemGroup) {
            SystemGroup systemGroup = (SystemGroup)group;
            SystemGroup baseSystemGroup = (SystemGroup)baseGroup;
            ArrayList<Document> documents = new ArrayList<Document>(baseSystemGroup.getDocuments());
            systemGroup.setDocuments(documents);
            ArrayList<MessageCategory> messageCategories = new ArrayList<MessageCategory>(baseSystemGroup.getMessageCategories());
            systemGroup.setMessageCategories(messageCategories);
            ArrayList<TransferType> chargebackTransferTypes = new ArrayList<TransferType>(baseSystemGroup.getChargebackTransferTypes());
            systemGroup.setChargebackTransferTypes(chargebackTransferTypes);
        }
        if (group instanceof AdminGroup) {
            AdminGroup adminGroup = (AdminGroup)group;
            AdminGroup baseAdminGroup = (AdminGroup)baseGroup;
            transferTypesAsMember = new ArrayList<TransferType>(baseAdminGroup.getTransferTypesAsMember());
            adminGroup.setTransferTypesAsMember(transferTypesAsMember);
            ArrayList<MemberGroup> managesGroups = new ArrayList<MemberGroup>(baseAdminGroup.getManagesGroups());
            adminGroup.setManagesGroups(managesGroups);
            ArrayList<SystemAccountType> viewInformationOf = new ArrayList<SystemAccountType>(baseAdminGroup.getViewInformationOf());
            adminGroup.setViewInformationOf(viewInformationOf);
            ArrayList<AdminGroup> viewConnectedAdminsOf = new ArrayList<AdminGroup>(baseAdminGroup.getViewConnectedAdminsOf());
            adminGroup.setViewConnectedAdminsOf(viewConnectedAdminsOf);
            ArrayList<MemberRecordType> viewMemberRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getViewMemberRecordTypes());
            adminGroup.setViewMemberRecordTypes(viewMemberRecordTypes);
            ArrayList<MemberRecordType> createMemberRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getCreateMemberRecordTypes());
            adminGroup.setCreateMemberRecordTypes(createMemberRecordTypes);
            ArrayList<MemberRecordType> modifyMemberRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getModifyMemberRecordTypes());
            adminGroup.setModifyMemberRecordTypes(modifyMemberRecordTypes);
            ArrayList<MemberRecordType> deleteMemberRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getDeleteMemberRecordTypes());
            adminGroup.setDeleteMemberRecordTypes(deleteMemberRecordTypes);
            ArrayList<MemberRecordType> viewAdminRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getViewAdminRecordTypes());
            adminGroup.setViewAdminRecordTypes(viewAdminRecordTypes);
            ArrayList<MemberRecordType> createAdminRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getCreateAdminRecordTypes());
            adminGroup.setCreateAdminRecordTypes(createAdminRecordTypes);
            ArrayList<MemberRecordType> modifyAdminRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getModifyAdminRecordTypes());
            adminGroup.setModifyAdminRecordTypes(modifyAdminRecordTypes);
            ArrayList<MemberRecordType> deleteAdminRecordTypes = new ArrayList<MemberRecordType>(baseAdminGroup.getDeleteAdminRecordTypes());
            adminGroup.setDeleteAdminRecordTypes(deleteAdminRecordTypes);
        }
        if (group instanceof MemberGroup) {
            MemberGroup memberGroup = (MemberGroup)group;
            MemberGroup baseMemberGroup = (MemberGroup)baseGroup;
            memberGroup.setMemberSettings((MemberGroupSettings)baseMemberGroup.getMemberSettings().clone());
            memberGroup.getMemberSettings().setEmailValidation(new HashSet<MemberGroupSettings.EmailValidation>(baseMemberGroup.getMemberSettings().getEmailValidation()));
            memberGroup.setInitialGroup(baseMemberGroup.isInitialGroup());
            memberGroup.setRegistrationAgreement(baseMemberGroup.getRegistrationAgreement());
            memberGroup.setActive(baseMemberGroup.isActive());
            ArrayList<MemberGroup> canViewProfileOfGroups = new ArrayList<MemberGroup>(baseMemberGroup.getCanViewProfileOfGroups());
            canViewProfileOfGroups.add(baseMemberGroup);
            memberGroup.setCanViewProfileOfGroups(canViewProfileOfGroups);
            ArrayList<MemberGroup> canViewAdsOfGroups = new ArrayList<MemberGroup>(baseMemberGroup.getCanViewAdsOfGroups());
            canViewAdsOfGroups.add(baseMemberGroup);
            memberGroup.setCanViewAdsOfGroups(canViewAdsOfGroups);
            ArrayList<AccountType> canViewInformationOf = new ArrayList<AccountType>(baseMemberGroup.getCanViewInformationOf());
            memberGroup.setCanViewInformationOf(canViewInformationOf);
            ArrayList<Message.Type> defaultMailMessages = new ArrayList<Message.Type>(baseMemberGroup.getDefaultMailMessages());
            memberGroup.setDefaultMailMessages(defaultMailMessages);
            ArrayList<Message.Type> smsMessages = new ArrayList<Message.Type>(baseMemberGroup.getSmsMessages());
            memberGroup.setSmsMessages(smsMessages);
            ArrayList<Message.Type> defaultSmsMessages = new ArrayList<Message.Type>(baseMemberGroup.getDefaultSmsMessages());
            memberGroup.setDefaultSmsMessages(defaultSmsMessages);
            ArrayList<Channel> channels = new ArrayList<Channel>(baseMemberGroup.getChannels());
            memberGroup.setChannels(channels);
            ArrayList<Channel> defaultChannels = new ArrayList<Channel>(baseMemberGroup.getDefaultChannels());
            memberGroup.setDefaultChannels(defaultChannels);
            ArrayList<Channel> requestPaymentByChannels = new ArrayList<Channel>(baseMemberGroup.getRequestPaymentByChannels());
            memberGroup.setRequestPaymentByChannels(requestPaymentByChannels);
            ArrayList<MemberGroup> canIssueCertificationToGroups = new ArrayList<MemberGroup>(baseMemberGroup.getCanIssueCertificationToGroups());
            memberGroup.setCanIssueCertificationToGroups(canIssueCertificationToGroups);
            ArrayList<MemberGroup> canBuyWithPaymentObligationsFromGroups = new ArrayList<MemberGroup>(baseMemberGroup.getCanBuyWithPaymentObligationsFromGroups());
            memberGroup.setCanBuyWithPaymentObligationsFromGroups(canBuyWithPaymentObligationsFromGroups);
            CardType cardType = baseMemberGroup.getCardType();
            memberGroup.setCardType(cardType);
        }
        if (group instanceof BrokerGroup) {
            BrokerGroup brokerGroup = (BrokerGroup)group;
            BrokerGroup baseBrokerGroup = (BrokerGroup)baseGroup;
            transferTypesAsMember = new ArrayList<TransferType>(baseBrokerGroup.getTransferTypesAsMember());
            brokerGroup.setTransferTypesAsMember(transferTypesAsMember);
            ArrayList<TransferType> brokerConversionSimulationTTs = new ArrayList<TransferType>(baseBrokerGroup.getBrokerConversionSimulationTTs());
            brokerGroup.setBrokerConversionSimulationTTs(brokerConversionSimulationTTs);
            ArrayList<Document> brokerDocuments = new ArrayList<Document>(baseBrokerGroup.getBrokerDocuments());
            brokerGroup.setBrokerDocuments(brokerDocuments);
            ArrayList<AccountType> brokerCanViewInformationOf = new ArrayList<AccountType>(baseBrokerGroup.getBrokerCanViewInformationOf());
            brokerGroup.setBrokerCanViewInformationOf(brokerCanViewInformationOf);
            ArrayList<MemberRecordType> brokerMemberRecordTypes = new ArrayList<MemberRecordType>(baseBrokerGroup.getBrokerMemberRecordTypes());
            brokerGroup.setBrokerMemberRecordTypes(brokerMemberRecordTypes);
            ArrayList<MemberRecordType> brokerCreateMemberRecordTypes = new ArrayList<MemberRecordType>(baseBrokerGroup.getBrokerCreateMemberRecordTypes());
            brokerGroup.setBrokerCreateMemberRecordTypes(brokerCreateMemberRecordTypes);
            ArrayList<MemberRecordType> brokerModifyMemberRecordTypes = new ArrayList<MemberRecordType>(baseBrokerGroup.getBrokerModifyMemberRecordTypes());
            brokerGroup.setBrokerModifyMemberRecordTypes(brokerModifyMemberRecordTypes);
            ArrayList<MemberRecordType> brokerDeleteMemberRecordTypes = new ArrayList<MemberRecordType>(baseBrokerGroup.getBrokerDeleteMemberRecordTypes());
            brokerGroup.setBrokerDeleteMemberRecordTypes(brokerDeleteMemberRecordTypes);
            ArrayList<MemberGroup> possibleInitialGroups = new ArrayList<MemberGroup>(baseBrokerGroup.getPossibleInitialGroups());
            brokerGroup.setPossibleInitialGroups(possibleInitialGroups);
        }
        if (group instanceof OperatorGroup) {
            OperatorGroup operatorGroup = (OperatorGroup)group;
            OperatorGroup baseOperatorGroup = (OperatorGroup)baseGroup;
            operatorGroup.setMember(baseOperatorGroup.getMember());
            HashMap<TransferType, BigDecimal> maxAmountPerDayByTransferType = new HashMap<TransferType, BigDecimal>(baseOperatorGroup.getMaxAmountPerDayByTransferType());
            operatorGroup.setMaxAmountPerDayByTransferType(maxAmountPerDayByTransferType);
            ArrayList<AccountType> canViewInformationOf = new ArrayList<AccountType>(baseOperatorGroup.getCanViewInformationOf());
            operatorGroup.setCanViewInformationOf(canViewInformationOf);
        }
        return group;
    }

    private Group copyInverseCollections(Group group, Group baseGroup) {
        block16: {
            block15: {
                Collection<PaymentFilter> paymentFilters = baseGroup.getPaymentFilters();
                for (PaymentFilter paymentFilter : paymentFilters) {
                    Collection<? extends Group> groups = paymentFilter.getGroups();
                    groups.add(group);
                    this.paymentFilterDao.update(paymentFilter);
                }
                Collection<CustomizedFile> customizedFiles = baseGroup.getCustomizedFiles();
                for (CustomizedFile baseGroupCustomizedFile : customizedFiles) {
                    CustomizedFile customizedFile = (CustomizedFile)baseGroupCustomizedFile.clone();
                    customizedFile.setId(null);
                    customizedFile.setGroup(group);
                    this.customizedFileDao.insert(customizedFile);
                }
                Collection<MemberRecordType> recordTypes = baseGroup.getMemberRecordTypes();
                for (MemberRecordType recordType : recordTypes) {
                    recordType.getGroups().add(group);
                    this.memberRecordTypeDao.update(recordType);
                }
                if (!(group instanceof AdminGroup)) break block15;
                AdminGroup adminGroup = (AdminGroup)group;
                AdminGroup baseAdminGroup = (AdminGroup)baseGroup;
                Collection<AdminGroup> connectedAdminsViewedBy = baseAdminGroup.getConnectedAdminsViewedBy();
                for (AdminGroup viewerAdminGroup : connectedAdminsViewedBy) {
                    viewerAdminGroup.getViewConnectedAdminsOf().add(adminGroup);
                    this.groupDao.update(viewerAdminGroup);
                }
                Collection<AdminCustomField> adminCustomFields = baseAdminGroup.getAdminCustomFields();
                for (AdminCustomField adminCustomField : adminCustomFields) {
                    adminCustomField.getGroups().add(adminGroup);
                    this.customFieldDao.update(adminCustomField);
                }
                break block16;
            }
            if (!(group instanceof MemberGroup)) break block16;
            MemberGroup memberGroup = (MemberGroup)group;
            MemberGroup baseMemberGroup = (MemberGroup)baseGroup;
            Collection<AdminGroup> managedByGroups = baseMemberGroup.getManagedByGroups();
            for (AdminGroup adminGroup : managedByGroups) {
                adminGroup.getManagesGroups().add(memberGroup);
                this.groupDao.update(adminGroup);
            }
            Collection<MemberGroupAccountSettings> baseMemberGroupAccountSettings = baseMemberGroup.getAccountSettings();
            for (MemberGroupAccountSettings baseAccountSettings : baseMemberGroupAccountSettings) {
                MemberGroupAccountSettings accountSettings = (MemberGroupAccountSettings)baseAccountSettings.clone();
                accountSettings.setId(null);
                accountSettings.setGroup(memberGroup);
                this.insertAccountSettings(accountSettings);
            }
            Collection<AccountFee> accountFees = baseMemberGroup.getAccountFees();
            for (AccountFee accountFee : accountFees) {
                Collection<MemberGroup> groups = accountFee.getGroups();
                groups.add(memberGroup);
                this.accountFeeDao.update(accountFee);
            }
            Collection<CustomField> customFields = baseMemberGroup.getCustomFields();
            for (CustomField customField : customFields) {
                Collection groups = (Collection)PropertyHelper.get(customField, "groups");
                groups.add(memberGroup);
                this.customFieldDao.update(customField);
            }
            Collection<TransactionFee> fromTransactionFees = baseMemberGroup.getFromTransactionFees();
            for (TransactionFee transactionFee : fromTransactionFees) {
                transactionFee.getFromGroups().add(memberGroup);
                this.transactionFeeDao.update(transactionFee);
            }
            Collection<TransactionFee> toTransactionFees = baseMemberGroup.getToTransactionFees();
            for (TransactionFee transactionFee : toTransactionFees) {
                transactionFee.getToGroups().add(memberGroup);
                this.transactionFeeDao.update(transactionFee);
            }
            for (MemberGroup other : memberGroup.getCanViewProfileOfGroups()) {
                other.getCanViewProfileOfGroups().add(memberGroup);
            }
            memberGroup.getCanViewProfileOfGroups().add(memberGroup);
            for (MemberGroup other : memberGroup.getCanViewAdsOfGroups()) {
                other.getCanViewAdsOfGroups().add(memberGroup);
            }
            memberGroup.getCanViewAdsOfGroups().add(memberGroup);
            for (GroupFilter groupFilter : baseMemberGroup.getGroupFilters()) {
                groupFilter.getGroups().add(memberGroup);
            }
            for (GroupFilter groupFilter : baseMemberGroup.getCanViewGroupFilters()) {
                groupFilter.getViewableBy().add(memberGroup);
            }
        }
        return group;
    }

    private Validator getAccountSettingsValidator() {
        Validator accountSettingsValidator = new Validator("account");
        accountSettingsValidator.property("group").displayName("group").required();
        accountSettingsValidator.property("accountType").displayName("account type").required();
        accountSettingsValidator.property("initialCredit").positive();
        accountSettingsValidator.general(new GeneralValidation(){
            private static final long serialVersionUID = 1L;

            @Override
            public ValidationError validate(Object object) {
                MemberGroupAccountSettings mgas = (MemberGroupAccountSettings)object;
                if (mgas.getInitialCreditTransferType() != null) {
                    boolean initialCreditIsPossitive;
                    TransferType tt = GroupServiceImpl.this.fetchService.fetch(mgas.getInitialCreditTransferType(), new Relationship[0]);
                    BigDecimal minAmount = tt.getMinAmount();
                    BigDecimal initialCredit = mgas.getInitialCredit();
                    boolean bl = initialCreditIsPossitive = initialCredit != null && initialCredit.compareTo(new BigDecimal(0)) > 0;
                    if (initialCreditIsPossitive && minAmount != null && initialCredit.compareTo(minAmount) < 0) {
                        return new ValidationError("group.account.error.minInitialCredit", initialCredit, minAmount);
                    }
                }
                return null;
            }
        });
        accountSettingsValidator.property("initialCreditTransferType").add(new PropertyValidation(){
            private static final long serialVersionUID = 8284432136349418154L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                MemberGroupAccountSettings mgas = (MemberGroupAccountSettings)object;
                TransferType tt = GroupServiceImpl.this.fetchService.fetch((TransferType)value, TransferType.Relationships.FROM, TransferType.Relationships.TO);
                BigDecimal initialCredit = mgas.getInitialCredit();
                if (initialCredit != null && initialCredit.compareTo(BigDecimal.ZERO) == 1 && tt == null) {
                    return new RequiredError(new Object[0]);
                }
                if (tt != null && (!tt.isFromSystem() || tt.isToSystem())) {
                    return new InvalidError();
                }
                return null;
            }
        });
        accountSettingsValidator.property("defaultCreditLimit").required().positive();
        accountSettingsValidator.property("defaultUpperCreditLimit").positive();
        accountSettingsValidator.property("lowUnits").positive();
        accountSettingsValidator.property("lowUnitsMessage").add(new PropertyValidation(){
            private static final long serialVersionUID = -6086632981851357180L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                MemberGroupAccountSettings mgas = (MemberGroupAccountSettings)object;
                BigDecimal lowUnits = mgas.getLowUnits();
                if (lowUnits != null && lowUnits.compareTo(BigDecimal.ZERO) == 1 && StringUtils.isEmpty((String)mgas.getLowUnitsMessage())) {
                    return new RequiredError(new Object[0]);
                }
                return null;
            }
        });
        return accountSettingsValidator;
    }

    private Validator getAdminValidator() {
        Validator adminValidator = new Validator("group");
        this.initSystem(adminValidator, true);
        return adminValidator;
    }

    private Validator getBrokerValidator() {
        Validator brokerValidator = new Validator("group");
        this.initSystem(brokerValidator, true);
        this.initMember(brokerValidator);
        return brokerValidator;
    }

    private Validator getInsertValidator() {
        Validator insertValidator = new Validator("group");
        insertValidator.property("name").required().maxLength(100);
        insertValidator.property("description").maxLength(2000);
        insertValidator.property("nature").required();
        insertValidator.property("status").required();
        return insertValidator;
    }

    private Validator getMemberValidator() {
        Validator memberValidator = new Validator("group");
        this.initSystem(memberValidator, true);
        this.initMember(memberValidator);
        return memberValidator;
    }

    private Validator getOperatorValidator() {
        Validator operatorValidator = new Validator("group");
        this.initBasic(operatorValidator, false);
        return operatorValidator;
    }

    private Validator getRemovedValidator() {
        Validator removedValidator = new Validator("group");
        removedValidator.property("name").required().maxLength(100);
        removedValidator.property("description").maxLength(2000);
        removedValidator.property("nature").add(new ChangeNatureValidation());
        return removedValidator;
    }

    private void initBasic(Validator validator, boolean addSettings) {
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(2000);
        validator.property("nature").add(new ChangeNatureValidation());
        if (addSettings) {
            validator.property("basicSettings.passwordLength.min").key("group.settings.passwordLength.min").between(1, 32);
            validator.property("basicSettings.passwordLength.max").key("group.settings.passwordLength.max").between(1, 32);
            validator.property("basicSettings.maxPasswordWrongTries").key("group.settings.passwordTries.maximum").between(0, 99);
            validator.property("basicSettings.deactivationAfterMaxPasswordTries.number").key("group.settings.passwordTries.deactivationTime.number").between(0, 999);
            validator.property("basicSettings.deactivationAfterMaxPasswordTries.field").key("group.settings.passwordTries.deactivationTime.field").required();
            validator.property("basicSettings.passwordExpiresAfter.number").key("group.settings.passwordExpiresAfter.number").between(0, 999);
            validator.property("basicSettings.passwordExpiresAfter.field").key("group.settings.passwordExpiresAfter.field").required();
            validator.property("basicSettings.transactionPassword").key("group.settings.transactionPassword").required();
            validator.property("basicSettings.transactionPasswordLength").key("group.settings.transactionPassword.length").between(1, 32);
            validator.property("basicSettings.maxTransactionPasswordWrongTries").key("group.settings.maxTransactionPasswordWrongTries").between(0, 99);
            validator.property("basicSettings.deactivationAfterMaxPasswordTries.number").key("group.settings.passwordTries.deactivationTime.number").add(new PasswordTrialsValidation());
            validator.property("basicSettings.passwordPolicy").key("group.settings.passwordPolicy").add(new PasswordPolicyValidation());
        }
    }

    private void initMember(Validator validator) {
        validator.property("memberSettings.defaultAdPublicationTime.number").key("group.settings.defaultAdPublicationTime.number").between(1, 999);
        validator.property("memberSettings.defaultAdPublicationTime.field").key("group.settings.defaultAdPublicationTime.field").required();
        validator.property("memberSettings.maxAdPublicationTime.number").key("group.settings.maxAdPublicationTime.number").between(1, 999);
        validator.property("memberSettings.maxAdPublicationTime.field").key("group.settings.maxAdPublicationTime.field").required();
        validator.property("memberSettings.maxAdDescriptionSize").key("group.settings.maxAdDescriptionSize").required().between(16, 16000);
        validator.property("memberSettings.maxAdsPerMember").key("group.settings.maxAdsPerMember").between(0, 999);
        validator.property("memberSettings.maxAdImagesPerMember").key("group.settings.maxAdImagesPerMember").between(0, 999);
        validator.property("memberSettings.maxImagesPerMember").key("group.settings.maxImagesPerMember").between(0, 999);
        validator.property("memberSettings.expireMembersAfter.number").key("group.settings.expireMembersAfter").between(0, 999);
        validator.property("memberSettings.expireMembersAfter.field").key("group.settings.expireMembersAfter").add(new ExpirationValidation(RequiredValidation.instance()));
        validator.property("memberSettings.groupAfterExpiration").key("group.settings.groupAfterExpiration").add(new ExpirationValidation(RequiredValidation.instance()));
        validator.property("memberSettings.pinBlockTimeAfterMaxTries.number").key("group.settings.pinBlockTimeAfterMaxTries.number").between(0, 999);
        validator.property("memberSettings.pinBlockTimeAfterMaxTries.field").key("group.settings.pinBlockTimeAfterMaxTries.field").add(new PINBlockTimeValidation(RequiredValidation.instance()));
        validator.property("memberSettings.smsContextClassName").key("group.settings.smsContextClassName").instanceOf(ISmsContext.class);
        validator.property("memberSettings.pinBlockTimeAfterMaxTries.number").key("group.settings.pinBlockTimeAfterMaxTries.number").add(new PinTrialsValidation());
    }

    private void initSystem(Validator validator, boolean addSettings) {
        this.initBasic(validator, addSettings);
        validator.property("rootUrl").maxLength(100).url();
        validator.property("loginPageName").maxLength(20);
        validator.property("containerUrl").maxLength(100).url();
    }

    private void removeFromInverseCollections(Group group) {
        Collection<PaymentFilter> paymentFilters = group.getPaymentFilters();
        for (PaymentFilter paymentFilter : paymentFilters) {
            Collection<? extends Group> groups = paymentFilter.getGroups();
            groups.remove(group);
            this.paymentFilterDao.update(paymentFilter);
        }
        Collection<MemberRecordType> recordTypes = group.getMemberRecordTypes();
        for (MemberRecordType recordType : recordTypes) {
            recordType.getGroups().remove(group);
            this.memberRecordTypeDao.update(recordType);
        }
        if (group instanceof AdminGroup) {
            AdminGroup adminGroup = (AdminGroup)group;
            Collection<AdminGroup> connectedAdminsViewedBy = adminGroup.getConnectedAdminsViewedBy();
            for (AdminGroup viewerAdminGroup : connectedAdminsViewedBy) {
                viewerAdminGroup.getViewConnectedAdminsOf().remove(adminGroup);
                this.groupDao.update(viewerAdminGroup);
            }
            Collection<AdminCustomField> adminCustomFields = adminGroup.getAdminCustomFields();
            for (AdminCustomField adminCustomField : adminCustomFields) {
                adminCustomField.getGroups().remove(adminGroup);
                this.customFieldDao.update(adminCustomField);
            }
        }
        if (group instanceof MemberGroup) {
            MemberGroup memberGroup = (MemberGroup)group;
            Collection<AccountFee> accountFees = memberGroup.getAccountFees();
            for (AccountFee accountFee : accountFees) {
                Collection<MemberGroup> groups = accountFee.getGroups();
                groups.remove(memberGroup);
                this.accountFeeDao.update(accountFee);
            }
            Collection<AdminGroup> managedByGroups = memberGroup.getManagedByGroups();
            for (AdminGroup adminGroup : managedByGroups) {
                adminGroup.getManagesGroups().remove(memberGroup);
                this.groupDao.update(adminGroup);
            }
            Collection<CustomField> customFields = memberGroup.getCustomFields();
            for (CustomField customField : customFields) {
                Collection groups = (Collection)PropertyHelper.get(customField, "groups");
                groups.remove(memberGroup);
                this.customFieldDao.update(customField);
            }
            Collection<TransactionFee> fromTransactionFees = memberGroup.getFromTransactionFees();
            for (TransactionFee transactionFee : fromTransactionFees) {
                transactionFee.getFromGroups().remove(memberGroup);
                this.transactionFeeDao.update(transactionFee);
            }
            Collection<TransactionFee> toTransactionFees = memberGroup.getToTransactionFees();
            for (TransactionFee transactionFee : toTransactionFees) {
                transactionFee.getToGroups().remove(memberGroup);
                this.transactionFeeDao.update(transactionFee);
            }
        }
    }

    private <G extends Group> G save(G group) {
        if (group.isTransient()) {
            group = this.groupDao.insert(group);
        } else {
            Object currentGroup = this.load(group.getId(), FETCH_TO_KEEP_DATA);
            group.setPermissions(new HashSet<Permission>(((Group)currentGroup).getPermissions()));
            group.setTransferTypes(new ArrayList<TransferType>(((Group)currentGroup).getTransferTypes()));
            group.setConversionSimulationTTs(new ArrayList<TransferType>(((Group)currentGroup).getConversionSimulationTTs()));
            group.setGuaranteeTypes(new ArrayList<GuaranteeType>(((Group)currentGroup).getGuaranteeTypes()));
            if (group instanceof SystemGroup) {
                SystemGroup systemGroup = (SystemGroup)group;
                SystemGroup currentSystemGroup = (SystemGroup)currentGroup;
                systemGroup.setDocuments(new ArrayList<Document>(currentSystemGroup.getDocuments()));
                systemGroup.setMessageCategories(new ArrayList<MessageCategory>(currentSystemGroup.getMessageCategories()));
                systemGroup.setChargebackTransferTypes(new ArrayList<TransferType>(currentSystemGroup.getChargebackTransferTypes()));
            }
            if (group instanceof AdminGroup) {
                AdminGroup adminGroup = (AdminGroup)group;
                AdminGroup currentAdminGroup = (AdminGroup)currentGroup;
                adminGroup.setTransferTypesAsMember(new ArrayList<TransferType>(currentAdminGroup.getTransferTypesAsMember()));
                adminGroup.setManagesGroups(new ArrayList<MemberGroup>(currentAdminGroup.getManagesGroups()));
                adminGroup.setViewConnectedAdminsOf(new ArrayList<AdminGroup>(currentAdminGroup.getViewConnectedAdminsOf()));
                adminGroup.setViewInformationOf(new ArrayList<SystemAccountType>(currentAdminGroup.getViewInformationOf()));
                adminGroup.setViewAdminRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getViewAdminRecordTypes()));
                adminGroup.setCreateAdminRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getCreateAdminRecordTypes()));
                adminGroup.setModifyAdminRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getModifyAdminRecordTypes()));
                adminGroup.setDeleteAdminRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getDeleteAdminRecordTypes()));
                adminGroup.setViewMemberRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getViewMemberRecordTypes()));
                adminGroup.setCreateMemberRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getCreateMemberRecordTypes()));
                adminGroup.setModifyMemberRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getModifyMemberRecordTypes()));
                adminGroup.setDeleteMemberRecordTypes(new ArrayList<MemberRecordType>(currentAdminGroup.getDeleteMemberRecordTypes()));
            }
            if (group instanceof BrokerGroup) {
                BrokerGroup brokerGroup = (BrokerGroup)group;
                BrokerGroup currentBrokerGroup = (BrokerGroup)currentGroup;
                ArrayList<Document> brokerDocuments = new ArrayList<Document>();
                if (currentBrokerGroup.getBrokerDocuments() != null) {
                    brokerDocuments.addAll(currentBrokerGroup.getBrokerDocuments());
                }
                brokerGroup.setBrokerDocuments(brokerDocuments);
                ArrayList<AccountType> brokerCanViewInformationOf = new ArrayList<AccountType>();
                if (brokerGroup.getBrokerCanViewInformationOf() != null) {
                    brokerCanViewInformationOf.addAll(brokerGroup.getBrokerCanViewInformationOf());
                }
                brokerGroup.setBrokerCanViewInformationOf(brokerCanViewInformationOf);
                brokerGroup.setTransferTypesAsMember(new ArrayList<TransferType>(currentBrokerGroup.getTransferTypesAsMember()));
                brokerGroup.setBrokerConversionSimulationTTs(new ArrayList<TransferType>(currentBrokerGroup.getBrokerConversionSimulationTTs()));
                brokerGroup.setBrokerMemberRecordTypes(new ArrayList<MemberRecordType>(currentBrokerGroup.getBrokerMemberRecordTypes()));
                brokerGroup.setBrokerCreateMemberRecordTypes(new ArrayList<MemberRecordType>(currentBrokerGroup.getBrokerCreateMemberRecordTypes()));
                brokerGroup.setBrokerModifyMemberRecordTypes(new ArrayList<MemberRecordType>(currentBrokerGroup.getBrokerModifyMemberRecordTypes()));
                brokerGroup.setBrokerDeleteMemberRecordTypes(new ArrayList<MemberRecordType>(currentBrokerGroup.getBrokerDeleteMemberRecordTypes()));
            }
            if (group instanceof MemberGroup) {
                Collection<Message.Type> defaultSmsMessages;
                MemberGroup memberGroup = (MemberGroup)group;
                MemberGroup currentMemberGroup = (MemberGroup)currentGroup;
                memberGroup.setAccountSettings(currentMemberGroup.getAccountSettings());
                memberGroup.getDefaultChannels().retainAll(memberGroup.getChannels());
                HashSet<Channel> removedChannels = new HashSet<Channel>();
                removedChannels.addAll(currentMemberGroup.getChannels());
                removedChannels.removeAll(memberGroup.getChannels());
                ArrayList<MemberGroup> viewProfile = new ArrayList<MemberGroup>();
                if (currentMemberGroup.getCanViewProfileOfGroups() != null) {
                    viewProfile.addAll(currentMemberGroup.getCanViewProfileOfGroups());
                }
                memberGroup.setCanViewProfileOfGroups(viewProfile);
                ArrayList<AccountType> canViewInformationOf = new ArrayList<AccountType>();
                if (currentMemberGroup.getCanViewInformationOf() != null) {
                    canViewInformationOf.addAll(currentMemberGroup.getCanViewInformationOf());
                }
                memberGroup.setCanViewInformationOf(canViewInformationOf);
                ArrayList<MemberGroup> viewAds = new ArrayList<MemberGroup>();
                if (currentMemberGroup.getCanViewAdsOfGroups() != null) {
                    viewAds.addAll(currentMemberGroup.getCanViewAdsOfGroups());
                }
                memberGroup.setCanViewAdsOfGroups(viewAds);
                ArrayList<AdminGroup> managedByGroups = new ArrayList<AdminGroup>();
                if (currentMemberGroup.getManagedByGroups() != null) {
                    managedByGroups.addAll(currentMemberGroup.getManagedByGroups());
                }
                memberGroup.setManagedByGroups(managedByGroups);
                Channel webChannel = this.channelService.loadByInternalName("web");
                memberGroup.setChannels(CollectionUtils.union(memberGroup.getChannels(), Collections.singleton(webChannel)));
                memberGroup.setDefaultChannels(CollectionUtils.union(memberGroup.getDefaultChannels(), Collections.singleton(webChannel)));
                ArrayList<Channel> requestPaymentByChannels = new ArrayList<Channel>();
                if (currentMemberGroup.getRequestPaymentByChannels() != null) {
                    requestPaymentByChannels.addAll(currentMemberGroup.getRequestPaymentByChannels());
                }
                memberGroup.setRequestPaymentByChannels(requestPaymentByChannels);
                MemberGroupSettings memberSettings = memberGroup.getMemberSettings();
                memberSettings.setGroupAfterExpiration(this.fetchService.fetch(memberSettings.getGroupAfterExpiration(), new Relationship[0]));
                GroupQuery operatorQuery = new GroupQuery();
                operatorQuery.setNature(Group.Nature.OPERATOR);
                operatorQuery.fetch(RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
                List<? extends Group> operatorGroups = this.groupDao.search(operatorQuery);
                for (OperatorGroup operatorGroup : operatorGroups) {
                    if (!operatorGroup.getMember().getGroup().equals(memberGroup)) continue;
                    this.groupDao.update(operatorGroup);
                }
                ArrayList<MemberGroup> canIssueCertificationToGroups = new ArrayList<MemberGroup>();
                if (currentMemberGroup.getCanIssueCertificationToGroups() != null) {
                    canIssueCertificationToGroups.addAll(currentMemberGroup.getCanIssueCertificationToGroups());
                }
                memberGroup.setCanIssueCertificationToGroups(canIssueCertificationToGroups);
                ArrayList<MemberGroup> arrayList = new ArrayList<MemberGroup>();
                if (currentMemberGroup.getCanBuyWithPaymentObligationsFromGroups() != null) {
                    arrayList.addAll(currentMemberGroup.getCanBuyWithPaymentObligationsFromGroups());
                }
                memberGroup.setCanBuyWithPaymentObligationsFromGroups(arrayList);
                Collection<Message.Type> smsMessages = memberGroup.getSmsMessages();
                if (smsMessages != null) {
                    smsMessages.remove(Message.Type.FROM_MEMBER);
                    smsMessages.remove(Message.Type.FROM_ADMIN_TO_GROUP);
                    smsMessages.remove(Message.Type.FROM_ADMIN_TO_MEMBER);
                }
                if ((defaultSmsMessages = memberGroup.getDefaultSmsMessages()) != null) {
                    defaultSmsMessages.remove(Message.Type.FROM_MEMBER);
                    defaultSmsMessages.remove(Message.Type.FROM_ADMIN_TO_GROUP);
                    defaultSmsMessages.remove(Message.Type.FROM_ADMIN_TO_MEMBER);
                }
                this.elementDao.removeChannelsFromMembers(memberGroup, removedChannels);
                if (memberGroup.isRemoved()) {
                    memberGroup.setActive(false);
                }
            }
            if (group instanceof OperatorGroup) {
                OperatorGroup operatorGroup = (OperatorGroup)group;
                OperatorGroup currentOperatorGroup = (OperatorGroup)currentGroup;
                ArrayList<AccountType> canViewInformationOf = new ArrayList<AccountType>();
                if (currentOperatorGroup.getCanViewInformationOf() != null) {
                    canViewInformationOf.addAll(currentOperatorGroup.getCanViewInformationOf());
                }
                operatorGroup.setCanViewInformationOf(canViewInformationOf);
            }
            group = this.groupDao.update(group);
        }
        this.permissionService.evictCache(group);
        return group;
    }

    private final class PinTrialsValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -5445950747956604765L;

        private PinTrialsValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            MemberGroup group = (MemberGroup)object;
            if ((value == null || (Integer)value == 0) && group.getMemberSettings().getMaxPinWrongTries() > 0) {
                return new InvalidError();
            }
            return null;
        }
    }

    private final class PINBlockTimeValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 7237205242667756245L;
        private final PropertyValidation validation;

        private PINBlockTimeValidation(PropertyValidation validation) {
            this.validation = validation;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            MemberGroup group = (MemberGroup)object;
            TimePeriod expireMembersAfter = group.getMemberSettings().getPinBlockTimeAfterMaxTries();
            if (expireMembersAfter != null && expireMembersAfter.getNumber() > 0) {
                return this.validation.validate(object, property, value);
            }
            return null;
        }
    }

    private final class PasswordTrialsValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -5445950747956604765L;

        private PasswordTrialsValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            Group group = (Group)object;
            if ((Integer)value == 0 && group.getBasicSettings().getMaxPasswordWrongTries() > 0) {
                return new InvalidError();
            }
            return null;
        }
    }

    private final class PasswordPolicyValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 5513735809903251255L;

        private PasswordPolicyValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            BasicGroupSettings.PasswordPolicy policy = (BasicGroupSettings.PasswordPolicy)value;
            if (policy == null) {
                return null;
            }
            Group group = (Group)object;
            AccessSettings accessSettings = GroupServiceImpl.this.settingsService.getAccessSettings();
            boolean virtualKeyboard = accessSettings.isVirtualKeyboard();
            boolean numericPassword = accessSettings.isNumericPassword();
            if (policy == BasicGroupSettings.PasswordPolicy.AVOID_OBVIOUS_LETTERS_NUMBERS_SPECIAL && virtualKeyboard) {
                return new ValidationError("group.error.passwordPolicySpecialVirtualKeyboard", new Object[0]);
            }
            if (group.getNature() != Group.Nature.ADMIN && policy.isForceCharacters() && numericPassword) {
                return new ValidationError("group.error.passwordPolicyNumeric", new Object[0]);
            }
            return null;
        }
    }

    private final class ExpirationValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 7237205242667756245L;
        private final PropertyValidation validation;

        private ExpirationValidation(PropertyValidation validation) {
            this.validation = validation;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            MemberGroup group = (MemberGroup)object;
            TimePeriod expireMembersAfter = group.getMemberSettings().getExpireMembersAfter();
            if (expireMembersAfter != null && expireMembersAfter.getNumber() > 0) {
                return this.validation.validate(object, property, value);
            }
            return null;
        }
    }

    private final class ChangeNatureValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 1L;

        private ChangeNatureValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            Object current;
            Group.Nature nature;
            Group group = (Group)object;
            if (group.isPersistent() && (nature = (Group.Nature)((Object)value)) != ((Group)(current = GroupServiceImpl.this.load(group.getId(), new Relationship[0]))).getNature()) {
                return new ValidationError("group.invalidNature", new Object[0]);
            }
            return null;
        }
    }
}

