/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.groups.GroupPermissionsDTO;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class GroupServiceSecurity
extends BaseServiceSecurity
implements GroupService {
    private GroupServiceLocal groupService;

    @Override
    public int countPendingAccounts(MemberGroup group, MemberAccountType accountType) {
        this.permissionService.checkManages(group);
        return this.groupService.countPendingAccounts(group, accountType);
    }

    @Override
    public SystemGroup findByLoginPageName(String loginPageName) {
        return this.groupService.findByLoginPageName(loginPageName);
    }

    @Override
    public List<? extends MemberGroup> getPossibleInitialGroups(GroupFilter groupFilter) {
        return this.groupService.getPossibleInitialGroups(groupFilter);
    }

    @Override
    public <G extends Group> G insert(G group, G baseGroup) {
        this.checkManage(group);
        return this.groupService.insert(group, baseGroup);
    }

    @Override
    public MemberGroupAccountSettings insertAccountSettings(MemberGroupAccountSettings settings) throws UnexpectedEntityException {
        this.checkManageAccountSettings();
        return this.groupService.insertAccountSettings(settings);
    }

    @Override
    public <T extends Group> Collection<T> load(Collection<Long> ids, Relationship ... fetch) {
        Collection groups = this.groupService.load(ids, fetch);
        for (Group group : groups) {
            this.checkView(group);
        }
        return groups;
    }

    @Override
    public <T extends Group> T load(Long id, Relationship ... fetch) {
        Object group = this.groupService.load(id, fetch);
        this.checkView((Group)group);
        return group;
    }

    @Override
    public MemberGroupAccountSettings loadAccountSettings(long groupId, long accountTypeId, Relationship ... fetch) {
        Object group = this.groupService.load(groupId, new Relationship[0]);
        this.permissionService.checkManages((Group)group);
        return this.groupService.loadAccountSettings(groupId, accountTypeId, fetch);
    }

    @Override
    public <T extends Group> T reload(Long id, Relationship ... fetch) {
        Object group = this.groupService.reload(id, fetch);
        this.checkView((Group)group);
        return group;
    }

    @Override
    public void remove(Long id) throws EntityNotFoundException {
        Object group = this.groupService.load(id, new Relationship[0]);
        this.checkManage((Group)group);
        this.groupService.remove(id);
    }

    @Override
    public void removeAccountTypeRelationship(MemberGroup group, MemberAccountType type) {
        this.checkManageAccountSettings();
        this.groupService.removeAccountTypeRelationship(group, type);
    }

    @Override
    public List<? extends Group> search(GroupQuery query) {
        query.setPossibleGroups(this.permissionService.getAllVisibleGroups());
        return this.groupService.search(query);
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    @Override
    public <G extends Group> G setPermissions(GroupPermissionsDTO<G> permissions) {
        Group group = (Group)this.fetchService.fetch(permissions.getGroup(), new Relationship[0]);
        this.checkManage(group);
        return this.groupService.setPermissions(permissions);
    }

    @Override
    public <G extends Group> G update(G group, boolean forceMembersToAcceptAgreement) {
        this.checkManage(group);
        return this.groupService.update(group, forceMembersToAcceptAgreement);
    }

    @Override
    public MemberGroupAccountSettings updateAccountSettings(MemberGroupAccountSettings settings, boolean updateAccountLimits) {
        this.checkManageAccountSettings();
        return this.groupService.updateAccountSettings(settings, updateAccountLimits);
    }

    @Override
    public boolean usesPin(MemberGroup group) {
        this.permissionService.checkManages(group);
        return this.groupService.usesPin(group);
    }

    @Override
    public void validate(Group group) throws ValidationException {
        this.groupService.validate(group);
    }

    @Override
    public void validate(MemberGroupAccountSettings settings) throws ValidationException {
        this.groupService.validate(settings);
    }

    private boolean canView(Group group) {
        switch (group.getNature()) {
            case ADMIN: {
                if (!this.hasPermission(AdminSystemPermission.ADMIN_GROUPS_VIEW)) break;
                return true;
            }
            case BROKER: 
            case MEMBER: {
                if (LoggedUser.hasUser() && this.hasPermission(AdminMemberPermission.GROUPS_VIEW)) {
                    return true;
                }
                MemberGroup memberGroup = (MemberGroup)group;
                if (LoggedUser.hasUser() || !memberGroup.isInitialGroup() && !StringUtils.isNotEmpty((String)memberGroup.getLoginPageName())) break;
                return true;
            }
            case OPERATOR: {
                OperatorGroup operatorGroup = this.fetchService.fetch((OperatorGroup)group, new Relationship[0]);
                boolean hasPermission = this.permissionService.permission(operatorGroup.getMember()).member(MemberPermission.OPERATORS_MANAGE).operator().hasPermission();
                if (!hasPermission) break;
                return true;
            }
        }
        return this.permissionService.getAllVisibleGroups().contains(group);
    }

    private void checkManage(Group group) {
        if (group instanceof AdminGroup) {
            this.permissionService.permission().admin(AdminSystemPermission.GROUPS_MANAGE_ADMIN).check();
        } else if (group instanceof BrokerGroup) {
            this.permissionService.permission().admin(AdminSystemPermission.GROUPS_MANAGE_BROKER).check();
        } else if (group instanceof MemberGroup) {
            this.permissionService.permission().admin(AdminSystemPermission.GROUPS_MANAGE_MEMBER).check();
        } else if (group instanceof OperatorGroup) {
            OperatorGroup operatorGroup = (OperatorGroup)group;
            this.permissionService.permission(operatorGroup.getMember()).member(MemberPermission.OPERATORS_MANAGE).check();
        }
    }

    private void checkManageAccountSettings() {
        this.permissionService.permission().admin(AdminMemberPermission.GROUPS_MANAGE_ACCOUNT_SETTINGS).check();
    }

    private void checkView(Group group) {
        if (!this.canView(group)) {
            throw new PermissionDeniedException();
        }
    }
}

