/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.services.groups.SystemGroupPermissionsDTO;

public class MemberGroupPermissionsDTO<MG extends MemberGroup>
extends SystemGroupPermissionsDTO<MG> {
    private static final long serialVersionUID = -2413523317670088644L;
    private Collection<MemberGroup> canViewProfileOfGroups;
    private Collection<MemberGroup> canViewAdsOfGroups;
    private Collection<AccountType> canViewInformationOf;
    private Collection<TransferType> memberToMemberTTs;
    private Collection<TransferType> memberToSystemTTs;
    private Collection<TransferType> selfPaymentTTs;
    private Collection<TransferType> chargebackTTs;
    private Collection<Channel> requestPaymentByChannels;
    private Collection<MemberGroup> canIssueCertificationToGroups;
    private Collection<MemberGroup> canBuyWithPaymentObligationsFromGroups;

    public Collection<MemberGroup> getCanBuyWithPaymentObligationsFromGroups() {
        return this.canBuyWithPaymentObligationsFromGroups;
    }

    public Collection<MemberGroup> getCanIssueCertificationToGroups() {
        return this.canIssueCertificationToGroups;
    }

    public Collection<MemberGroup> getCanViewAdsOfGroups() {
        return this.canViewAdsOfGroups;
    }

    public Collection<AccountType> getCanViewInformationOf() {
        return this.canViewInformationOf;
    }

    public Collection<MemberGroup> getCanViewProfileOfGroups() {
        return this.canViewProfileOfGroups;
    }

    public Collection<TransferType> getChargebackTTs() {
        return this.chargebackTTs;
    }

    public Collection<TransferType> getMemberToMemberTTs() {
        return this.memberToMemberTTs;
    }

    public Collection<TransferType> getMemberToSystemTTs() {
        return this.memberToSystemTTs;
    }

    public Collection<Channel> getRequestPaymentByChannels() {
        return this.requestPaymentByChannels;
    }

    public Collection<TransferType> getSelfPaymentTTs() {
        return this.selfPaymentTTs;
    }

    public void setCanBuyWithPaymentObligationsFromGroups(Collection<MemberGroup> canBuyWithPaymentObligationsFromGroups) {
        this.canBuyWithPaymentObligationsFromGroups = canBuyWithPaymentObligationsFromGroups;
    }

    public void setCanIssueCertificationToGroups(Collection<MemberGroup> canIssueCertificationToGroups) {
        this.canIssueCertificationToGroups = canIssueCertificationToGroups;
    }

    public void setCanViewAdsOfGroups(Collection<MemberGroup> canViewAdsOfGroups) {
        this.canViewAdsOfGroups = canViewAdsOfGroups;
    }

    public void setCanViewInformationOf(Collection<AccountType> canViewInformationOf) {
        this.canViewInformationOf = canViewInformationOf;
    }

    public void setCanViewProfileOfGroups(Collection<MemberGroup> canViewProfileOfGroups) {
        this.canViewProfileOfGroups = canViewProfileOfGroups;
    }

    public void setChargebackTTs(Collection<TransferType> chargebackTTs) {
        this.chargebackTTs = chargebackTTs;
    }

    public void setMemberToMemberTTs(Collection<TransferType> memberToMemberTTs) {
        this.memberToMemberTTs = memberToMemberTTs;
    }

    public void setMemberToSystemTTs(Collection<TransferType> memberToSystemTTs) {
        this.memberToSystemTTs = memberToSystemTTs;
    }

    public void setRequestPaymentByChannels(Collection<Channel> requestPaymentByChannels) {
        this.requestPaymentByChannels = requestPaymentByChannels;
    }

    public void setSelfPaymentTTs(Collection<TransferType> selfPaymentTTs) {
        this.selfPaymentTTs = selfPaymentTTs;
    }

    @Override
    public void updateOperations() {
        this.update(MemberPermission.GUARANTEES_ISSUE_GUARANTEES, this.getGuaranteeTypes());
        this.update(MemberPermission.DOCUMENTS_VIEW, this.getDocuments());
        this.update(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION, this.getMessageCategories());
        this.update(MemberPermission.PROFILE_VIEW, this.getCanViewProfileOfGroups());
        this.update(MemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, this.getCanViewInformationOf());
        this.update(MemberPermission.ADS_VIEW, this.getCanViewAdsOfGroups());
        this.update(MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER, this.getMemberToMemberTTs());
        this.update(MemberPermission.PAYMENTS_PAYMENT_TO_SYSTEM, this.getMemberToSystemTTs());
        this.update(MemberPermission.PAYMENTS_PAYMENT_TO_SELF, this.getSelfPaymentTTs());
        this.update(MemberPermission.PAYMENTS_REQUEST, this.getRequestPaymentByChannels());
        this.update(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, this.getCanIssueCertificationToGroups());
        this.update(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, this.getCanBuyWithPaymentObligationsFromGroups());
        this.update(MemberPermission.PAYMENTS_CHARGEBACK, this.getChargebackTTs());
    }

    @Override
    protected void updateCollections(MG memberGroup) {
        super.updateCollections(memberGroup);
        ((MemberGroup)memberGroup).setCanViewAdsOfGroups(this.getCanViewAdsOfGroups());
        ((MemberGroup)memberGroup).setCanViewProfileOfGroups(this.getCanViewProfileOfGroups());
        ((MemberGroup)memberGroup).setCanViewInformationOf(this.getCanViewInformationOf());
        ((MemberGroup)memberGroup).setRequestPaymentByChannels(this.getRequestPaymentByChannels());
        ((MemberGroup)memberGroup).setCanIssueCertificationToGroups(this.getCanIssueCertificationToGroups());
        ((MemberGroup)memberGroup).setCanBuyWithPaymentObligationsFromGroups(this.getCanBuyWithPaymentObligationsFromGroups());
        ((SystemGroup)memberGroup).setChargebackTransferTypes(this.getChargebackTTs());
        Collection<TransferType> memberToMemberTTs = this.getMemberToMemberTTs();
        Collection<TransferType> memberToSystemTTs = this.getMemberToSystemTTs();
        Collection<TransferType> selfPaymentTTs = this.getSelfPaymentTTs();
        ArrayList<TransferType> transferTypes = new ArrayList<TransferType>();
        if (memberToMemberTTs != null) {
            transferTypes.addAll(memberToMemberTTs);
        }
        if (memberToSystemTTs != null) {
            transferTypes.addAll(memberToSystemTTs);
        }
        if (selfPaymentTTs != null) {
            transferTypes.addAll(selfPaymentTTs);
        }
        ((Group)memberGroup).setTransferTypes(transferTypes);
    }
}

