/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.groups;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.services.groups.GroupPermissionsDTO;

public class OperatorGroupPermissionsDTO
extends GroupPermissionsDTO<OperatorGroup> {
    private static final long serialVersionUID = -823068618685104044L;
    private Collection<AccountType> canViewInformationOf;
    private Collection<TransferType> memberToMemberTTs;
    private Collection<TransferType> memberToSystemTTs;
    private Collection<TransferType> selfPaymentTTs;
    private Collection<TransferType> externalPaymentTTs;

    public Collection<AccountType> getCanViewInformationOf() {
        return this.canViewInformationOf;
    }

    public Collection<TransferType> getExternalPaymentTTs() {
        return this.externalPaymentTTs;
    }

    public Collection<TransferType> getMemberToMemberTTs() {
        return this.memberToMemberTTs;
    }

    public Collection<TransferType> getMemberToSystemTTs() {
        return this.memberToSystemTTs;
    }

    public Collection<TransferType> getSelfPaymentTTs() {
        return this.selfPaymentTTs;
    }

    public void setCanViewInformationOf(Collection<AccountType> canViewInformationOf) {
        this.canViewInformationOf = canViewInformationOf;
    }

    public void setExternalPaymentTTs(Collection<TransferType> externalPaymentTTs) {
        this.externalPaymentTTs = externalPaymentTTs;
    }

    public void setMemberToMemberTTs(Collection<TransferType> memberToMemberTTs) {
        this.memberToMemberTTs = memberToMemberTTs;
    }

    public void setMemberToSystemTTs(Collection<TransferType> memberToSystemTTs) {
        this.memberToSystemTTs = memberToSystemTTs;
    }

    public void setSelfPaymentTTs(Collection<TransferType> selfPaymentTTs) {
        this.selfPaymentTTs = selfPaymentTTs;
    }

    @Override
    public void updateOperations() {
        this.update(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES, this.getGuaranteeTypes());
        this.update(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION, this.getCanViewInformationOf());
    }

    @Override
    protected void updateCollections(OperatorGroup operatorGroup) {
        super.updateCollections(operatorGroup);
        operatorGroup.setCanViewInformationOf(this.getCanViewInformationOf());
        Collection<TransferType> memberToMemberTTs = this.getMemberToMemberTTs();
        Collection<TransferType> memberToSystemTTs = this.getMemberToSystemTTs();
        Collection<TransferType> selfPaymentTTs = this.getSelfPaymentTTs();
        Collection<TransferType> externalPaymentTTs = this.getExternalPaymentTTs();
        ArrayList<TransferType> transferTypes = new ArrayList<TransferType>();
        if (memberToMemberTTs != null) {
            transferTypes.addAll(memberToMemberTTs);
        }
        if (memberToSystemTTs != null) {
            transferTypes.addAll(memberToSystemTTs);
        }
        if (selfPaymentTTs != null) {
            transferTypes.addAll(selfPaymentTTs);
        }
        if (externalPaymentTTs != null) {
            transferTypes.addAll(externalPaymentTTs);
        }
        operatorGroup.setTransferTypes(transferTypes);
    }
}

