/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.infotexts;

import java.util.List;
import nl.strohalm.cyclos.dao.infotexts.InfoTextDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.infotexts.InfoTextQuery;
import nl.strohalm.cyclos.services.infotexts.InfoTextServiceLocal;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.validation.PeriodValidation;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class InfoTextServiceImpl
implements InfoTextServiceLocal {
    private InfoTextDAO infoTextDao;
    private MessageResolver messageResolver;

    @Override
    public String getInfoTextSubject(String alias) {
        alias = StringUtils.trimToEmpty((String)alias);
        InfoTextQuery query = new InfoTextQuery();
        query.setOnlyActive(true);
        query.setAlias(alias);
        List<InfoText> result = this.infoTextDao.search(query);
        int size = result.size();
        if (size == 0) {
            if (StringUtils.isEmpty((String)alias)) {
                return this.messageResolver.message("infoText.empty.subject", new Object[0]);
            }
            return this.messageResolver.message("infoText.nomatch.subject", alias);
        }
        if (size == 1) {
            return result.get(0).getSubject();
        }
        int index = RandomUtils.nextInt((int)result.size());
        return result.get(index).getSubject();
    }

    @Override
    public InfoText load(long id, Relationship ... fetch) {
        return (InfoText)this.infoTextDao.load(id, fetch);
    }

    @Override
    public InfoText loadByAliasForWebServices(String alias) {
        alias = StringUtils.trimToEmpty((String)alias);
        InfoTextQuery query = new InfoTextQuery();
        query.setOnlyActive(true);
        query.setAlias(alias);
        List<InfoText> result = this.infoTextDao.search(query);
        int size = result.size();
        if (size == 0) {
            throw new EntityNotFoundException(InfoText.class);
        }
        if (size == 1) {
            return result.get(0);
        }
        int index = RandomUtils.nextInt((int)result.size());
        return result.get(index);
    }

    @Override
    public InfoText loadForWebServices(long id) {
        return this.load(id, new Relationship[0]);
    }

    @Override
    public int remove(Long ... ids) {
        return this.infoTextDao.delete(ids);
    }

    @Override
    public InfoText save(InfoText infoText) {
        this.validate(infoText);
        if (infoText.isTransient()) {
            return this.infoTextDao.insert(infoText);
        }
        return this.infoTextDao.update(infoText);
    }

    @Override
    public List<InfoText> search(InfoTextQuery query) {
        return this.infoTextDao.search(query);
    }

    @Override
    public List<InfoText> searchForWebServices(InfoTextQuery query) {
        return this.search(query);
    }

    public void setInfoTextDao(InfoTextDAO infoTextDao) {
        this.infoTextDao = infoTextDao;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    @Override
    public void validate(InfoText infoText) {
        this.getValidator().validate(infoText);
    }

    private Validator getValidator() {
        Validator validator = new Validator();
        validator.property("subject").required();
        validator.property("aliases").required();
        validator.property("validity").add(new PeriodValidation(PeriodValidation.ValidationType.VALIDATE_RANGE));
        return validator;
    }
}

