/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.infotexts;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.infotexts.InfoTextQuery;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.infotexts.InfoTextService;
import nl.strohalm.cyclos.services.infotexts.InfoTextServiceLocal;

public class InfoTextServiceSecurity
extends BaseServiceSecurity
implements InfoTextService {
    private InfoTextServiceLocal infoTextService;

    @Override
    public InfoText load(long id, Relationship ... fetch) throws EntityNotFoundException {
        this.permissionService.permission().admin(AdminSystemPermission.INFO_TEXTS_VIEW).check();
        return this.infoTextService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.INFO_TEXTS_MANAGE).check();
        return this.infoTextService.remove(ids);
    }

    @Override
    public InfoText save(InfoText infoText) {
        this.permissionService.permission().admin(AdminSystemPermission.INFO_TEXTS_MANAGE).check();
        return this.infoTextService.save(infoText);
    }

    @Override
    public List<InfoText> search(InfoTextQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.INFO_TEXTS_VIEW).hasPermission()) {
            return Collections.emptyList();
        }
        return this.infoTextService.search(query);
    }

    public void setInfoTextServiceLocal(InfoTextServiceLocal infoTextService) {
        this.infoTextService = infoTextService;
    }

    @Override
    public void validate(InfoText infoText) {
        this.infoTextService.validate(infoText);
    }
}

