/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.loangroups;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.loans.LoanGroupDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.loangroups.LoanGroupServiceLocal;
import nl.strohalm.cyclos.services.loangroups.exceptions.LoanGroupHasLoansException;
import nl.strohalm.cyclos.services.loangroups.exceptions.MemberAlreadyInListException;
import nl.strohalm.cyclos.services.loangroups.exceptions.MemberNotInListException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class LoanGroupServiceImpl
implements LoanGroupServiceLocal {
    private LoanGroupCustomFieldServiceLocal loanGroupLoanGroupCustomFieldService;
    private FetchServiceLocal fetchService;
    private LoanGroupDAO loanGroupDao;

    @Override
    public void addMember(Member member, LoanGroup loanGroup) {
        Collection<Member> members = (loanGroup = this.fetchService.fetch(loanGroup, LoanGroup.Relationships.MEMBERS)).getMembers();
        if (members.contains(member)) {
            throw new MemberAlreadyInListException();
        }
        members.add(member);
        this.loanGroupDao.update(loanGroup);
    }

    @Override
    public LoanGroup load(Long id, Relationship ... fetch) {
        return (LoanGroup)this.loanGroupDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            LoanGroup lg = new LoanGroup();
            lg.setId(id);
            this.failIfHasLoans(lg);
        }
        return this.loanGroupDao.delete(ids);
    }

    @Override
    public void removeMember(Member member, LoanGroup loanGroup) {
        Collection<Member> members = (loanGroup = this.fetchService.fetch(loanGroup, LoanGroup.Relationships.MEMBERS)).getMembers();
        if (!members.contains(member)) {
            throw new MemberNotInListException();
        }
        members.remove(member);
        this.loanGroupDao.update(loanGroup);
    }

    @Override
    public LoanGroup save(LoanGroup loanGroup) {
        this.validate(loanGroup);
        if (loanGroup.isTransient()) {
            loanGroup = this.loanGroupDao.insert(loanGroup);
        } else {
            LoanGroup toSave = this.load(loanGroup.getId(), LoanGroup.Relationships.CUSTOM_VALUES, LoanGroup.Relationships.LOANS, LoanGroup.Relationships.MEMBERS);
            if (toSave.getLoans() != null && !toSave.getLoans().isEmpty()) {
                throw new LoanGroupHasLoansException();
            }
            toSave.setDescription(loanGroup.getDescription());
            toSave.setName(loanGroup.getName());
            loanGroup = this.loanGroupDao.update(toSave);
        }
        this.loanGroupLoanGroupCustomFieldService.saveValues(loanGroup);
        return loanGroup;
    }

    @Override
    public List<LoanGroup> search(LoanGroupQuery query) {
        return this.loanGroupDao.search(query);
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLoanGroupCustomFieldServiceLocal(LoanGroupCustomFieldServiceLocal loanGroupLoanGroupCustomFieldService) {
        this.loanGroupLoanGroupCustomFieldService = loanGroupLoanGroupCustomFieldService;
    }

    public void setLoanGroupDao(LoanGroupDAO loanGroupDao) {
        this.loanGroupDao = loanGroupDao;
    }

    @Override
    public void validate(LoanGroup loanGroup) {
        this.getValidator().validate(loanGroup);
    }

    private void failIfHasLoans(LoanGroup loanGroup) {
        if ((loanGroup = this.fetchService.fetch(loanGroup, LoanGroup.Relationships.LOANS)) != null && loanGroup.getLoans() != null && !loanGroup.getLoans().isEmpty()) {
            throw new LoanGroupHasLoansException();
        }
    }

    private Validator getValidator() {
        Validator validator = new Validator("loanGroup");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        return validator;
    }
}

