/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.loangroups;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.loangroups.LoanGroupServiceLocal;
import nl.strohalm.cyclos.services.loangroups.exceptions.MemberAlreadyInListException;
import nl.strohalm.cyclos.services.loangroups.exceptions.MemberNotInListException;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.collections.CollectionUtils;

public class LoanGroupServiceSecurity
extends BaseServiceSecurity
implements LoanGroupService {
    private LoanGroupServiceLocal loanGroupService;

    @Override
    public void addMember(Member member, LoanGroup loanGroup) throws MemberAlreadyInListException {
        this.permissionService.permission(member).admin(AdminMemberPermission.LOAN_GROUPS_MANAGE).check();
        this.loanGroupService.addMember(member, loanGroup);
    }

    @Override
    public LoanGroup load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.LOAN_GROUPS_VIEW).broker(BrokerPermission.LOAN_GROUPS_VIEW).member(new MemberPermission[0]).check();
        LoanGroup loanGroup = this.loanGroupService.load(id, fetch);
        loanGroup = this.fetchService.fetch(loanGroup, LoanGroup.Relationships.MEMBERS);
        if (!CollectionUtils.isEmpty(loanGroup.getMembers())) {
            boolean manages = false;
            for (Member m : loanGroup.getMembers()) {
                if (!this.permissionService.manages(m)) continue;
                manages = true;
                break;
            }
            if (!manages) {
                throw new PermissionDeniedException();
            }
        }
        return loanGroup;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.LOAN_GROUPS_MANAGE).check();
        return this.loanGroupService.remove(ids);
    }

    @Override
    public void removeMember(Member member, LoanGroup loanGroup) throws MemberNotInListException {
        this.permissionService.permission(member).admin(AdminMemberPermission.LOAN_GROUPS_MANAGE).check();
        this.loanGroupService.removeMember(member, loanGroup);
    }

    @Override
    public LoanGroup save(LoanGroup loanGroup) {
        this.permissionService.permission().admin(AdminSystemPermission.LOAN_GROUPS_MANAGE).check();
        return this.loanGroupService.save(loanGroup);
    }

    @Override
    public List<LoanGroup> search(LoanGroupQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.loanGroupService.search(query);
    }

    public void setLoanGroupServiceLocal(LoanGroupServiceLocal loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Override
    public void validate(LoanGroup loanGroup) {
        this.loanGroupService.validate(loanGroup);
    }

    private boolean applyQueryRestrictions(LoanGroupQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.LOAN_GROUPS_VIEW, AdminMemberPermission.LOAN_GROUPS_VIEW).broker(BrokerPermission.LOAN_GROUPS_VIEW).member(new MemberPermission[0]).hasPermission()) {
            return false;
        }
        if (!LoggedUser.isAdministrator()) {
            query.setNotOfMember(false);
        }
        if (query.getMember() == null && !LoggedUser.isAdministrator()) {
            return false;
        }
        return query.getMember() == null || this.permissionService.manages(query.getMember());
    }
}

