/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.CurrencyServiceLocal;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.services.customization.DocumentServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeServiceLocal;
import nl.strohalm.cyclos.services.elements.MessageCategoryServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.EntityVO;
import nl.strohalm.cyclos.utils.access.PermissionCatalogHandler;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import org.apache.commons.collections.CollectionUtils;

public class PermissionCatalogHandlerImpl
implements PermissionCatalogHandler {
    private static final Relationship[] FETCH = new Relationship[]{Group.Relationships.PERMISSIONS, Group.Relationships.TRANSFER_TYPES, SystemGroup.Relationships.DOCUMENTS, SystemGroup.Relationships.MESSAGE_CATEGORIES, BrokerGroup.Relationships.BROKER_DOCUMENTS, SystemGroup.Relationships.CHARGEBACK_TRANSFER_TYPES, AdminGroup.Relationships.MANAGES_GROUPS, AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER, AdminGroup.Relationships.VIEW_INFORMATION_OF, AdminGroup.Relationships.VIEW_CONNECTED_ADMINS_OF, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS};
    private static final Map<Permission, SharedValue> permissionSharedValueMap = new HashMap<Permission, SharedValue>();
    private AccountTypeServiceLocal accountTypeService;
    private ChannelServiceLocal channelService;
    private CurrencyServiceLocal currencyService;
    private DocumentServiceLocal documentService;
    private GroupServiceLocal groupService;
    private GuaranteeTypeServiceLocal guaranteeTypeService;
    private MessageCategoryServiceLocal messageCategoryService;
    private TransferTypeServiceLocal transferTypeService;
    private MemberRecordTypeServiceLocal memberRecordTypeService;
    private FetchServiceLocal fetchService;
    private PermissionServiceLocal permissionService;
    private Map<Permission, Set<EntityVO>> possibleValuesMap;
    private Group group;

    @Override
    public Set<EntityVO> currentValues(Permission permission) {
        return EntityHelper.toEntityVO(PermissionHelper.getAllowedValues(this.group, permission));
    }

    @Override
    public Set<EntityVO> possibleValues(Permission permission) {
        return this.possibleValuesMap.get(permission);
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCurrencyServiceLocal(CurrencyServiceLocal currencyService) {
        this.currencyService = currencyService;
    }

    public void setDocumentServiceLocal(DocumentServiceLocal documentService) {
        this.documentService = documentService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setGuaranteeTypeServiceLocal(GuaranteeTypeServiceLocal guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    public void setMemberRecordTypeServiceLocal(MemberRecordTypeServiceLocal memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    public void setMessageCategoryServiceLocal(MessageCategoryServiceLocal messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    private Collection<MemberAccountType> getMemberAccountTypes() {
        Collection<AccountType> memberAccountTypes = null;
        if (this.group instanceof BrokerGroup) {
            memberAccountTypes = this.accountTypeService.search(new MemberAccountTypeQuery());
        } else if (this.group instanceof MemberGroup) {
            memberAccountTypes = ((MemberGroup)this.group).getAccountTypes();
        } else {
            AdminGroup adminGroup = (AdminGroup)this.group;
            Collection<MemberGroup> managesGroups = adminGroup.getManagesGroups();
            memberAccountTypes = new HashSet();
            for (MemberGroup memberGroup : managesGroups) {
                memberAccountTypes.addAll(memberGroup.getAccountTypes());
            }
        }
        return memberAccountTypes;
    }

    private Collection<SystemAccountType> getSystemAccountTypes() {
        Collection<SystemAccountType> systemAccountTypes = null;
        if (this.group instanceof AdminGroup) {
            systemAccountTypes = ((AdminGroup)this.group).getViewInformationOf();
        }
        return systemAccountTypes;
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, AdminAdminPermission permission) {
        switch (permission) {
            case RECORDS_VIEW: 
            case RECORDS_CREATE: 
            case RECORDS_MODIFY: 
            case RECORDS_DELETE: {
                return this.load(commonData, permissionSharedValueMap.get(permission));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, AdminMemberPermission permission) {
        switch (permission) {
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM: 
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER: 
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF: 
            case RECORDS_VIEW: 
            case RECORDS_CREATE: 
            case RECORDS_MODIFY: 
            case RECORDS_DELETE: 
            case DOCUMENTS_DETAILS: 
            case MESSAGES_VIEW: {
                return this.load(commonData, permissionSharedValueMap.get(permission));
            }
            case MEMBERS_VIEW: {
                GroupQuery groupQuery = new GroupQuery();
                groupQuery.setIgnoreManagedBy(true);
                groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                return this.groupService.search(groupQuery);
            }
            case PAYMENTS_PAYMENT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.SYSTEM);
                ttQuery.setToNature(AccountType.Nature.MEMBER);
                ttQuery.setFromAccountTypes(commonData.systemAccountTypes);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case PAYMENTS_CHARGEBACK: {
                TransferTypeQuery memberChargebackQuery = new TransferTypeQuery();
                memberChargebackQuery.setToNature(AccountType.Nature.MEMBER);
                List<TransferType> memberChargebacks = this.transferTypeService.search(memberChargebackQuery);
                Iterator<TransferType> iter = memberChargebacks.iterator();
                while (iter.hasNext()) {
                    TransferType tt = iter.next();
                    TransferType.Context ctx = tt.getContext();
                    if (ctx.isPayment() || ctx.isSelfPayment()) continue;
                    iter.remove();
                }
                return memberChargebacks;
            }
            case LOANS_GRANT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.LOAN);
                ttQuery.setFromAccountTypes(commonData.systemAccountTypes);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case GUARANTEES_REGISTER_GUARANTEES: {
                GuaranteeTypeQuery guaranteeTypeQuery = new GuaranteeTypeQuery();
                guaranteeTypeQuery.setEnabled(true);
                ArrayList<GuaranteeType.Model> models = new ArrayList<GuaranteeType.Model>();
                models.add(GuaranteeType.Model.WITH_BUYER_AND_SELLER);
                models.add(GuaranteeType.Model.WITH_BUYER_ONLY);
                guaranteeTypeQuery.setModels(models);
                return this.guaranteeTypeService.search(guaranteeTypeQuery);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, AdminSystemPermission permission) {
        switch (permission) {
            case ACCOUNTS_INFORMATION: {
                return this.accountTypeService.search(new SystemAccountTypeQuery());
            }
            case PAYMENTS_PAYMENT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.SELF_PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.SYSTEM);
                ttQuery.setToNature(AccountType.Nature.SYSTEM);
                ttQuery.setFromAccountTypes(commonData.systemAccountTypes);
                ttQuery.setToAccountTypes(commonData.systemAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case PAYMENTS_CHARGEBACK: {
                TransferTypeQuery systemChargebackQuery = new TransferTypeQuery();
                systemChargebackQuery.setToNature(AccountType.Nature.SYSTEM);
                List<TransferType> systemChargebacks = this.transferTypeService.search(systemChargebackQuery);
                Iterator<TransferType> iter = systemChargebacks.iterator();
                while (iter.hasNext()) {
                    TransferType tt = iter.next();
                    TransferType.Context ctx = tt.getContext();
                    if (ctx.isPayment() || ctx.isSelfPayment()) continue;
                    iter.remove();
                }
                return systemChargebacks;
            }
            case STATUS_VIEW_CONNECTED_ADMINS: {
                GroupQuery groupQuery = new GroupQuery();
                groupQuery.setNatures(Group.Nature.ADMIN);
                return this.groupService.search(groupQuery);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, BrokerPermission permission) {
        switch (permission) {
            case REPORTS_SHOW_ACCOUNT_INFORMATION: 
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM: 
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER: 
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF: 
            case MEMBER_RECORDS_VIEW: 
            case MEMBER_RECORDS_CREATE: 
            case MEMBER_RECORDS_MODIFY: 
            case MEMBER_RECORDS_DELETE: {
                return this.load(commonData, permissionSharedValueMap.get(permission));
            }
            case DOCUMENTS_VIEW: {
                DocumentQuery documentQuery = new DocumentQuery();
                ArrayList<Document.Nature> natures = new ArrayList<Document.Nature>();
                natures.add(Document.Nature.DYNAMIC);
                documentQuery.setNatures(natures);
                return this.documentService.search(documentQuery);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, MemberPermission permission) {
        switch (permission) {
            case PROFILE_VIEW: 
            case ADS_VIEW: 
            case GUARANTEES_ISSUE_CERTIFICATIONS: 
            case GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS: 
            case DOCUMENTS_VIEW: 
            case REPORTS_SHOW_ACCOUNT_INFORMATION: 
            case MESSAGES_SEND_TO_ADMINISTRATION: {
                return this.load(commonData, permissionSharedValueMap.get(permission));
            }
            case PAYMENTS_PAYMENT_TO_SELF: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.SELF_PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.MEMBER);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case PAYMENTS_PAYMENT_TO_MEMBER: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.MEMBER);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                ArrayList<TransferType> memberMemberTTs = new ArrayList<TransferType>(this.transferTypeService.search(ttQuery));
                Iterator iter = memberMemberTTs.iterator();
                while (iter.hasNext()) {
                    TransferType.Context ctx = ((TransferType)iter.next()).getContext();
                    if (ctx.isPayment()) continue;
                    iter.remove();
                }
                return memberMemberTTs;
            }
            case PAYMENTS_PAYMENT_TO_SYSTEM: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.SYSTEM);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                ttQuery.setToAccountTypes(commonData.systemAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case PAYMENTS_REQUEST: {
                return this.channelService.listSupportingPaymentRequest();
            }
            case PAYMENTS_CHARGEBACK: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.PAYMENT);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case GUARANTEES_ISSUE_GUARANTEES: {
                GuaranteeTypeQuery guaranteeTypeQuery = new GuaranteeTypeQuery();
                guaranteeTypeQuery.setEnabled(true);
                List<Currency> currencies = this.currencyService.listByMemberGroup((MemberGroup)this.group);
                guaranteeTypeQuery.setCurrencies(currencies);
                return this.guaranteeTypeService.search(guaranteeTypeQuery);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    private Collection<? extends Entity> load(CommonDataBean commonData, SharedValue shared) {
        switch (shared) {
            case DOCUMENTS: {
                DocumentQuery documentQuery = new DocumentQuery();
                ArrayList<Document.Nature> natures = new ArrayList<Document.Nature>();
                natures.add(Document.Nature.DYNAMIC);
                natures.add(Document.Nature.STATIC);
                documentQuery.setNatures(natures);
                return this.documentService.search(documentQuery);
            }
            case MEMBER_GROUPS: {
                GroupQuery groupQuery = new GroupQuery();
                groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                groupQuery.setStatus(Group.Status.NORMAL);
                groupQuery.setIgnoreManagedBy(true);
                return this.groupService.search(groupQuery);
            }
            case ACCOUNT_TYPES: {
                MemberGroup memberGroup = (MemberGroup)this.group;
                Collection<MemberGroup> canViewProfileOfGroups = memberGroup.getCanViewProfileOfGroups();
                if (CollectionUtils.isNotEmpty(canViewProfileOfGroups)) {
                    MemberAccountTypeQuery accountTypeQuery = new MemberAccountTypeQuery();
                    accountTypeQuery.setRelatedToGroups(canViewProfileOfGroups);
                    return this.accountTypeService.search(accountTypeQuery);
                }
                return Collections.emptyList();
            }
            case MEMBER_TO_SYSTEM_TT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.SYSTEM);
                ttQuery.setToAccountTypes(commonData.systemAccountTypes);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case MEMBER_TO_MEMBER_TT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.MEMBER);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                ArrayList<TransferType> memberMemberTTs = new ArrayList<TransferType>(this.transferTypeService.search(ttQuery));
                Iterator iter = memberMemberTTs.iterator();
                while (iter.hasNext()) {
                    TransferType.Context ctx = ((TransferType)iter.next()).getContext();
                    if (ctx.isPayment()) continue;
                    iter.remove();
                }
                return memberMemberTTs;
            }
            case MEMBER_TO_SELF_TT: {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.SELF_PAYMENT);
                ttQuery.setFromNature(AccountType.Nature.MEMBER);
                ttQuery.setToNature(AccountType.Nature.MEMBER);
                ttQuery.setFromAccountTypes(commonData.memberAccountTypes);
                ttQuery.setToAccountTypes(commonData.memberAccountTypes);
                return this.transferTypeService.search(ttQuery);
            }
            case RECORD_TYPES: {
                MemberRecordTypeQuery memberRecordTypeQuery = new MemberRecordTypeQuery();
                return this.memberRecordTypeService.search(memberRecordTypeQuery);
            }
            case CONVERSION_TT: {
                return this.transferTypeService.getConversionTTs();
            }
            case MESSAGE_CATEGORIES: {
                return this.messageCategoryService.listAll();
            }
        }
        throw new IllegalArgumentException("Unknown shared value: " + (Object)((Object)shared));
    }

    private Collection<? extends Entity> load(OperatorPermission permission) {
        MemberGroup loggedMemberGroup = (MemberGroup)((OperatorGroup)this.group).getMember().getGroup();
        if (permission.getParentPermissions().length > 0 && !this.permissionService.hasPermission(permission.getParentPermissions())) {
            return Collections.emptyList();
        }
        switch (permission) {
            case ACCOUNT_ACCOUNT_INFORMATION: {
                return loggedMemberGroup.getAccountTypes();
            }
            case GUARANTEES_ISSUE_GUARANTEES: {
                return loggedMemberGroup.getGuaranteeTypes();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
    }

    void load(Group group) {
        this.group = this.fetchService.fetch(group, FETCH);
        this.possibleValuesMap = new HashMap<Permission, Set<EntityVO>>();
        CommonDataBean commonData = null;
        if (group.getNature() != Group.Nature.OPERATOR) {
            commonData = new CommonDataBean(this.getSystemAccountTypes(), this.getMemberAccountTypes());
        }
        HashMap<SharedValue, Set<EntityVO>> loaded = new HashMap<SharedValue, Set<EntityVO>>();
        for (Permission permission : PermissionHelper.getMultivaluedPermissions(group.getNature())) {
            SharedValue shared = permissionSharedValueMap.get(permission);
            Set<EntityVO> values = (Set<EntityVO>)loaded.get((Object)shared);
            if (values == null) {
                Collection<? extends Entity> possibleValues;
                Class<?> clazz = permission.getClass();
                if (clazz == BrokerPermission.class) {
                    possibleValues = this.load(commonData, (BrokerPermission)permission);
                } else if (clazz == MemberPermission.class) {
                    possibleValues = this.load(commonData, (MemberPermission)permission);
                } else if (clazz == OperatorPermission.class) {
                    possibleValues = this.load((OperatorPermission)permission);
                } else if (clazz == AdminAdminPermission.class) {
                    possibleValues = this.load(commonData, (AdminAdminPermission)permission);
                } else if (clazz == AdminMemberPermission.class) {
                    possibleValues = this.load(commonData, (AdminMemberPermission)permission);
                } else if (clazz == AdminSystemPermission.class) {
                    possibleValues = this.load(commonData, (AdminSystemPermission)permission);
                } else {
                    throw new IllegalArgumentException("Unknown permission class: " + clazz);
                }
                values = EntityHelper.toEntityVO(possibleValues);
                if (shared != null) {
                    loaded.put(shared, values);
                }
            }
            this.possibleValuesMap.put(permission, values);
        }
    }

    static {
        permissionSharedValueMap.put(AdminMemberPermission.DOCUMENTS_DETAILS, SharedValue.DOCUMENTS);
        permissionSharedValueMap.put(MemberPermission.DOCUMENTS_VIEW, SharedValue.DOCUMENTS);
        permissionSharedValueMap.put(MemberPermission.ADS_VIEW, SharedValue.MEMBER_GROUPS);
        permissionSharedValueMap.put(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, SharedValue.MEMBER_GROUPS);
        permissionSharedValueMap.put(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, SharedValue.MEMBER_GROUPS);
        permissionSharedValueMap.put(MemberPermission.PROFILE_VIEW, SharedValue.MEMBER_GROUPS);
        permissionSharedValueMap.put(BrokerPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, SharedValue.ACCOUNT_TYPES);
        permissionSharedValueMap.put(MemberPermission.REPORTS_SHOW_ACCOUNT_INFORMATION, SharedValue.ACCOUNT_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, SharedValue.MEMBER_TO_SYSTEM_TT);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, SharedValue.MEMBER_TO_SYSTEM_TT);
        permissionSharedValueMap.put(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, SharedValue.MEMBER_TO_MEMBER_TT);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, SharedValue.MEMBER_TO_MEMBER_TT);
        permissionSharedValueMap.put(AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, SharedValue.MEMBER_TO_SELF_TT);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, SharedValue.MEMBER_TO_SELF_TT);
        permissionSharedValueMap.put(AdminAdminPermission.RECORDS_CREATE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminAdminPermission.RECORDS_MODIFY, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminAdminPermission.RECORDS_DELETE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminAdminPermission.RECORDS_VIEW, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.RECORDS_CREATE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.RECORDS_MODIFY, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.RECORDS_DELETE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.RECORDS_VIEW, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_RECORDS_CREATE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_RECORDS_MODIFY, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_RECORDS_DELETE, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(BrokerPermission.MEMBER_RECORDS_VIEW, SharedValue.RECORD_TYPES);
        permissionSharedValueMap.put(AdminMemberPermission.MESSAGES_VIEW, SharedValue.MESSAGE_CATEGORIES);
        permissionSharedValueMap.put(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION, SharedValue.MESSAGE_CATEGORIES);
    }

    private static enum SharedValue {
        DOCUMENTS,
        MEMBER_GROUPS,
        ACCOUNT_TYPES,
        MEMBER_TO_SYSTEM_TT,
        MEMBER_TO_MEMBER_TT,
        MEMBER_TO_SELF_TT,
        RECORD_TYPES,
        CONVERSION_TT,
        MESSAGE_CATEGORIES;

    }

    private static class CommonDataBean {
        private final Collection<SystemAccountType> systemAccountTypes;
        private final Collection<MemberAccountType> memberAccountTypes;

        private CommonDataBean(Collection<SystemAccountType> systemAccountTypes, Collection<MemberAccountType> memberAccountTypes) {
            this.memberAccountTypes = memberAccountTypes;
            this.systemAccountTypes = systemAccountTypes;
        }
    }
}

