/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AbstractPermissionCheck;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionCatalogHandlerImpl;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.permissions.exceptions.PermissionCatalogInitializationException;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionCatalogHandler;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PermissionServiceImpl
implements PermissionServiceLocal,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(PermissionServiceImpl.class);
    private FetchServiceLocal fetchService;
    private GroupServiceLocal groupService;
    private CacheManager cacheManager;
    private ApplicationContext applicationContext;

    private static void debug(Group group, List<Permission> permissions, boolean result) {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Checked [");
            for (int i = 0; i < permissions.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(permissions.get(i).getValue());
            }
            sb.append("] for group id=" + group.getId() + " (" + group.getName() + ")");
            sb.append(" with result ").append(result);
            LOG.debug((Object)sb.toString());
        }
    }

    private static void debug(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        }
    }

    @Override
    public void checkManages(Element element) throws PermissionDeniedException {
        if (!this.manages(element)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public void checkManages(Group group) throws PermissionDeniedException {
        if (!this.manages(group)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public void checkRelatesTo(Element element) throws PermissionDeniedException {
        if (!this.relatesTo(element)) {
            throw new PermissionDeniedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictCache(Group group) {
        this.getAllVisibleGroupsCache().clear();
        this.getManagedMemberGroupsCache().clear();
        this.getVisibleMemberGroupsCache().clear();
        group = this.fetchService.fetch(group, new Relationship[0]);
        Cache cache = this.getPermissionsCache();
        cache.remove(group.getId());
        if (group instanceof MemberGroup) {
            MemberGroup memberGroup = (MemberGroup)group;
            List<OperatorGroup> operatorGroups = this.groupService.iterateOperatorGroups(memberGroup);
            try {
                for (OperatorGroup operatorGroup : operatorGroups) {
                    cache.remove(operatorGroup.getId());
                }
            }
            finally {
                DataIteratorHelper.close(operatorGroups);
            }
        }
    }

    @Override
    public Collection<Group> getAllVisibleGroups() {
        CacheKey cacheKey = CacheKey.fromLoggedUser();
        Collection groups = (Collection)this.getAllVisibleGroupsCache().get(cacheKey, new CacheCallback(){

            @Override
            public Object retrieve() {
                if (LoggedUser.getAccessType() == null) {
                    return PermissionServiceImpl.this.groupService.getPossibleInitialGroups(null);
                }
                ArrayList<Group> result = new ArrayList<Group>();
                if (LoggedUser.isSystem() || PermissionServiceImpl.this.hasPermission(AdminAdminPermission.ADMINS_REGISTER, AdminAdminPermission.ADMINS_CHANGE_PROFILE)) {
                    GroupQuery query = new GroupQuery();
                    query.setNatures(Group.Nature.ADMIN);
                    result.addAll(PermissionServiceImpl.this.groupService.search(query));
                }
                if (LoggedUser.hasUser()) {
                    result.add((Group)LoggedUser.group());
                }
                result.addAll(PermissionServiceImpl.this.getVisibleMemberGroups());
                return result;
            }
        });
        if (this.hasPermission(MemberPermission.OPERATORS_MANAGE)) {
            GroupQuery query = new GroupQuery();
            query.setNature(Group.Nature.OPERATOR);
            query.setMember(LoggedUser.member());
            groups.addAll(this.groupService.search(query));
        }
        return groups;
    }

    @Override
    public Collection<MemberGroup> getManagedMemberGroups() {
        CacheKey cacheKey = CacheKey.fromLoggedUser();
        return (Collection)this.getManagedMemberGroupsCache().get(cacheKey, new CacheCallback(){

            @Override
            public Object retrieve() {
                if (LoggedUser.isSystemOrUnrestrictedClient() || LoggedUser.isAdministrator()) {
                    return PermissionServiceImpl.this.getVisibleMemberGroups();
                }
                if (LoggedUser.isBroker()) {
                    HashSet<MemberGroup> groups = new HashSet<MemberGroup>();
                    groups.addAll(PermissionServiceImpl.this.getVisibleMemberGroups());
                    MemberGroup group = (MemberGroup)LoggedUser.group();
                    groups.add(group);
                    return groups;
                }
                return Collections.singleton(LoggedUser.member().getMemberGroup());
            }
        });
    }

    @Override
    public PermissionCatalogHandler getPermissionCatalogHandler(Group group) {
        AutowireCapableBeanFactory factory = this.applicationContext.getAutowireCapableBeanFactory();
        try {
            PermissionCatalogHandlerImpl handler = (PermissionCatalogHandlerImpl)factory.createBean(PermissionCatalogHandlerImpl.class, 1, false);
            handler.load(group);
            return handler;
        }
        catch (Exception e) {
            throw new PermissionCatalogInitializationException(group.getNature(), e.getMessage(), e);
        }
    }

    @Override
    public Collection<MemberGroup> getVisibleMemberGroups() {
        return this.getVisibleMemberGroups(true);
    }

    @Override
    public Collection<MemberGroup> getVisibleMemberGroups(final boolean addLoggedMemberGroup) {
        CacheKey cacheKey = CacheKey.fromLoggedUser(Boolean.valueOf(addLoggedMemberGroup));
        return (Collection)this.getVisibleMemberGroupsCache().get(cacheKey, new CacheCallback(){

            @Override
            public Object retrieve() {
                if (LoggedUser.getAccessType() == null) {
                    return PermissionServiceImpl.this.groupService.getPossibleInitialGroups(null);
                }
                boolean isSystem = LoggedUser.isSystem();
                boolean isUnrestrictedClient = LoggedUser.isUnrestrictedClient();
                if (isSystem || isUnrestrictedClient) {
                    GroupQuery query = new GroupQuery();
                    query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                    if (isUnrestrictedClient) {
                        query.setStatus(Group.Status.NORMAL);
                        query.setOnlyActive(true);
                    }
                    return PermissionServiceImpl.this.groupService.search(query);
                }
                Object group = LoggedUser.group();
                if (group instanceof AdminGroup) {
                    return PermissionServiceImpl.this.fetchService.fetch((AdminGroup)group, AdminGroup.Relationships.MANAGES_GROUPS).getManagesGroups();
                }
                HashSet<MemberGroup> memberGroups = new HashSet<MemberGroup>();
                MemberGroup memberGroup = PermissionServiceImpl.this.fetchService.fetch(LoggedUser.member().getMemberGroup(), MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS);
                if (addLoggedMemberGroup) {
                    memberGroups.add(memberGroup);
                }
                memberGroups.addAll(memberGroup.getCanViewProfileOfGroups());
                if (LoggedUser.isBroker()) {
                    BrokerGroup brokerGroup = (BrokerGroup)PermissionServiceImpl.this.fetchService.fetch(LoggedUser.group(), new Relationship[]{BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS});
                    memberGroups.addAll(brokerGroup.getPossibleInitialGroups());
                }
                return memberGroups;
            }
        });
    }

    @Override
    public boolean hasPermission(Group group, Module module) {
        return this.ensureGroupPermissions(group).containsKey((Object)module);
    }

    @Override
    public boolean hasPermission(Group group, Permission ... permissions) {
        return this.hasPermission(group, Arrays.asList(permissions), Collections.<Permission, AbstractPermissionCheck.RequiredValuesBean>emptyMap());
    }

    @Override
    public boolean hasPermission(Module module) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        if (LoggedUser.isUnrestrictedClient()) {
            return module.getType() == ModuleType.MEMBER;
        }
        return this.hasPermission((Group)LoggedUser.group(), module);
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        if (LoggedUser.isUnrestrictedClient()) {
            if (permissions == null || permissions.length == 0) {
                return false;
            }
            for (Permission p : permissions) {
                if (p.getModule().getType() != ModuleType.MEMBER) continue;
                return true;
            }
            return false;
        }
        return this.hasPermission((Group)LoggedUser.group(), permissions);
    }

    @Override
    public boolean hasPermissionFor(Group group, Permission permission, Entity ... required) {
        if (permission.relationship() == null) {
            throw new IllegalArgumentException(String.format("Invalid permission: %1$s.%2$s. The permission must has a relationship to allow ensuring entity membership", permission.getClass().getSimpleName(), permission));
        }
        return this.hasPermission(group, Collections.singletonList(permission), Collections.singletonMap(permission, new AbstractPermissionCheck.RequiredValuesBean(permission, required)));
    }

    @Override
    public boolean hasPermissionFor(Permission permission, Entity ... required) {
        if (permission.relationship() == null) {
            throw new IllegalArgumentException(String.format("Invalid permission: %1$s.%2$s. The permission must has a relationship to allow ensuring entity membership", permission.getClass().getSimpleName(), permission));
        }
        boolean hasPermission = this.hasPermission(permission);
        if (!hasPermission) {
            return false;
        }
        if (LoggedUser.isSystemOrUnrestrictedClient()) {
            return true;
        }
        return this.checkRequiredValues((Group)LoggedUser.group(), permission, required);
    }

    @Override
    public boolean manages(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (LoggedUser.isSystem()) {
            return true;
        }
        element = this.fetchService.fetch(element, Element.Relationships.GROUP);
        if (LoggedUser.isUnrestrictedClient()) {
            return element instanceof Member && ((Member)element).isActive();
        }
        Object logged = LoggedUser.element();
        if (((Entity)logged).equals(element)) {
            return true;
        }
        if (logged instanceof Administrator) {
            AdminGroup group = (AdminGroup)LoggedUser.group();
            if (element instanceof Administrator) {
                return this.hasPermission((Group)group, AdminAdminPermission.ADMINS_VIEW);
            }
            if (element instanceof Member) {
                Collection<MemberGroup> managedGroups = this.fetchService.fetch(group, AdminGroup.Relationships.MANAGES_GROUPS).getManagesGroups();
                return managedGroups.contains(element.getGroup());
            }
        } else if (logged instanceof Member) {
            if (element instanceof Member) {
                return ((Entity)logged).equals(((Member)element).getBroker());
            }
            if (element instanceof Operator) {
                return ((Entity)logged).equals(((Operator)element).getMember());
            }
        } else if (logged instanceof Operator) {
            return ((Operator)logged).getMember().equals(element);
        }
        return false;
    }

    @Override
    public boolean manages(Group group) {
        if (group instanceof AdminGroup) {
            return this.permission().admin(AdminAdminPermission.ADMINS_REGISTER, AdminAdminPermission.ADMINS_CHANGE_PROFILE).hasPermission();
        }
        if (group instanceof MemberGroup) {
            return this.getManagedMemberGroups().contains(group);
        }
        if (group instanceof OperatorGroup) {
            OperatorGroup operatorGroup = (OperatorGroup)group;
            return LoggedUser.isSystem() || LoggedUser.isMember() && ((Entity)LoggedUser.element()).equals(operatorGroup.getMember());
        }
        return false;
    }

    @Override
    public PermissionCheck permission() {
        if (LoggedUser.isSystemOrUnrestrictedClient()) {
            return new AbstractPermissionCheck(){

                @Override
                protected boolean doHasPermission() {
                    if (LoggedUser.isSystem()) {
                        return true;
                    }
                    return this.memberPermissions != null;
                }
            };
        }
        return this.permission((Group)LoggedUser.group());
    }

    @Override
    public PermissionCheck permission(final Element element) {
        return new AbstractPermissionCheck(){

            @Override
            public boolean doHasPermission() {
                if (element == null) {
                    throw new NullPointerException("Checking permission over a null element");
                }
                if (LoggedUser.isSystem()) {
                    PermissionServiceImpl.debug("Checking permission as system. Assuming true");
                    return true;
                }
                boolean canManage = PermissionServiceImpl.this.manages(element);
                PermissionServiceImpl.debug("Checking management over " + element + (LoggedUser.isWebService() ? " (as webservice)" : "") + ". Result is " + canManage);
                if (!canManage) {
                    return false;
                }
                if (LoggedUser.isUnrestrictedClient()) {
                    return this.memberPermissions != null;
                }
                Object logged = LoggedUser.element();
                Group group = ((Element)logged).getGroup();
                ModuleType onlyOfType = this.getModuleTypeFilter((Element)logged, element);
                List<Permission> permissions = this.getPermissions(group.getNature(), onlyOfType);
                return PermissionServiceImpl.this.hasPermissionOrIsEmpty(group, permissions, this.requiredValuesMap);
            }

            private ModuleType getModuleTypeFilter(Element logged, Element element2) {
                if (logged instanceof Administrator) {
                    if (element2 instanceof Administrator) {
                        return ModuleType.ADMIN_ADMIN;
                    }
                    if (element2 instanceof Member) {
                        return ModuleType.ADMIN_MEMBER;
                    }
                } else if (logged instanceof Member) {
                    if (element2 instanceof Operator) {
                        return ModuleType.MEMBER;
                    }
                    Member toCheck = PermissionServiceImpl.this.fetchService.fetch((Member)element2, Member.Relationships.BROKER);
                    if (logged.equals(toCheck.getBroker())) {
                        return ModuleType.BROKER;
                    }
                    return ModuleType.MEMBER;
                }
                return null;
            }
        };
    }

    @Override
    public PermissionCheck permission(final Group group) {
        return new AbstractPermissionCheck(){

            @Override
            public boolean doHasPermission() {
                return PermissionServiceImpl.this.hasPermissionOrIsEmpty(group, this.getPermissions(group.getNature(), null), this.requiredValuesMap);
            }
        };
    }

    @Override
    public boolean relatesTo(Element element) {
        if (this.manages(element)) {
            return true;
        }
        if (LoggedUser.isUnrestrictedClient()) {
            return false;
        }
        element = this.fetchService.fetch(element, Element.Relationships.GROUP);
        Object logged = LoggedUser.element();
        if (element instanceof Member) {
            Member loggedMember = null;
            if (logged instanceof Member) {
                loggedMember = (Member)logged;
            } else if (logged instanceof Operator) {
                loggedMember = ((Operator)logged).getMember();
            }
            if (loggedMember != null) {
                MemberGroup memberGroup = this.fetchService.fetch(loggedMember, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS)).getMemberGroup();
                return memberGroup.getCanViewProfileOfGroups().contains(element.getGroup());
            }
        } else if (element instanceof Operator && logged instanceof Operator) {
            return ((Operator)element).getMember().equals(((Operator)logged).getMember());
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    private boolean checkRequiredValues(Group group, MemberGroup memberGroup, Permission permission, Map<Permission, AbstractPermissionCheck.RequiredValuesBean> requiredValues) {
        if (requiredValues == null) {
            return true;
        }
        AbstractPermissionCheck.RequiredValuesBean required = requiredValues.get(permission);
        if (required == null) {
            return true;
        }
        if (group.getNature() == Group.Nature.OPERATOR && required.getPermission().getModule().getType() == ModuleType.MEMBER) {
            group = memberGroup;
        }
        return this.checkRequiredValues(group, required.getPermission(), required.getEntities());
    }

    private boolean checkRequiredValues(Group group, Permission permission, Entity[] required) {
        if (required == null || required.length == 0) {
            return true;
        }
        group = this.fetchService.fetch(group, permission.relationship());
        Collection<? extends Entity> allowed = PermissionHelper.getAllowedValues(group, permission);
        boolean found = true;
        for (int i = 0; i < required.length && found; ++i) {
            found = allowed.contains(required[i]);
        }
        return found;
    }

    private Map<Module, SortedSet<Permission>> ensureGroupPermissions(Group group) {
        final Long id = group.getId();
        return (Map)this.getPermissionsCache().get(id, new CacheCallback(){

            @Override
            public Object retrieve() {
                HashMap groupPermissions = new HashMap();
                Group group = EntityHelper.reference(Group.class, id);
                group = PermissionServiceImpl.this.fetchService.reload(group, Group.Relationships.PERMISSIONS, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
                boolean isOperatorGroup = group.getNature() == Group.Nature.OPERATOR;
                for (Permission permission : group.getPermissions()) {
                    TreeSet<Permission> modulePermissions = (TreeSet<Permission>)groupPermissions.get((Object)permission.getModule());
                    if (modulePermissions == null) {
                        modulePermissions = new TreeSet<Permission>();
                        groupPermissions.put(permission.getModule(), modulePermissions);
                    }
                    boolean addPermission = true;
                    if (isOperatorGroup) {
                        if (!ModuleType.getModuleTypes(group.getNature()).contains(permission.getModule().getType())) {
                            throw new IllegalStateException("Invalid permission for operator group: " + permission);
                        }
                        MemberGroup memberGroup = ((OperatorGroup)group).getMember().getMemberGroup();
                        if (PermissionServiceImpl.this.hasPermission((Group)memberGroup, MemberPermission.OPERATORS_MANAGE)) {
                            if (permission instanceof OperatorPermission) {
                                MemberPermission memberPermission;
                                MemberPermission[] arr$ = ((OperatorPermission)permission).getParentPermissions();
                                int len$ = arr$.length;
                                for (int i$ = 0; i$ < len$ && !(addPermission = PermissionServiceImpl.this.hasPermission((Group)memberGroup, memberPermission = arr$[i$])); ++i$) {
                                }
                            }
                        } else {
                            addPermission = false;
                        }
                    }
                    if (!addPermission) continue;
                    modulePermissions.add(permission);
                }
                return groupPermissions;
            }
        });
    }

    private Cache getAllVisibleGroupsCache() {
        return this.cacheManager.getCache("cyclos.AllVisibleGroups");
    }

    private Cache getManagedMemberGroupsCache() {
        return this.cacheManager.getCache("cyclos.ManagedMemberGroups");
    }

    private Cache getPermissionsCache() {
        return this.cacheManager.getCache("cyclos.Permissions");
    }

    private Cache getVisibleMemberGroupsCache() {
        return this.cacheManager.getCache("cyclos.VisibleMemberGroups");
    }

    private boolean hasPermission(Group group, List<Permission> permissions, Map<Permission, AbstractPermissionCheck.RequiredValuesBean> requiredValues) {
        boolean result = false;
        if (permissions != null) {
            MemberGroup memberGroup = null;
            if (group.getNature() == Group.Nature.OPERATOR) {
                OperatorGroup operatorGroup = this.fetchService.fetch((OperatorGroup)group, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
                memberGroup = operatorGroup.getMember().getMemberGroup();
            }
            for (Permission permission : permissions) {
                Map<Module, SortedSet<Permission>> groupPermissions;
                SortedSet<Permission> permissionsSet;
                Group groupToCheck = group;
                if (group.getNature() == Group.Nature.OPERATOR && permission.getModule().getType() == ModuleType.MEMBER) {
                    groupToCheck = memberGroup;
                }
                if ((permissionsSet = (groupPermissions = this.ensureGroupPermissions(groupToCheck)).get((Object)permission.getModule())) == null || !permissionsSet.contains(permission) || !(result = this.checkRequiredValues(groupToCheck, memberGroup, permission, requiredValues))) continue;
                break;
            }
        }
        return result;
    }

    private boolean hasPermissionOrIsEmpty(Group group, List<Permission> permissions, Map<Permission, AbstractPermissionCheck.RequiredValuesBean> requiredValues) {
        if (permissions == null) {
            return false;
        }
        if (permissions.isEmpty()) {
            PermissionServiceImpl.debug("Passing with empty permissions on group id=" + group.getId() + " (" + group.getName() + ")");
            return true;
        }
        boolean result = this.hasPermission(group, permissions, requiredValues);
        PermissionServiceImpl.debug(group, permissions, result);
        return result;
    }

    private static class CacheKey
    implements Serializable {
        private static final long serialVersionUID = -7967894427520131064L;
        private final LoggedUser.AccessType accessType;
        private final Group group;
        private final Serializable qualifier;

        public static CacheKey fromLoggedUser() {
            return CacheKey.fromLoggedUser(null);
        }

        public static CacheKey fromLoggedUser(Serializable qualifier) {
            LoggedUser.AccessType accessType = LoggedUser.getAccessType();
            Object group = LoggedUser.hasUser() ? LoggedUser.group() : null;
            return new CacheKey(accessType, (Group)group, qualifier);
        }

        public CacheKey(LoggedUser.AccessType accessType, Group group, Serializable qualifier) {
            this.accessType = accessType;
            this.group = group;
            this.qualifier = qualifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)obj;
            return this.accessType == key.accessType && ObjectUtils.equals((Object)this.group, (Object)key.group) && ObjectUtils.equals((Object)this.qualifier, (Object)key.qualifier);
        }

        public int hashCode() {
            return 13 * (this.accessType == null ? 1 : this.accessType.hashCode()) * (this.group == null ? 1 : this.group.hashCode() * (this.qualifier == null ? 1 : this.qualifier.hashCode()));
        }

        public String toString() {
            return (this.accessType == null ? "Guest" : this.accessType.name()) + (this.group == null ? "" : "#" + this.group.getId());
        }
    }
}

