/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.permissions;

import java.util.Collection;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.utils.access.PermissionCatalogHandler;

public class PermissionServiceSecurity
extends BaseServiceSecurity
implements PermissionService {
    @Override
    public void checkManages(Element element) throws PermissionDeniedException {
        this.permissionService.checkManages(element);
    }

    @Override
    public void checkManages(Group group) throws PermissionDeniedException {
        this.permissionService.checkManages(group);
    }

    @Override
    public void checkRelatesTo(Element element) throws PermissionDeniedException {
        this.permissionService.checkRelatesTo(element);
    }

    @Override
    public Collection<Group> getAllVisibleGroups() {
        return this.permissionService.getAllVisibleGroups();
    }

    @Override
    public Collection<MemberGroup> getManagedMemberGroups() {
        return this.permissionService.getManagedMemberGroups();
    }

    @Override
    public PermissionCatalogHandler getPermissionCatalogHandler(Group group) {
        PermissionCheck check = this.permissionService.permission();
        switch (group.getNature()) {
            case ADMIN: {
                check.admin(AdminSystemPermission.GROUPS_MANAGE_ADMIN);
                break;
            }
            case BROKER: {
                check.admin(AdminSystemPermission.GROUPS_MANAGE_BROKER);
                break;
            }
            case MEMBER: {
                check.admin(AdminSystemPermission.GROUPS_MANAGE_MEMBER);
                break;
            }
            case OPERATOR: {
                check.member(MemberPermission.OPERATORS_MANAGE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported group's nature: " + (Object)((Object)group.getNature()));
            }
        }
        check.check();
        return this.permissionService.getPermissionCatalogHandler(group);
    }

    @Override
    public Collection<MemberGroup> getVisibleMemberGroups() {
        return this.permissionService.getVisibleMemberGroups();
    }

    @Override
    public boolean hasPermission(Module module) {
        return this.permissionService.hasPermission(module);
    }

    @Override
    public boolean hasPermission(Permission ... permission) {
        return this.permissionService.hasPermission(permission);
    }

    @Override
    public boolean hasPermissionFor(Permission permission, Entity ... required) {
        return this.permissionService.hasPermissionFor(permission, required);
    }

    @Override
    public boolean manages(Element element) {
        return this.permissionService.manages(element);
    }

    @Override
    public boolean manages(Group group) {
        return false;
    }

    @Override
    public PermissionCheck permission() {
        return this.permissionService.permission();
    }

    @Override
    public PermissionCheck permission(Element element) {
        return this.permissionService.permission(element);
    }

    @Override
    public boolean relatesTo(Element element) {
        return this.permissionService.relatesTo(element);
    }
}

