/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.dao.members.AdminNotificationPreferenceDAO;
import nl.strohalm.cyclos.dao.members.NotificationPreferenceDAO;
import nl.strohalm.cyclos.dao.members.brokerings.DefaultBrokerCommissionDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.preferences.AdminNotificationPreference;
import nl.strohalm.cyclos.entities.members.preferences.AdminNotificationPreferenceQuery;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.elements.ReferenceServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.preferences.MessageChannel;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.springframework.transaction.TransactionStatus;

public class PreferenceServiceImpl
implements PreferenceServiceLocal {
    private TransactionHelper transactionHelper;
    private AdminNotificationPreferenceDAO adminNotificationPreferenceDao;
    private DefaultBrokerCommissionDAO defaultBrokerCommissionDao;
    private FetchServiceLocal fetchService;
    private NotificationPreferenceDAO notificationPreferenceDao;
    private AccountServiceLocal accountService;
    private MemberServiceLocal memberService;
    private ReferenceServiceLocal referenceService;
    private GuaranteeServiceLocal guaranteeService;
    private GuaranteeTypeServiceLocal guaranteeTypeService;
    private PermissionServiceLocal permissionService;

    @Override
    public MemberSmsStatus getMemberSmsStatus(Member member) {
        return this.memberService.getSmsStatus(member, false);
    }

    @Override
    public List<Administrator> listAdminsForNotification(AdminNotificationPreferenceQuery query) {
        return this.adminNotificationPreferenceDao.searchAdmins(query);
    }

    @Override
    public List<Message.Type> listNotificationTypes(Member member) {
        ArrayList<Message.Type> types = new ArrayList<Message.Type>(Arrays.asList(Message.Type.values()));
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Message.Type type = (Message.Type)iterator.next();
            if (this.useType(type, member)) continue;
            iterator.remove();
        }
        return types;
    }

    @Override
    public AdminNotificationPreference load(Administrator admin, Relationship ... fetch) {
        return this.adminNotificationPreferenceDao.load(admin, fetch);
    }

    @Override
    public Collection<NotificationPreference> load(Member member) {
        return this.notificationPreferenceDao.load(member);
    }

    public List<DefaultBrokerCommission> load(Member broker, Relationship ... fetch) {
        return this.defaultBrokerCommissionDao.load(broker, fetch);
    }

    @Override
    public NotificationPreference load(Member member, Message.Type type) {
        Collection<NotificationPreference> preferences = this.load(member);
        for (NotificationPreference preference : preferences) {
            if (preference.getType() != type) continue;
            return preference;
        }
        return null;
    }

    @Override
    public Set<MessageChannel> receivedChannels(Member member, Message.Type type) {
        try {
            NotificationPreference preference = this.notificationPreferenceDao.load(member, type);
            EnumSet<MessageChannel> channels = EnumSet.noneOf(MessageChannel.class);
            if (preference.isEmail()) {
                channels.add(MessageChannel.EMAIL);
            }
            if (preference.isMessage()) {
                channels.add(MessageChannel.MESSAGE);
            }
            if (preference.isSms()) {
                channels.add(MessageChannel.SMS);
            }
            return channels;
        }
        catch (EntityNotFoundException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public boolean receivesMessage(Member member, Message.Type type) {
        try {
            NotificationPreference preference = this.notificationPreferenceDao.load(member, type);
            return preference.isEmail() || preference.isMessage() || preference.isSms();
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public AdminNotificationPreference save(AdminNotificationPreference preference) {
        Administrator loggedAdmin = (Administrator)LoggedUser.element();
        preference.setAdmin(loggedAdmin);
        try {
            AdminNotificationPreference current = this.load(loggedAdmin, new Relationship[0]);
            preference.setId(current.getId());
            return this.adminNotificationPreferenceDao.update(preference);
        }
        catch (EntityNotFoundException e) {
            return this.adminNotificationPreferenceDao.insert(preference);
        }
    }

    @Override
    public void save(Member member, Collection<NotificationPreference> prefs) {
        member = this.fetchService.fetch(member, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.SMS_MESSAGES));
        Collection<Message.Type> smsMessages = member.getMemberGroup().getSmsMessages();
        for (NotificationPreference preference : prefs) {
            if (preference.isSms() && !smsMessages.contains(preference.getType())) {
                preference.setSms(false);
            }
            preference.setMember(member);
            this.save(preference);
        }
    }

    @Override
    public MemberSmsStatus saveSmsStatusPreferences(final Member member, final boolean isAcceptFreeMailing, final boolean isAcceptPaidMailing, final boolean isAllowChargingSms, final boolean hasNotificationsBySms) {
        return this.transactionHelper.runInNewTransaction(new Transactional<MemberSmsStatus>(){

            @Override
            public MemberSmsStatus afterCommit(MemberSmsStatus result) {
                return PreferenceServiceImpl.this.fetchService.fetch(result, new Relationship[0]);
            }

            public MemberSmsStatus doInTransaction(TransactionStatus status) {
                MemberSmsStatus memberSmsStatus = PreferenceServiceImpl.this.memberService.getSmsStatus(member, true);
                memberSmsStatus.setAcceptFreeMailing(isAcceptFreeMailing);
                memberSmsStatus.setAcceptPaidMailing(isAcceptPaidMailing);
                memberSmsStatus.setAllowChargingSms(isAllowChargingSms);
                PreferenceServiceImpl.this.memberService.ensureAllowChargingSms(memberSmsStatus, hasNotificationsBySms);
                return PreferenceServiceImpl.this.memberService.updateSmsStatus(memberSmsStatus);
            }
        });
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAdminNotificationPreferenceDao(AdminNotificationPreferenceDAO adminNotificationPreferenceDao) {
        this.adminNotificationPreferenceDao = adminNotificationPreferenceDao;
    }

    public void setDefaultBrokerCommissionDao(DefaultBrokerCommissionDAO brokerPreferenceDao) {
        this.defaultBrokerCommissionDao = brokerPreferenceDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setGuaranteeTypeServiceLocal(GuaranteeTypeServiceLocal guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }

    public void setNotificationPreferenceDao(NotificationPreferenceDAO notificationPreferenceDAO) {
        this.notificationPreferenceDao = notificationPreferenceDAO;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setReferenceServiceLocal(ReferenceServiceLocal referenceService) {
        this.referenceService = referenceService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    private NotificationPreference save(NotificationPreference notificationPreference) {
        notificationPreference = notificationPreference.isTransient() ? this.notificationPreferenceDao.insert(notificationPreference) : this.notificationPreferenceDao.update(notificationPreference);
        return notificationPreference;
    }

    private boolean useType(Message.Type type, Member member) {
        boolean useType;
        MemberGroup group = member.getMemberGroup();
        block0 : switch (type) {
            case ACCOUNT: {
                List<? extends Account> accounts = this.accountService.getAccounts(member, new Relationship[0]);
                useType = !accounts.isEmpty();
                break;
            }
            case AD_EXPIRATION: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.ADS_PUBLISH);
                break;
            }
            case AD_INTEREST: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.PREFERENCES_MANAGE_AD_INTERESTS);
                break;
            }
            case BROKERING: {
                useType = member.getGroup().getNature() == Group.Nature.BROKER || member.getBroker() != null;
                break;
            }
            case FROM_MEMBER: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.PROFILE_VIEW);
                break;
            }
            case INVOICE: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.INVOICES_VIEW);
                break;
            }
            case LOAN: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.LOANS_VIEW);
                break;
            }
            case PAYMENT: {
                useType = this.permissionService.hasPermission((Group)group, Module.MEMBER_PAYMENTS);
                break;
            }
            case EXTERNAL_PAYMENT: {
                useType = false;
                for (Channel channel : group.getChannels()) {
                    if (!Channel.listBuiltin().contains(channel.getInternalName())) continue;
                    useType = true;
                    break block0;
                }
                break;
            }
            case REFERENCE: {
                useType = this.permissionService.hasPermission((Group)group, MemberPermission.REFERENCES_VIEW);
                break;
            }
            case TRANSACTION_FEEDBACK: {
                Collection<Reference.Nature> referenceNatures = this.referenceService.getNaturesByGroup(member.getMemberGroup());
                useType = referenceNatures.contains(Reference.Nature.TRANSACTION);
                break;
            }
            case CERTIFICATION: {
                useType = this.guaranteeService.isBuyer() || this.permissionService.hasPermission((Group)group, MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS);
                break;
            }
            case GUARANTEE: {
                useType = this.guaranteeTypeService.areEnabledGuaranteeTypes();
                break;
            }
            case PAYMENT_OBLIGATION: {
                useType = this.guaranteeService.isBuyer() || this.guaranteeService.isSeller();
                break;
            }
            default: {
                useType = true;
            }
        }
        return useType;
    }
}

