/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.preferences.AdminNotificationPreference;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.services.preferences.PreferenceService;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.collections.CollectionUtils;

public class PreferenceServiceSecurity
extends BaseServiceSecurity
implements PreferenceService {
    private PreferenceServiceLocal preferenceService;
    private TransferTypeServiceLocal transferTypeService;
    private GuaranteeTypeServiceLocal guaranteeTypeService;

    private static <T> Set<T> filterAllowed(Collection<T> elements, Collection<T> allowed) {
        if (CollectionUtils.isEmpty(allowed)) {
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(elements)) {
            return Collections.emptySet();
        }
        elements.retainAll(allowed);
        return new HashSet<T>(elements);
    }

    @Override
    public MemberSmsStatus getMemberSmsStatus(Member member) {
        this.checkManage(member);
        return this.preferenceService.getMemberSmsStatus(member);
    }

    @Override
    public List<Message.Type> listNotificationTypes(Member member) {
        this.checkManage(member);
        return this.preferenceService.listNotificationTypes(member);
    }

    @Override
    public AdminNotificationPreference load(Administrator admin, Relationship ... fetch) {
        if (!((Entity)LoggedUser.element()).equals(admin)) {
            throw new PermissionDeniedException();
        }
        return this.preferenceService.load(admin, fetch);
    }

    @Override
    public Collection<NotificationPreference> load(Member member) {
        this.checkManage(member);
        return this.preferenceService.load(member);
    }

    @Override
    public NotificationPreference load(Member member, Message.Type type) {
        this.permissionService.permission(member).admin(AdminMemberPermission.MESSAGES_SEND_TO_MEMBER).member(MemberPermission.MESSAGES_SEND_TO_MEMBER).operator(OperatorPermission.MESSAGES_SEND_TO_MEMBER).check();
        return this.preferenceService.load(member, type);
    }

    @Override
    public AdminNotificationPreference save(AdminNotificationPreference preference) {
        preference.setTransferTypes(PreferenceServiceSecurity.filterAllowed(preference.getTransferTypes(), this.transferTypeService.getPaymentAndSelfPaymentTTs()));
        preference.setNewPendingPayments(PreferenceServiceSecurity.filterAllowed(preference.getNewPendingPayments(), this.transferTypeService.getAuthorizableTTs()));
        List<Object> allowedGuaranteeTypes = Collections.emptyList();
        if (this.permissionService.hasPermission(AdminSystemPermission.GUARANTEE_TYPES_VIEW)) {
            GuaranteeTypeQuery guaranteeTypeQuery = new GuaranteeTypeQuery();
            guaranteeTypeQuery.setEnabled(true);
            allowedGuaranteeTypes = this.guaranteeTypeService.search(guaranteeTypeQuery);
        }
        preference.setGuaranteeTypes(PreferenceServiceSecurity.filterAllowed(preference.getGuaranteeTypes(), allowedGuaranteeTypes));
        Collection<MemberGroup> allowedInitialGroups = this.permissionService.getManagedMemberGroups();
        preference.setNewMembers(PreferenceServiceSecurity.filterAllowed(preference.getNewMembers(), allowedInitialGroups));
        return this.preferenceService.save(preference);
    }

    @Override
    public void save(Member member, Collection<NotificationPreference> prefs) {
        this.checkManage(member);
        this.preferenceService.save(member, prefs);
    }

    @Override
    public MemberSmsStatus saveSmsStatusPreferences(Member member, boolean isAcceptFreeMailing, boolean isAcceptPaidMailing, boolean isAllowChargingSms, boolean hasNotificationsBySms) {
        this.checkManage(member);
        return this.preferenceService.saveSmsStatusPreferences(member, isAcceptFreeMailing, isAcceptPaidMailing, isAllowChargingSms, hasNotificationsBySms);
    }

    public void setGuaranteeTypeServiceLocal(GuaranteeTypeServiceLocal guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    private void checkManage(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).broker(BrokerPermission.PREFERENCES_MANAGE_NOTIFICATIONS).member(MemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).check();
    }
}

