/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.preferences;

import java.util.List;
import nl.strohalm.cyclos.dao.members.ReceiptPrinterSettingsDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class ReceiptPrinterSettingsServiceImpl
implements ReceiptPrinterSettingsServiceLocal {
    private ReceiptPrinterSettingsDAO receiptPrinterSettingsDao;
    private Validator validator;

    @Override
    public boolean belongsToTheLoggedUser(Long id) {
        if (id == null) {
            return false;
        }
        try {
            ReceiptPrinterSettings settings = (ReceiptPrinterSettings)this.receiptPrinterSettingsDao.load(id, ReceiptPrinterSettings.Relationships.MEMBER);
            return settings.getMember().equals(LoggedUser.member());
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<ReceiptPrinterSettings> list() {
        Member member = LoggedUser.hasUser() ? LoggedUser.member() : null;
        return this.receiptPrinterSettingsDao.listByMember(member);
    }

    @Override
    public ReceiptPrinterSettings load(Long id) {
        return (ReceiptPrinterSettings)this.receiptPrinterSettingsDao.load(id, new Relationship[0]);
    }

    @Override
    public void remove(Long id) {
        this.receiptPrinterSettingsDao.delete(id);
    }

    @Override
    public ReceiptPrinterSettings save(ReceiptPrinterSettings receiptPrinterSettings) {
        this.validate(receiptPrinterSettings);
        if (receiptPrinterSettings.isPersistent()) {
            return this.receiptPrinterSettingsDao.update(receiptPrinterSettings);
        }
        return this.receiptPrinterSettingsDao.insert(receiptPrinterSettings);
    }

    public void setReceiptPrinterSettingsDao(ReceiptPrinterSettingsDAO receiptPrinterSettingsDao) {
        this.receiptPrinterSettingsDao = receiptPrinterSettingsDao;
    }

    @Override
    public void validate(ReceiptPrinterSettings receiptPrinterSettings) throws ValidationException {
        this.getValidator().validate(receiptPrinterSettings);
    }

    private Validator getValidator() {
        if (this.validator == null) {
            Validator validator = new Validator("receiptPrinterSettings");
            validator.property("member").required();
            validator.property("name").required().maxLength(100);
            validator.property("printerName").required().maxLength(100);
            validator.property("beginOfDocCommand").maxLength(100);
            validator.property("endOfDocCommand").maxLength(100);
            validator.property("paymentAdditionalMessage").maxLength(500);
            this.validator = validator;
        }
        return this.validator;
    }
}

