/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.preferences;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsService;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ReceiptPrinterSettingsServiceSecurity
extends BaseServiceSecurity
implements ReceiptPrinterSettingsService {
    private ReceiptPrinterSettingsServiceLocal receiptPrinterSettingsService;

    @Override
    public boolean belongsToTheLoggedUser(Long id) {
        return this.receiptPrinterSettingsService.belongsToTheLoggedUser(id);
    }

    @Override
    public List<ReceiptPrinterSettings> list() {
        boolean hasViewPermission = this.permissionService.permission().member(MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS).operator(MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS).hasPermission();
        if (!hasViewPermission) {
            return Collections.emptyList();
        }
        return this.receiptPrinterSettingsService.list();
    }

    @Override
    public ReceiptPrinterSettings load(Long id) {
        ReceiptPrinterSettings receiptPrinterSettings = this.receiptPrinterSettingsService.load(id);
        this.checkView(receiptPrinterSettings);
        return receiptPrinterSettings;
    }

    @Override
    public void remove(Long id) {
        ReceiptPrinterSettings receiptPrinterSettings = this.receiptPrinterSettingsService.load(id);
        this.checkManagement(receiptPrinterSettings);
        this.receiptPrinterSettingsService.remove(id);
    }

    @Override
    public ReceiptPrinterSettings save(ReceiptPrinterSettings receiptPrinterSettings) {
        Member member = receiptPrinterSettings.getMember();
        if (member == null) {
            throw new ValidationException();
        }
        this.checkManagement(receiptPrinterSettings);
        return this.receiptPrinterSettingsService.save(receiptPrinterSettings);
    }

    public void setReceiptPrinterSettingsServiceLocal(ReceiptPrinterSettingsServiceLocal receiptPrinterSettingsService) {
        this.receiptPrinterSettingsService = receiptPrinterSettingsService;
    }

    @Override
    public void validate(ReceiptPrinterSettings receiptPrinterSettings) throws ValidationException {
        this.receiptPrinterSettingsService.validate(receiptPrinterSettings);
    }

    private void checkManagement(ReceiptPrinterSettings receiptPrinterSettings) {
        this.permissionService.permission(receiptPrinterSettings.getMember()).member(MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS).check();
    }

    private void checkView(ReceiptPrinterSettings receiptPrinterSettings) {
        this.permissionService.permission(receiptPrinterSettings.getMember()).member(MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS).operator(MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS).check();
    }
}

