/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.reports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.reports.AdReportVO;
import nl.strohalm.cyclos.entities.reports.CurrentStateReportVO;
import nl.strohalm.cyclos.entities.reports.InvoiceSummaryType;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.CurrencyServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.elements.ReferenceServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.reports.CurrentStateReportParameters;
import nl.strohalm.cyclos.services.reports.CurrentStateReportServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;

public class CurrentStateReportServiceImpl
implements CurrentStateReportServiceLocal {
    private CurrencyServiceLocal currencyService;
    private MemberServiceLocal memberService;
    private AdServiceLocal adService;
    private AccountTypeServiceLocal accountTypeService;
    private InvoiceServiceLocal invoiceService;
    private LoanServiceLocal loanService;
    private ReferenceServiceLocal referenceService;
    private FetchServiceLocal fetchService;

    @Override
    public CurrentStateReportVO getCurrentStateReport(CurrentStateReportParameters params) {
        CurrentStateReportVO report = new CurrentStateReportVO();
        List<Currency> currencies = this.currencyService.listAll();
        CurrentStateReportParameters.TimePointType timePointType = params.getTimePointType();
        Calendar timePoint = timePointType == CurrentStateReportParameters.TimePointType.TIME_POINT_HISTORY ? params.getTimePoint() : null;
        Collection<MemberGroup> groups = this.fetchService.fetch(params.getMemberGroups(), new Relationship[0]);
        ArrayList<MemberGroup> activeGroups = new ArrayList<MemberGroup>();
        for (MemberGroup group : groups) {
            if (!group.isActive()) continue;
            activeGroups.add(group);
        }
        if (params.isMemberGroupInformation()) {
            Map<MemberGroup, Integer> groupMemberCount = this.memberService.getGroupMemberCount(groups, timePoint);
            int activeMembers = 0;
            for (Map.Entry<MemberGroup, Integer> entry : groupMemberCount.entrySet()) {
                if (!entry.getKey().isActive()) continue;
                activeMembers += entry.getValue().intValue();
            }
            report.setNumberActiveMembers(activeMembers);
            report.setGroupMemberCount(groupMemberCount);
        }
        if (params.isAds()) {
            Integer numberActiveMembersWithAds = this.adService.countMembersWithAds(activeGroups, timePoint);
            Integer numberActiveAdvertisements = this.adService.getNumberOfAds(groups, Ad.Status.ACTIVE, timePoint);
            Integer numberExpiredAdvertisements = this.adService.getNumberOfAds(groups, Ad.Status.EXPIRED, timePoint);
            Integer numberScheduledAdvertisements = this.adService.getNumberOfAds(groups, Ad.Status.SCHEDULED, timePoint);
            Integer numberPermanentAdvertisements = this.adService.getNumberOfAds(groups, Ad.Status.PERMANENT, timePoint);
            AdReportVO adReportVO = new AdReportVO();
            adReportVO.setNumberActiveMembersWithAds(numberActiveMembersWithAds);
            adReportVO.setNumberActiveAdvertisements(numberActiveAdvertisements);
            adReportVO.setNumberExpiredAdvertisements(numberExpiredAdvertisements);
            adReportVO.setNumberScheduledAdvertisements(numberScheduledAdvertisements);
            adReportVO.setNumberPermanentAdvertisements(numberPermanentAdvertisements);
            report.setAdReportVO(adReportVO);
        }
        Collection<AccountType> visibleAccountTypes = this.accountTypeService.getVisibleAccountTypes();
        if (params.isSystemAccountInformation()) {
            ArrayList<SystemAccountType> systemAccountTypes = new ArrayList<SystemAccountType>();
            for (AccountType accountType : visibleAccountTypes) {
                if (!(accountType instanceof SystemAccountType)) continue;
                systemAccountTypes.add((SystemAccountType)accountType);
            }
            Map<SystemAccountType, BigDecimal> systemAccountTypesBalance = this.accountTypeService.getSystemAccountTypesBalance(systemAccountTypes, timePoint);
            report.setSystemAccountTypesBalance(systemAccountTypesBalance);
        }
        if (params.isMemberAccountInformation()) {
            ArrayList<MemberAccountType> memberAccountTypes = new ArrayList<MemberAccountType>();
            for (AccountType accountType : visibleAccountTypes) {
                if (!(accountType instanceof MemberAccountType)) continue;
                memberAccountTypes.add((MemberAccountType)accountType);
            }
            Map<MemberAccountType, BigDecimal> memberAccountTypesBalance = this.accountTypeService.getMemberAccountTypesBalance(memberAccountTypes, groups, timePoint);
            report.setMemberAccountTypesBalance(memberAccountTypesBalance);
        }
        if (params.isInvoices()) {
            LinkedHashMap<Currency, Map<InvoiceSummaryType, TransactionSummaryVO>> invoicesSummaries = new LinkedHashMap<Currency, Map<InvoiceSummaryType, TransactionSummaryVO>>(currencies.size());
            for (Currency currency : currencies) {
                TransactionSummaryVO memberInvoicesSummary = this.invoiceService.getSummaryByType(currency, InvoiceSummaryType.MEMBER);
                TransactionSummaryVO systemIncomingInvoicesSummary = this.invoiceService.getSummaryByType(currency, InvoiceSummaryType.SYSTEM_INCOMING);
                TransactionSummaryVO systemOutgoingInvoicesSummary = this.invoiceService.getSummaryByType(currency, InvoiceSummaryType.SYSTEM_OUTGOING);
                EnumMap<InvoiceSummaryType, TransactionSummaryVO> currencyInvoices = new EnumMap<InvoiceSummaryType, TransactionSummaryVO>(InvoiceSummaryType.class);
                currencyInvoices.put(InvoiceSummaryType.MEMBER, memberInvoicesSummary);
                currencyInvoices.put(InvoiceSummaryType.SYSTEM_INCOMING, systemIncomingInvoicesSummary);
                currencyInvoices.put(InvoiceSummaryType.SYSTEM_OUTGOING, systemOutgoingInvoicesSummary);
                invoicesSummaries.put(currency, currencyInvoices);
            }
            report.setInvoicesSummaries(invoicesSummaries);
        }
        if (params.isLoans()) {
            LinkedHashMap<Currency, TransactionSummaryVO> loansSummaries = new LinkedHashMap<Currency, TransactionSummaryVO>();
            for (Currency currency : currencies) {
                TransactionSummaryVO openLoansSummary = this.loanService.getOpenLoansSummary(currency);
                loansSummaries.put(currency, openLoansSummary);
            }
            report.setOpenLoansSummary(loansSummaries);
        }
        if (params.isReferences()) {
            Map<Reference.Level, Integer> givenReferences = this.referenceService.countGivenReferencesByLevel(Reference.Nature.GENERAL);
            report.setGivenReferences(givenReferences);
        }
        report.setCurrencies(currencies);
        return report;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setCurrencyServiceLocal(CurrencyServiceLocal currencyService) {
        this.currencyService = currencyService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }

    public void setReferenceServiceLocal(ReferenceServiceLocal referenceService) {
        this.referenceService = referenceService;
    }
}

