/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.reports;

import java.util.Collection;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.reports.CurrentStateReportVO;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.reports.CurrentStateReportParameters;
import nl.strohalm.cyclos.services.reports.CurrentStateReportService;
import nl.strohalm.cyclos.services.reports.CurrentStateReportServiceLocal;
import org.springframework.util.CollectionUtils;

public class CurrentStateReportServiceSecurity
extends BaseServiceSecurity
implements CurrentStateReportService {
    private CurrentStateReportServiceLocal currentStateReportService;

    @Override
    public CurrentStateReportVO getCurrentStateReport(CurrentStateReportParameters params) {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_CURRENT).check();
        Collection<MemberGroup> memberGroups = this.permissionService.getManagedMemberGroups();
        if (CollectionUtils.isEmpty(memberGroups)) {
            throw new PermissionDeniedException();
        }
        params.setMemberGroups(memberGroups);
        return this.currentStateReportService.getCurrentStateReport(params);
    }

    public void setCurrentStateReportServiceLocal(CurrentStateReportServiceLocal currentStateReportService) {
        this.currentStateReportService = currentStateReportService;
    }
}

