/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.services;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.dao.services.ServiceClientDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceClientQuery;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.InternetAddressHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ServiceClientServiceImpl
implements ServiceClientServiceLocal {
    private static Comparator<TransferType> TT_COMPARATOR = new TransferTypeNameComparator();
    private static List<String> FORBIDDEN_CHANNELS = Arrays.asList("web", "wap1", "wap2", "posweb", "pos");
    private ServiceClientDAO serviceClientDao;
    private TransferTypeServiceLocal transferTypeService;
    private ChannelServiceLocal channelService;
    private FetchServiceLocal fetchService;

    @Override
    public int delete(Long ... ids) {
        return this.serviceClientDao.delete(ids);
    }

    @Override
    public ServiceClient findByAddressAndCredentials(String address, String username, String password) {
        ServiceClientQuery query = new ServiceClientQuery();
        query.fetch(RelationshipHelper.nested(ServiceClient.Relationships.MEMBER, Element.Relationships.GROUP));
        query.setUniqueResult();
        query.setAddress(address);
        query.setUsername(username);
        query.setPassword(password);
        List<ServiceClient> list = this.search(query);
        if (list.isEmpty()) {
            throw new EntityNotFoundException(ServiceClient.class);
        }
        return list.iterator().next();
    }

    @Override
    public List<Channel> listPossibleChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>(this.channelService.list());
        Iterator iterator = channels.iterator();
        while (iterator.hasNext()) {
            Channel channel = (Channel)iterator.next();
            if (!FORBIDDEN_CHANNELS.contains(channel.getInternalName())) continue;
            iterator.remove();
        }
        return channels;
    }

    @Override
    public List<TransferType> listPossibleDoPaymentTypes(ServiceClient client) {
        Channel channel = client.getChannel();
        if (channel == null) {
            return Collections.emptyList();
        }
        TransferTypeQuery query = new TransferTypeQuery();
        query.setContext(TransactionContext.PAYMENT);
        query.setChannel(channel.getInternalName());
        Member member = client.getMember();
        if (member != null) {
            member = this.fetchService.fetch(member, Element.Relationships.GROUP);
            query.setFromOwner(member);
        }
        List<TransferType> tTypes = this.transferTypeService.search(query);
        if (member == null) {
            query.setContext(TransactionContext.SELF_PAYMENT);
            tTypes.addAll(this.transferTypeService.search(query));
        }
        Collections.sort(tTypes, TT_COMPARATOR);
        return tTypes;
    }

    @Override
    public List<TransferType> listPossibleReceivePaymentTypes(ServiceClient client) {
        Member member = client.getMember();
        Channel channel = client.getChannel();
        if (member == null || channel == null) {
            return Collections.emptyList();
        }
        TransferTypeQuery query = new TransferTypeQuery();
        query.setContext(TransactionContext.PAYMENT);
        query.setChannel(channel.getInternalName());
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        query.setToOwner(member);
        query.setFromNature(AccountType.Nature.MEMBER);
        return this.transferTypeService.search(query);
    }

    @Override
    public ServiceClient load(Long id, Relationship ... fetch) {
        return (ServiceClient)this.serviceClientDao.load(id, fetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveAllIpAddresses() {
        ServiceClientQuery query = new ServiceClientQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        List<ServiceClient> clients = this.serviceClientDao.search(query);
        try {
            for (ServiceClient client : clients) {
                try {
                    if (!this.resolveAddress(client)) continue;
                    this.serviceClientDao.update(client);
                }
                catch (Exception e) {}
            }
        }
        finally {
            DataIteratorHelper.close(clients);
        }
    }

    @Override
    public ServiceClient save(ServiceClient client) {
        boolean isWebShop;
        this.validate(client);
        Channel channel = this.fetchService.fetch(client.getChannel(), new Relationship[0]);
        boolean bl = isWebShop = channel != null && "webshop".equals(channel.getInternalName());
        if (isWebShop || channel == null) {
            client.setDoPaymentTypes(null);
            client.setReceivePaymentTypes(null);
            client.setChargebackPaymentTypes(null);
        } else if (client.getMember() == null) {
            client.setReceivePaymentTypes(null);
        }
        Set<ServiceOperation> permissions = client.getPermissions();
        if (permissions == null) {
            permissions = new HashSet<ServiceOperation>();
            client.setPermissions(permissions);
        } else if (isWebShop) {
            Iterator<ServiceOperation> iterator = permissions.iterator();
            while (iterator.hasNext()) {
                ServiceOperation operation = iterator.next();
                if (operation == ServiceOperation.WEBSHOP) continue;
                iterator.remove();
            }
        } else {
            permissions.remove(ServiceOperation.WEBSHOP);
            if (channel == null) {
                permissions.remove(ServiceOperation.ACCESS);
            }
        }
        if (CollectionUtils.isEmpty(client.getDoPaymentTypes())) {
            permissions.remove(ServiceOperation.DO_PAYMENT);
        } else {
            permissions.add(ServiceOperation.DO_PAYMENT);
        }
        if (client.getMember() == null || CollectionUtils.isEmpty(client.getReceivePaymentTypes())) {
            permissions.remove(ServiceOperation.RECEIVE_PAYMENT);
        } else {
            permissions.add(ServiceOperation.RECEIVE_PAYMENT);
        }
        if (CollectionUtils.isEmpty(client.getChargebackPaymentTypes())) {
            permissions.remove(ServiceOperation.CHARGEBACK);
        } else {
            permissions.add(ServiceOperation.CHARGEBACK);
        }
        if (client.getMember() != null || client.getChannel() == null || CollectionUtils.isEmpty(client.getManageGroups())) {
            client.setManageGroups(null);
            permissions.remove(ServiceOperation.MANAGE_MEMBERS);
        } else {
            permissions.add(ServiceOperation.MANAGE_MEMBERS);
        }
        if (client.isTransient()) {
            return this.serviceClientDao.insert(client);
        }
        return this.serviceClientDao.update(client);
    }

    @Override
    public List<ServiceClient> search(ServiceClientQuery query) {
        return this.serviceClientDao.search(query);
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setServiceClientDao(ServiceClientDAO serviceClientDao) {
        this.serviceClientDao = serviceClientDao;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(ServiceClient client) {
        this.getValidator(client).validate(client);
    }

    private Validator getValidator(ServiceClient client) {
        Validator validator = new Validator("serviceClient");
        validator.property("name").required().maxLength(100);
        validator.property("hostname").key("serviceClient.address").required().add(new HostnameValidation()).maxLength(100);
        validator.property("username").maxLength(100);
        validator.property("password").maxLength(100);
        validator.property("channel").anyOf(this.listPossibleChannels().toArray());
        Channel channel = this.fetchService.fetch(client.getChannel(), new Relationship[0]);
        if (channel != null && !"webshop".equals(channel.getInternalName())) {
            Object[] doPaymentTTs = this.listPossibleDoPaymentTypes(client).toArray();
            Object[] receiveTTs = this.listPossibleReceivePaymentTypes(client).toArray();
            validator.property("doPaymentTypes").key("serviceOperation.DO_PAYMENT").anyOf(doPaymentTTs);
            validator.property("receivePaymentTypes").key("serviceOperation.RECEIVE_PAYMENT").anyOf(receiveTTs);
            validator.property("receivePaymentTypes").key("serviceOperation.CHARGEBACK").anyOf(client.getMember() == null ? doPaymentTTs : receiveTTs);
        }
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = -6137330080312890785L;

            @Override
            public ValidationError validate(Object object) {
                ServiceClient client = (ServiceClient)object;
                String username = StringUtils.trimToNull((String)client.getUsername());
                String password = StringUtils.trimToNull((String)client.getPassword());
                int nonEmpty = 0;
                if (username != null) {
                    ++nonEmpty;
                }
                if (password != null) {
                    ++nonEmpty;
                }
                if (nonEmpty == 1) {
                    return new ValidationError("serviceClient.error.empty.usernameOrPassword", new Object[0]);
                }
                return null;
            }
        });
        return validator;
    }

    private boolean resolveAddress(ServiceClient client) {
        String hostname = client.getHostname();
        InternetAddressHelper.AddressType addressType = InternetAddressHelper.resolveAddressType(hostname);
        if (addressType == null) {
            return false;
        }
        String addressBegin = client.getAddressBegin();
        String addressEnd = client.getAddressBegin();
        switch (addressType) {
            case HOSTNAME: {
                try {
                    InetAddress[] addr = InetAddress.getAllByName(hostname);
                    String ip = InternetAddressHelper.padAddress(addr[0].getHostAddress());
                    client.setAddressBegin(ip);
                    client.setAddressEnd(ip);
                }
                catch (UnknownHostException e) {}
                break;
            }
            case SIMPLE_IP: {
                String paddedAddress = InternetAddressHelper.padAddress(hostname);
                client.setAddressBegin(paddedAddress);
                client.setAddressEnd(paddedAddress);
                break;
            }
            case IP_RANGE: {
                String[] range = InternetAddressHelper.getRangeBoundaries(hostname);
                client.setAddressBegin(InternetAddressHelper.padAddress(range[0]));
                client.setAddressEnd(InternetAddressHelper.padAddress(range[1]));
            }
        }
        return !ObjectUtils.equals((Object)client.getAddressBegin(), (Object)addressBegin) || !ObjectUtils.equals((Object)client.getAddressEnd(), (Object)addressEnd);
    }

    private static class TransferTypeNameComparator
    implements Comparator<TransferType> {
        private TransferTypeNameComparator() {
        }

        @Override
        public int compare(TransferType tt1, TransferType tt2) {
            return tt1.getName().compareTo(tt2.getName());
        }
    }

    private class HostnameValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 8330071155849944811L;

        private HostnameValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            if (value == null || "".equals(value)) {
                return null;
            }
            String address = value.toString();
            InternetAddressHelper.AddressType addressType = InternetAddressHelper.resolveAddressType(address);
            if (addressType == null) {
                return new InvalidError();
            }
            if (!ServiceClientServiceImpl.this.resolveAddress((ServiceClient)object)) {
                return new InvalidError();
            }
            return null;
        }
    }
}

