/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.services;

import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceClientQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.services.ServiceClientService;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;

public class ServiceClientServiceSecurity
extends BaseServiceSecurity
implements ServiceClientService {
    private ServiceClientServiceLocal serviceClientService;

    @Override
    public int delete(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_MANAGE).check();
        return this.serviceClientService.delete(ids);
    }

    @Override
    public List<Channel> listPossibleChannels() {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_VIEW).check();
        return this.serviceClientService.listPossibleChannels();
    }

    @Override
    public List<TransferType> listPossibleDoPaymentTypes(ServiceClient client) {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_VIEW).check();
        return this.serviceClientService.listPossibleDoPaymentTypes(client);
    }

    @Override
    public List<TransferType> listPossibleReceivePaymentTypes(ServiceClient client) {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_VIEW).check();
        return this.serviceClientService.listPossibleReceivePaymentTypes(client);
    }

    @Override
    public ServiceClient load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_VIEW).check();
        return this.serviceClientService.load(id, fetch);
    }

    @Override
    public ServiceClient save(ServiceClient host) {
        this.permissionService.permission().admin(AdminSystemPermission.SERVICE_CLIENTS_MANAGE).check();
        return this.serviceClientService.save(host);
    }

    @Override
    public List<ServiceClient> search(ServiceClientQuery query) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.SERVICE_CLIENTS_VIEW)) {
            throw new PermissionDeniedException();
        }
        return this.serviceClientService.search(query);
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientService = serviceClientService;
    }

    @Override
    public void validate(ServiceClient client) {
        this.serviceClientService.validate(client);
    }
}

