/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.AccessSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.AccessSettingsEvent;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class AccessSettingsHandler
extends BaseSettingsHandler<AccessSettings, AccessSettingsChangeListener> {
    private GroupServiceLocal groupService;

    protected AccessSettingsHandler() {
        super(Setting.Type.ACCESS, AccessSettings.class);
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap accessConverters = new LinkedHashMap();
        accessConverters.put("virtualKeyboard", CoercionConverter.instance(Boolean.TYPE));
        accessConverters.put("virtualKeyboardTransactionPassword", CoercionConverter.instance(Boolean.TYPE));
        accessConverters.put("numericPassword", CoercionConverter.instance(Boolean.TYPE));
        accessConverters.put("allowOperatorLogin", CoercionConverter.instance(Boolean.TYPE));
        accessConverters.put("allowMultipleLogins", CoercionConverter.instance(Boolean.TYPE));
        accessConverters.put("usernameLength.min", CoercionConverter.instance(Integer.TYPE));
        accessConverters.put("usernameLength.max", CoercionConverter.instance(Integer.TYPE));
        accessConverters.put("adminTimeout.number", CoercionConverter.instance(Integer.class));
        accessConverters.put("adminTimeout.field", CoercionConverter.instance(TimePeriod.Field.class));
        accessConverters.put("administrationWhitelist", CoercionConverter.instance(String.class));
        accessConverters.put("usernameGeneration", CoercionConverter.instance(AccessSettings.UsernameGeneration.class));
        accessConverters.put("generatedUsernameLength", CoercionConverter.instance(Integer.TYPE));
        accessConverters.put("memberTimeout.number", CoercionConverter.instance(Integer.class));
        accessConverters.put("memberTimeout.field", CoercionConverter.instance(TimePeriod.Field.class));
        accessConverters.put("poswebTimeout.number", CoercionConverter.instance(Integer.class));
        accessConverters.put("poswebTimeout.field", CoercionConverter.instance(TimePeriod.Field.class));
        accessConverters.put("transactionPasswordChars", CoercionConverter.instance(String.class));
        accessConverters.put("usernameRegex", CoercionConverter.instance(String.class));
        return accessConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator accessValidator = new Validator("settings.access");
        accessValidator.property("virtualKeyboard").key("settings.access.virtualKeyboardLogin").add(new PropertyValidation(){
            private static final long serialVersionUID = 1503822395572865451L;

            @Override
            public ValidationError validate(Object object, Object property, Object value) {
                boolean used = Boolean.TRUE.equals(value);
                if (used && AccessSettingsHandler.this.groupService.hasGroupsWhichRequiresSpecialOnPassword()) {
                    return new ValidationError("settings.access.error.virtualKeyboard.groupsRequireSpecial", new Object[0]);
                }
                return null;
            }
        });
        accessValidator.property("numericPassword").add(new PropertyValidation(){
            private static final long serialVersionUID = 1763257236548237123L;

            @Override
            public ValidationError validate(Object object, Object property, Object value) {
                boolean used = Boolean.TRUE.equals(value);
                if (used && AccessSettingsHandler.this.groupService.hasMemberGroupsWhichEnforcesCharactersOnPassword()) {
                    return new ValidationError("settings.access.error.numericPassword.groupsRequireLetters", new Object[0]);
                }
                return null;
            }
        });
        accessValidator.property("usernameLength.min").key("settings.access.usernameLength").required().between(1, 10);
        accessValidator.property("usernameLength.max").key("settings.access.usernameLength").required().between(3, 30);
        accessValidator.property("adminTimeout.number").key("settings.access.adminTimeout").between(1, 999);
        accessValidator.property("adminTimeout.field").key("settings.access.adminTimeout").required();
        accessValidator.property("usernameGeneration").required();
        accessValidator.property("generatedUsernameLength").between(3, 30);
        accessValidator.property("memberTimeout.number").key("settings.access.memberTimeout").between(1, 999);
        accessValidator.property("memberTimeout.field").key("settings.access.memberTimeout").required();
        accessValidator.property("poswebTimeout.number").key("settings.access.poswebTimeout").between(1, 999);
        accessValidator.property("poswebTimeout.field").key("settings.access.poswebTimeout").required();
        accessValidator.property("transactionPasswordChars").required().length(3, 50);
        accessValidator.property("usernameRegex").required();
        return accessValidator;
    }

    @Override
    protected void notifyListener(AccessSettingsChangeListener listener, AccessSettings settings) {
        listener.onAccessSettingsUpdate(new AccessSettingsEvent(settings));
    }
}

