/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.AlertSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.AlertSettingsEvent;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.Validator;

public class AlertSettingsHandler
extends BaseSettingsHandler<AlertSettings, AlertSettingsChangeListener> {
    protected AlertSettingsHandler() {
        super(Setting.Type.ALERT, AlertSettings.class);
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap alertConverters = new LinkedHashMap();
        alertConverters.put("givenVeryBadRefs", CoercionConverter.instance(Integer.TYPE));
        alertConverters.put("receivedVeryBadRefs", CoercionConverter.instance(Integer.TYPE));
        alertConverters.put("idleInvoiceExpiration.number", CoercionConverter.instance(Integer.class));
        alertConverters.put("idleInvoiceExpiration.field", CoercionConverter.instance(TimePeriod.Field.class));
        alertConverters.put("amountDeniedInvoices", CoercionConverter.instance(Integer.TYPE));
        alertConverters.put("amountIncorrectLogin", CoercionConverter.instance(Integer.TYPE));
        return alertConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator alertValidator = new Validator("settings.alert");
        alertValidator.property("givenVeryBadRefs").between(0, 999);
        alertValidator.property("receivedVeryBadRefs").between(0, 999);
        alertValidator.property("idleInvoiceExpiration.number").between(0, 999);
        alertValidator.property("idleInvoiceExpiration.field").required();
        alertValidator.property("amountDeniedInvoices").between(0, 999);
        alertValidator.property("amountIncorrectLogin").between(0, 999);
        return alertValidator;
    }

    @Override
    protected void notifyListener(AlertSettingsChangeListener listener, AlertSettings settings) {
        listener.onAlertSettingsUpdate(new AlertSettingsEvent(settings));
    }
}

