/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.dao.settings.SettingDAO;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.SettingsChangeListener;
import nl.strohalm.cyclos.services.settings.SettingsHandler;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheAdapter;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseSettingsHandler<T, L extends SettingsChangeListener>
implements SettingsHandler<T, L>,
InitializingBean {
    private final Log LOGGER = LogFactory.getLog(this.getClass());
    private final Class<T> beanClass;
    private final Validator validator;
    private CacheManager cacheManager;
    private SettingDAO settingDao;
    private final Set<L> listeners = new HashSet<L>();
    final Setting.Type type;
    final Map<String, Converter<?>> converters;

    protected BaseSettingsHandler(Setting.Type type, Class<T> beanClass) {
        this.type = type;
        this.beanClass = beanClass;
        this.converters = Collections.unmodifiableMap(this.createConverters());
        this.validator = this.createValidator();
    }

    @Override
    public void addListener(L listener) {
        this.listeners.add(listener);
    }

    public void afterPropertiesSet() throws Exception {
        CacheAdapter listener = new CacheAdapter(){

            @Override
            public void onValueAdded(Cache cache, Serializable key, Object value) {
                if (!BaseSettingsHandler.this.beanClass.isInstance(value)) {
                    return;
                }
                Object settings = value;
                for (SettingsChangeListener listener : BaseSettingsHandler.this.listeners) {
                    BaseSettingsHandler.this.notifyListener(listener, settings);
                }
            }
        };
        this.getCache().addListener(listener);
    }

    @Override
    public T get() {
        return this.getCache().get((Serializable)((Object)this.getCacheKey()), new CacheCallback(){

            @Override
            public Object retrieve() {
                return BaseSettingsHandler.this.read();
            }
        });
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public SettingDAO getSettingDao() {
        return this.settingDao;
    }

    @Override
    public T importFrom(Map<String, String> values) {
        T object = ClassHelper.instantiate(this.beanClass);
        this.populate(object, values);
        return this.update(object);
    }

    @Override
    public List<Setting> listSettings() {
        return this.buildSettings(this.get());
    }

    @Override
    public void refresh() {
        this.getCache().remove((Serializable)((Object)this.getCacheKey()));
    }

    @Override
    public void removeListener(L listener) {
        this.listeners.remove(listener);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setSettingDao(SettingDAO settingsDao) {
        this.settingDao = settingsDao;
    }

    @Override
    public T update(T newSettings) {
        CurrentTransactionData.addTransactionRollbackListener(new TransactionRollbackListener(){

            @Override
            public void onTransactionRollback() {
                BaseSettingsHandler.this.refresh();
            }
        });
        this.validate(newSettings);
        List<Setting> list = this.buildSettings(newSettings);
        for (Setting setting : list) {
            Setting loaded = null;
            try {
                loaded = this.settingDao.load(this.type, setting.getName());
                loaded.setValue(setting.getValue());
                this.settingDao.update(loaded);
            }
            catch (EntityNotFoundException e) {
                this.settingDao.insert(setting);
            }
        }
        this.refresh();
        return this.get();
    }

    @Override
    public void validate(T settings) {
        this.validator.validate(settings);
    }

    protected abstract Map<String, Converter<?>> createConverters();

    protected abstract Validator createValidator();

    protected abstract void notifyListener(L var1, T var2);

    protected T read() {
        List<Setting> settingsList = this.settingDao.listByType(this.type);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Setting setting : settingsList) {
            values.put(setting.getName(), setting.getValue());
        }
        try {
            T settings = this.getBeanClass().newInstance();
            this.populate(settings, values);
            return settings;
        }
        catch (Exception e) {
            this.LOGGER.warn((Object)"Error creating a settings bean", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<Setting> buildSettings(T settings) {
        LinkedList<Setting> values = new LinkedList<Setting>();
        for (Map.Entry<String, Converter<?>> entry : this.converters.entrySet()) {
            String name = entry.getKey();
            Object value = PropertyHelper.get(settings, name);
            String valueAsString = PropertyHelper.getAsString(value, entry.getValue());
            Setting setting = new Setting();
            setting.setType(this.type);
            setting.setName(name);
            setting.setValue(valueAsString);
            values.add(setting);
        }
        return values;
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.Settings");
    }

    private String getCacheKey() {
        return this.beanClass.getSimpleName();
    }

    private void populate(Object settings, Map<String, String> values) {
        for (Map.Entry<String, Converter<?>> entry : this.converters.entrySet()) {
            String first;
            String name = entry.getKey();
            Converter<?> converter = entry.getValue();
            if (!values.containsKey(name)) continue;
            String value = values.get(name);
            Object realValue = converter.valueOf(value);
            if (name.contains(".") && PropertyHelper.get(settings, first = PropertyHelper.firstProperty(name)) == null) {
                try {
                    Class type = PropertyUtils.getPropertyType((Object)settings, (String)first);
                    Object bean = type.newInstance();
                    PropertyHelper.set(settings, first, bean);
                }
                catch (Exception e) {
                    this.LOGGER.warn((Object)"Error while setting nested settings bean", (Throwable)e);
                    throw new IllegalStateException();
                }
            }
            PropertyHelper.set(settings, name, realValue);
        }
    }
}

