/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.settings.events.LogSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LogSettingsEvent;
import nl.strohalm.cyclos.services.settings.BaseSettingsHandler;
import nl.strohalm.cyclos.utils.FileUnits;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.validation.Validator;

public class LogSettingsHandler
extends BaseSettingsHandler<LogSettings, LogSettingsChangeListener> {
    protected LogSettingsHandler() {
        super(Setting.Type.LOG, LogSettings.class);
    }

    @Override
    protected Map<String, Converter<?>> createConverters() {
        LinkedHashMap logConverters = new LinkedHashMap();
        logConverters.put("traceLevel", CoercionConverter.instance(LogSettings.TraceLevel.class));
        logConverters.put("traceFile", CoercionConverter.instance(String.class));
        logConverters.put("traceWritesOnly", CoercionConverter.instance(Boolean.TYPE));
        logConverters.put("webServiceLevel", CoercionConverter.instance(LogSettings.WebServiceLevel.class));
        logConverters.put("webServiceFile", CoercionConverter.instance(String.class));
        logConverters.put("restLevel", CoercionConverter.instance(LogSettings.WebServiceLevel.class));
        logConverters.put("restFile", CoercionConverter.instance(String.class));
        logConverters.put("transactionLevel", CoercionConverter.instance(LogSettings.TransactionLevel.class));
        logConverters.put("transactionFile", CoercionConverter.instance(String.class));
        logConverters.put("accountFeeLevel", CoercionConverter.instance(LogSettings.AccountFeeLevel.class));
        logConverters.put("accountFeeFile", CoercionConverter.instance(String.class));
        logConverters.put("scheduledTaskLevel", CoercionConverter.instance(LogSettings.ScheduledTaskLevel.class));
        logConverters.put("scheduledTaskFile", CoercionConverter.instance(String.class));
        logConverters.put("maxFilesPerLog", CoercionConverter.instance(Integer.TYPE));
        logConverters.put("maxLengthPerFile", CoercionConverter.instance(Integer.TYPE));
        logConverters.put("maxLengthPerFileUnits", CoercionConverter.instance(FileUnits.class));
        return logConverters;
    }

    @Override
    protected Validator createValidator() {
        Validator logValidator = new Validator("settings.log");
        logValidator.property("traceLevel").required();
        logValidator.property("traceFile").required();
        logValidator.property("webServiceLevel").required();
        logValidator.property("webServiceFile").required();
        logValidator.property("restLevel").required();
        logValidator.property("restFile").required();
        logValidator.property("transactionLevel").required();
        logValidator.property("transactionFile").required();
        logValidator.property("accountFeeLevel").required();
        logValidator.property("accountFeeFile").required();
        logValidator.property("scheduledTaskLevel").required();
        logValidator.property("scheduledTaskFile").required();
        logValidator.property("maxFilesPerLog").required().positiveNonZero();
        logValidator.property("maxLengthPerFile").required().positiveNonZero();
        logValidator.property("maxLengthPerFileUnits").required();
        return logValidator;
    }

    @Override
    protected void notifyListener(LogSettingsChangeListener listener, LogSettings settings) {
        listener.onLogSettingsUpdate(new LogSettingsEvent(settings));
    }
}

